/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.sql;

import dods.dap.DAS;
import dods.dap.DODSException;
import dods.dap.Server.ServerDDS;
import dods.dap.parser.ParseException;
import dods.servers.sql.GuardedSQLDataset;
import dods.servers.sql.sqlDDS;
import dods.servers.sql.sqlServerFactory;
import dods.servlet.ReqState;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;

public class sqlDataset
implements GuardedSQLDataset {
    private ReqState rs;

    sqlDataset(ReqState rs) {
        this.rs = rs;
    }

    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public sqlDDS getSQLDDS() throws DODSException, ParseException {
        sqlDDS myDDS = null;
        FilterInputStream ddsSource = null;
        try {
            sqlServerFactory sfactory = new sqlServerFactory();
            myDDS = new sqlDDS(this.rs.getDataSet(), sfactory);
            ddsSource = this.openCachedDDS(this.rs);
            myDDS.parse(ddsSource);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (ddsSource == null) throw throwable;
                ddsSource.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new DODSException(0, ioe.getMessage());
            }
        }
        try {
            if (ddsSource == null) return myDDS;
            ddsSource.close();
            return myDDS;
        }
        catch (IOException ioe) {
            throw new DODSException(0, ioe.getMessage());
        }
    }

    public ServerDDS getDDS() throws DODSException, ParseException {
        return this.getSQLDDS();
    }

    public DataInputStream openCachedDDS(ReqState rs) throws DODSException {
        String cacheDir = rs.getInitParameter("DDScache");
        if (cacheDir == null) {
            cacheDir = rs.getDDSCache();
        }
        try {
            File fin = new File(cacheDir + rs.getDataSet());
            FileInputStream fp_in = new FileInputStream(fin);
            DataInputStream dds_source = new DataInputStream(fp_in);
            return dds_source;
        }
        catch (FileNotFoundException fnfe) {
            throw new DODSException(5, fnfe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DAS getDAS() throws DODSException, ParseException {
        DataInputStream is = null;
        DAS myDAS = new DAS();
        boolean gotIt = false;
        try {
            try {
                is = this.openCachedDAS(this.rs);
                myDAS.parse(is);
                gotIt = true;
            }
            catch (FileNotFoundException fnfe) {
                gotIt = false;
                Object var6_5 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    throw new DODSException(0, ioe.getMessage());
                }
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {}
            catch (IOException ioe) {
                throw new DODSException(0, ioe.getMessage());
            }
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            throw new DODSException(0, ioe.getMessage());
        }
        if (is != null) {
            is.close();
        }
        if (gotIt) {
            System.out.println("Successfully opened and parsed DAS cache: " + this.rs.getDataSet());
            return myDAS;
        }
        System.out.println("No DAS present for dataset: " + this.rs.getDataSet());
        return myDAS;
    }

    public DataInputStream openCachedDAS(ReqState rs) throws FileNotFoundException {
        String cacheDir = rs.getInitParameter("DAScache");
        if (cacheDir == null) {
            cacheDir = rs.getDASCache();
        }
        File fin = new File(cacheDir + rs.getDataSet());
        FileInputStream fp_in = new FileInputStream(fin);
        DataInputStream das_source = new DataInputStream(fp_in);
        return das_source;
    }
}

