/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.sql;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DConstructor;
import dods.dap.DDSException;
import dods.dap.DODSException;
import dods.dap.DVector;
import dods.dap.PrimitiveVector;
import dods.dap.Server.ServerDDS;
import dods.dap.Server.ServerMethods;
import dods.dap.parser.ParseException;
import dods.servers.sql.sqlCEEval;
import dods.servers.sql.sqlDDS;
import dods.servers.sql.sqlResponse;
import dods.servers.sql.sqlServerFactory;
import dods.util.DODSiniFile;
import gnu.getopt.Getopt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

public class sqlTest {
    public static String DDSFile;
    public static String ConstraintExpression;
    private static boolean Debug;
    private static PrintStream dOut;
    private static int Level;

    public static void print_SDDS(ServerDDS sdds, boolean constrained) {
        System.out.println("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
        System.out.println("sqlDDS:");
        Enumeration e = sdds.getVariables();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            ServerMethods s = (ServerMethods)o;
            BaseType bt = (BaseType)o;
            System.out.println(bt.getTypeName() + " " + bt.getName() + ":");
            System.out.println("Constrained DDS:");
            bt.printDecl(System.out, "    ", true, constrained);
            System.out.println("Declaration and Value:");
            if (s.isRead()) {
                try {
                    bt.printVal(System.out, "    ", true);
                }
                catch (NullPointerException except) {
                    System.out.println(" Instance not Allocated.");
                }
            } else {
                System.out.println(" Item not yet initialized.");
            }
            System.out.print(" isProj: " + s.isProject());
            System.out.print("    isRead: " + s.isRead());
            System.out.println("    isSynth: " + s.isSynthesized());
            if (!e.hasMoreElements()) continue;
            System.out.println("- - - - - - - - - - - - - - - - - -");
        }
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    public static void parse_options(String[] args) {
        int c;
        Getopt g = new Getopt("SDTest", args, "f:c:");
        block5: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 102: {
                    String arg = g.getOptarg();
                    if (Debug) {
                        dOut.print("DDS File: " + (arg != null ? arg : "null") + "\n");
                    }
                    DDSFile = arg;
                    continue block5;
                }
                case 99: {
                    String arg = g.getOptarg();
                    if (Debug) {
                        dOut.print("Constraint Expression: \"" + (arg != null ? arg : "null") + "\"\n");
                    }
                    ConstraintExpression = arg;
                    continue block5;
                }
                case 63: {
                    continue block5;
                }
            }
            if (!Debug) continue;
            dOut.print("getopt() returned " + c + "\n");
        }
    }

    public static sqlDDS getDDS() throws FileNotFoundException, DDSException, ParseException {
        File fin = new File(DDSFile);
        FileInputStream fp_in = new FileInputStream(fin);
        DataInputStream dds_source = new DataInputStream(fp_in);
        sqlServerFactory sfactory = new sqlServerFactory();
        sqlDDS myDDS = new sqlDDS("bogus", sfactory);
        if (Debug) {
            dOut.println("Parsing DDS...");
        }
        myDDS.parse(dds_source);
        return myDDS;
    }

    public static void main(String[] args) throws Exception {
        sqlTest sdt = new sqlTest();
        dOut = System.out;
        Debug = true;
        try {
            Statement stmnt;
            ResultSet rs;
            File fout = new File("a.out");
            FileOutputStream fp_out = new FileOutputStream(fout);
            DataOutputStream sink = new DataOutputStream(fp_out);
            System.out.println("-------------------------------------------");
            System.out.println("Debugging Display: " + (Debug ? "ON" : "OFF"));
            sqlTest.parse_options(args);
            System.out.println("...........................................");
            sqlDDS myDDS = sqlTest.getDDS();
            DAS myDAS = new DAS();
            myDDS.print(System.out);
            if (Debug) {
                dOut.println("Constructing CEEvaluator...");
            }
            sqlCEEval ce = new sqlCEEval(myDDS);
            if (Debug) {
                dOut.println("Parsing Constraint Expression: " + ConstraintExpression);
            }
            ce.parseConstraint(ConstraintExpression);
            myDDS.printConstrained(dOut);
            String query = ce.getSQLQuery(myDAS, true);
            if (Debug) {
                dOut.println("Query String: \"" + query + "\"");
            }
            if ((rs = (stmnt = sqlTest.connect2DB()).executeQuery(query)).next() && rs.isFirst()) {
                sqlTest.processResult(rs);
                System.out.println("ResultSet.isFirst(): " + rs.isFirst());
                System.out.println("ResultSet.first(): " + rs.first());
                System.out.println("ResultSet.absolute(1): " + rs.absolute(1));
                sqlResponse res = new sqlResponse(rs);
                if (Debug) {
                    dOut.println("Attempting to send data...");
                }
                ce.send(myDDS.getName(), sink, res);
                sqlTest.print_SDDS(myDDS, true);
                myDDS.printConstrained(dOut);
            } else {
                System.out.println("\n\n\nYour Query Produced No Matches in The Database.\n\n");
            }
            stmnt.close();
            System.out.println("-------------------------------------------");
            sink.close();
        }
        catch (DODSException e) {
            System.out.println("\n\nERROR of Type: " + e.getClass().getName() + "\n");
            System.out.println("Message:\n" + e.getMessage() + "\n");
            System.out.println("Stack Trace: ");
            e.printStackTrace(System.out);
            System.out.println("\n\n");
        }
        System.exit(0);
    }

    public static void testNameBuilder(sqlDDS dds) {
        Enumeration v = dds.getVariables();
        while (v.hasMoreElements()) {
            BaseType thisBT = (BaseType)v.nextElement();
            System.out.println("\nHighest Level. Starting On: " + thisBT.getName());
            sqlTest.nameDigger(thisBT, dds);
        }
    }

    private static void nameDigger(BaseType thisBT, sqlDDS dds) {
        System.out.print("Item: \"" + thisBT.getName() + "\"\t\tFullName: \"" + thisBT.getLongName() + "\"");
        System.out.print("\t\tLevel: " + ++Level);
        Object fullName = null;
        if (thisBT instanceof DConstructor) {
            System.out.print("(It's a DConstructor...)\n");
            Enumeration dce = ((DConstructor)thisBT).getVariables();
            boolean done = false;
            while (dce.hasMoreElements()) {
                BaseType dcBT = (BaseType)dce.nextElement();
                sqlTest.nameDigger(dcBT, dds);
            }
        } else if (thisBT instanceof DVector) {
            System.out.print("(It's a DVector...)\n");
            PrimitiveVector pv = ((DVector)thisBT).getPrimitiveVector();
            sqlTest.nameDigger(pv.getTemplate(), dds);
        }
        System.out.println("");
        --Level;
    }

    public static Statement connect2DB() throws SQLException, FileNotFoundException, IOException {
        Connection conn = null;
        Statement stmt = null;
        String jdbcDriver = "openlink.jdbc2.Driver";
        String connectionURL = "jdbc:openlink://cupcake.oce.orst.edu/DSN=oplEOSDB";
        String uname = "";
        String password = "";
        DODSiniFile inf = new DODSiniFile();
        if (inf.setSection("JDBC")) {
            String tmp = null;
            tmp = inf.getProperty("driver");
            if (tmp != null) {
                jdbcDriver = tmp;
            }
            if ((tmp = inf.getProperty("connectionurl")) != null) {
                connectionURL = tmp;
            }
            if ((tmp = inf.getProperty("username")) != null) {
                uname = tmp;
            }
            if ((tmp = inf.getProperty("password")) != null) {
                password = tmp;
            }
        }
        if (Debug) {
            dOut.println("Using JDBC Driver:    " + jdbcDriver);
        }
        if (Debug) {
            dOut.println("Using Connection URL: " + connectionURL);
        }
        Properties p = System.getProperties();
        p.put("jdbc.drivers", jdbcDriver);
        System.setProperties(p);
        conn = DriverManager.getConnection(connectionURL, uname, password);
        stmt = conn.createStatement(1004, 1007);
        return stmt;
    }

    public static void processResult(ResultSet result) throws SQLException, IOException {
        ResultSetMetaData meta = result.getMetaData();
        int count = meta.getColumnCount();
        sqlTest.printColumnNames(meta);
        int limit = 0;
        result.beforeFirst();
        dOut.println("ResultSet.isFirst(): " + result.isFirst());
        boolean done = false;
        while (result.next() && !done) {
            dOut.print(".");
            ++limit;
            done = result.isLast();
        }
        dOut.println("\nScanned " + limit + " rows...");
        result.beforeFirst();
        dOut.println("ResultSet.isFirst(): " + result.isFirst());
        if (limit > 1) {
            return;
        }
        done = false;
        while (result.next() && !done) {
            dOut.print(".");
            done = result.isLast();
        }
        dOut.println("\nScanned " + limit + " rows...");
        dOut.println("limit: " + limit);
    }

    public static void printColumnNames(ResultSetMetaData m) throws SQLException {
        int count = m.getColumnCount();
        String metaStuff = "";
        for (int c = 1; c <= count; ++c) {
            String name1 = m.getCatalogName(c);
            String name3 = m.getColumnLabel(c);
            String name4 = m.getSchemaName(c);
            String name5 = m.getTableName(c);
            String name6 = m.getColumnName(c);
            String name7 = m.getColumnTypeName(c);
            System.out.println("NAMES:");
            System.out.println("getCatalogName():     " + name1);
            System.out.println("getColumnLabel():     " + name3);
            System.out.println("getSchemaName():      " + name4);
            System.out.println("getTableName():       " + name5);
            System.out.println("getColumnName():      " + name6);
            System.out.println("getColumnTypeName():  " + name7);
            String name = name6;
            String type = m.getColumnTypeName(c);
            name = name == null ? "NULL  " : name + "(" + type + ")  ";
            metaStuff = metaStuff + name;
        }
        dOut.println(metaStuff);
        for (int i = 0; i < metaStuff.length(); ++i) {
            dOut.print("-");
        }
        dOut.println("");
    }

    static {
        Level = 0;
    }
}

