/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import jsyntaxpane.DefaultSyntaxKit;
import org.autoplot.jythonsupport.JythonToJavaConverter;

public class JavaJythonConverter
extends JPanel {
    public static final int DIR_JAVA_TO_JYTHON = 1;
    public static final int DIR_JYTHON_TO_JAVA = 2;
    private int direction;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JEditorPane javaEditorPane;
    private JEditorPane jythonEditorPane;

    public JavaJythonConverter(JEditorPane editor) {
        this(editor, 1);
    }

    public JavaJythonConverter(JEditorPane editor, int direction) {
        this.initComponents();
        this.direction = direction;
        DefaultSyntaxKit.initKit();
        this.javaEditorPane.setContentType("text/java");
        DefaultSyntaxKit.initKit();
        this.jythonEditorPane.setContentType("text/python");
        if (direction != 1) {
            Component _1 = this.jSplitPane1.getLeftComponent();
            Component _2 = this.jSplitPane1.getRightComponent();
            this.jSplitPane1.setLeftComponent(_2);
            this.jSplitPane1.setRightComponent(_1);
            this.jSplitPane1.revalidate();
            this.jButton1.setText("Convert Jython to Java");
            this.jButton2.setText("Copy Java to Clipboard");
        }
        if (editor != null) {
            this.javaEditorPane.setBackground(editor.getBackground());
            this.javaEditorPane.setForeground(editor.getForeground());
            this.javaEditorPane.setFont(editor.getFont());
            this.jythonEditorPane.setBackground(editor.getBackground());
            this.jythonEditorPane.setForeground(editor.getForeground());
            this.jythonEditorPane.setFont(editor.getFont());
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.javaEditorPane = new JEditorPane();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jythonEditorPane = new JEditorPane();
        this.jLabel2 = new JLabel();
        this.jButton1.setText("Convert Java to Jython");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaJythonConverter.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Copy Jython to Clipboard");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaJythonConverter.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(382, Short.MAX_VALUE).addComponent(this.jButton1).addGap(280, 280, 280).addComponent(this.jButton2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)));
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jLabel1.setText("Java Code");
        this.jScrollPane1.setViewportView(this.javaEditorPane);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 456, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jScrollPane1, -1, 641, Short.MAX_VALUE)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 24, -2).addGap(0, 648, Short.MAX_VALUE))));
        this.jSplitPane1.setLeftComponent(this.jPanel3);
        this.jScrollPane2.setViewportView(this.jythonEditorPane);
        this.jLabel2.setText("Jython Code");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 508, Short.MAX_VALUE)).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 593, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 657, Short.MAX_VALUE)).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jScrollPane2, -1, 643, Short.MAX_VALUE))));
        this.jSplitPane1.setRightComponent(this.jPanel4);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.direction == 1) {
            String java = this.javaEditorPane.getText();
            String jython = JythonToJavaConverter.convertReverse(java);
            this.jythonEditorPane.setText(jython);
        } else if (this.direction == 2) {
            try {
                String jython = this.jythonEditorPane.getText();
                String java = JythonToJavaConverter.convert(jython);
                this.javaEditorPane.setText(java);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, ex.toString());
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(this.jythonEditorPane.getText());
        clipboard.setContents(ss, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    public static void main(String[] args) throws IOException {
        JavaJythonConverter cc = new JavaJythonConverter(null);
        String src = "            this.args= new LinkedHashMap<>(args);\n            String s= args.get(\"start\");\n            if ( s==null ) return \"periodic field needs start\";\n            start= TimeUtil.isoTimeToArray(s);\n            julday= TimeUtil.julianDay( start[0], start[1], start[2] );\n            start[0]= 0;\n            start[1]= 0;\n            start[2]= 0;\n            s= args.get(\"offset\");\n            if ( s==null ) return \"periodic field needs offset\";\n            offset= Integer.parseInt( s );\n            s= args.get(\"period\");\n            if ( s==null ) return \"periodic field needs period\";\n            if ( !s.startsWith(\"P\") ) {\n                if ( s.endsWith(\"D\") ) {\n                    throw new IllegalArgumentException(\"periodic unit for day is d, not D\");\n                } if ( s.endsWith(\"d\")  ) {\n                    s= \"P\"+s.toUpperCase(); // TODO: this only supports d,H,M,S\n                } else {\n                    s= \"PT\" + s.toUpperCase(); \n                }\n            }";
        cc.javaEditorPane.setText(src);
        JDialog dia = new JDialog();
        dia.setContentPane(cc);
        dia.pack();
        dia.setVisible(true);
    }

    public void setJavaSource(String doThis) {
        this.javaEditorPane.setText(doThis);
    }

    public void setPythonSource(String doThis) {
        this.jythonEditorPane.setText(doThis);
    }
}

