/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.datasource.DataSourceUtil;
import org.das2.util.LoggerManager;

public class JythonRefactory {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.refactory");
    private static final Map<String, String> forwardMap;
    private static final Map<String, String> fullNameMap;
    private static final Pattern IMPORT_REGEX;
    private static final Pattern IMPORT_AS_REGEX;

    public static String fixImports(String s) throws IOException {
        ByteArrayInputStream fin = new ByteArrayInputStream(s.getBytes(Charset.forName("UTF-8")));
        InputStream out = JythonRefactory.fixImports(fin, "<memory>");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(s.length() * 110 / 100);
        DataSourceUtil.transfer((InputStream)out, (OutputStream)baos);
        String result = baos.toString("UTF-8");
        return result;
    }

    public static String fixImports(String s, String name) throws IOException {
        ByteArrayInputStream fin = new ByteArrayInputStream(s.getBytes(Charset.forName("UTF-8")));
        InputStream out = JythonRefactory.fixImports(fin, name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(s.length() * 110 / 100);
        DataSourceUtil.transfer((InputStream)out, (OutputStream)baos);
        String result = baos.toString("UTF-8");
        return result;
    }

    private static Map<String, String> reverseMap(Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> e : map.entrySet()) {
            result.put(e.getValue(), e.getKey());
        }
        return result;
    }

    private static String magicMatch(String p) {
        String n = "";
        String cl = "";
        String[] ss = p.split("\\.", -2);
        int i = p.length();
        for (int k = ss.length; k > 0; --k) {
            String path = p.substring(0, i);
            n = forwardMap.get(path);
            if (n != null) {
                cl = p.substring(i);
                break;
            }
            i = i - ss[k - 1].length() - 1;
        }
        return n + cl;
    }

    public static InputStream fixImports(InputStream in) throws IOException {
        return JythonRefactory.fixImports(in, "<?>");
    }

    public static InputStream fixImports(InputStream in, String name) throws IOException {
        ByteArrayOutputStream baos;
        long t0 = System.currentTimeMillis();
        boolean affected = false;
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, "UTF-8"));){
            String line = reader.readLine();
            baos = new ByteArrayOutputStream(10000);
            PrintStream writer = new PrintStream((OutputStream)baos, false, "UTF-8");
            while (line != null) {
                String path;
                int k;
                int i;
                String[] ss;
                String n;
                String cl;
                String p;
                Matcher m;
                int ibs = line.indexOf(".BoxSelected");
                if (ibs > -1) {
                    line = line.substring(0, ibs) + ".boxSelected" + line.substring(ibs + 12);
                    affected = true;
                    logger.log(Level.WARNING, "fixImports found use of old .BoxSelected method");
                }
                if (line.indexOf(160) > -1) {
                    logger.log(Level.WARNING, "non-breaking space found and removed.  This script will not work with Autoplots released before 2021-09-23 and v2021a_10.");
                    line = line.replace('\u00a0', ' ');
                }
                if ((m = IMPORT_REGEX.matcher(line)).matches()) {
                    p = m.group(3);
                    cl = null;
                    n = null;
                    ss = p.split("\\.", -2);
                    i = p.length();
                    for (k = ss.length; k > 0; --k) {
                        path = p.substring(0, i);
                        n = forwardMap.get(path);
                        if (n != null) {
                            cl = p.substring(i);
                            break;
                        }
                        i = i - ss[k - 1].length() - 1;
                    }
                    if (n != null) {
                        writer.print(m.group(1));
                        writer.print("from");
                        writer.print(m.group(2));
                        writer.print(n);
                        if (cl != null) {
                            writer.print(cl);
                        }
                        writer.print(m.group(4));
                        writer.print("import");
                        writer.print(m.group(5));
                        writer.print(m.group(6));
                        writer.print(m.group(7));
                        writer.println();
                        if (cl != null) {
                            if (!p.equals(n + cl)) {
                                logger.log(Level.FINER, "affected line {0} of {2}: {1}", new Object[]{reader.getLineNumber(), line, name});
                                affected = true;
                            }
                        } else if (!p.equals(n)) {
                            logger.log(Level.FINER, "affected line {0} of {2}: {1}", new Object[]{reader.getLineNumber(), line, name});
                            affected = true;
                        }
                    } else {
                        writer.println(line);
                    }
                } else {
                    m = IMPORT_AS_REGEX.matcher(line);
                    if (m.matches()) {
                        p = m.group(3);
                        cl = null;
                        n = null;
                        ss = p.split("\\.", -2);
                        i = p.length();
                        for (k = ss.length; k > 0; --k) {
                            path = p.substring(0, i);
                            n = forwardMap.get(path);
                            if (n != null) {
                                cl = p.substring(i);
                                p = path;
                                break;
                            }
                            i = i - ss[k - 1].length() - 1;
                        }
                        if (n != null) {
                            writer.print(m.group(1));
                            writer.print("import");
                            writer.print(m.group(2));
                            writer.print(n);
                            if (cl != null) {
                                writer.print(cl);
                            }
                            writer.print(m.group(4));
                            if (m.group(5) != null) {
                                writer.print(m.group(5));
                            } else {
                                for (k = ss.length; k > 0; --k) {
                                    path = p.substring(0, i);
                                    n = forwardMap.get(path);
                                    if (n == null || !n.equals(p)) continue;
                                    fullNameMap.put(p, n);
                                }
                                fullNameMap.put(p + cl, n + cl);
                            }
                            writer.println();
                            if (!p.equals(n) && !p.equals("autoplot")) {
                                logger.log(Level.FINER, "affected line {0} of {2}: {1}", new Object[]{reader.getLineNumber(), line, name});
                                affected = true;
                            }
                        } else {
                            writer.println(line);
                        }
                    } else {
                        if (fullNameMap.size() > 0) {
                            for (Map.Entry<String, String> e : fullNameMap.entrySet()) {
                                String s;
                                int singleQuoteCount;
                                Pattern identifierP = Pattern.compile("([a-zA-Z0-9\\.\\_]+)");
                                String skey = e.getKey();
                                i = line.indexOf(skey);
                                while (i > -1 && (singleQuoteCount = (s = line.substring(0, i)).split("'", -2).length - 1) % 2 == 0) {
                                    Matcher matcher = identifierP.matcher(line.substring(i));
                                    if (matcher.find()) {
                                        String mehave = matcher.group(1);
                                        String mewant = JythonRefactory.magicMatch(mehave);
                                        line = line.replace(mehave, mewant);
                                        i = line.indexOf(skey, i + mewant.length());
                                        if (mehave.equals(mewant)) continue;
                                        logger.log(Level.FINER, "affected line {0} of {2}: {1}", new Object[]{reader.getLineNumber(), line, name});
                                        affected = true;
                                        continue;
                                    }
                                    logger.warning("something has gone terribly wrong at JythonRefactory line 233");
                                    i = -1;
                                }
                            }
                        }
                        writer.println(line);
                    }
                }
                line = reader.readLine();
            }
        }
        if (affected) {
            logger.log(Level.WARNING, "{2} fixImports in {0}ms, affected={1}.  Code contains imports with old (\"virbo\") names.", new Object[]{System.currentTimeMillis() - t0, affected, name});
        } else {
            logger.log(Level.FINE, "{2} fixImports in {0}ms, affected={1}", new Object[]{System.currentTimeMillis() - t0, affected, name});
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static void main(String[] args) throws IOException {
        String line;
        System.err.println(JythonRefactory.magicMatch("org.virbo.autoplot.RenderType"));
        URL url = new URL("http://emfisis.physics.uiowa.edu/team/jyds/filterParm.jyds");
        InputStream in = JythonRefactory.fixImports(url.openStream(), "main");
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        while ((line = r.readLine()) != null) {
            System.err.println(line);
        }
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("org.virbo.dataset", "org.das2.qds");
        m.put("org.qdataset", "org.das2.qds");
        m.put("org.virbo.dataset.examples", "org.das2.qds.examples");
        m.put("org.virbo", "org.autoplot");
        m.put("org.virbo.autoplot", "org.autoplot");
        m.put("org.virbo.autoplot.dom", "org.autoplot.dom");
        m.put("org.virbo.autoplot.bookmarks", "org.autoplot.bookmarks");
        m.put("org.virbo.autoplot.state", "org.autoplot.state");
        m.put("org.virbo.datasource", "org.autoplot.datasource");
        m.put("org.autoplot.bufferdataset", "org.das2.qds.buffer");
        m.put("org.virbo.dsutil", "org.das2.qds.util");
        m.put("org.virbo.dsops", "org.das2.qds.ops");
        m.put("org.virbo.filters", "org.das2.qds.filters");
        m.put("org.virbo.qstream", "org.das2.qstream");
        m.put("org.qstream.filter", "org.das2.qstream.filter");
        m.put("org.virbo.ascii", "org.autoplot.ascii");
        m.put("org.virbo.das2Stream", "org.autoplot.das2stream");
        m.put("org.virbo.spase", "org.autoplot.spase");
        m.put("org.virbo.imagedatasource", "org.autoplot.imagedatasource");
        m.put("org.virbo.idlsupport", "org.autoplot.idlsupport");
        m.put("org.virbo.jythonsupport", "org.autoplot.jythonsupport");
        m.put("org", "org");
        m.put("autoplot", "autoplot2025");
        m.put("autoplotapp", "autoplotapp2017");
        forwardMap = m;
        fullNameMap = new HashMap<String, String>();
        IMPORT_REGEX = Pattern.compile("(\\s*)from(\\s+)([a-zA-Z0-9_.]+)(\\s+)import(\\s+)([a-zA-Z0-9_ ,\\*(]+)(\\s*)");
        IMPORT_AS_REGEX = Pattern.compile("(\\s*)import(\\s+)([a-zA-Z0-9_.]+)(\\s*)((\\s+)as(\\s+)([a-zA-Z0-9_]+)(\\s*))?");
    }
}

