/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.Util;
import org.das2.jythoncompletion.Utilities;
import org.das2.util.LoggerManager;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.parser;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Call;
import org.python.parser.ast.ClassDef;
import org.python.parser.ast.For;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.Global;
import org.python.parser.ast.If;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.VisitorBase;
import org.python.parser.ast.VisitorIF;
import org.python.parser.ast.While;
import org.python.parser.ast.aliasType;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;
import org.python.util.InteractiveInterpreter;

public class StaticCodeAnalysis {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.staticcodeanalysis");
    private static final Map<String, SimpleNode> definedNamesApp = new HashMap<String, SimpleNode>();

    public static List<SimpleNode> showReassignFunctionCall(String script, boolean appContext, String pwd) {
        Module n = (Module)parser.parse((String)script, (String)"exec");
        VisitNamesVisitorBase vb = new VisitNamesVisitorBase("");
        if (pwd != null) {
            vb.addName("PWD");
        }
        for (stmtType st : n.body) {
            vb.handleStmtType(st);
        }
        return vb.getReassignedFunctionCalls();
    }

    public static List<SimpleNode> showWriteWithoutRead(String script) {
        logger.log(Level.FINE, "# showWriteWithoutRead (script length={0})", script.length());
        Module n = (Module)parser.parse((String)script, (String)"exec");
        VisitNamesVisitorBase vb = new VisitNamesVisitorBase("");
        for (stmtType st : n.body) {
            logger.log(Level.FINER, "line {0}", st.beginLine);
            vb.handleStmtType(st);
        }
        return vb.getAssignedButNotRead();
    }

    public static List<SimpleNode> showReadButNotAssigned(String script, boolean appContext, String pwd) {
        Module n = (Module)parser.parse((String)script, (String)"exec");
        VisitNamesVisitorBase vb = new VisitNamesVisitorBase("");
        if (pwd != null) {
            vb.addName("PWD");
        }
        for (stmtType st : n.body) {
            vb.handleStmtType(st);
        }
        return vb.getReadButNotAssigned();
    }

    public static List<SimpleNode> showUsage(String script, String symbol) {
        Module n = (Module)parser.parse((String)script, (String)"exec");
        VisitNamesVisitorBase vb = new VisitNamesVisitorBase(symbol);
        for (stmtType st : n.body) {
            try {
                st.traverse(vb);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        List<SimpleNode> usages = vb.getNames();
        usages.forEach(use -> {
            int stop;
            int start = Utilities.getOffsetForLineNumber(script, use.beginLine - 1);
            String theLine = script.substring(start, stop = Utilities.getOffsetForLineNumber(script, use.beginLine));
            String theWord = theLine.substring(use.beginColumn - 1, use.beginColumn - 1 + symbol.length());
            if (!theWord.equals(symbol)) {
                logger.info("That bug with the parens has happened");
                int shift = theLine.indexOf(symbol, use.beginColumn - 1) - (use.beginColumn - 1);
                if (shift > 0) {
                    use.beginColumn += shift;
                }
            }
        });
        return usages;
    }

    static {
        try {
            boolean appContext;
            definedNamesApp.put("None", null);
            definedNamesApp.put("True", null);
            definedNamesApp.put("False", null);
            definedNamesApp.put("len", null);
            definedNamesApp.put("open", null);
            definedNamesApp.put("str", null);
            definedNamesApp.put("range", null);
            definedNamesApp.put("xrange", null);
            definedNamesApp.put("int", null);
            definedNamesApp.put("float", null);
            definedNamesApp.put("Exception", null);
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true);
            if (Util.isLegacyImports() && (appContext = true)) {
                try (InputStream in = JythonUtil.class.getResource("/appContextImports2017.py").openStream();){
                    interp.execfile(in, "/appContextImports2017.py");
                }
            }
            definedNamesApp.put("dom", null);
            definedNamesApp.put("monitor", null);
            definedNamesApp.put("plotx", null);
            definedNamesApp.put("plot", null);
            definedNamesApp.put("dataset", null);
            definedNamesApp.put("annotation", null);
            PyObject po = interp.getLocals();
            if (po instanceof PyStringMap) {
                PyStringMap psm = (PyStringMap)po;
                PyList k = psm.keys();
                for (int i = 0; i < k.__len__(); ++i) {
                    definedNamesApp.put(k.get(i).toString(), null);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JythonUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static class VisitNamesVisitorBase<R>
    extends VisitorBase {
        String name;
        List<SimpleNode> names;
        Map<String, SimpleNode> assignButNotReadWarning;
        List<SimpleNode> reassignedBeforeReadWarning;
        Map<String, SimpleNode> readButNotAssignedError;
        Map<String, SimpleNode> definedNames;
        Map<String, SimpleNode> reassignedFunctionCalls;
        List<SimpleNode> reassignedFunctionCallWarning;

        VisitNamesVisitorBase(String name) {
            if (name == null) {
                throw new NullPointerException("set to empty string not null");
            }
            this.name = name;
            this.names = new ArrayList<SimpleNode>();
            this.assignButNotReadWarning = new LinkedHashMap<String, SimpleNode>();
            this.reassignedBeforeReadWarning = new ArrayList<SimpleNode>();
            this.reassignedFunctionCalls = new LinkedHashMap<String, SimpleNode>();
            this.reassignedFunctionCallWarning = new ArrayList<SimpleNode>();
            this.readButNotAssignedError = new LinkedHashMap<String, SimpleNode>();
            this.definedNames = new HashMap<String, SimpleNode>(definedNamesApp);
        }

        public void addName(String name) {
            if (!this.definedNames.containsKey(name)) {
                this.definedNames.put(name, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void handleStmtType(stmtType st) {
            logger.log(Level.FINER, "handleStmtType line{0}", st.beginLine);
            try {
                if (st instanceof ImportFrom) {
                    for (aliasType a : ((ImportFrom)st).names) {
                        if (a.asname != null) {
                            this.addName(a.asname);
                            logger.log(Level.FINE, "assignButNotReadWarning asname {0}", a.asname);
                            this.assignButNotReadWarning.put(a.asname, (SimpleNode)a);
                            continue;
                        }
                        this.addName(a.name);
                        logger.log(Level.FINE, "assignButNotReadWarning name {0}", a.name);
                        this.assignButNotReadWarning.put(a.name, (SimpleNode)a);
                    }
                    st.traverse((VisitorIF)this);
                } else if (st instanceof Import) {
                    for (aliasType a : ((Import)st).names) {
                        if (a.asname != null) {
                            this.addName(a.asname);
                            continue;
                        }
                        this.addName(a.name);
                    }
                    st.traverse((VisitorIF)this);
                } else if (st instanceof Global) {
                    Global gst = (Global)st;
                    for (String string : gst.names) {
                        this.addName(string);
                    }
                } else if (st instanceof FunctionDef) {
                    FunctionDef fd = (FunctionDef)st;
                    this.addName(fd.name);
                    for (exprType exprType2 : fd.args.args) {
                        if (!(exprType2 instanceof Name)) continue;
                        this.addName(((Name)exprType2).id);
                    }
                    for (exprType exprType3 : fd.body) {
                        this.handleStmtType((stmtType)exprType3);
                    }
                } else if (st instanceof ClassDef) {
                    ClassDef cld = (ClassDef)st;
                    this.addName(cld.name);
                    for (exprType exprType4 : cld.bases) {
                        this.handleExprTypeRead(exprType4);
                    }
                    for (exprType exprType5 : cld.body) {
                        this.handleStmtType((stmtType)exprType5);
                    }
                } else if (st instanceof Assign) {
                    Assign ast = (Assign)st;
                    this.handleExprTypeRead(ast.value);
                    logger.log(Level.FINER, "assignButNotRead={0}", this.assignButNotReadWarning);
                    logger.log(Level.FINER, "reassignedBeforeRead={0}", this.reassignedBeforeReadWarning);
                    for (exprType exprType6 : ast.targets) {
                        this.handleExprTypeAssign(exprType6);
                    }
                } else if (st instanceof If) {
                    void var6_49;
                    If ist = (If)st;
                    this.handleExprTypeRead(ist.test);
                    HashMap<String, SimpleNode> beforeIf = new HashMap<String, SimpleNode>(this.assignButNotReadWarning);
                    stmtType[] stmtTypeArray = ist.body;
                    int a = stmtTypeArray.length;
                    boolean bl = false;
                    while (var6_49 < a) {
                        stmtType sst = stmtTypeArray[var6_49];
                        this.handleStmtType(sst);
                        ++var6_49;
                    }
                    if (ist.orelse != null) {
                        HashMap<String, SimpleNode> afterIf = new HashMap<String, SimpleNode>(this.assignButNotReadWarning);
                        ArrayList<stmtType[]> ifClears = new ArrayList<stmtType[]>();
                        for (stmtType[] n : beforeIf.keySet()) {
                            if (afterIf.containsKey(n)) continue;
                            ifClears.add(n);
                        }
                        this.assignButNotReadWarning = beforeIf;
                        HashMap<String, SimpleNode> hashMap = new HashMap<String, SimpleNode>(this.assignButNotReadWarning);
                        for (stmtType stmtType2 : ist.orelse) {
                            this.handleStmtType(stmtType2);
                        }
                        HashMap<String, SimpleNode> afterElse = new HashMap<String, SimpleNode>(this.assignButNotReadWarning);
                        ArrayList<String> elseClears = new ArrayList<String>();
                        for (String string : hashMap.keySet()) {
                            if (afterElse.containsKey(string)) continue;
                            elseClears.add(string);
                        }
                        this.assignButNotReadWarning.putAll(afterIf);
                        for (String string : ifClears) {
                            this.assignButNotReadWarning.remove(string);
                        }
                        for (String string : elseClears) {
                            this.assignButNotReadWarning.remove(string);
                        }
                    }
                } else if (st instanceof For) {
                    For fst = (For)st;
                    this.handleExprTypeRead(fst.iter);
                    this.handleExprTypeAssign(fst.target);
                    for (stmtType stmtType3 : fst.body) {
                        this.handleStmtType(stmtType3);
                    }
                    if (fst.orelse != null) {
                        for (stmtType stmtType4 : fst.orelse) {
                            this.handleStmtType(stmtType4);
                        }
                    }
                } else if (st instanceof While) {
                    While fst = (While)st;
                    this.handleExprTypeRead(fst.test);
                    for (stmtType stmtType5 : fst.body) {
                        this.handleStmtType(stmtType5);
                    }
                    this.handleExprTypeRead(fst.test);
                } else {
                    st.traverse((VisitorIF)this);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }

        private void handleExprTypeRead(exprType t) throws Exception {
            if (t instanceof Name) {
                this.visitName((Name)t);
            } else {
                t.traverse((VisitorIF)this);
            }
        }

        private void handleExprTypeAssign(exprType t) throws Exception {
            if (t instanceof Name) {
                String n = ((Name)t).id;
                if (this.definedNames.containsKey(n)) {
                    logger.finer("reassign name");
                    this.reassignedFunctionCalls.put(n, (SimpleNode)t);
                }
                this.addName(n);
                SimpleNode notRead = this.assignButNotReadWarning.get(n);
                if (notRead != null) {
                    logger.log(Level.FINE, "reassignedBeforeReadWarning {0} line {1}", new Object[]{n, ((Name)t).beginLine});
                    this.reassignedBeforeReadWarning.add(notRead);
                }
                this.assignButNotReadWarning.put(n, (SimpleNode)t);
            }
            t.traverse((VisitorIF)this);
        }

        public Object visitName(Name node) throws Exception {
            logger.log(Level.FINER, "visitName line{0} {1} {2}", new Object[]{node.beginLine, node.id, Name.expr_contextTypeNames[node.ctx]});
            if (this.name.equals(node.id)) {
                this.names.add((SimpleNode)node);
            }
            if (node.ctx == 2) {
                if (this.assignButNotReadWarning.containsKey(node.id)) {
                    this.reassignedBeforeReadWarning.add(this.assignButNotReadWarning.get(node.id));
                }
                this.assignButNotReadWarning.put(node.id, (SimpleNode)node);
                this.definedNames.put(node.id, (SimpleNode)node);
            } else if (node.ctx == 1) {
                if (this.assignButNotReadWarning.containsKey(node.id)) {
                    logger.log(Level.FINE, "assignedBeforeReadWarning use {0} line {1}", new Object[]{node.id, node.beginLine});
                }
                this.assignButNotReadWarning.remove(node.id);
                if (!this.definedNames.containsKey(node.id)) {
                    this.readButNotAssignedError.put(node.id, (SimpleNode)node);
                }
            }
            return node;
        }

        public Object visitCall(Call node) throws Exception {
            String name;
            if (node.func instanceof Name && this.reassignedFunctionCalls.containsKey(name = ((Name)node.func).id)) {
                this.reassignedFunctionCallWarning.add(this.reassignedFunctionCalls.get(name));
                this.reassignedFunctionCallWarning.add((SimpleNode)node);
            }
            return super.visitCall(node);
        }

        protected Object unhandled_node(SimpleNode sn) throws Exception {
            return sn;
        }

        public void traverse(SimpleNode sn) throws Exception {
            sn.traverse((VisitorIF)this);
        }

        public Object visitImport(Import node) throws Exception {
            this.handleStmtType((stmtType)node);
            return super.visitImport(node);
        }

        public Object visitImportFrom(ImportFrom node) throws Exception {
            this.handleStmtType((stmtType)node);
            return super.visitImportFrom(node);
        }

        public List<SimpleNode> getNames() {
            return this.names;
        }

        public List<SimpleNode> getAssignedButNotRead() {
            ArrayList<SimpleNode> result = new ArrayList<SimpleNode>(this.reassignedBeforeReadWarning);
            result.addAll(this.assignButNotReadWarning.values());
            return result;
        }

        public List<SimpleNode> getReadButNotAssigned() {
            return new ArrayList<SimpleNode>(this.readButNotAssignedError.values());
        }

        private List<SimpleNode> getReassignedFunctionCalls() {
            return new ArrayList<SimpleNode>(this.reassignedFunctionCallWarning);
        }
    }
}

