/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.jythonsupport.ui.NamedURIListTool;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.python.core.PyException;
import org.python.core.parser;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.BinOp;
import org.python.parser.ast.Call;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Num;
import org.python.parser.ast.Str;
import org.python.parser.ast.UnaryOp;
import org.python.parser.ast.exprType;

public class DataMashUp
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.mashup");
    private static final String LABEL_DIRECTIONS = "Double-click on the name to set the data set.  Shift-click for popup plot.";
    private static final QDataSet ERROR_DS = DataSetUtil.asDataSet((Datum)new EnumerationUnits("DataMashUp").createDatum((Object)"*Fail*"));
    private static final QDataSet NULL_DS = DataSetUtil.asDataSet((Datum)new EnumerationUnits("DataMashUp").createDatum((Object)"*Null*"));
    private ListCellRenderer myListCellRenderer = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String v = value.toString();
            if (v.contains(": ")) {
                int i = v.lastIndexOf(": ");
                String newv = "<html><b>" + v.substring(0, i) + "</b>: <i>" + v.substring(i + 2) + "</i>";
                label.setText(newv);
            }
            return label;
        }
    };
    private Resolver resolver;
    final Map<String, QDataSet> resolved = new HashMap<String, QDataSet>();
    final Map<String, String> resolvePending = new HashMap<String, String>();
    final Map<QDataSet, BufferedImage> imaged = new HashMap<QDataSet, BufferedImage>();
    final Map<QDataSet, String> imagePending = new HashMap<QDataSet, String>();
    private static final String REPLACEARGSFLAG = "(REPLACEARGSFLAG)";
    private JMenuItem addItemMenuItem;
    private JList<String> allList;
    private JButton calendarButton;
    private JList datasetList;
    private JMenuItem deleteItemsMenuItem;
    private JLabel directionsLabel;
    private JMenuItem editMenuItem;
    private JPopupMenu expressionPopupMenu;
    private JTree expressionTree;
    private JList filtersList;
    private JButton helpButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JList mathematicsList;
    private JPanel myFunctionsPanel;
    private NamedURIListTool namedURIListTool1;
    private JPopupMenu palettePopupMenu;
    private JMenuItem plotMenuItem;
    private JList scratchList;
    private JCheckBox synchronizeCB;
    private JLabel timeRangeLabel;
    private RecentComboBox timeRangeRecentComboBox;
    private BindingGroup bindingGroup;

    public void setUris(List<String> uris) {
        this.namedURIListTool1.setUris(uris);
    }

    public void setIds(List<String> ids) {
        this.namedURIListTool1.setIds(ids);
        ArrayList<Boolean> isAuto = new ArrayList<Boolean>(ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            isAuto.add(i, Boolean.FALSE);
        }
        this.namedURIListTool1.setIsAuto(isAuto);
    }

    public void rename(String oldName, String newName) {
        DefaultTreeModel tm = (DefaultTreeModel)this.expressionTree.getModel();
        this.renameImpl(tm, tm.getRoot(), oldName, newName);
        tm.reload();
    }

    private void renameImpl(DefaultTreeModel tm, Object parent, String oldName, String newName) {
        int n = tm.getChildCount(parent);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)tm.getChild(parent, i);
            if (dmtn.isLeaf()) {
                if (!dmtn.getUserObject().equals(oldName)) continue;
                dmtn.setUserObject(newName);
                continue;
            }
            this.renameImpl(tm, dmtn, oldName, newName);
        }
    }

    protected void refresh() {
        this.resolved.clear();
        this.imaged.clear();
        this.expressionTree.treeDidChange();
        this.expressionTree.revalidate();
        this.expressionTree.repaint();
        this.checkForTSB();
    }

    public DataMashUp() {
        this.initComponents();
        ArrayList<String> allItems = new ArrayList<String>();
        ArrayList<JList> lsms = new ArrayList<JList>();
        lsms.add(this.mathematicsList);
        lsms.add(this.datasetList);
        lsms.add(this.filtersList);
        lsms.add(this.scratchList);
        for (int i = 0; i < lsms.size(); ++i) {
            JList jc = (JList)lsms.get(i);
            for (int j = 0; j < jc.getModel().getSize(); ++j) {
                String s = (String)jc.getModel().getElementAt(j);
                allItems.add(s);
            }
        }
        Collections.sort(allItems);
        DefaultListModel<String> dlm = new DefaultListModel<String>();
        for (String s : allItems) {
            if (s.trim().length() <= 0) continue;
            dlm.addElement(s);
        }
        this.allList.setModel(dlm);
        this.timeRangeRecentComboBox.setPreferenceNode("timerange");
        this.namedURIListTool1.setDataMashUp(this);
        this.namedURIListTool1.addPropertyChangeListener("timeRange", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DataMashUp.this.timeRangeRecentComboBox.setText(DataMashUp.this.namedURIListTool1.getTimeRange().toString());
            }
        });
        DragSource dragSource = DragSource.getDefaultDragSource();
        DropTarget dropTarget = new DropTarget();
        try {
            dropTarget.addDropTargetListener(this.createTreeDropTargetListener());
        }
        catch (TooManyListenersException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.expressionTree.setDropTarget(dropTarget);
        DropTarget listDropTarget = new DropTarget();
        try {
            listDropTarget.addDropTargetListener(this.createListDropTargetListener());
        }
        catch (TooManyListenersException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.scratchList.setDropTarget(listDropTarget);
        dragSource.createDefaultDragGestureRecognizer(this.expressionTree, 3, this.createDragGestureListener());
        dragSource.createDefaultDragGestureRecognizer(this.mathematicsList, 3, this.createDragGestureListener());
        dragSource.createDefaultDragGestureRecognizer(this.datasetList, 3, this.createDragGestureListener());
        dragSource.createDefaultDragGestureRecognizer(this.filtersList, 3, this.createDragGestureListener());
        dragSource.createDefaultDragGestureRecognizer(this.scratchList, 3, this.createDragGestureListener());
        dragSource.createDefaultDragGestureRecognizer(this.allList, 3, this.createDragGestureListener());
        dragSource.createDefaultDragGestureRecognizer(this.namedURIListTool1, 3, this.createDragGestureListener());
        this.mathematicsList.setCellRenderer(this.myListCellRenderer);
        this.datasetList.setCellRenderer(this.myListCellRenderer);
        this.filtersList.setCellRenderer(this.myListCellRenderer);
        this.scratchList.setCellRenderer(this.myListCellRenderer);
        this.allList.setCellRenderer(this.myListCellRenderer);
        String data = "ds";
        TreePath tp = new TreePath(((DefaultMutableTreeNode)this.expressionTree.getModel().getRoot()).getPath());
        this.doDrop(data, tp);
        Runnable run = () -> this.backFromFile();
        new Thread(run).start();
    }

    private boolean isInfix(String op) {
        switch (op) {
            case "and": 
            case "or": {
                return true;
            }
        }
        return false;
    }

    private String getInfix(DefaultTreeModel m, Object o) {
        String op = o.toString();
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)o;
        switch (op) {
            case "and": {
                return this.getJython(m, m.getChild(n, 0)) + ".and(" + this.getJython(m, m.getChild(n, 1)) + ")";
            }
            case "or": {
                return this.getJython(m, m.getChild(n, 0)) + ".or(" + this.getJython(m, m.getChild(n, 1)) + ")";
            }
            case "multiply": {
                return this.getJython(m, m.getChild(n, 0)) + "*" + this.getJython(m, m.getChild(n, 1));
            }
            case "add": {
                return this.getJython(m, m.getChild(n, 0)) + "+" + this.getJython(m, m.getChild(n, 1));
            }
            case "divide": {
                return this.getJython(m, m.getChild(n, 0)) + "/" + this.getJython(m, m.getChild(n, 1));
            }
            case "subtract": {
                return this.getJython(m, m.getChild(n, 0)) + "-" + this.getJython(m, m.getChild(n, 1));
            }
            case "pow": {
                return this.getJython(m, m.getChild(n, 0)) + "**" + this.getJython(m, m.getChild(n, 1));
            }
        }
        return null;
    }

    private String getJython(DefaultTreeModel m, Object n) {
        if (m.isLeaf(n)) {
            return n.toString();
        }
        String sn = n.toString();
        int iparen = sn.indexOf("(");
        if (iparen > -1) {
            sn = sn.substring(0, iparen);
        }
        int nchild = m.getChildCount(n);
        if (this.isInfix(sn) && nchild == 2) {
            String alt = this.getInfix(m, n);
            if (alt != null) {
                if (m.getRoot() == n) {
                    return alt;
                }
                return "(" + alt + ")";
            }
            return this.getJython(m, m.getChild(n, 0)) + "." + sn + "(" + this.getJython(m, m.getChild(n, 1)) + ")";
        }
        StringBuilder t = new StringBuilder(sn + "(");
        for (int i = 0; i < nchild; ++i) {
            if (i > 0) {
                t.append(",");
            }
            t.append(this.getJython(m, m.getChild(n, i)));
        }
        t.append(")");
        return t.toString();
    }

    public String getAsJythonInline() {
        StringBuilder b = new StringBuilder("vap+inline:");
        b.append(this.namedURIListTool1.getAsJythonInline());
        b.append((CharSequence)this.getJythonSynchronize("&"));
        DefaultTreeModel m = (DefaultTreeModel)this.expressionTree.getModel();
        b.append(this.getJython(m, m.getRoot()));
        String timerange = this.timeRangeRecentComboBox.getText();
        if (this.timeRangeRecentComboBox.isEnabled()) {
            b.append("&timerange=").append(timerange.trim().replaceAll(" ", "+"));
        }
        return b.toString();
    }

    private StringBuilder getJythonSynchronize(String delim) {
        StringBuilder b = new StringBuilder();
        if (this.synchronizeCB.isSelected()) {
            String[] ids = this.namedURIListTool1.getIds();
            if (ids.length > 2) {
                StringBuilder list = new StringBuilder("(");
                list.append(ids[1]);
                for (int i = 2; i < ids.length; ++i) {
                    list.append(",").append(ids[i]);
                }
                list.append(")");
                b.append((CharSequence)list).append("=synchronize(").append(ids[0]).append(",").append((CharSequence)list).append(")").append(delim);
            } else if (ids.length == 2) {
                StringBuilder list = new StringBuilder("");
                list.append(ids[1]);
                b.append((CharSequence)list).append("=synchronizeOne(").append(ids[0]).append(",").append((CharSequence)list).append(")").append(delim);
            }
        }
        return b;
    }

    public String getAsJythonInline(TreeNode tn) {
        StringBuilder b = new StringBuilder("vap+inline:");
        b.append(this.namedURIListTool1.getAsJythonInline());
        String timerange = this.timeRangeRecentComboBox.getText();
        if (this.timeRangeRecentComboBox.isEnabled()) {
            b.append("timerange='").append(timerange.trim().replaceAll(" ", "+")).append("'&");
        }
        DefaultTreeModel m = (DefaultTreeModel)this.expressionTree.getModel();
        b.append(this.getJython(m, tn));
        b.append((CharSequence)this.getJythonSynchronize("&"));
        return b.toString();
    }

    public String getAsJythonExpr(TreeNode tn) {
        DefaultTreeModel m = (DefaultTreeModel)this.expressionTree.getModel();
        return this.getJython(m, tn);
    }

    private void fillTreeExprType(exprType et, MutableTreeNode parent, int i, List<String> datasets, List<String> usedDatasets) {
        if (et instanceof Name) {
            String name = ((Name)et).id;
            if (datasets.contains(name) || datasets.isEmpty() || name.equals("None")) {
                parent.insert(new DefaultMutableTreeNode(name), i);
            } else {
                parent.insert(new DefaultMutableTreeNode(datasets.get(0)), i);
            }
        } else if (et instanceof Num) {
            parent.insert(new DefaultMutableTreeNode(String.valueOf(((Num)et).n)), i);
        } else if (et instanceof Str) {
            parent.insert(new DefaultMutableTreeNode("'" + String.valueOf(((Str)et).s) + "'"), i);
        } else if (et instanceof Attribute) {
            exprType vv = ((Attribute)et).value;
            if (vv instanceof Name) {
                parent.insert(new DefaultMutableTreeNode(((Name)vv).id + "." + ((Attribute)et).attr), i);
            } else {
                logger.log(Level.FINE, "expected Name at {0}", et.toString());
                parent.insert(new DefaultMutableTreeNode("." + ((Attribute)et).attr), i);
            }
        } else if (et instanceof UnaryOp) {
            exprType et1 = ((UnaryOp)et).operand;
            switch (((UnaryOp)et).op) {
                case 4: {
                    this.fillTreeExprType(et1, parent, i, datasets, usedDatasets);
                    ((DefaultMutableTreeNode)parent.getChildAt(i)).setUserObject("-" + ((DefaultMutableTreeNode)parent.getChildAt(i)).getUserObject());
                    break;
                }
                case 3: {
                    this.fillTreeExprType(et1, parent, i, datasets, usedDatasets);
                    ((DefaultMutableTreeNode)parent.getChildAt(i)).setUserObject("+" + ((DefaultMutableTreeNode)parent.getChildAt(i)).getUserObject());
                    break;
                }
                default: {
                    this.fillTreeExprType(et1, parent, i, datasets, usedDatasets);
                    break;
                }
            }
        } else if (et instanceof BinOp) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(this.nameForBinOp(((BinOp)et).op));
            this.fillTreeBinOp((BinOp)et, child, datasets, usedDatasets);
            parent.insert(child, i);
        } else {
            Call call = (Call)et;
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(this.funcCallName(call));
            if (call.func instanceof Attribute) {
                this.fillTreeCall(((Attribute)call.func).value, call, child, datasets, usedDatasets);
            } else {
                this.fillTreeCall(call, child, datasets, usedDatasets);
            }
            parent.insert(child, i);
        }
    }

    private void fillTreeCall(Call c, MutableTreeNode parent, List<String> datasets, List<String> usedDatasets) {
        for (int i = 0; i < c.args.length; ++i) {
            exprType et = c.args[i];
            this.fillTreeExprType(et, parent, i, datasets, usedDatasets);
        }
    }

    private void fillTreeCall(exprType n, Call c, MutableTreeNode parent, List<String> datasets, List<String> usedDatasets) {
        this.fillTreeExprType(n, parent, 0, datasets, usedDatasets);
        for (int i = 0; i < c.args.length; ++i) {
            exprType et = c.args[i];
            this.fillTreeExprType(et, parent, i + 1, datasets, usedDatasets);
        }
    }

    private void fillTreeBinOp(BinOp c, MutableTreeNode parent, List<String> datasets, List<String> usedDatasets) {
        this.fillTreeExprType(c.left, parent, 0, datasets, usedDatasets);
        this.fillTreeExprType(c.right, parent, 1, datasets, usedDatasets);
    }

    private String funcCallName(Call c) {
        exprType et = c.func;
        if (et instanceof Name) {
            Name name = (Name)et;
            return name.id;
        }
        if (et instanceof Attribute) {
            Attribute attr = (Attribute)et;
            return attr.attr;
        }
        throw new IllegalArgumentException("unsupported call type");
    }

    public void setResolver(Resolver r) {
        this.directionsLabel.setText(LABEL_DIRECTIONS);
        this.expressionTree.setRowHeight(0);
        this.resolver = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QDataSet getDataSet(TreeNode value) {
        String uri = this.namedURIListTool1.getUriForId(value.toString());
        if (uri == null) {
            uri = this.getAsJythonInline(value);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            QDataSet qds = this.resolved.get(uri);
            if (qds == null) {
                Map<String, String> map = this.resolvePending;
                synchronized (map) {
                    if (this.resolvePending.containsKey(uri)) {
                        return null;
                    }
                    this.resolvePending.put(uri, "");
                }
                Runnable run = () -> {
                    this.getDataSet(value);
                    this.expressionTree.treeDidChange();
                };
                new Thread(run).start();
            }
            return qds;
        }
        Map<String, QDataSet> map = this.resolved;
        synchronized (map) {
            QDataSet qds = this.resolved.get(uri);
            if (qds == null) {
                logger.log(Level.FINE, "resolving URI {0}", uri);
                long t0 = System.currentTimeMillis();
                try {
                    qds = this.resolver.getDataSet(uri);
                    if (qds == null) {
                        qds = NULL_DS;
                    }
                    this.resolved.put(uri, qds);
                    this.resolvePending.remove(uri);
                    this.expressionTree.treeDidChange();
                    logger.log(Level.FINE, "done resolving URI in {0} ms: {1}", new Object[]{System.currentTimeMillis() - t0, uri});
                }
                catch (Exception ex) {
                    this.resolved.put(uri, ERROR_DS);
                    this.resolvePending.remove(uri);
                    this.expressionTree.treeDidChange();
                }
            }
            return qds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(QDataSet qds) {
        if (SwingUtilities.isEventDispatchThread()) {
            BufferedImage im = this.imaged.get(qds);
            if (im == null) {
                Map<QDataSet, String> map = this.imagePending;
                synchronized (map) {
                    if (this.imagePending.containsKey(qds)) {
                        return null;
                    }
                    this.imagePending.put(qds, "");
                }
                Runnable run = () -> {
                    if (qds != null) {
                        this.getImage(qds);
                        this.expressionTree.treeDidChange();
                    }
                };
                new Thread(run).start();
            }
            return im;
        }
        Map<QDataSet, BufferedImage> map = this.imaged;
        synchronized (map) {
            BufferedImage im = this.imaged.get(qds);
            if (im == null && qds != null) {
                logger.log(Level.FINE, "rendering dataset {0}", qds.toString());
                long t0 = System.currentTimeMillis();
                im = this.resolver.getImage(qds);
                Graphics g = im.getGraphics();
                g.setColor(Color.lightGray);
                g.drawRect(0, 0, im.getWidth() - 1, im.getHeight() - 1);
                this.imaged.put(qds, im);
                this.imagePending.remove(qds);
                this.expressionTree.treeDidChange();
                logger.log(Level.FINE, "done rendering dataset in {0} ms: {1}", new Object[]{System.currentTimeMillis() - t0, qds.toString()});
            }
            return im;
        }
    }

    private TreeCellRenderer getCellRenderer() {
        return (tree, value, selected, expanded, leaf, row, hasFocus) -> {
            BufferedImage im;
            String s = value.toString();
            Icon icon = null;
            if (this.resolver != null) {
                QDataSet ds = this.getDataSet((TreeNode)value);
                if (ds != null) {
                    s = "<html>" + s + " <span color='gray'>" + ds.toString() + "</span>";
                    im = this.getImage(ds);
                    if (im != null) {
                        icon = new ImageIcon(im);
                    }
                }
            } else if (!((DefaultMutableTreeNode)value).isLeaf() && tree.isCollapsed(row)) {
                String jy = this.getJython((DefaultTreeModel)tree.getModel(), value);
                s = "<html>" + s + " <span color='gray'>" + jy + "</span>";
            }
            JLabel result = new JLabel(s);
            if (icon != null) {
                result.setIcon(icon);
                Dimension d = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                result.setMinimumSize(d);
                result.setPreferredSize(new Dimension(600, icon.getIconHeight()));
            } else if (this.resolver != null) {
                im = new BufferedImage(60, 60, 2);
                Graphics2D g = (Graphics2D)im.getGraphics();
                g.setColor(Color.lightGray);
                g.drawRect(0, 0, im.getWidth() - 1, im.getHeight() - 1);
                result.setIcon(new ImageIcon(im));
                Dimension d = new Dimension(60, 60);
                result.setMinimumSize(d);
                result.setPreferredSize(new Dimension(600, 60));
            }
            return result;
        };
    }

    private MutableTreeNode getTreeNode(String expr, List<String> datasets, List<String> usedDatasets) {
        DefaultMutableTreeNode root;
        Module n;
        try {
            n = (Module)parser.parse((String)("x=" + expr), (String)"exec");
        }
        catch (PyException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            n = (Module)parser.parse((String)"x='error'", (String)"exec");
            expr = "error " + expr;
        }
        Assign assign = (Assign)n.body[0];
        if (assign.value instanceof Name) {
            String name = ((Name)assign.value).id;
            root = datasets.contains(name) || datasets.isEmpty() || name.equals("None") ? new DefaultMutableTreeNode(name) : new DefaultMutableTreeNode(datasets.get(datasets.size() - 1));
        } else if (assign.value instanceof Num) {
            root = new DefaultMutableTreeNode(((Num)assign.value).n);
        } else if (assign.value instanceof Str) {
            root = new DefaultMutableTreeNode(expr);
        } else if (assign.value instanceof Attribute) {
            root = new DefaultMutableTreeNode(expr);
        } else if (assign.value instanceof UnaryOp) {
            UnaryOp op = (UnaryOp)assign.value;
            root = op.operand instanceof Num ? new DefaultMutableTreeNode("-" + String.valueOf(((Num)op.operand).n).trim()) : new DefaultMutableTreeNode("0.0");
        } else if (assign.value instanceof BinOp) {
            BinOp op = (BinOp)assign.value;
            String sop = this.nameForBinOp(op.op);
            root = new DefaultMutableTreeNode(sop);
            this.fillTreeBinOp(op, root, datasets, usedDatasets);
        } else {
            root = new DefaultMutableTreeNode(this.funcCallName((Call)assign.value));
            if (assign.value instanceof Call) {
                Call c = (Call)assign.value;
                if (c.func instanceof Attribute) {
                    Attribute attr = (Attribute)c.func;
                    this.fillTreeCall(attr.value, c, root, datasets, usedDatasets);
                } else {
                    this.fillTreeCall(c, root, datasets, usedDatasets);
                }
            }
        }
        return root;
    }

    private String nameForBinOp(int op) {
        String sop;
        switch (op) {
            case 1: {
                sop = "add";
                break;
            }
            case 2: {
                sop = "subtract";
                break;
            }
            case 3: {
                sop = "multiply";
                break;
            }
            case 4: {
                sop = "divide";
                break;
            }
            case 6: {
                sop = "pow";
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot find name for BinOp (internal error at line 732)");
            }
        }
        return sop;
    }

    private void fillTree(String expr, List<String> datasets, List<String> usedDatasets) {
        Module n = (Module)parser.parse((String)("x=" + expr), (String)"exec");
        Assign assign = (Assign)n.body[0];
        if (assign.value instanceof Name) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(((Name)assign.value).id);
            DefaultTreeModel model = new DefaultTreeModel(root);
            this.expressionTree.setModel(model);
            this.expressionTree.setCellRenderer(this.getCellRenderer());
        } else {
            exprType et = assign.value;
            if (et instanceof Call) {
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.funcCallName((Call)assign.value));
                DefaultTreeModel model = new DefaultTreeModel(root);
                Call c = (Call)assign.value;
                if (c.func instanceof Attribute) {
                    Attribute attr = (Attribute)c.func;
                    this.fillTreeCall(attr.value, c, root, datasets, usedDatasets);
                } else {
                    this.fillTreeCall(c, root, datasets, usedDatasets);
                }
                this.expressionTree.setModel(model);
            } else if (et instanceof BinOp) {
                String sop = this.nameForBinOp(((BinOp)et).op);
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(sop);
                DefaultTreeModel model = new DefaultTreeModel(root);
                this.fillTreeBinOp((BinOp)et, root, datasets, usedDatasets);
                this.expressionTree.setModel(model);
            }
            for (int i = 0; i < this.expressionTree.getRowCount(); ++i) {
                this.expressionTree.expandRow(i);
            }
            this.expressionTree.setCellRenderer(this.getCellRenderer());
        }
    }

    protected static String[] guardedSplit(String s, char delim, char exclude1, char exclude2) {
        if (delim == '_') {
            throw new IllegalArgumentException("_ not allowed for delim");
        }
        StringBuilder scopyb = new StringBuilder(s.length());
        char inExclude = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inExclude == '\u0000') {
                if (c == exclude1 || c == exclude2) {
                    inExclude = c;
                }
            } else if (c == inExclude) {
                inExclude = '\u0000';
            }
            if (inExclude > '\u0000') {
                c = '_';
            }
            scopyb.append(c);
        }
        String[] ss = scopyb.toString().split("" + delim);
        int i1 = 0;
        for (int i = 0; i < ss.length; ++i) {
            int i2 = i1 + ss[i].length();
            ss[i] = s.substring(i1, i2);
            i1 = i2 + 1;
        }
        return ss;
    }

    public static JythonInlineDescriptor verifyJythonInline(String script) {
        JythonInlineDescriptor result = new JythonInlineDescriptor();
        if (script.startsWith("vap+inline:")) {
            script = script.substring(11);
        }
        String[] ss = DataMashUp.guardedSplit(script, '&', '\'', '\"');
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> uris = new ArrayList<String>();
        boolean haveAllIds = false;
        String timerange = null;
        String explicitTimerange = null;
        boolean synch = ss.length == 1;
        for (String s : ss) {
            if (s.trim().length() == 0) continue;
            int i = s.indexOf("=");
            if (i > -1) {
                Pattern p = Pattern.compile("(.+)=getDataSet\\('(.*)'\\)");
                Matcher m = p.matcher(s);
                if (m.matches()) {
                    String suri;
                    block15: {
                        URI uri;
                        ids.add(m.group(1));
                        suri = m.group(2);
                        try {
                            uri = new URI(suri);
                        }
                        catch (URISyntaxException ex) {
                            uri = null;
                        }
                        if (uri != null) {
                            try {
                                DataSourceFactory dsf = DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
                                if (dsf == null) break block15;
                                try {
                                    DataSource dss = dsf.getDataSource(new URI(suri));
                                    TimeSeriesBrowse tsb = (TimeSeriesBrowse)dss.getCapability(TimeSeriesBrowse.class);
                                    if (tsb == null) break block15;
                                    DatumRange tr = tsb.getTimeRange();
                                    if (tr != null) {
                                        timerange = tr.toString();
                                        suri = tsb.blurURI();
                                        break block15;
                                    }
                                    timerange = "";
                                }
                                catch (Exception ex) {
                                    logger.log(Level.SEVERE, null, ex);
                                }
                            }
                            catch (IOException | IllegalArgumentException | URISyntaxException ex) {
                                logger.log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    uris.add(suri);
                    continue;
                }
                if (s.contains("synchronize(")) {
                    synch = true;
                    continue;
                }
                if (s.contains("synchronizeOne(")) {
                    synch = true;
                    continue;
                }
                if (s.substring(0, i).trim().equals("timerange")) {
                    explicitTimerange = s.substring(i + 1).trim();
                    continue;
                }
                throw new IllegalArgumentException("script is not jython mashup");
            }
            result.expr = s;
        }
        result.ids = ids;
        result.uris = uris;
        result.timerange = explicitTimerange != null ? explicitTimerange : timerange;
        result.synchronize = synch;
        return result;
    }

    public void setAsJythonInline(String script) {
        JythonInlineDescriptor desc = DataMashUp.verifyJythonInline(script);
        this.setIds(desc.ids);
        this.setUris(desc.uris);
        this.fillTree(desc.expr, desc.ids, new ArrayList<String>());
        this.synchronizeCB.setSelected(desc.synchronize);
        if (desc.timerange == null) {
            this.timeRangeRecentComboBox.setText("");
            this.timeRangeRecentComboBox.setEnabled(false);
            this.timeRangeLabel.setEnabled(false);
            this.timeRangeLabel.setToolTipText("In-line code does not support Time Series Browse");
        } else {
            this.timeRangeRecentComboBox.setText(desc.timerange.replaceAll("\\+", " "));
            this.timeRangeRecentComboBox.setEnabled(true);
            this.timeRangeLabel.setEnabled(true);
            this.timeRangeLabel.setToolTipText("Current time range for data requests");
        }
    }

    public void enableTimeRange() {
        this.timeRangeLabel.setEnabled(true);
        this.timeRangeRecentComboBox.setEnabled(true);
    }

    private static boolean isChildOf(TreeNode parent, TreeNode child) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    private void doDrop(String data, TreePath tp) {
        this.doDrop(data, tp, true);
    }

    public static String printPath(Object[] newPath) {
        StringBuilder bb = new StringBuilder();
        for (Object newPath1 : newPath) {
            bb.append(",");
            bb.append(newPath1);
        }
        return bb.length() == 0 ? "" : bb.substring(1);
    }

    public static Object[] insertElement(Object[] array, int index, Object node) {
        if (array.length >= index) {
            Object[] result = new Object[array.length + 1];
            System.arraycopy(array, 0, result, 0, index);
            result[index] = node;
            System.arraycopy(array, index, result, index + 1, array.length - index);
            return result;
        }
        return array;
    }

    private void doDrop(String data, TreePath tp, boolean moveOldNodeDown) {
        DefaultTreeModel model = (DefaultTreeModel)this.expressionTree.getModel();
        MutableTreeNode oldBranch = (MutableTreeNode)tp.getLastPathComponent();
        Enumeration<TreePath> ppp = this.expressionTree.getExpandedDescendants(tp);
        ArrayList<TreePath> expandedDescendants = new ArrayList<TreePath>();
        if (ppp != null) {
            while (ppp.hasMoreElements()) {
                expandedDescendants.add(ppp.nextElement());
            }
        }
        MutableTreeNode parent = (MutableTreeNode)oldBranch.getParent();
        MutableTreeNode newBranch = this.getTreeNode(data, this.namedURIListTool1.ids, new ArrayList<String>());
        int index = -1;
        String arg0 = null;
        if (parent != null) {
            index = parent.getIndex(oldBranch);
            String vv = oldBranch.toString();
            if (Ops.isSafeName((String)vv) && oldBranch.getChildCount() == 0) {
                arg0 = vv;
            }
            model.removeNodeFromParent(oldBranch);
        }
        if (moveOldNodeDown && newBranch.getChildCount() > 0) {
            newBranch.remove(0);
            newBranch.insert(oldBranch, 0);
        }
        if (parent == null) {
            model.setRoot(newBranch);
        } else {
            model.insertNodeInto(newBranch, parent, index);
        }
        SwingUtilities.invokeLater(() -> {
            TreePath newTreePath = DataMashUp.getPath(newBranch);
            this.expressionTree.expandPath(newTreePath);
            for (TreePath tp1 : expandedDescendants) {
                Object[] path = tp1.getPath();
                Object[] newPath = DataMashUp.insertElement(path, tp.getPathCount() - 1, newBranch);
                TreePath mtp1 = new TreePath(newPath);
                this.expressionTree.expandPath(mtp1);
            }
            this.imaged.clear();
            this.resolved.clear();
            this.expressionTree.treeDidChange();
        });
    }

    private static TreePath getPath(TreeNode treeNode) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        if (treeNode != null) {
            nodes.add(treeNode);
            for (treeNode = treeNode.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
                nodes.add(0, treeNode);
            }
        }
        return nodes.isEmpty() ? null : new TreePath(nodes.toArray());
    }

    public static boolean isDataMashupJythonInline(String jython) {
        try {
            JythonInlineDescriptor desc = DataMashUp.verifyJythonInline(jython);
            String emptyScript = "vap+inline:ds";
            return !emptyScript.equals(desc.getAsJythonInline());
        }
        catch (Exception ex) {
            logger.log(Level.FINER, null, ex);
            return false;
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.palettePopupMenu = new JPopupMenu();
        this.addItemMenuItem = new JMenuItem();
        this.deleteItemsMenuItem = new JMenuItem();
        this.expressionPopupMenu = new JPopupMenu();
        this.editMenuItem = new JMenuItem();
        this.plotMenuItem = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.directionsLabel = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.expressionTree = new JTree();
        this.jPanel7 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.mathematicsList = new JList();
        this.jPanel3 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.datasetList = new JList();
        this.jPanel5 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.filtersList = new JList();
        this.myFunctionsPanel = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.scratchList = new JList();
        this.jPanel6 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.allList = new JList();
        this.jPanel2 = new JPanel();
        this.synchronizeCB = new JCheckBox();
        this.jScrollPane7 = new JScrollPane();
        this.namedURIListTool1 = new NamedURIListTool();
        this.jLabel1 = new JLabel();
        this.timeRangeLabel = new JLabel();
        this.timeRangeRecentComboBox = new RecentComboBox();
        this.helpButton = new JButton();
        this.calendarButton = new JButton();
        this.addItemMenuItem.setText("Add function...");
        this.addItemMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMashUp.this.addItemMenuItemActionPerformed(evt);
            }
        });
        this.palettePopupMenu.add(this.addItemMenuItem);
        this.deleteItemsMenuItem.setText("Delete Items");
        this.deleteItemsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMashUp.this.deleteItemsMenuItemActionPerformed(evt);
            }
        });
        this.palettePopupMenu.add(this.deleteItemsMenuItem);
        this.editMenuItem.setText("Edit");
        this.editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMashUp.this.editMenuItemActionPerformed(evt);
            }
        });
        this.expressionPopupMenu.add(this.editMenuItem);
        this.plotMenuItem.setText("Plot");
        this.plotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMashUp.this.plotMenuItemActionPerformed(evt);
            }
        });
        this.expressionPopupMenu.add(this.plotMenuItem);
        this.jSplitPane1.setDividerLocation(140);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane2.setDividerLocation(420);
        this.directionsLabel.setText("<html>Double-click on the name to set the variable or constant argument, or to replace the branch.");
        this.directionsLabel.setAlignmentY(0.0f);
        this.directionsLabel.setVerticalTextPosition(1);
        this.expressionTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DataMashUp.this.expressionTreeMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DataMashUp.this.expressionTreeMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                DataMashUp.this.expressionTreeMouseClicked(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.expressionTree);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.directionsLabel, -1, 540, Short.MAX_VALUE).addComponent(this.jScrollPane6));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.directionsLabel, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane6, -1, 292, Short.MAX_VALUE)));
        this.jSplitPane2.setRightComponent(this.jPanel4);
        this.jLabel2.setText("Drag functions onto the palette to the right.");
        this.mathematicsList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"add(x,y)", "add(x,y,z)", "subtract(x,y)", "multiply(x,y)", "divide(x,y)", "mod(x,y)", "pow(x,y)", "log10(x)", "sqrt(x)", "abs(x): the absolute value of the data", "magnitude(x): the lengths of the vectors", "toRadians(x)", "toDegrees(x)", "sin(x)", "cos(x)", "tan(x)", "asin(x)", "acos(x)", "atan2(y,x)", "atan(x)", "crossProduct(a,b)"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.mathematicsList.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.mathematicsList);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 419, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 291, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("mathematics", this.jPanel1);
        this.datasetList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"link(x,y): create data set where y is a function of x", "link(x,y,z): create data set where z is a function of x and y", "slice1(ds,0): slice ds(x,y) to create a new ds(x)", "smooth(ds,5): run boxcar average over the dataset", "putProperty(ds,QDataSet.UNITS,'s'): attach properties to the data", "getProperty(ds,QDataSet.DEPEND_0): get properties, like timetags.", "unbundle(ds,0): remove the 0th dataset from the bundle", "bundle(t,ds1,ds2): bundle the three datasets together", "collapse1(ds): average measurements along the dimension", "total(ds,1): sum measurements along the dimension", "trim1(ds,st,en): trim the indices in the the dimension"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.datasetList.setSelectionMode(0);
        this.jScrollPane4.setViewportView(this.datasetList);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, GroupLayout.Alignment.TRAILING, -1, 419, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, GroupLayout.Alignment.TRAILING, -1, 289, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("dataset", this.jPanel3);
        this.filtersList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"putValues(ds,w,v)", "removeValues(ds,w)", "removeValuesGreaterThan(ds,v)", "removeValuesLessThan(ds,v)", "where(c)", "lt(ds1,ds2)", "le(ds1,ds2)", "gt(ds1,ds2)", "ge(ds1,ds2)", "eq(ds1,ds2)", "ne(ds1,ds2)", "ds1.or(ds2)", "ds1.and(ds2)"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.filtersList.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.filtersList);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 419, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 289, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("filters", this.jPanel5);
        this.scratchList.setToolTipText("scratch is a list for storing expressions");
        this.scratchList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DataMashUp.this.scratchListMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DataMashUp.this.scratchListMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                DataMashUp.this.scratchListMouseClicked(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.scratchList);
        GroupLayout myFunctionsPanelLayout = new GroupLayout(this.myFunctionsPanel);
        this.myFunctionsPanel.setLayout(myFunctionsPanelLayout);
        myFunctionsPanelLayout.setHorizontalGroup(myFunctionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 419, Short.MAX_VALUE));
        myFunctionsPanelLayout.setVerticalGroup(myFunctionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 289, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("my functions", this.myFunctionsPanel);
        this.allList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.allList);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jScrollPane1, -1, 413, Short.MAX_VALUE).addGap(3, 3, 3)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jScrollPane1, -1, 283, Short.MAX_VALUE).addGap(3, 3, 3)));
        this.jTabbedPane1.addTab("all", this.jPanel6);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 328, Short.MAX_VALUE)).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.jTabbedPane1))));
        this.jSplitPane2.setLeftComponent(this.jPanel7);
        this.jSplitPane1.setBottomComponent(this.jSplitPane2);
        this.synchronizeCB.setSelected(true);
        this.synchronizeCB.setText("synchronize data by time tags, interpolating data to the first dataset's time tags");
        this.synchronizeCB.setToolTipText("Nearest Neighbor synchronization is used to line up the data, so that they can be combined.");
        this.namedURIListTool1.setMinimumSize(new Dimension(100, 100));
        this.namedURIListTool1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DataMashUp.this.namedURIListTool1FocusLost(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.namedURIListTool1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane7, GroupLayout.Alignment.TRAILING).addComponent(this.synchronizeCB, -1, 971, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane7, -1, 97, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.synchronizeCB, -2, 28, -2).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.jLabel1.setText("Load these Data Sets into variable names:");
        this.timeRangeLabel.setText("Time Range:");
        this.timeRangeLabel.setEnabled(false);
        this.timeRangeLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DataMashUp.this.timeRangeTextFieldFocusLost(evt);
            }
        });
        this.timeRangeRecentComboBox.setEnabled(false);
        this.timeRangeRecentComboBox.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DataMashUp.this.timeRangeRecentComboBoxFocusLost(evt);
            }
        });
        this.timeRangeRecentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMashUp.this.timeRangeRecentComboBoxActionPerformed(evt);
            }
        });
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/help.png")));
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMashUp.this.helpButtonActionPerformed(evt);
            }
        });
        this.calendarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/calendar.png")));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.timeRangeRecentComboBox, (Property)ELProperty.create((String)"${enabled}"), (Object)this.calendarButton, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.calendarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMashUp.this.calendarButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeRangeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.timeRangeRecentComboBox, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calendarButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton, -2, 109, -2).addContainerGap()).addComponent(this.jSplitPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.timeRangeLabel).addComponent((Component)this.timeRangeRecentComboBox, -2, -1, -2).addComponent(this.helpButton).addComponent(this.calendarButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1)));
        layout.linkSize(1, this.calendarButton, this.helpButton);
        this.bindingGroup.bind();
    }

    private void timeRangeTextFieldFocusLost(FocusEvent evt) {
    }

    private void plotExpr() {
        TreePath tp = this.expressionTree.getSelectionPath();
        if (tp == null) {
            return;
        }
        QDataSet showMe = this.resolved.get(this.getAsJythonInline((TreeNode)tp.getLastPathComponent()));
        if (showMe != null) {
            this.resolver.interactivePlot(showMe);
        } else if (this.resolver != null) {
            Runnable run = () -> {
                TreePath tp1 = this.expressionTree.getSelectionPath();
                if (tp1 == null) {
                    return;
                }
                QDataSet showMe1 = this.resolver.getDataSet(this.getAsJythonInline((TreeNode)tp1.getLastPathComponent()));
                this.resolver.interactivePlot(showMe1);
            };
            new Thread(run).start();
        } else {
            logger.info("resolver is not set.");
        }
    }

    private String getSelectedFunction() {
        Object o;
        Component c = this.jTabbedPane1.getSelectedComponent();
        if (c instanceof JPanel) {
            c = ((JPanel)c).getComponent(0);
        }
        if (c instanceof JScrollPane) {
            c = ((JScrollPane)c).getViewport().getComponent(0);
        }
        if (c instanceof JList && (o = ((JList)c).getSelectedValue()) instanceof String) {
            String s = (String)o;
            int i = s.indexOf(":");
            if (i > 1 && s.charAt(i - 1) == ')') {
                s = s.substring(0, i);
            }
            return s;
        }
        return "";
    }

    private void expressionTreeMouseClicked(MouseEvent evt) {
        if (evt.isShiftDown()) {
            TreePath tp = this.expressionTree.getClosestPathForLocation(evt.getX(), evt.getY());
            this.expressionTree.setSelectionPath(tp);
            this.plotExpr();
        } else if (evt.getClickCount() == 2) {
            TreePath tp = this.expressionTree.getClosestPathForLocation(evt.getX(), evt.getY());
            if (!this.expressionTree.getModel().isLeaf(tp.getLastPathComponent())) {
                return;
            }
            this.expressionTree.setSelectionPath(tp);
            String currentId = tp.getLastPathComponent().toString();
            this.namedURIListTool1.setExpression(this.getSelectedFunction());
            String s = this.namedURIListTool1.selectDataId(currentId);
            if (s != null) {
                this.doDrop(s, tp);
            }
        }
    }

    private void addItemMenuItemActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(this, (Object)"Add function");
        if (s != null && s.trim().length() != 0) {
            this.addToScratch(s.trim());
        }
    }

    private void deleteItemsMenuItemActionPerformed(ActionEvent evt) {
        int[] indices = this.scratchList.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.removeFromScratch(indices[i]);
        }
    }

    private void namedURIListTool1FocusLost(FocusEvent evt) {
        this.checkForTSB();
    }

    private void expressionTreeMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.plotMenuItem.setEnabled(this.resolver != null);
            this.expressionPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void editMenuItemActionPerformed(ActionEvent evt) {
        TreePath tp = this.expressionTree.getSelectionPath();
        if (tp == null) {
            JOptionPane.showMessageDialog(this, "A node must be selected", "Node must be selected", -1);
            return;
        }
        this.expressionTree.setSelectionPath(tp);
        if (!this.expressionTree.getModel().isLeaf(tp.getLastPathComponent())) {
            String s = this.getAsJythonExpr((TreeNode)tp.getLastPathComponent());
            if ((s = this.namedURIListTool1.selectDataId(s)) != null) {
                this.doDrop(s, tp, false);
            }
        } else {
            String currentId = tp.getLastPathComponent().toString();
            String s = this.namedURIListTool1.selectDataId(currentId);
            this.namedURIListTool1.setExpression(this.getSelectedFunction());
            if (s != null) {
                this.doDrop(s, tp, false);
            }
        }
    }

    private void expressionTreeMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.expressionPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void plotMenuItemActionPerformed(ActionEvent evt) {
        TreePath tp = this.expressionTree.getSelectionPath();
        if (tp == null) {
            JOptionPane.showMessageDialog(this, "A node must be selected", "Node must be selected", -1);
            return;
        }
        this.expressionTree.setSelectionPath(tp);
        this.plotExpr();
    }

    private void timeRangeRecentComboBoxFocusLost(FocusEvent evt) {
        String s = this.timeRangeRecentComboBox.getText().trim();
        if (s.length() > 0) {
            try {
                this.namedURIListTool1.setTimeRange(DatumRangeUtil.parseTimeRange((String)this.timeRangeRecentComboBox.getText()));
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void timeRangeRecentComboBoxActionPerformed(ActionEvent evt) {
        String s = this.timeRangeRecentComboBox.getText().trim();
        if (s.length() > 0) {
            try {
                this.namedURIListTool1.setTimeRange(DatumRangeUtil.parseTimeRange((String)this.timeRangeRecentComboBox.getText()));
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void scratchListMouseClicked(MouseEvent evt) {
        if (this.jTabbedPane1.getSelectedComponent() == this.myFunctionsPanel && evt.isPopupTrigger()) {
            this.palettePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void scratchListMouseReleased(MouseEvent evt) {
        if (this.jTabbedPane1.getSelectedComponent() == this.myFunctionsPanel && evt.isPopupTrigger()) {
            this.palettePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void scratchListMousePressed(MouseEvent evt) {
        if (this.jTabbedPane1.getSelectedComponent() == this.myFunctionsPanel && evt.isPopupTrigger()) {
            this.palettePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        DataSourceUtil.openBrowser((String)"http://autoplot.org/help.mashup");
    }

    private void calendarButtonActionPerformed(ActionEvent evt) {
        int r;
        LoggerManager.logGuiEvent((ActionEvent)evt);
        TimeRangeTool tt = new TimeRangeTool();
        String s = this.timeRangeRecentComboBox.getText();
        if (s != null) {
            tt.setSelectedRange(s);
        }
        if ((r = JOptionPane.showConfirmDialog(this, tt, "Select Time Range", 2)) == 0) {
            this.timeRangeRecentComboBox.setText(tt.getSelectedRange());
        }
    }

    private void checkForTSB() {
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable run = () -> this.checkForTSBImmediately();
            new Thread(run, "checkForTSB").start();
        } else {
            this.checkForTSBImmediately();
        }
    }

    private void checkForTSBImmediately() {
        String[] suris = this.namedURIListTool1.getUris();
        String timerange = this.timeRangeRecentComboBox.getText().trim();
        boolean haveTsb = false;
        for (String suri : suris) {
            URI uri;
            try {
                uri = new URI(suri);
            }
            catch (URISyntaxException ex) {
                uri = null;
            }
            if (uri == null) continue;
            try {
                DataSourceFactory dsf = DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
                if (dsf == null) continue;
                try {
                    DataSource dss = dsf.getDataSource(new URI(suri));
                    TimeSeriesBrowse tsb = (TimeSeriesBrowse)dss.getCapability(TimeSeriesBrowse.class);
                    if (tsb == null) continue;
                    haveTsb = true;
                    if (timerange.length() != 0) continue;
                    timerange = tsb.getTimeRange().toString();
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            catch (IOException | IllegalArgumentException | URISyntaxException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        String ftimerange = timerange;
        boolean fhaveTsb = haveTsb;
        Runnable run = () -> {
            if (fhaveTsb) {
                this.timeRangeRecentComboBox.setEnabled(true);
                this.timeRangeLabel.setEnabled(true);
                this.timeRangeRecentComboBox.setText(ftimerange);
            } else {
                this.timeRangeRecentComboBox.setEnabled(false);
                this.timeRangeLabel.setEnabled(false);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void removeFromScratch(int index) {
        DefaultListModel dlm;
        ListModel lm = this.scratchList.getModel();
        if (lm instanceof DefaultListModel) {
            dlm = (DefaultListModel)lm;
        } else {
            dlm = new DefaultListModel();
            for (int i = 0; i < lm.getSize(); ++i) {
                dlm.add(i, lm.getElementAt(i));
            }
        }
        dlm.remove(index);
        this.scratchList.setModel(dlm);
        Runnable run = () -> this.backToFile();
        new Thread(run).start();
    }

    private void addToScratch(String expression) {
        DefaultListModel dlm;
        String text0 = this.directionsLabel.getText();
        this.directionsLabel.setText("Replaced expression is added to my functions.");
        Timer t = new Timer(1500, e -> this.directionsLabel.setText(text0));
        t.setRepeats(false);
        t.start();
        ListModel lm = this.scratchList.getModel();
        if (lm instanceof DefaultListModel) {
            dlm = (DefaultListModel)lm;
        } else {
            dlm = new DefaultListModel();
            for (int i = 0; i < lm.getSize(); ++i) {
                dlm.add(i, lm.getElementAt(i));
            }
        }
        int remove = -1;
        for (int i = 0; i < dlm.size(); ++i) {
            if (!dlm.get(i).toString().equals(expression)) continue;
            remove = i;
        }
        if (remove > -1) {
            dlm.removeElementAt(remove);
        }
        dlm.add(dlm.getSize(), expression);
        this.scratchList.setModel(dlm);
        Runnable run = () -> this.backToFile();
        new Thread(run).start();
    }

    private void backToFile() {
        try {
            ListModel m = this.scratchList.getModel();
            File f = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
            File f1 = new File(f, "bookmarks");
            File f2 = new File(f1, "mashup.myfunctions.txt");
            try (PrintWriter w = new PrintWriter(new FileWriter(f2));){
                for (int i = 0; i < m.getSize(); ++i) {
                    w.println(m.getElementAt(i).toString());
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void backFromFile() {
        block15: {
            DefaultListModel<String> dlm = new DefaultListModel<String>();
            try {
                File f = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
                File f1 = new File(f, "bookmarks");
                File f2 = new File(f1, "mashup.myfunctions.txt");
                if (!f2.exists()) break block15;
                try (BufferedReader r = new BufferedReader(new FileReader(f2));){
                    String s;
                    while ((s = r.readLine()) != null) {
                        dlm.addElement(s);
                    }
                }
                Runnable run = () -> this.scratchList.setModel(dlm);
                SwingUtilities.invokeLater(run);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    final DropTargetListener createTreeDropTargetListener() {
        return new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dtde.acceptDrag(1);
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                TreePath tp = DataMashUp.this.expressionTree.getClosestPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
                DataMashUp.this.expressionTree.setSelectionPath(tp);
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String data = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    TreePath tp = DataMashUp.this.expressionTree.getClosestPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)tp.getLastPathComponent();
                    String old = DataMashUp.this.getJython((DefaultTreeModel)DataMashUp.this.expressionTree.getModel(), n);
                    if (old.contains("(")) {
                        DataMashUp.this.addToScratch(old);
                    }
                    if (data.endsWith(DataMashUp.REPLACEARGSFLAG)) {
                        data = data.substring(0, data.length() - 17);
                        DataMashUp.this.doDrop(data, tp, true);
                    } else {
                        DataMashUp.this.doDrop(data, tp, false);
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        };
    }

    final DropTargetListener createListDropTargetListener() {
        return new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dtde.acceptDrag(1);
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    String data = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    if (data.endsWith(DataMashUp.REPLACEARGSFLAG)) {
                        data = data.substring(0, data.length() - 17);
                    }
                    DataMashUp.this.addToScratch(data);
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        };
    }

    final DragGestureListener createDragGestureListener() {
        return dge -> {
            String s = null;
            boolean replaceArgs = false;
            if (dge.getComponent() instanceof JList) {
                s = (String)((JList)dge.getComponent()).getSelectedValue();
                replaceArgs = true;
            } else if (dge.getComponent() == this.expressionTree) {
                if (this.expressionTree.getSelectionCount() == 1) {
                    TreePath tp = this.expressionTree.getSelectionPath();
                    if (tp == null) {
                        return;
                    }
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)tp.getLastPathComponent();
                    s = this.getJython((DefaultTreeModel)this.expressionTree.getModel(), n);
                }
            } else if (dge.getComponent() == this.namedURIListTool1) {
                logger.fine("here where dge.getComponent()==namedURIListTool1");
            }
            if (s != null) {
                if (s.contains(": ")) {
                    int i = s.lastIndexOf(": ");
                    s = s.substring(0, i).trim();
                }
                if (replaceArgs) {
                    s = s + REPLACEARGSFLAG;
                }
                dge.startDrag(null, new StringSelection(s));
            }
        };
    }

    public static void main(String[] args) {
        DataMashUp dmu = new DataMashUp();
        dmu.setResolver(new Resolver(){
            EnumerationUnits eu = new EnumerationUnits("foo");

            @Override
            public QDataSet getDataSet(String uri) {
                return DataSetUtil.asDataSet((Datum)this.eu.createDatum((Object)uri));
            }

            @Override
            public BufferedImage getImage(QDataSet qds) {
                BufferedImage result = new BufferedImage(128, 32, 6);
                Graphics2D g = (Graphics2D)result.getGraphics();
                g.setColor(Color.DARK_GRAY);
                g.drawString(this.eu.createDatum(qds.value()).toString(), 2, 10);
                return result;
            }

            @Override
            public void interactivePlot(QDataSet qds) {
                System.err.println(qds);
            }
        });
        dmu.fillTree("add(a,b)", Collections.singletonList("z"), new ArrayList<String>());
        JOptionPane.showConfirmDialog(null, dmu);
        System.err.println(dmu.getAsJythonInline());
    }

    public static class JythonInlineDescriptor {
        String timerange;
        List<String> ids;
        List<String> uris;
        boolean synchronize;
        String expr;

        public String getAsJythonInline() {
            StringBuilder b = new StringBuilder("vap+inline:");
            for (int i = 0; i < this.uris.size(); ++i) {
                String uri = this.uris.get(i);
                if (uri.trim().length() <= 0) continue;
                String s = this.uris.get(i);
                if (s.contains("'")) {
                    logger.info("removing single quotes from URI, hope that doesn't break anything.");
                    b.append(this.ids.get(i)).append("=").append("getDataSet('").append(s.replaceAll("'", "")).append("')&");
                    continue;
                }
                b.append(this.ids.get(i)).append("=").append("getDataSet('").append(s).append("')&");
            }
            if (this.synchronize) {
                if (this.ids.size() > 2) {
                    StringBuilder list = new StringBuilder("(");
                    list.append(this.ids.get(1));
                    for (int i = 2; i < this.ids.size(); ++i) {
                        list.append(",").append(this.ids.get(i));
                    }
                    list.append(")");
                    b.append((CharSequence)list).append("=synchronize(").append(this.ids.get(0)).append(",").append((CharSequence)list).append(")").append("&");
                } else if (this.ids.size() == 2) {
                    StringBuilder list = new StringBuilder("");
                    list.append(this.ids.get(1));
                    b.append((CharSequence)list).append("=synchronizeOne(").append(this.ids.get(0)).append(",").append((CharSequence)list).append(")").append("&");
                }
            }
            b.append(this.expr);
            if (this.timerange != null) {
                b.append("&timerange=").append(this.timerange.trim().replaceAll(" ", "+"));
            }
            return b.toString();
        }
    }

    public static interface Resolver {
        public QDataSet getDataSet(String var1);

        public BufferedImage getImage(QDataSet var1);

        public void interactivePlot(QDataSet var1);
    }
}

