/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.jythonsupport.ui.EditorAnnotationsSupport;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.das2.DasApplication;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.python.core.PyException;

public class ScriptPanelSupport {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.editor");
    private final EditorTextPane editor;
    private final EditorAnnotationsSupport annotationsSupport;
    private JLabel fileNameLabel;
    private boolean readOnly = false;
    private DocumentListener dirtyListener;
    protected boolean dirty = false;
    public static final String PROP_DIRTY = "dirty";
    protected File file = null;
    public static final String PROP_FILE = "file";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ScriptPanelSupport(EditorTextPane editor) {
        this.editor = editor;
        this.dirtyListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ScriptPanelSupport.this.setDirty(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ScriptPanelSupport.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.editor.getDocument().addDocumentListener(this.dirtyListener);
        this.editor.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null) {
                    ((Document)evt.getOldValue()).removeDocumentListener(ScriptPanelSupport.this.dirtyListener);
                }
                ((Document)evt.getNewValue()).addDocumentListener(ScriptPanelSupport.this.dirtyListener);
            }
        });
        this.annotationsSupport = editor.getEditorAnnotationsSupport();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        boolean oldDirty = this.dirty;
        this.dirty = dirty;
        this.updateFileNameLabel();
        this.propertyChangeSupport.firePropertyChange(PROP_DIRTY, oldDirty, dirty);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        File oldFile = this.file;
        this.file = file;
        this.updateFileNameLabel();
        this.propertyChangeSupport.firePropertyChange(PROP_FILE, oldFile, file);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void save(File file) throws FileNotFoundException, IOException {
        if (file == null || FileSystemUtil.isChildOf((File)FileSystem.settings().getLocalCacheDir(), (File)file)) {
            this.saveAs();
            return;
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            String text = this.editor.getText();
            ((OutputStream)out).write(text.getBytes());
            this.setDirty(false);
        }
    }

    public void loadFile(File file) throws IOException, FileNotFoundException {
        logger.log(Level.FINE, "loadFile({0})", file);
        this.loadFileInternal(file);
        this.setFile(file);
        this.setDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFileInternal(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        final StringBuilder buf = new StringBuilder();
        try (BufferedReader r = null;){
            r = new BufferedReader(new InputStreamReader(in));
            String s = r.readLine();
            while (s != null) {
                buf.append(s).append("\n");
                s = r.readLine();
            }
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    Document d = ScriptPanelSupport.this.editor.getDocument();
                    d.remove(0, d.getLength());
                    d.insertString(0, buf.toString(), null);
                    ScriptPanelSupport.this.setDirty(false);
                }
                catch (BadLocationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void annotateError(PyException ex, int offset) throws BadLocationException {
        this.annotationsSupport.annotateError(ex, offset);
    }

    public void annotatePatch(Patch<String> patch) {
        this.annotationsSupport.clearAnnotations();
        int scrollToOffset = -1;
        for (AbstractDelta d : patch.getDeltas()) {
            int[] lp1;
            int i;
            Iterator iterator;
            ArrayList<Integer> ss;
            ArrayList<Integer> ll = d.getSource().getChangePosition();
            if (ll == null) {
                ll = new ArrayList<Integer>(d.getSource().size());
                for (int i2 = 0; i2 < d.getSource().size(); ++i2) {
                    ll.add(d.getSource().getPosition() + 1 + i2);
                }
            }
            if ((ss = d.getTarget().getChangePosition()) == null) {
                ss = new ArrayList<Integer>(d.getTarget().size());
                for (int i3 = 0; i3 < d.getTarget().size(); ++i3) {
                    ss.add(d.getTarget().getPosition() + 1 + i3);
                }
            }
            String sourceText = String.join((CharSequence)"<br>", d.getSource().getLines());
            if (d instanceof ChangeDelta) {
                sourceText = "<html><i>Text has been changed:</i><br>" + sourceText;
                iterator = ss.iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    int[] lp0 = this.annotationsSupport.getLinePosition(i);
                    lp1 = this.annotationsSupport.getLinePosition(i);
                    this.annotationsSupport.annotateChars(lp0[0], lp1[1], "change", sourceText, null);
                    if (scrollToOffset != -1) continue;
                    scrollToOffset = lp0[0];
                }
                continue;
            }
            if (d instanceof DeleteDelta) {
                sourceText = "<html><i>Text has been deleted:</i><br>" + sourceText;
                iterator = ll.iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    int[] lp0 = this.annotationsSupport.getLinePosition(i);
                    lp1 = this.annotationsSupport.getLinePosition(i);
                    this.annotationsSupport.annotateChars(lp0[0], lp1[1], "delete", sourceText, null);
                    if (scrollToOffset != -1) continue;
                    scrollToOffset = lp0[0];
                }
                continue;
            }
            if (!(d instanceof InsertDelta)) continue;
            iterator = ss.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                int[] lp0 = this.annotationsSupport.getLinePosition(i);
                lp1 = this.annotationsSupport.getLinePosition(i);
                this.annotationsSupport.annotateChars(lp0[0], lp1[1], "insert", "<html><i>Text has been inserted.</i>", null);
                if (scrollToOffset != -1) continue;
                scrollToOffset = lp0[0];
            }
        }
        if (scrollToOffset > -1) {
            try {
                this.annotationsSupport.scrollToOffset(scrollToOffset);
            }
            catch (BadLocationException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    private int getSaveFile() throws IOException {
        int r;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("python and jython scripts", "jy", "jyds", "py"));
        if (this.file != null && !FileSystemUtil.isChildOf((File)FileSystem.settings().getLocalCacheDir(), (File)this.file)) {
            chooser.setSelectedFile(this.file);
        }
        if ((r = chooser.showSaveDialog(this.editor)) == 0) {
            this.file = chooser.getSelectedFile();
            if (!(this.file.toString().endsWith(".jy") || this.file.toString().endsWith(".py") || this.file.toString().endsWith(".jyds"))) {
                this.file = new File(this.file.toString() + ".jy");
            }
        }
        return r;
    }

    private void saveAs() {
        OutputStream out = null;
        try {
            if (this.getSaveFile() == 0) {
                out = new FileOutputStream(this.file);
                String text = this.editor.getText();
                out.write(text.getBytes());
                this.setDirty(false);
                this.setFile(this.file);
            }
        }
        catch (IOException iOException) {
            DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)iOException);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public void setReadOnly() {
        this.editor.setEditable(false);
        this.readOnly = true;
        this.updateFileNameLabel();
    }

    public void addCaretLabel(final JLabel caretPositionLabel) {
        this.editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int pos = ScriptPanelSupport.this.editor.getCaretPosition();
                Element root = ScriptPanelSupport.this.editor.getDocument().getDefaultRootElement();
                int irow = root.getElementIndex(pos);
                int icol = pos - root.getElement(irow).getStartOffset();
                String text = "" + (1 + irow) + "," + (1 + icol);
                int isel = ScriptPanelSupport.this.editor.getSelectionEnd() - ScriptPanelSupport.this.editor.getSelectionStart();
                int iselRow0 = root.getElementIndex(ScriptPanelSupport.this.editor.getSelectionStart());
                int iselRow1 = root.getElementIndex(ScriptPanelSupport.this.editor.getSelectionEnd());
                if (isel > 0) {
                    text = iselRow1 > iselRow0 ? "[" + isel + "ch," + (1 + iselRow1 - iselRow0) + "lines]" : "[" + isel + "ch]";
                }
                caretPositionLabel.setText(text);
            }
        });
    }

    public void addFileLabel(JLabel fileNameLabel) {
        this.fileNameLabel = fileNameLabel;
        this.updateFileNameLabel();
    }

    private void updateFileNameLabel() {
        if (this.fileNameLabel != null) {
            this.fileNameLabel.setText(String.valueOf(this.getFile()) + " " + (this.isDirty() ? "*" : "") + (this.readOnly ? "(Read Only)" : ""));
        }
    }
}

