/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.das2.components.propertyeditor.PropertyEditor;

public class SyntaxColorBean {
    private Color tokenMarker = Color.WHITE;
    public static final String PROP_TOKENMARKER = "tokenMarker";
    private Color pairMarker = Color.WHITE;
    public static final String PROP_PAIRMARKER = "pairMarker";
    private Color carotColor = Color.WHITE;
    public static final String PROP_CAROTCOLOR = "carotColor";
    private Color backgroundColor = Color.WHITE;
    public static final String PROP_BACKGROUNDCOLOR = "backgroundColor";
    private Color selectionColor = Color.WHITE;
    public static final String PROP_SELECTIONCOLOR = "selectionColor";
    private Color styleOperator = Color.decode("0x000000");
    public static final String PROP_STYLEOPERATOR = "styleOperator";
    private Color styleDelimiter = Color.decode("0x000000");
    public static final String PROP_STYLEDELIMITER = "styleDelimiter";
    private Color styleKeyword = Color.decode("0x3333ee");
    public static final String PROP_STYLEKEYWORD = "styleKeyword";
    private Color styleKeyword2 = Color.decode("0x3333ee");
    public static final String PROP_STYLEKEYWORD2 = "styleKeyword2";
    private Color styleType = Color.decode("0x000000");
    public static final String PROP_STYLETYPE = "styleType";
    private Color styleType2 = Color.decode("0x000000");
    public static final String PROP_STYLETYPE2 = "styleType2";
    private Color styleType3 = Color.decode("0x000000");
    public static final String PROP_STYLETYPE3 = "styleType3";
    private Color styleString = Color.decode("0xcc6600");
    public static final String PROP_STYLESTRING = "styleString";
    private Color styleString2 = Color.decode("0xcc6600");
    public static final String PROP_STYLESTRING2 = "styleString2";
    private Color styleNumber = Color.decode("0x999933");
    public static final String PROP_STYLENUMBER = "styleNumber";
    private Color styleRegex = Color.decode("0xcc6600");
    public static final String PROP_STYLEREGEX = "styleRegex";
    private Color styleIdentifier = Color.decode("0x000000");
    public static final String PROP_STYLEIDENTIFIER = "styleIdentifier";
    private Color styleComment = Color.decode("0x339933");
    public static final String PROP_STYLECOMMENT = "styleComment";
    private Color styleComment2 = Color.decode("0x339933");
    public static final String PROP_STYLECOMMENT2 = "styleComment2";
    private Color styleDefault = Color.decode("0x000000");
    public static final String PROP_STYLEDEFAULT = "styleDefault";
    private Color styleWarning = Color.decode("0xCC0000");
    public static final String PROP_STYLEWARNING = "styleWarning";
    private Color styleError = Color.decode("0xCC0000");
    public static final String PROP_STYLEERROR = "styleError";
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Color getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(Color tokenMarker) {
        Color oldTokenMarker = this.tokenMarker;
        this.tokenMarker = tokenMarker;
        this.propertyChangeSupport.firePropertyChange(PROP_TOKENMARKER, oldTokenMarker, tokenMarker);
    }

    public Color getPairMarker() {
        return this.pairMarker;
    }

    public void setPairMarker(Color pairMarker) {
        Color oldPairMarker = this.pairMarker;
        this.pairMarker = pairMarker;
        this.propertyChangeSupport.firePropertyChange(PROP_PAIRMARKER, oldPairMarker, pairMarker);
    }

    public Color getCarotColor() {
        return this.carotColor;
    }

    public void setCarotColor(Color carotColor) {
        Color oldCarotColor = this.carotColor;
        this.carotColor = carotColor;
        this.propertyChangeSupport.firePropertyChange(PROP_CAROTCOLOR, oldCarotColor, carotColor);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        Color oldBackgroundColor = this.backgroundColor;
        this.backgroundColor = backgroundColor;
        this.propertyChangeSupport.firePropertyChange(PROP_BACKGROUNDCOLOR, oldBackgroundColor, backgroundColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        Color oldSelectionColor = this.selectionColor;
        this.selectionColor = selectionColor;
        this.propertyChangeSupport.firePropertyChange(PROP_SELECTIONCOLOR, oldSelectionColor, selectionColor);
    }

    public void setStyleOperator(Color c) {
        Color oldColor = this.styleOperator;
        this.styleOperator = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLEOPERATOR, oldColor, c);
    }

    public Color getStyleOperator() {
        return this.styleOperator;
    }

    public void setStyleDelimiter(Color c) {
        Color oldColor = this.styleDelimiter;
        this.styleDelimiter = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLEDELIMITER, oldColor, c);
    }

    public Color getStyleDelimiter() {
        return this.styleDelimiter;
    }

    public void setStyleKeyword(Color c) {
        Color oldColor = this.styleKeyword;
        this.styleKeyword = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLEKEYWORD, oldColor, c);
    }

    public Color getStyleKeyword() {
        return this.styleKeyword;
    }

    public void setStyleKeyword2(Color c) {
        Color oldColor = this.styleKeyword2;
        this.styleKeyword2 = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLEKEYWORD2, oldColor, c);
    }

    public Color getStyleKeyword2() {
        return this.styleKeyword2;
    }

    public void setStyleType(Color c) {
        Color oldColor = this.styleType;
        this.styleType = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLETYPE, oldColor, c);
    }

    public Color getStyleType() {
        return this.styleType;
    }

    public void setStyleType2(Color c) {
        Color oldColor = this.styleType2;
        this.styleType2 = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLETYPE2, oldColor, c);
    }

    public Color getStyleType2() {
        return this.styleType2;
    }

    public void setStyleType3(Color c) {
        Color oldColor = this.styleType3;
        this.styleType3 = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLETYPE3, oldColor, c);
    }

    public Color getStyleType3() {
        return this.styleType3;
    }

    public void setStyleString(Color c) {
        Color oldColor = this.styleString;
        this.styleString = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLESTRING, oldColor, c);
    }

    public Color getStyleString() {
        return this.styleString;
    }

    public void setStyleString2(Color c) {
        Color oldColor = this.styleString2;
        this.styleString2 = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLESTRING2, oldColor, c);
    }

    public Color getStyleString2() {
        return this.styleString2;
    }

    public void setStyleNumber(Color c) {
        Color oldColor = this.styleNumber;
        this.styleNumber = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLENUMBER, oldColor, c);
    }

    public Color getStyleNumber() {
        return this.styleNumber;
    }

    public void setStyleRegex(Color c) {
        Color oldColor = this.styleRegex;
        this.styleRegex = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLEREGEX, oldColor, c);
    }

    public Color getStyleRegex() {
        return this.styleRegex;
    }

    public void setStyleIdentifier(Color c) {
        Color oldColor = this.styleIdentifier;
        this.styleIdentifier = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLEIDENTIFIER, oldColor, c);
    }

    public Color getStyleIdentifier() {
        return this.styleIdentifier;
    }

    public void setStyleComment(Color c) {
        Color oldColor = this.styleComment;
        this.styleComment = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLECOMMENT, oldColor, c);
    }

    public Color getStyleComment() {
        return this.styleComment;
    }

    public void setStyleComment2(Color c) {
        Color oldColor = this.styleComment2;
        this.styleComment2 = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLECOMMENT2, oldColor, c);
    }

    public Color getStyleComment2() {
        return this.styleComment2;
    }

    public void setStyleDefault(Color c) {
        Color oldColor = this.styleDefault;
        this.styleDefault = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLEDEFAULT, oldColor, c);
    }

    public Color getStyleDefault() {
        return this.styleDefault;
    }

    public void setStyleWarning(Color c) {
        Color oldColor = this.styleWarning;
        this.styleWarning = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLEWARNING, oldColor, c);
    }

    public Color getStyleWarning() {
        return this.styleWarning;
    }

    public void setStyleError(Color c) {
        Color oldColor = this.styleError;
        this.styleError = c;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLEERROR, oldColor, c);
    }

    public Color getStyleError() {
        return this.styleError;
    }

    public void readFromConfig(File file) throws IOException {
        Pattern p = Pattern.compile("([a-zA-Z\\.]+)\\s*=\\s*([0-9a-fA-Fx]+)(\\s*\\,\\s*([0123])\\s*)?");
        try (Stream<String> linesStream = Files.lines(file.toPath());){
            linesStream.forEach(line -> {
                Matcher m = p.matcher((CharSequence)line);
                if (m.matches()) {
                    String prop = m.group(1);
                    String value = m.group(2);
                    Color c = Color.decode(value);
                    switch (prop) {
                        case "TokenMarker.Color": {
                            this.setTokenMarker(c);
                            break;
                        }
                        case "PairMarker.Color": {
                            this.setPairMarker(c);
                            break;
                        }
                        case "CaretColor": {
                            this.setCarotColor(c);
                            break;
                        }
                        case "Background": {
                            this.setBackgroundColor(c);
                            break;
                        }
                        case "SelectionColor": {
                            this.setSelectionColor(c);
                            break;
                        }
                        case "Style.OPERATOR": {
                            this.setStyleOperator(c);
                            break;
                        }
                        case "Style.DELIMITER": {
                            this.setStyleDelimiter(c);
                            break;
                        }
                        case "Style.KEYWORD": {
                            this.setStyleKeyword(c);
                            break;
                        }
                        case "Style.KEYWORD2": {
                            this.setStyleKeyword2(c);
                            break;
                        }
                        case "Style.TYPE": {
                            this.setStyleType(c);
                            break;
                        }
                        case "Style.TYPE2": {
                            this.setStyleType2(c);
                            break;
                        }
                        case "Style.TYPE3": {
                            this.setStyleType3(c);
                            break;
                        }
                        case "Style.STRING": {
                            this.setStyleString(c);
                            break;
                        }
                        case "Style.STRING2": {
                            this.setStyleString2(c);
                            break;
                        }
                        case "Style.NUMBER": {
                            this.setStyleNumber(c);
                            break;
                        }
                        case "Style.REGEX": {
                            this.setStyleRegex(c);
                            break;
                        }
                        case "Style.IDENTIFIER": {
                            this.setStyleIdentifier(c);
                            break;
                        }
                        case "Style.COMMENT": {
                            this.setStyleComment(c);
                            break;
                        }
                        case "Style.COMMENT2": {
                            this.setStyleComment2(c);
                            break;
                        }
                        case "Style.DEFAULT": {
                            this.setStyleDefault(c);
                            break;
                        }
                        case "Style.WARNING": {
                            this.setStyleWarning(c);
                            break;
                        }
                        case "Style.ERROR": {
                            this.setStyleError(c);
                            break;
                        }
                    }
                }
            });
        }
    }

    private String toHex(Color c) {
        return String.format("0x%06x", c.getRGB() & 0xFFFFFF);
    }

    public void writeToConfig(File f) throws FileNotFoundException {
        PrintWriter w = new PrintWriter(f);
        w.println("TokenMarker.Color = " + this.toHex(this.getTokenMarker()));
        w.println("PairMarker.Color = " + this.toHex(this.getPairMarker()));
        w.println("LineNumbers.Foreground = 0x333300");
        w.println("LineNumbers.Background = 0xeeeeff");
        w.println("LineNumbers.CurrentBack = 0xccccee");
        w.println("CaretColor = " + this.toHex(this.getCarotColor()));
        w.println("Background = " + this.toHex(this.getBackgroundColor()));
        w.println("SelectionColor = " + this.toHex(this.getSelectionColor()));
        w.println("# These are the various Attributes for each TokenType.");
        w.println("# The keys of this map are the TokenType Strings, and the values are:");
        w.println("# color (hex, or integer), Font.Style attribute");
        w.println("# Style is one of: 0 = plain, 1=bold, 2=italic, 3=bold/italic");
        w.println("Style.OPERATOR = " + this.toHex(this.getStyleOperator()) + ", 0");
        w.println("Style.DELIMITER = " + this.toHex(this.getStyleDelimiter()) + ", 1");
        w.println("Style.KEYWORD = " + this.toHex(this.getStyleKeyword()) + ", 0");
        w.println("Style.KEYWORD2 = " + this.toHex(this.getStyleKeyword2()) + ", 3");
        w.println("Style.TYPE = " + this.toHex(this.getStyleType()) + ", 2");
        w.println("Style.TYPE2 = " + this.toHex(this.getStyleType2()) + ", 1");
        w.println("Style.TYPE3 = " + this.toHex(this.getStyleType3()) + ", 3");
        w.println("Style.STRING = " + this.toHex(this.getStyleString()) + ", 0");
        w.println("Style.STRING2 = " + this.toHex(this.getStyleString2()) + ", 1");
        w.println("Style.NUMBER = " + this.toHex(this.getStyleNumber()) + ", 1");
        w.println("Style.REGEX = " + this.toHex(this.getStyleRegex()) + ", 0");
        w.println("Style.IDENTIFIER = " + this.toHex(this.getStyleIdentifier()) + ", 0");
        w.println("Style.COMMENT = " + this.toHex(this.getStyleComment()) + ", 2");
        w.println("Style.COMMENT2 = " + this.toHex(this.getStyleComment2()) + ", 3");
        w.println("Style.DEFAULT = " + this.toHex(this.getStyleDefault()) + ", 0");
        w.println("Style.WARNING = " + this.toHex(this.getStyleWarning()) + ", 0");
        w.println("Style.ERROR = " + this.toHex(this.getStyleError()) + ", 3");
        w.close();
    }

    public static void main(String[] args) throws IOException {
        SyntaxColorBean bean = new SyntaxColorBean();
        bean.readFromConfig(new File("/home/jbf/autoplot_data/config/jsyntaxpane.properties"));
        PropertyEditor edit = new PropertyEditor((Object)bean);
        edit.showModalDialog(null);
        bean.writeToConfig(new File("/home/jbf/autoplot_data/config/jsyntaxpane.xxx.properties"));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

