/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.das2.jythoncompletion.DefaultDocumentationItem;
import org.das2.jythoncompletion.Utilities;
import org.das2.jythoncompletion.support.CompletionItem;
import org.das2.jythoncompletion.support.CompletionResultSet;
import org.das2.jythoncompletion.support.CompletionTask;
import org.das2.jythoncompletion.support.CompletionUtilities;
import org.das2.jythoncompletion.ui.CompletionImpl;

public class DefaultCompletionItem
implements CompletionItem {
    String text;
    int offset;
    String complete;
    String label;
    String link;
    int sortPriority;
    boolean referenceOnly = false;
    ImageIcon icon = null;
    static final Logger logger = Logger.getLogger("jython.editor.completion");

    public DefaultCompletionItem(String text, int offset, String complete, String label, String link, int sortPriority, ImageIcon icon) {
        logger.log(Level.FINER, "DefaultCompletionItem {0}", text);
        if (complete.length() < offset) {
            throw new IllegalArgumentException("completion offset is less than length");
        }
        this.text = text;
        this.offset = offset;
        this.complete = complete;
        if (label == null) {
            label = complete;
        }
        this.label = label;
        this.link = link;
        this.sortPriority = sortPriority;
        this.icon = icon;
    }

    public void setReferenceOnly(boolean ref) {
        this.referenceOnly = ref;
    }

    public DefaultCompletionItem(String text, int offset, String complete, String label, String link) {
        this(text, offset, complete, label, link, 1, null);
    }

    public static DefaultCompletionItem error(String message) {
        return new DefaultCompletionItem(message, 0, "", message, null);
    }

    @Override
    public void defaultAction(JTextComponent jTextComponent) {
        if (this.referenceOnly) {
            return;
        }
        try {
            int pos = jTextComponent.getCaretPosition();
            Document d = jTextComponent.getDocument();
            int lineEnd = Utilities.getRowEnd(jTextComponent, pos);
            String restOfLine = d.getText(pos, lineEnd - pos);
            if (!restOfLine.startsWith(this.complete.substring(this.offset))) {
                d.insertString(pos, this.complete.substring(this.offset), null);
            }
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
        CompletionImpl.get().hideCompletion(false);
    }

    public String getComplete() {
        return this.complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void substituteText(JTextComponent c, int offset, int len, String toAdd) {
        Document doc = c.getDocument();
        String textl = this.getInsertPrefix().toString().substring(offset);
        if (textl != null) {
            try {
                String textToReplace = doc.getText(offset, len);
                if (textl.equals(textToReplace)) {
                    return;
                }
                Position position = doc.createPosition(offset);
                doc.remove(offset, len);
                doc.insertString(position.getOffset(), textl, null);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
    }

    @Override
    public int getPreferredWidth(Graphics graphics, Font font) {
        String left = this.label;
        String right = null;
        int i2 = this.label.indexOf("->");
        if (i2 > -1) {
            right = this.label.substring(i2 + 2);
            left = this.label.substring(0, i2);
        }
        return CompletionUtilities.getPreferredWidth(left, right, graphics, font);
    }

    @Override
    public void render(Graphics graphics, Font font, Color color, Color color0, int i, int i0, boolean b) {
        String left = this.label;
        String right = null;
        int i2 = this.label.indexOf("->");
        if (i2 > -1) {
            right = this.label.substring(i2 + 2);
            left = this.label.substring(0, i2);
        }
        CompletionUtilities.renderHtml(this.icon, left, right, graphics, font, color, i, i0, b);
    }

    private String findLink(String s) {
        String find = "http://";
        String[] ss = s.split(find, 2);
        if (ss.length == 1) {
            find = "https://";
            ss = s.split(find, 2);
        }
        if (ss.length == 1) {
            return null;
        }
        String[] ss2 = ss[1].split("\\s", 2);
        ss2 = ss2[0].split("<br>", 2);
        ss2 = ss2[0].split("'", 2);
        ss2 = ss2[0].split("\"", 2);
        return find + ss2[0];
    }

    @Override
    public CompletionTask createDocumentationTask() {
        if (this.link == null) {
            return null;
        }
        if (this.link.startsWith("inline:")) {
            final String fdoc = this.link.substring(7);
            return new CompletionTask(){

                @Override
                public void query(CompletionResultSet resultSet) {
                    String link = DefaultCompletionItem.this.findLink(fdoc);
                    resultSet.setDocumentation(new DefaultDocumentationItem(link, fdoc));
                    resultSet.finish();
                }

                @Override
                public void refresh(CompletionResultSet resultSet) {
                    this.query(resultSet);
                }

                @Override
                public void cancel() {
                }
            };
        }
        return new CompletionTask(){

            @Override
            public void query(CompletionResultSet resultSet) {
                resultSet.setDocumentation(new DefaultDocumentationItem(DefaultCompletionItem.this.link));
                resultSet.finish();
            }

            @Override
            public void refresh(CompletionResultSet resultSet) {
                this.query(resultSet);
            }

            @Override
            public void cancel() {
            }
        };
    }

    @Override
    public CompletionTask createToolTipTask() {
        return null;
    }

    @Override
    public boolean instantSubstitution(JTextComponent jTextComponent) {
        if (this.referenceOnly) {
            return false;
        }
        this.defaultAction(jTextComponent);
        return true;
    }

    @Override
    public int getSortPriority() {
        return this.sortPriority;
    }

    @Override
    public CharSequence getSortText() {
        return this.text;
    }

    @Override
    public CharSequence getInsertPrefix() {
        return this.text.substring(0, this.offset);
    }
}

