/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion;

import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class Utilities {
    public static int getRowStart(JTextComponent editor, int pos) {
        Element root = editor.getDocument().getDefaultRootElement();
        int iele = root.getElementIndex(pos);
        return root.getElement(iele).getStartOffset();
    }

    public static int getRowEnd(JTextComponent editor, int pos) {
        Element root = editor.getDocument().getDefaultRootElement();
        int iele = root.getElementIndex(pos);
        return root.getElement(iele).getEndOffset();
    }

    public static int getLineNumberForOffset(JTextArea a, int offset) throws BadLocationException {
        int line;
        for (line = 0; line < a.getRows() && a.getLineEndOffset(line) <= offset; ++line) {
        }
        return line;
    }

    public static int getLineNumberForOffset(JTextComponent comp, int offset) throws BadLocationException {
        Document doc = comp.getDocument();
        if (offset < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Can't translate offset to line", doc.getLength() + 1);
        }
        Element map = doc.getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public static int getOffsetForLineNumber(String text, int line) {
        String[] ss = text.split("\n");
        if (ss.length == 1) {
            return 0;
        }
        int firstNewLine = ss[0].length();
        int newlineLength = 1;
        if (text.length() > firstNewLine + 2 && text.charAt(firstNewLine) == '\r' && text.charAt(firstNewLine + 1) == '\n') {
            newlineLength = 2;
        }
        int index = 0;
        for (int i = 0; i < line; ++i) {
            index += ss[i].length() + newlineLength;
        }
        return index;
    }

    public static int getRowStart(JTextArea a, int offset) throws BadLocationException {
        int line = Utilities.getLineNumberForOffset(a, offset);
        return a.getLineStartOffset(line);
    }

    public static int getRowEnd(JTextArea a, int offset) throws BadLocationException {
        int line = Utilities.getLineNumberForOffset(a, offset);
        return a.getLineEndOffset(line);
    }

    public static String getWordAt(JTextPane logTextArea, int caret) throws BadLocationException {
        int caretEnd;
        Document d = logTextArea.getDocument();
        while (caret > 0 && !Character.isWhitespace(d.getText(caret, 1).charAt(0))) {
            --caret;
        }
        for (caretEnd = ++caret; caretEnd < d.getLength() && !Character.isWhitespace(d.getText(caretEnd, 1).charAt(0)); ++caretEnd) {
        }
        return d.getText(caret, caretEnd - caret);
    }

    public static int[] getLinePosition(JTextPane editor, int carotPos) {
        int j = carotPos;
        try {
            int i;
            int limit = editor.getText().length();
            for (i = carotPos; i > 0 && !editor.getText(i, 1).equals("\n"); --i) {
            }
            if (i >= 0 && i < limit - 1 && editor.getText(i, 1).equals("\n") && !editor.getText(i + 1, 1).equals("\n")) {
                ++i;
            }
            while (j < limit && !editor.getText(j, 1).equals("\n")) {
                ++j;
            }
            return new int[]{i, j - i};
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

