/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.das2.DasApplication;
import org.das2.DasProperties;
import org.das2.client.DasServer;
import org.das2.client.Key;
import org.das2.system.NullPreferences;
import org.das2.util.Crypt;

public class Authenticator
extends JPanel {
    JLabel feedbackLabel;
    JTextField tfUser;
    JPasswordField tfPass;
    DasServer dasServer;
    String resourceId;
    String resource;
    final String KEY_AUTOLOGIN = "autoLogin";
    final String KEY_SAVECREDENTIALS = "saveCredentials";
    Preferences prefs;

    public Authenticator(DasServer dasServer) {
        this(dasServer, "");
    }

    public Authenticator(DasServer dasServer, String restrictedResourceLabel) {
        try {
            this.prefs = Preferences.userNodeForPackage(Authenticator.class);
        }
        catch (NullPointerException ex) {
            this.prefs = new NullPreferences();
        }
        this.dasServer = dasServer;
        this.resourceId = String.valueOf(dasServer.getURL()) + "::" + restrictedResourceLabel;
        this.resource = restrictedResourceLabel;
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel(dasServer.getName(), 2));
        this.add(new JLabel(dasServer.getLogo(), 2));
        if (!"".equals(restrictedResourceLabel)) {
            this.add(new JLabel("" + restrictedResourceLabel));
        }
        this.add(new JLabel("Username: ", 2));
        this.tfUser = new JTextField();
        this.add(this.tfUser);
        this.add(new JLabel("Password: ", 2));
        this.tfPass = new JPasswordField();
        this.add(this.tfPass);
        JPanel prefsPanel = new JPanel();
        prefsPanel.setLayout(new BoxLayout(prefsPanel, 1));
        final JCheckBox cb = new JCheckBox();
        cb.setSelected(this.prefs.getBoolean("saveCredentials", true));
        cb.setAction(new AbstractAction("save credentials"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Authenticator.this.prefs.putBoolean("saveCredentials", cb.isSelected());
            }
        });
        prefsPanel.add(cb);
        cb = new JCheckBox();
        cb.setSelected(this.prefs.getBoolean("autoLogin", false));
        cb.setAction(new AbstractAction("allow automatic logins"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Authenticator.this.prefs.putBoolean("autoLogin", cb.isSelected());
            }
        });
        prefsPanel.add(cb);
        this.add(prefsPanel);
        if (this.prefs.getBoolean("saveCredentials", true)) {
            String passwordCrypt;
            String username = this.prefs.get(this.resourceId + ".username", DasProperties.getInstance().getProperty("username"));
            if (!"".equals(username)) {
                this.tfUser.setText(username);
            }
            if (!"".equals(passwordCrypt = this.prefs.get(this.resourceId + ".passwordCrypt", DasProperties.getInstance().getProperty("password")))) {
                this.tfPass.setText("usePrefs");
            }
        }
        this.feedbackLabel = new JLabel("", 2);
        this.feedbackLabel.setForeground(Color.red);
        this.add(this.feedbackLabel);
        try {
            String lockingKeyWarning = "";
            if (Toolkit.getDefaultToolkit().getLockingKeyState(20)) {
                lockingKeyWarning = lockingKeyWarning + ", CAPS LOCK is on";
            }
            if (!"".equals(lockingKeyWarning)) {
                this.feedbackLabel.setText(lockingKeyWarning.substring(2));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public Key authenticate() {
        Key result = null;
        int okayCancel = 0;
        if (this.prefs.getBoolean("autoLogin", false)) {
            String passCrypt;
            String username = this.prefs.get(this.resourceId + ".username", DasProperties.getInstance().getProperty("username"));
            result = this.dasServer.authenticate(username, passCrypt = this.prefs.get(this.resourceId + ".passwordCrypt", DasProperties.getInstance().getProperty("password")));
            if (result != null) {
                if (this.checkGroup(result)) {
                    return result;
                }
                this.feedbackLabel.setText(username + " doesn't have access to " + this.resource);
            } else {
                this.feedbackLabel.setText("stored credentials rejected by server");
            }
        }
        if (DasApplication.getDefaultApplication().isHeadless()) {
            System.err.println("head is not available to query for credentials");
            return null;
        }
        JFrame parent = DasApplication.getDefaultApplication().getMainFrame();
        while (okayCancel == 0 && result == null) {
            okayCancel = JOptionPane.showConfirmDialog(parent, this, "Authenticator", 2, -1);
            if (okayCancel != 0) continue;
            String username = this.tfUser.getText().trim();
            String password = String.valueOf(this.tfPass.getPassword());
            String passCrypt = null;
            passCrypt = password.equals("usePrefs") ? this.prefs.get(this.resourceId + ".passwordCrypt", DasProperties.getInstance().getProperty("password")) : Crypt.crypt((String)password);
            try {
                result = this.dasServer.authenticate(username, passCrypt);
                if (result == null) {
                    this.feedbackLabel.setText("Login incorrect");
                    continue;
                }
                if (!this.checkGroup(result)) {
                    this.feedbackLabel.setText(username + " doesn't have access to " + this.resource);
                    result = null;
                }
                if (!this.prefs.getBoolean("saveCredentials", true)) continue;
                this.prefs.put(this.resourceId + ".username", username);
                this.prefs.put(this.resourceId + ".passwordCrypt", passCrypt);
                this.prefs.flush();
            }
            catch (Exception e) {
                this.feedbackLabel.setText("Failed connect to server");
            }
        }
        return result;
    }

    private boolean checkGroup(Key result) {
        if (this.resource.equals("")) {
            return true;
        }
        List groups = this.dasServer.groups(result);
        return groups.contains(this.resource);
    }
}

