/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.components.ComponentsUtil;
import org.das2.components.SliceSettings;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.MouseModule;
import org.das2.event.PointSlopeDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Painter;
import org.das2.graph.Renderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.SymbolLineRenderer;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.system.DasLogger;
import org.das2.util.LoggerManager;

public class HorizontalSpectrogramSlicer
implements DataPointSelectionListener {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.gui.dmia");
    private JDialog popupWindow;
    private final DasPlot parentPlot;
    private DasPlot myPlot;
    private final DasAxis sourceZAxis;
    private final DasAxis sourceXAxis;
    protected Datum xValue;
    protected Datum yValue;
    protected Datum ySlice;
    JPanel buttonPanel;
    List<Action> additionalActions = new ArrayList<Action>();
    private SymbolLineRenderer renderer;
    private Color markColor = new Color(230, 230, 230);

    private HorizontalSpectrogramSlicer(DasPlot parent, DasAxis sourceXAxis, DasAxis sourceZAxis) {
        this.sourceZAxis = sourceZAxis;
        this.sourceXAxis = sourceXAxis;
        this.parentPlot = parent;
    }

    private void initPlot(DasCanvas canvas) {
        DasAxis xAxis = this.sourceXAxis.createAttachedAxis(2);
        DasAxis yAxis = this.sourceZAxis.createAttachedAxis(3);
        this.myPlot = new DasPlot(xAxis, yAxis);
        this.renderer = new SymbolLineRenderer();
        this.renderer.setAntiAliased(true);
        this.myPlot.addRenderer(this.renderer);
        canvas.addTopDecorator(new Painter(){

            @Override
            public void paint(Graphics2D g) {
                int ix = (int)HorizontalSpectrogramSlicer.this.myPlot.getXAxis().transform(HorizontalSpectrogramSlicer.this.xValue);
                DasRow row = HorizontalSpectrogramSlicer.this.myPlot.getRow();
                int iy0 = row.getDMinimum();
                int iy1 = row.getDMaximum();
                g.drawLine(ix + 3, iy0, ix, iy0 + 3);
                g.drawLine(ix - 3, iy0, ix, iy0 + 3);
                g.drawLine(ix + 3, iy1, ix, iy1 - 3);
                g.drawLine(ix - 3, iy1, ix, iy1 - 3);
                g.setColor(HorizontalSpectrogramSlicer.this.markColor);
                g.drawLine(ix, iy0 + 4, ix, iy1 - 4);
            }
        });
        this.myPlot.getDasMouseInputAdapter().addMouseModule(new MouseModule(this.myPlot, new PointSlopeDragRenderer(this.myPlot, this.myPlot.getXAxis(), this.myPlot.getYAxis()), "Slope"));
    }

    public void addAction(Action a) {
        this.additionalActions.add(a);
        if (this.buttonPanel != null) {
            JButton b = new JButton(a);
            this.buttonPanel.add((Component)b, 0);
        }
    }

    protected void setDataSet(QDataSet ds) {
        this.renderer.setDataSet(ds);
    }

    public QDataSet getDataSet() {
        return this.renderer.getDataSet();
    }

    public Datum getSliceY() {
        return this.ySlice;
    }

    public static HorizontalSpectrogramSlicer createSlicer(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceXAxis = plot.getXAxis();
        DasAxis sourceZAxis = dataSetConsumer.getZAxis();
        return new HorizontalSpectrogramSlicer(plot, sourceXAxis, sourceZAxis);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    HorizontalSpectrogramSlicer.this.showPopupImpl();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    public void dispose() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
        }
    }

    public void clear(QDataSet tds) {
        if (this.renderer != null) {
            if (tds == null) {
                this.renderer.setDataSet(null);
            } else {
                try {
                    if (this.isPopupVisible()) {
                        this.showSlice(tds, this.xValue, this.yValue);
                    }
                }
                catch (InconvertibleUnitsException ex) {
                    this.renderer.setDataSet(null);
                }
            }
        }
    }

    private void createPopup() {
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        final DasCanvas canvas = new DasCanvas(width, height);
        canvas.setScaleFonts(false);
        if (this.myPlot == null) {
            this.initPlot(canvas);
        }
        DasRow row = new DasRow(canvas, null, 0.0, 1.0, 3.0, -5.0, 0, 0);
        DasColumn column = new DasColumn(canvas, null, 0.0, 1.0, 7.0, -3.0, 0, 0);
        canvas.add(this.myPlot, row, column);
        JPanel content = new JPanel(new BorderLayout());
        this.buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(this.buttonPanel, 0);
        this.buttonPanel.setLayout(buttonLayout);
        if (this.additionalActions != null && this.additionalActions.size() > 0) {
            for (Action a : this.additionalActions) {
                this.buttonPanel.add(new JButton(a));
            }
        }
        this.buttonPanel.add(Box.createHorizontalGlue());
        JButton pdfButton = new JButton(ComponentsUtil.getPdfButtonAction(canvas));
        this.buttonPanel.add(pdfButton);
        JButton printButton = new JButton(new AbstractAction("Print..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                canvas.makeCurrent();
                DasCanvas.PRINT_ACTION.actionPerformed(e);
            }
        });
        this.buttonPanel.add(printButton);
        JButton settingsButton = new JButton(new AbstractAction("Settings..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpectrogramRenderer rend = null;
                for (Renderer r : HorizontalSpectrogramSlicer.this.parentPlot.getRenderers()) {
                    if (!(r instanceof SpectrogramRenderer)) continue;
                    rend = (SpectrogramRenderer)r;
                    break;
                }
                if (rend == null) {
                    JOptionPane.showMessageDialog(null, "Unable to find associated Spectrogram");
                    return;
                }
                SliceSettings settings = new SliceSettings();
                settings.setSliceRebinnedData(rend.isSliceRebinnedData());
                Font ff = HorizontalSpectrogramSlicer.this.myPlot.getCanvas().getBaseFont();
                settings.setFont(SliceSettings.encodeFont(ff));
                new PropertyEditor(settings).showModalDialog(canvas);
                rend.setSliceRebinnedData(settings.isSliceRebinnedData());
                String f = settings.getFont();
                if (f.length() > 0) {
                    HorizontalSpectrogramSlicer.this.myPlot.getCanvas().setBaseFont(Font.decode(f));
                    HorizontalSpectrogramSlicer.this.myPlot.invalidateCacheImage();
                    HorizontalSpectrogramSlicer.this.myPlot.repaint();
                    HorizontalSpectrogramSlicer.this.myPlot.getCanvas().setSize(HorizontalSpectrogramSlicer.this.myPlot.getCanvas().getSize());
                    HorizontalSpectrogramSlicer.this.myPlot.getCanvas().revalidate();
                    HorizontalSpectrogramSlicer.this.myPlot.getCanvas().repaint();
                }
                QDataSet ds = rend.getConsumedDataSet();
                HorizontalSpectrogramSlicer.this.showSlice(ds, HorizontalSpectrogramSlicer.this.xValue, HorizontalSpectrogramSlicer.this.yValue);
            }
        });
        this.buttonPanel.add(settingsButton);
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HorizontalSpectrogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        this.buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)this.buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = new JDialog(parentWindow);
        this.popupWindow.setTitle("Horizontal Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point(0, this.parentPlot.getY());
        parentLocation.translate(this.parentPlot.getX() / 20, -1 * this.myPlot.getRow().getDMinimum());
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        int xx = parentLocation.x + this.parentPlot.getCanvas().getWidth();
        int yy = parentLocation.y;
        Rectangle r = ComponentsUtil.verifyVisible(new Rectangle(xx, yy, width, height));
        if (r != null) {
            xx = r.x;
            yy = r.y;
        }
        this.popupWindow.setLocation(xx, yy);
    }

    protected boolean isPopupVisible() {
        return this.popupWindow != null && this.popupWindow.isVisible() && this.myPlot.getCanvas() != null;
    }

    @Override
    public void dataPointSelected(DataPointSelectionEvent e) {
        this.yValue = e.getY();
        this.xValue = e.getX();
        QDataSet ds = e.getDataSet();
        if (ds == null) {
            return;
        }
        if (Schemes.isXYZScatter((QDataSet)ds)) {
            logger.fine("gridding data to support mouse module");
            ds = Ops.grid((QDataSet)ds);
        } else if (!SemanticOps.isTableDataSet((QDataSet)ds)) {
            logger.log(Level.WARNING, "dataset scheme is not supported: {0}", ds);
        }
        QDataSet tds = ds;
        if (!this.showSlice(tds, this.xValue, this.yValue)) {
            this.parentPlot.getDasMouseInputAdapter().getFeedback().setMessage("Horizontal Slice is unable to find data");
        }
    }

    private boolean showSlice(QDataSet tds, Datum xValue, Datum yValue) {
        String ystr;
        MutablePropertyDataSet sliceDataSet;
        Datum yy;
        QDataSet tds1 = null;
        if (tds.rank() == 3) {
            for (int i = 0; i < tds.length(); ++i) {
                QDataSet bounds = DataSetOps.dependBounds((QDataSet)tds.slice(i));
                if (DataSetOps.boundsContains((QDataSet)bounds, (Datum)xValue, (Datum)yValue)) {
                    tds1 = tds.slice(i);
                    break;
                }
                Units xunits = SemanticOps.getUnits((QDataSet)bounds.slice(0));
                if (xunits.isConvertibleTo(xValue.getUnits()) || !UnitsUtil.isRatioMeasurement((Units)xunits) || xunits != Units.dimensionless && xValue.getUnits() != Units.dimensionless) continue;
                xValue = xunits.createDatum(xValue.value());
            }
        } else {
            double v;
            QDataSet xrange = Ops.extent((QDataSet)SemanticOps.xtagsDataSet((QDataSet)tds));
            QDataSet yrange = Ops.extent((QDataSet)SemanticOps.ytagsDataSet((QDataSet)tds));
            QDataSet bounds = Ops.join((QDataSet)xrange, (QDataSet)yrange);
            Units xunits = SemanticOps.getUnits((QDataSet)xrange);
            Units yunits = SemanticOps.getUnits((QDataSet)yrange);
            if (!xunits.isConvertibleTo(xValue.getUnits()) && UnitsUtil.isRatioMeasurement((Units)xunits) && (xunits == Units.dimensionless || xValue.getUnits() == Units.dimensionless)) {
                xValue = xunits.createDatum(xValue.value());
            }
            if (!yunits.isConvertibleTo(yValue.getUnits()) && UnitsUtil.isRatioMeasurement((Units)yunits) && (yunits == Units.dimensionless || yValue.getUnits() == Units.dimensionless)) {
                yValue = yunits.createDatum(yValue.value());
            }
            if ((v = Math.abs((xrange.value(1) - xrange.value(0)) * (yrange.value(1) - yrange.value(0)))) == 0.0 || DataSetOps.boundsContains((QDataSet)bounds, (Datum)xValue, (Datum)yValue)) {
                tds1 = tds;
            }
        }
        if (tds1 == null) {
            return false;
        }
        QDataSet yds = SemanticOps.ytagsDataSet(tds1);
        if (yds.rank() == 2 && yds.property("BINS_1") == null) {
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)tds1);
            int ix = DataSetUtil.closestIndex((QDataSet)xds, (Datum)xValue);
            QDataSet yds1 = yds.slice(ix);
            int iy = DataSetUtil.closestIndex((QDataSet)yds1, (Datum)yValue);
            yy = DataSetUtil.asDatum((QDataSet)yds.slice(ix).slice(iy));
            IDataSet eqdep1 = IDataSet.createRank1((int)yds.length());
            eqdep1.putValue(ix, 1.0);
            DataSetBuilder bz = new DataSetBuilder(1, yds.length());
            bz.putProperty("UNITS", tds1.property("UNITS"));
            DataSetBuilder bx = new DataSetBuilder(1, yds.length());
            int lastIndex = iy;
            for (int i = 0; i < yds.length(); ++i) {
                if (yds.value(i, lastIndex) == yy.value()) {
                    bz.putValue(-1, tds1.value(i, lastIndex));
                    bx.putValue(-1, xds.value(i));
                    bx.nextRecord();
                    bz.nextRecord();
                    continue;
                }
                try {
                    int j = DataSetUtil.closestIndex((QDataSet)yds.slice(i), (Datum)yValue);
                    if (yds.value(i, j) != yy.value()) continue;
                    lastIndex = j;
                    bz.putValue(-1, tds1.value(i, lastIndex));
                    bx.putValue(-1, xds.value(i));
                    bx.nextRecord();
                    bz.nextRecord();
                    continue;
                }
                catch (IllegalArgumentException j) {
                    // empty catch block
                }
            }
            DDataSet s1 = bz.getDataSet();
            DDataSet sx = bx.getDataSet();
            sx.putProperty("UNITS", xds.property("UNITS"));
            s1.putProperty("DEPEND_0", (Object)sx);
            sliceDataSet = s1;
            DatumFormatter yformatter = yy.getFormatter();
            ystr = yformatter.format(yy);
            this.ySlice = yy;
        } else {
            int iy = DataSetUtil.closestIndex((QDataSet)yds, (Datum)yValue);
            if (yds.rank() == 1) {
                yy = DataSetUtil.asDatum((QDataSet)yds.slice(iy));
                DatumFormatter yformatter = yy.getFormatter();
                ystr = yformatter.format(yy);
                this.ySlice = yy;
            } else {
                DatumRange ydr = DataSetUtil.asDatumRange((QDataSet)yds.slice(iy));
                ystr = ydr.toString();
                this.ySlice = ydr.middle();
            }
            sliceDataSet = DataSetOps.slice1((QDataSet)tds1, (int)iy);
        }
        DasLogger.getLogger(DasLogger.GUI_LOG).finest("setDataSet sliceDataSet");
        if (!this.isPopupVisible()) {
            this.showPopup();
        } else {
            Rectangle r = ComponentsUtil.verifyVisible(this.popupWindow.getBounds());
            if (r != null) {
                this.popupWindow.setLocation(r.x, r.y);
            }
        }
        this.myPlot.getCanvas().setFont(this.parentPlot.getCanvas().getFont());
        this.renderer.setDataSet((QDataSet)sliceDataSet);
        Object formatter = xValue.getUnits() instanceof TimeLocationUnits ? TimeDatumFormatter.DEFAULT : xValue.getFormatter();
        String title = this.parentPlot.getTitle().trim();
        if (title.length() > 0) {
            title = title + "!c";
        }
        this.myPlot.setTitle(title + "x: " + formatter.format(xValue) + " y: " + ystr);
        if (!this.myPlot.getXAxis().getLabel().equals(this.sourceXAxis.getLabel())) {
            this.myPlot.getXAxis().setLabel(this.sourceXAxis.getLabel());
        }
        if (!this.myPlot.getYAxis().getLabel().equals(this.sourceZAxis.getLabel())) {
            this.myPlot.getYAxis().setLabel(this.sourceZAxis.getLabel());
        }
        return true;
    }

    public Color getMarkColor() {
        return this.markColor;
    }

    public void setMarkColor(Color markColor) {
        this.markColor = markColor;
    }
}

