/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.das2.util.LoggerManager;
import org.das2.util.StringSchemeEditor;

public class UriTemplatesStringSchemeEditor
extends JPanel
implements StringSchemeEditor {
    URI uri;
    private static final Logger logger = LoggerManager.getLogger((String)"das2.gui");
    private JButton colonButton;
    private JButton dashButton;
    private JButton dayButton;
    private JButton doyButton;
    private JButton hourButton;
    private JLabel jLabel1;
    private JButton minuteButton;
    private JButton monthButton;
    private JButton periodButton;
    private JButton secondButton;
    private JButton slashButton;
    private JButton subsecButton;
    private JLabel subsecDecimalPlacesLabel;
    private JPanel subsecPanel;
    private JFormattedTextField subsecPlacesTF;
    private JTextField templTextField;
    private JButton yearButton;
    private JButton yrButton;

    public UriTemplatesStringSchemeEditor() {
        this.initComponents();
        this.jLabel1.addMouseListener(this.myMouseListener());
        try {
            this.uri = new URI("https://github.com/uri-templates-time/uri-templates-time-specification/blob/main/specification-1.1.0.md");
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.subsecPanel = new JPanel();
        this.subsecDecimalPlacesLabel = new JLabel();
        this.subsecPlacesTF = new JFormattedTextField();
        this.templTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.yearButton = new JButton();
        this.monthButton = new JButton();
        this.dayButton = new JButton();
        this.doyButton = new JButton();
        this.yrButton = new JButton();
        this.hourButton = new JButton();
        this.minuteButton = new JButton();
        this.secondButton = new JButton();
        this.subsecButton = new JButton();
        this.dashButton = new JButton();
        this.slashButton = new JButton();
        this.colonButton = new JButton();
        this.periodButton = new JButton();
        this.subsecDecimalPlacesLabel.setText("Number of Decimal Places (1-9):");
        this.subsecPlacesTF.setText("6");
        GroupLayout subsecPanelLayout = new GroupLayout(this.subsecPanel);
        this.subsecPanel.setLayout(subsecPanelLayout);
        subsecPanelLayout.setHorizontalGroup(subsecPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subsecPanelLayout.createSequentialGroup().addContainerGap().addGroup(subsecPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subsecPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.subsecPlacesTF, -2, 44, -2)).addComponent(this.subsecDecimalPlacesLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        subsecPanelLayout.setVerticalGroup(subsecPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subsecPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subsecDecimalPlacesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subsecPlacesTF, -2, -1, -2).addContainerGap(31, Short.MAX_VALUE)));
        this.templTextField.setText("jTextField1");
        this.jLabel1.setText("<html>A URI Template describes how a time range is to be formatted into a string, such as a filename or tick format.  Edit the string below using your keyboard or the buttons to insert time components.  The URI_Templates specification can be found here: <a href=\"https://github.com/uri-templates-time/uri-templates-time-specification/blob/main/specification-1.1.0.md\">https://github.com/uri-templates-time/</a>");
        this.jLabel1.setVerticalAlignment(1);
        this.yearButton.setText("Year");
        this.yearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.yearButtonActionPerformed(evt);
            }
        });
        this.monthButton.setText("Month");
        this.monthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.monthButtonActionPerformed(evt);
            }
        });
        this.dayButton.setText("Day");
        this.dayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.dayButtonActionPerformed(evt);
            }
        });
        this.doyButton.setText("Day of Year");
        this.doyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.doyButtonActionPerformed(evt);
            }
        });
        this.yrButton.setText("Two-Digit Year");
        this.yrButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.yrButtonActionPerformed(evt);
            }
        });
        this.hourButton.setText("Hour");
        this.hourButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.hourButtonActionPerformed(evt);
            }
        });
        this.minuteButton.setText("Minute");
        this.minuteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.minuteButtonActionPerformed(evt);
            }
        });
        this.secondButton.setText("Second");
        this.secondButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.secondButtonActionPerformed(evt);
            }
        });
        this.subsecButton.setText("Sub-Second...");
        this.subsecButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.subsecButtonActionPerformed(evt);
            }
        });
        this.dashButton.setText("-");
        this.dashButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.dashButtonActionPerformed(evt);
            }
        });
        this.slashButton.setText("/");
        this.slashButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.slashButtonActionPerformed(evt);
            }
        });
        this.colonButton.setText(":");
        this.colonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.colonButtonActionPerformed(evt);
            }
        });
        this.periodButton.setText(".");
        this.periodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UriTemplatesStringSchemeEditor.this.periodButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.monthButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dashButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slashButton)).addGroup(layout.createSequentialGroup().addComponent(this.yearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yrButton)).addGroup(layout.createSequentialGroup().addComponent(this.dayButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doyButton)).addGroup(layout.createSequentialGroup().addComponent(this.hourButton).addGap(18, 18, 18).addComponent(this.colonButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.periodButton)).addComponent(this.minuteButton).addGroup(layout.createSequentialGroup().addComponent(this.secondButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subsecButton))).addGap(0, 248, Short.MAX_VALUE)).addComponent(this.templTextField)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 86, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templTextField, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.yearButton).addComponent(this.yrButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.monthButton).addComponent(this.dashButton).addComponent(this.slashButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dayButton).addComponent(this.doyButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hourButton).addComponent(this.colonButton).addComponent(this.periodButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minuteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.secondButton).addComponent(this.subsecButton)).addContainerGap(64, Short.MAX_VALUE)));
    }

    private void yearButtonActionPerformed(ActionEvent evt) {
        this.insertText("$Y");
    }

    private void yrButtonActionPerformed(ActionEvent evt) {
        this.insertText("$y");
    }

    private void monthButtonActionPerformed(ActionEvent evt) {
        this.insertText("$m");
    }

    private void dayButtonActionPerformed(ActionEvent evt) {
        this.insertText("$d");
    }

    private void doyButtonActionPerformed(ActionEvent evt) {
        this.insertText("$j");
    }

    private void hourButtonActionPerformed(ActionEvent evt) {
        this.insertText("$H");
    }

    private void minuteButtonActionPerformed(ActionEvent evt) {
        this.insertText("$M");
    }

    private void secondButtonActionPerformed(ActionEvent evt) {
        this.insertText("$S");
    }

    private void subsecButtonActionPerformed(ActionEvent evt) {
        if (0 == JOptionPane.showConfirmDialog(this, this.subsecPanel, "subsec options", 2)) {
            try {
                int places = Integer.parseInt(this.subsecPlacesTF.getText());
                this.insertText(String.format("$(subsec;places=%d)", places));
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void dashButtonActionPerformed(ActionEvent evt) {
        this.insertText("-");
    }

    private void slashButtonActionPerformed(ActionEvent evt) {
        this.insertText("/");
    }

    private void colonButtonActionPerformed(ActionEvent evt) {
        this.insertText(":");
    }

    private void periodButtonActionPerformed(ActionEvent evt) {
        this.insertText(".");
    }

    public void setValue(String v) {
        this.templTextField.setText(v);
    }

    public String getValue() {
        return this.templTextField.getText();
    }

    public Component getComponent() {
        return this;
    }

    public void setContext(Object o) {
    }

    private void insertText(String s) {
        String t = this.templTextField.getText();
        int i = this.templTextField.getCaretPosition();
        t = t.substring(0, i) + s + t.substring(i);
        this.templTextField.setText(t);
    }

    private MouseListener myMouseListener() {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (UriTemplatesStringSchemeEditor.this.uri != null) {
                    try {
                        Desktop.getDesktop().browse(UriTemplatesStringSchemeEditor.this.uri);
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (UriTemplatesStringSchemeEditor.this.uri != null) {
                    UriTemplatesStringSchemeEditor.this.setCursor(Cursor.getPredefinedCursor(12));
                    UriTemplatesStringSchemeEditor.this.setToolTipText(UriTemplatesStringSchemeEditor.this.uri.toString());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (UriTemplatesStringSchemeEditor.this.uri != null) {
                    UriTemplatesStringSchemeEditor.this.setCursor(Cursor.getPredefinedCursor(0));
                    UriTemplatesStringSchemeEditor.this.setToolTipText(null);
                }
            }
        };
    }

    public static void main(String[] args) {
        UriTemplatesStringSchemeEditor edit = new UriTemplatesStringSchemeEditor();
        edit.setValue("$Y-$m-$d");
        if (0 == JOptionPane.showConfirmDialog(null, edit)) {
            System.err.println(edit.getValue());
        }
    }

    public String getLabel() {
        return "URI Templates Editor";
    }
}

