/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.beans.AccessLevelBeanInfo;
import org.das2.beans.BeansUtil;
import org.das2.graph.DasCanvasComponent;
import org.das2.system.DasLogger;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMBuilder {
    Object bean;
    HashMap serializedObjects;

    public DOMBuilder(Object bean) {
        this.bean = bean;
    }

    private String getBeanName(Object bean) {
        try {
            PropertyDescriptor[] pds = BeansUtil.getPropertyDescriptors(bean.getClass());
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor pd = pds[i];
                if (!pd.getName().equals("name")) continue;
                String name = (String)pd.getReadMethod().invoke(bean, new Object[0]);
                return name;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private Element getDOMElement(Document document, Object object, ProgressMonitor monitor) {
        Logger log = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
        try {
            int i;
            String elementName = object.getClass().getName();
            elementName = elementName.replaceAll("\\$", "\\_dollar_");
            Element element = null;
            try {
                element = document.createElement(elementName);
            }
            catch (Exception e) {
                System.err.println(e);
                throw new RuntimeException(e);
            }
            BeanInfo info = BeansUtil.getBeanInfo(object.getClass());
            AccessLevelBeanInfo alInfo = BeansUtil.asAccessLevelBeanInfo(info, object.getClass());
            PropertyDescriptor[] properties = alInfo.getPropertyDescriptors(AccessLevelBeanInfo.PersistenceLevel.PERSISTENT);
            String[] propertyNameList = BeansUtil.getPropertyNames(properties);
            HashMap<String, PropertyDescriptor> nameMap = new HashMap<String, PropertyDescriptor>();
            for (i = 0; i < properties.length; ++i) {
                nameMap.put(properties[i].getName(), properties[i]);
            }
            if (propertyNameList.length > 0) {
                monitor.setTaskSize((long)propertyNameList.length);
            }
            monitor.started();
            for (i = 0; i < propertyNameList.length; ++i) {
                Element child;
                Element propertyElement;
                monitor.setTaskProgress((long)i);
                String propertyName = propertyNameList[i];
                log.log(Level.FINE, "serializing property {0} of {1}", new Object[]{propertyName, elementName});
                System.err.println("@@@: serializing property " + propertyName + " of " + elementName);
                if (propertyName.equals("parent")) {
                    log.fine("kludge to skip parents thus avoiding cycles.");
                    continue;
                }
                PropertyDescriptor pd = (PropertyDescriptor)nameMap.get(propertyName);
                if (pd == null) {
                    log.log(Level.WARNING, "unable to locate property: {0}, ignoring", propertyName);
                    continue;
                }
                Method readMethod = pd.getReadMethod();
                if (readMethod == null) {
                    log.log(Level.INFO, "skipping property {0} of {1}, failed to find read method.", new Object[]{propertyName, elementName});
                    continue;
                }
                Method writeMethod = pd.getWriteMethod();
                Object value = readMethod.invoke(object, new Object[0]);
                if (value == null) {
                    log.log(Level.INFO, "skipping property {0} of {1}, value is null.", new Object[]{propertyName, elementName});
                    continue;
                }
                if (pd.getName().equals("dataMaximum")) {
                    System.err.println(elementName);
                }
                if (pd.getName().equals("baseFont")) {
                    System.err.println(elementName);
                }
                PropertyEditor editor = BeansUtil.getEditor(pd);
                String textValue = null;
                if (editor != null) {
                    editor.setValue(value);
                    textValue = editor.getAsText();
                }
                String beanName = this.getBeanName(value);
                if (textValue != null) {
                    if (writeMethod == null) continue;
                    element.setAttribute(propertyName, textValue);
                    continue;
                }
                if (beanName != null) {
                    if (this.serializedObjects.containsKey(beanName)) {
                        element.setAttribute(propertyName, beanName);
                        continue;
                    }
                    propertyElement = document.createElement(propertyName);
                    child = this.getDOMElement(document, value, (ProgressMonitor)new NullProgressMonitor());
                    propertyElement.appendChild(child);
                    element.appendChild(propertyElement);
                    this.serializedObjects.put(beanName, value);
                    continue;
                }
                if (value.getClass().isArray()) {
                    propertyElement = document.createElement(propertyName);
                    for (int j = 0; j < Array.getLength(value); ++j) {
                        Object value1 = Array.get(value, j);
                        Element child2 = this.getDOMElement(document, value1, (ProgressMonitor)new NullProgressMonitor());
                        propertyElement.appendChild(child2);
                        if (!(value1 instanceof DasCanvasComponent)) continue;
                        DasCanvasComponent dcc = (DasCanvasComponent)value1;
                        this.serializedObjects.put(dcc.getDasName(), value1);
                    }
                    element.appendChild(propertyElement);
                    continue;
                }
                propertyElement = document.createElement(propertyName);
                child = this.getDOMElement(document, value, (ProgressMonitor)new NullProgressMonitor());
                propertyElement.appendChild(child);
                element.appendChild(propertyElement);
            }
            monitor.finished();
            Element element2 = element;
            return element2;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            monitor.finished();
        }
    }

    public synchronized Element serialize(Document document, ProgressMonitor monitor) {
        this.serializedObjects = new HashMap();
        return this.getDOMElement(document, this.bean, monitor);
    }
}

