/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.NameContext;
import org.das2.components.propertyeditor.Editable;
import org.das2.dasml.CommandAction;
import org.das2.dasml.CommandBlock;
import org.das2.dasml.DefaultComponentDnDSupport;
import org.das2.dasml.FormBase;
import org.das2.dasml.FormComponent;
import org.das2.dasml.ListOption;
import org.das2.dasml.OptionList;
import org.das2.dasml.ParsedExpressionException;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DnDSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormChoice
extends JComboBox
implements Editable,
FormComponent,
OptionList {
    protected DnDSupport dndSupport;
    private boolean editable;
    private String dasName;

    public FormChoice(String name) {
        if (name == null) {
            name = "choice_" + Integer.toString(System.identityHashCode(this));
        }
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
    }

    FormChoice(Element element, FormBase form) throws DasPropertyException, DasNameException, ParsedExpressionException {
        String name = element.getAttribute("name");
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node node = children.item(i);
            if (node instanceof Element && node.getNodeName().equals("option")) {
                this.processOptionElement((Element)node);
                continue;
            }
            if (!(node instanceof Element) || !node.getNodeName().equals("action")) continue;
            CommandBlock cb = new CommandBlock((Element)node, form);
            CommandAction action = new CommandAction(cb);
            this.addActionListener(action);
        }
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void processOptionElement(Element element) {
        boolean selected = element.getAttribute("selected").equals("true");
        ListOption option = new ListOption(element);
        this.addItem(option);
        if (selected) {
            this.setSelectedItem(option);
        }
    }

    public String getSelectedValue() {
        ListOption selected = (ListOption)this.getSelectedItem();
        if (selected == null) {
            return null;
        }
        return selected.getValue();
    }

    public void addOption(ListOption option) {
        this.addItem(option);
    }

    @Override
    public Element getDOMElement(Document document) {
        Element element = document.createElement("choice");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("enabled", String.valueOf(this.isEnabled()));
        for (int index = 0; index < this.getItemCount(); ++index) {
            ListOption option = (ListOption)this.getItemAt(index);
            element.appendChild(option.getDOMElement(document));
        }
        return element;
    }

    @Override
    public ListOption[] getOptions() {
        ComboBoxModel model = this.getModel();
        ListOption[] options = new ListOption[model.getSize()];
        for (int index = 0; index < options.length; ++index) {
            options[index] = (ListOption)model.getElementAt(index);
        }
        return options;
    }

    @Override
    public void setOptions(ListOption[] options) {
        this.setModel(new DefaultComboBoxModel<ListOption>(options));
        if (options.length == 0) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(options[0]);
            for (int index = 0; index < options.length; ++index) {
                if (!options[index].isSelected()) continue;
                this.setSelectedItem(options[index]);
            }
        }
    }

    public Object getPrototypeDisplayValue() {
        if (this.getItemCount() == 0) {
            return "XXXXXXXXXXXX";
        }
        return null;
    }

    @Override
    public String getDasName() {
        return this.dasName;
    }

    @Override
    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    @Override
    public FormBase getForm() {
        FormComponent parent = (FormComponent)((Object)this.getParent());
        if (parent == null) {
            return null;
        }
        return parent.getForm();
    }

    @Override
    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    @Override
    public boolean startDrag(int x, int y, int action, MouseEvent evt) {
        return false;
    }

    @Override
    public boolean getEditingMode() {
        return this.editable;
    }

    @Override
    public void setEditingMode(boolean b) {
        this.editable = b;
    }

    @Override
    public void deregisterComponent() {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            try {
                if (nc.get(this.getDasName()) == this) {
                    nc.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dpe) {
                IllegalStateException se = new IllegalStateException(dpe.toString());
                se.initCause(dpe);
                throw se;
            }
            catch (InvocationTargetException ite) {
                IllegalStateException se = new IllegalStateException(ite.toString());
                se.initCause(ite);
                throw se;
            }
        }
    }

    @Override
    public DasApplication getDasApplication() {
        Container p = this.getParent();
        if (p instanceof FormComponent) {
            return ((FormComponent)((Object)p)).getDasApplication();
        }
        return null;
    }

    @Override
    public void registerComponent() throws DasException {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            nc.put(this.getDasName(), this);
        }
    }
}

