/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.DefaultTableDataSet;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.system.DasLogger;

public class QernalTableRebinner {
    Logger logger = DasLogger.getLogger(DasLogger.DATA_OPERATIONS_LOG);
    QernalFactory factory;

    public QernalTableRebinner(QernalFactory factory) {
        this.factory = factory;
    }

    public DataSet rebin(DataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) throws IllegalArgumentException, DasException {
        Object yTags;
        double[] xTags;
        this.logger.finest("enter QernalTableRebinner.rebin");
        if (ds == null) {
            throw new NullPointerException("null data set");
        }
        if (!(ds instanceof TableDataSet)) {
            throw new IllegalArgumentException("Data set must be an instanceof TableDataSet: " + ds.getClass().getName());
        }
        TableDataSet tds = (TableDataSet)ds;
        TableDataSet weights = (TableDataSet)ds.getPlanarView("weights");
        if (ddX != null && tds.getXLength() > 0) {
            double start = tds.getXTagDouble(0, ddX.getUnits());
            double end = tds.getXTagDouble(tds.getXLength() - 1, ddX.getUnits());
            if (start > ddX.end) {
                throw new NoDataInIntervalException("data starts after range");
            }
            if (end < ddX.start) {
                throw new NoDataInIntervalException("data ends before range");
            }
        }
        Datum xBinWidth = DataSetUtil.guessXTagWidth(tds);
        long timer = System.currentTimeMillis();
        Units xUnits = ddX.getUnits();
        Units zUnits = tds.getZUnits();
        int nx = ddX == null ? tds.getXLength() : ddX.numberOfBins();
        int ny = ddY == null ? tds.getYLength(0) : ddY.numberOfBins();
        this.logger.finest("Allocating rebinData and rebinWeights: " + nx + " x " + ny);
        double[][] rebinData = new double[nx][ny];
        double[][] rebinWeights = new double[nx][ny];
        int nTables = tds.tableCount();
        for (int iTable = 0; iTable < nTables; ++iTable) {
            Datum yBinWidth = TableUtil.guessYTagWidth(tds, iTable);
            Qernal qernal = this.factory.getQernal(ddX, ddY, xBinWidth, yBinWidth);
            int[] ibiny = new int[tds.getYLength(iTable)];
            for (int j = 0; j < ibiny.length; ++j) {
                ibiny[j] = ddY != null ? ddY.whichBin(tds.getYTagDouble(iTable, j, tds.getYUnits()), tds.getYUnits()) : j;
            }
            for (int i = tds.tableStart(iTable); i < tds.tableEnd(iTable); ++i) {
                int ibinx = ddX != null ? ddX.whichBin(tds.getXTagDouble(i, xUnits), xUnits) : i;
                for (int j = 0; j < tds.getYLength(iTable); ++j) {
                    double z = tds.getDouble(i, j, zUnits);
                    double w = weights == null ? (zUnits.isFill(z) ? 0.0 : 1.0) : weights.getDouble(i, j, Units.dimensionless);
                    qernal.apply(ibinx, ibiny[j], z, w, rebinData, rebinWeights);
                }
            }
        }
        this.logger.finest("normalize sums by weights");
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                if (rebinWeights[i][j] > 0.0) {
                    double[] dArray = rebinData[i];
                    int n = j;
                    dArray[n] = dArray[n] / rebinWeights[i][j];
                    continue;
                }
                rebinData[i][j] = zUnits.getFillDouble();
            }
        }
        this.logger.finest("create new DataSet");
        if (ddX != null) {
            xTags = ddX.binCenters();
        } else {
            xTags = new double[nx];
            for (int i = 0; i < nx; ++i) {
                xTags[i] = tds.getXTagDouble(i, tds.getXUnits());
            }
        }
        if (ddY != null) {
            yTags = new double[][]{ddY.binCenters()};
        } else {
            yTags = new double[1][ny];
            for (int j = 0; j < ny; ++j) {
                yTags[0][j] = tds.getYTagDouble(0, j, tds.getYUnits());
            }
        }
        Units resultXUnits = ddX == null ? tds.getXUnits() : ddX.getUnits();
        Units resultYUnits = ddY == null ? tds.getYUnits() : ddY.getUnits();
        double[][][] zValues = new double[][][]{rebinData, rebinWeights};
        int[] tableOffsets = new int[]{0};
        Units[] newZUnits = new Units[]{tds.getZUnits(), Units.dimensionless};
        String[] planeIDs = new String[]{"", "weights"};
        HashMap<String, Datum> properties = new HashMap<String, Datum>(ds.getProperties());
        if (ddX != null) {
            properties.put("xTagWidth", ddX.binWidthDatum());
        }
        if (ddY != null) {
            properties.put("yTagWidth", ddY.binWidthDatum());
        }
        DefaultTableDataSet result = new DefaultTableDataSet(xTags, resultXUnits, (double[][])yTags, resultYUnits, (double[][][])zValues, newZUnits, planeIDs, tableOffsets, (Map)properties);
        this.logger.finest("done, QernalTableRebinner.rebin");
        return result;
    }

    public static interface Qernal {
        public void apply(int var1, int var2, double var3, double var5, double[][] var7, double[][] var8);
    }

    public static interface QernalFactory {
        public Qernal getQernal(RebinDescriptor var1, RebinDescriptor var2, Datum var3, Datum var4);
    }
}

