/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public class WeightsVectorDataSet
implements VectorDataSet {
    VectorDataSet source;
    Units sourceUnits;

    public static VectorDataSet create(VectorDataSet source) {
        if (source.getPlanarView("weights") != null) {
            return (VectorDataSet)source.getPlanarView("weights");
        }
        return new WeightsVectorDataSet(source);
    }

    private WeightsVectorDataSet(VectorDataSet source) {
        this.source = source;
        this.sourceUnits = source.getYUnits();
    }

    @Override
    public DataSet getPlanarView(String planeID) {
        return this;
    }

    @Override
    public String[] getPlaneIds() {
        return new String[]{""};
    }

    @Override
    public Map getProperties() {
        return new HashMap();
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public int getXLength() {
        return this.source.getXLength();
    }

    @Override
    public Datum getXTagDatum(int i) {
        return this.source.getXTagDatum(i);
    }

    @Override
    public double getXTagDouble(int i, Units units) {
        return this.source.getXTagDouble(i, units);
    }

    @Override
    public int getXTagInt(int i, Units units) {
        return this.source.getXTagInt(i, units);
    }

    @Override
    public Units getXUnits() {
        return this.source.getXUnits();
    }

    @Override
    public Units getYUnits() {
        return Units.dimensionless;
    }

    @Override
    public Datum getDatum(int i) {
        return Units.dimensionless.createDatum(this.getDouble(i, Units.dimensionless));
    }

    @Override
    public double getDouble(int i, Units units) {
        return this.sourceUnits.isFill(this.source.getDouble(i, this.sourceUnits)) ? 0.0 : 1.0;
    }

    @Override
    public int getInt(int i, Units units) {
        return (int)this.getDouble(i, units);
    }
}

