/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.das2.dataset.DataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public abstract class WavVectorDataSet
implements VectorDataSet {
    AudioFormat audioFormat;
    ByteBuffer byteBuffer;
    ShortBuffer shortBuffer;
    int frameCount;
    int channelCount;
    int channel;
    float sampleRate;
    int frameSize;
    boolean unsigned;
    Map properties = new HashMap();
    String[] planeIds = new String[0];

    private WavVectorDataSet(ByteBuffer dataBuf, AudioFormat format) throws IOException {
        this.audioFormat = format;
        this.byteBuffer = dataBuf;
        this.channelCount = this.audioFormat.getChannels();
        this.channel = 0;
        this.sampleRate = this.audioFormat.getSampleRate();
        this.frameSize = this.audioFormat.getFrameSize();
        this.unsigned = this.audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
        this.frameCount = (this.byteBuffer.limit() - this.byteBuffer.position()) / this.frameSize;
        if (this.audioFormat.getSampleSizeInBits() == 16) {
            if (this.audioFormat.isBigEndian()) {
                this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
            } else {
                this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.shortBuffer = this.byteBuffer.asShortBuffer();
        }
    }

    abstract int indexOf(int var1);

    @Override
    public DataSet getPlanarView(String planeID) {
        if (planeID.equals("")) {
            return this;
        }
        int ch = Integer.parseInt(planeID.substring(7));
        if (ch == this.channel) {
            return this;
        }
        try {
            WavVectorDataSet result = WavVectorDataSet.createWavVectorDataSet(this.byteBuffer, this.audioFormat);
            result.channel = ch;
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getPlaneIds() {
        String[] result = new String[this.channelCount];
        for (int i = 0; i < this.channelCount; ++i) {
            result[i] = "channel" + i;
        }
        return result;
    }

    public static WavVectorDataSet createWavVectorDataSet(ByteBuffer buf, AudioFormat audioFormat) throws IOException {
        int bits = audioFormat.getSampleSizeInBits();
        boolean unsigned = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
        if (bits == 16) {
            if (unsigned) {
                return new Wav16bitMonoUnsigned(buf, audioFormat);
            }
            return new Wav16bitMonoSigned(buf, audioFormat);
        }
        if (unsigned) {
            return new Wav8bitMonoUnsigned(buf, audioFormat);
        }
        return new Wav8bitMonoSigned(buf, audioFormat);
    }

    public static WavVectorDataSet createFromFile(File wavFile) throws FileNotFoundException, IOException {
        try {
            AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(wavFile);
            AudioFormat audioFormat = fileFormat.getFormat();
            FileInputStream fin = new FileInputStream(wavFile);
            MappedByteBuffer buf = fin.getChannel().map(FileChannel.MapMode.READ_ONLY, 64L, wavFile.length() - 64L);
            return WavVectorDataSet.createWavVectorDataSet(buf, audioFormat);
        }
        catch (UnsupportedAudioFileException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getXLength() {
        return this.frameCount;
    }

    @Override
    public double getXTagDouble(int i, Units units) {
        return Units.seconds.convertDoubleTo(units, (double)i / (double)this.sampleRate);
    }

    @Override
    public Units getXUnits() {
        return Units.seconds;
    }

    @Override
    public Units getYUnits() {
        return Units.dimensionless;
    }

    @Override
    public Datum getDatum(int i) {
        Units yUnits = this.getYUnits();
        return yUnits.createDatum(this.getDouble(i, yUnits));
    }

    @Override
    public int getInt(int i, Units units) {
        return (int)this.getDouble(i, units);
    }

    @Override
    public Map getProperties() {
        return null;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public Datum getXTagDatum(int i) {
        return Units.seconds.createDatum(this.getXTagDouble(i, Units.seconds));
    }

    @Override
    public int getXTagInt(int i, Units units) {
        return (int)this.getXTagDouble(i, units);
    }

    static class Wav16bitMonoSigned
    extends WavVectorDataSet {
        Wav16bitMonoSigned(ByteBuffer dataBuf, AudioFormat format) throws IOException {
            super(dataBuf, format);
        }

        @Override
        int indexOf(int frame) {
            return frame * this.channelCount + this.channel;
        }

        @Override
        public double getDouble(int i, Units units) {
            return (double)this.shortBuffer.get(this.indexOf(i)) / 65536.0 + 0.5;
        }
    }

    static class Wav8bitMonoUnsigned
    extends WavVectorDataSet {
        Wav8bitMonoUnsigned(ByteBuffer dataBuf, AudioFormat format) throws IOException {
            super(dataBuf, format);
        }

        @Override
        int indexOf(int frame) {
            return frame * this.channelCount + this.channel;
        }

        @Override
        public double getDouble(int i, Units units) {
            return (double)(0xFF & this.byteBuffer.get(this.indexOf(i))) / 256.0;
        }
    }

    static class Wav16bitMonoUnsigned
    extends WavVectorDataSet {
        Wav16bitMonoUnsigned(ByteBuffer dataBuf, AudioFormat format) throws IOException {
            super(dataBuf, format);
        }

        @Override
        int indexOf(int frame) {
            return frame * this.channelCount + this.channel;
        }

        @Override
        public double getDouble(int i, Units units) {
            return (double)this.shortBuffer.get(this.indexOf(i)) / 65536.0;
        }
    }

    static class Wav8bitMonoSigned
    extends WavVectorDataSet {
        Wav8bitMonoSigned(ByteBuffer dataBuf, AudioFormat format) throws IOException {
            super(dataBuf, format);
        }

        @Override
        int indexOf(int frame) {
            return frame * this.channelCount + this.channel;
        }

        @Override
        public double getDouble(int i, Units units) {
            return (double)this.byteBuffer.get(this.indexOf(i)) / 256.0 + 0.5;
        }
    }
}

