/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.das2.dataset.DataSetConsumer;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.event.BoxRangeSelectorMouseModule;
import org.das2.event.BoxZoomGesturesRenderer;
import org.das2.event.Gesture;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.GraphUtil;

public class BoxZoomMouseModule
extends BoxRangeSelectorMouseModule {
    DatumRange xrange;
    DatumRange yrange;
    boolean autoUpdate = true;
    boolean constrainProportions = false;
    long t0;
    long tbirth;

    public BoxZoomMouseModule(DasCanvasComponent parent, DataSetConsumer consumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, consumer, xAxis, yAxis);
        this.setDragRenderer(new BoxZoomGesturesRenderer(parent));
        this.setLabel("Box Zoom");
        this.tbirth = System.nanoTime();
    }

    protected void zoomBox() {
        if (this.yrange != null) {
            this.yAxis.setDatumRange(this.yrange);
        }
        if (this.xrange != null) {
            this.xAxis.setDatumRange(this.xrange);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int i;
        DatumRange dr;
        double nmax;
        double nmin;
        double xshift = 0.0;
        double yshift = 0.0;
        if (e.isControlDown() || e.isShiftDown()) {
            if (this.xAxis != null && this.yAxis != null) {
                return;
            }
            if (e.getWheelRotation() < 0) {
                nmin = -0.2;
                nmax = 0.8;
            } else {
                nmin = 0.2;
                nmax = 1.2;
            }
        } else {
            MouseModule.Pos ypos;
            Point ep = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            MouseModule.Pos xpos = this.xAxis == null ? MouseModule.Pos._null : this.position(this.xAxis.getColumn(), ep.x, 20);
            MouseModule.Pos pos = ypos = this.yAxis == null ? MouseModule.Pos._null : this.position(this.yAxis.getRow(), ep.y, 20);
            if (e.getWheelRotation() < 0) {
                nmin = 0.1;
                nmax = 0.9;
            } else {
                nmin = -0.125;
                nmax = 1.125;
            }
            switch (xpos) {
                case min: {
                    xshift = -nmin;
                    break;
                }
                case max: {
                    xshift = nmin;
                    break;
                }
                default: {
                    logger.log(Level.FINE, "xpos: {0}", (Object)xpos);
                }
            }
            switch (ypos) {
                case min: {
                    yshift = nmin;
                    break;
                }
                case max: {
                    yshift = -nmin;
                    break;
                }
                default: {
                    logger.log(Level.FINE, "ypos: {0}", (Object)xpos);
                }
            }
        }
        int clickMag = 1;
        long t1 = System.nanoTime();
        long limitNanos = 40000000L;
        if ((t1 - this.t0) / (long)clickMag < limitNanos) {
            clickMag = (int)Math.floor((double)(t1 - this.t0) / (double)limitNanos);
        }
        if (clickMag == 0) {
            return;
        }
        this.t0 = System.nanoTime();
        DatumRange xdrnew = null;
        DatumRange ydrnew = null;
        logger.log(Level.FINEST, ":ns:  {0}  {1}", new Object[]{System.nanoTime() - this.tbirth, clickMag});
        if (BoxZoomMouseModule.axisIsAdjustable(this.xAxis)) {
            dr = this.xAxis.getDatumRange();
            for (i = 0; i < clickMag; ++i) {
                dr = this.xAxis.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)dr, (double)(nmin + xshift), (double)(nmax + xshift)) : DatumRangeUtil.rescale((DatumRange)dr, (double)(nmin + xshift), (double)(nmax + xshift));
            }
            if (!DatumRangeUtil.isAcceptable((DatumRange)(dr = BoxZoomMouseModule.maybeRound(this.xAxis, dr)), (boolean)this.xAxis.isLog())) {
                dr = null;
            }
            xdrnew = dr;
        }
        if (BoxZoomMouseModule.axisIsAdjustable(this.yAxis)) {
            dr = this.yAxis.getDatumRange();
            for (i = 0; i < clickMag; ++i) {
                dr = this.yAxis.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)dr, (double)(nmin + yshift), (double)(nmax + yshift)) : DatumRangeUtil.rescale((DatumRange)dr, (double)(nmin + yshift), (double)(nmax + yshift));
            }
            if (!DatumRangeUtil.isAcceptable((DatumRange)(dr = BoxZoomMouseModule.maybeRound(this.yAxis, dr)), (boolean)this.yAxis.isLog())) {
                dr = null;
            }
            ydrnew = dr;
        }
        if (BoxZoomMouseModule.axisIsAdjustable(this.xAxis) && xdrnew == null) {
            return;
        }
        if (BoxZoomMouseModule.axisIsAdjustable(this.yAxis) && ydrnew == null) {
            return;
        }
        if (BoxZoomMouseModule.axisIsAdjustable(this.xAxis)) {
            this.xAxis.setDatumRange(xdrnew);
        }
        if (BoxZoomMouseModule.axisIsAdjustable(this.yAxis)) {
            this.yAxis.setDatumRange(ydrnew);
        }
        super.mouseWheelMoved(e);
    }

    @Override
    public void mouseRangeSelected(MouseDragEvent e0) {
        if (e0 instanceof MouseBoxEvent) {
            MouseBoxEvent e = (MouseBoxEvent)e0;
            this.xrange = GraphUtil.invTransformRange(this.xAxis, e.getXMinimum(), e.getXMaximum());
            this.yrange = GraphUtil.invTransformRange(this.yAxis, e.getYMinimum(), e.getYMaximum());
            double boxAspect = (float)(e.getYMaximum() - e.getYMinimum()) / (float)(e.getXMaximum() - e.getXMinimum());
            boolean edgeY = e.getYMaximum() > this.yAxis.getRow().getDMaximum() || e.getYMinimum() < this.yAxis.getRow().getDMinimum();
            boolean edgeX = e.getXMaximum() > this.xAxis.getColumn().getDMaximum() || e.getXMinimum() < this.xAxis.getColumn().getDMinimum();
            BoxZoomGesturesRenderer.Type t = BoxZoomGesturesRenderer.idType(this.parent, e.getPressPoint(), e.getPoint());
            if (t == BoxZoomGesturesRenderer.Type.XAXIS) {
                this.yrange = this.yAxis.getDatumRange();
            }
            if (t == BoxZoomGesturesRenderer.Type.YAXIS) {
                this.xrange = this.xAxis.getDatumRange();
            }
            if (e.getYMaximum() - e.getYMinimum() < 5 || boxAspect < 0.1 && edgeY) {
                this.yrange = this.yAxis.getDatumRange();
            }
            if (e.getXMaximum() - e.getXMinimum() < 5 || boxAspect > 10.0 && edgeX) {
                this.xrange = this.xAxis.getDatumRange();
            }
            if (edgeY && boxAspect < 0.2) {
                this.yrange = this.yAxis.getDatumRange();
            }
            if (edgeX && boxAspect > 5.0) {
                this.xrange = this.xAxis.getDatumRange();
            }
            if (this.constrainProportions) {
                double aspect = (double)this.yAxis.getHeight() / (double)this.xAxis.getWidth();
                DatumRange mx = new DatumRange((double)e.getXMinimum(), (double)e.getXMaximum(), Units.dimensionless);
                DatumRange my = new DatumRange((double)e.getYMinimum(), (double)e.getYMaximum(), Units.dimensionless);
                double mouseAspect = my.width().divide(mx.width()).doubleValue(Units.dimensionless);
                if (mouseAspect > aspect) {
                    double f = mouseAspect / aspect;
                    mx = DatumRangeUtil.rescale((DatumRange)my, (double)(0.5 - f / 2.0), (double)(0.5 + f / 2.0));
                } else {
                    double f = aspect / mouseAspect;
                    my = DatumRangeUtil.rescale((DatumRange)my, (double)(0.5 - f / 2.0), (double)(0.5 + f / 2.0));
                }
                this.xrange = GraphUtil.invTransformRange(this.xAxis, mx.min().doubleValue(Units.dimensionless), mx.max().doubleValue(Units.dimensionless));
                this.yrange = GraphUtil.invTransformRange(this.yAxis, my.max().doubleValue(Units.dimensionless), my.min().doubleValue(Units.dimensionless));
            }
            this.zoomBox();
        } else if (e0.isGesture()) {
            if (e0.getGesture() == Gesture.ZOOMOUT) {
                this.xAxis.setDataRangeZoomOut();
                this.yAxis.setDataRangeZoomOut();
            } else if (e0.getGesture() == Gesture.BACK) {
                this.xAxis.setDataRangePrev();
                this.yAxis.setDataRangePrev();
            } else if (e0.getGesture() == Gesture.FORWARD) {
                this.xAxis.setDataRangeForward();
                this.yAxis.setDataRangeForward();
            }
        }
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isConstrainProportions() {
        return this.constrainProportions;
    }

    public void setConstrainProportions(boolean constrainProportions) {
        this.constrainProportions = constrainProportions;
    }
}

