/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.das2.DasApplication;
import org.das2.components.propertyeditor.Editable;
import org.das2.event.BoxRenderer;
import org.das2.event.DragRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.event.MousePointSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.system.DasLogger;
import org.das2.util.LoggerManager;

public class DasMouseInputAdapter
extends MouseInputAdapter
implements Editable,
MouseWheelListener {
    private MouseModule primary = null;
    private MouseModule secondary = null;
    private ArrayList active = null;
    private boolean pinned = false;
    private final ArrayList modules;
    private final HashMap primaryActionButtonMap;
    private final HashMap secondaryActionButtonMap;
    protected JPopupMenu primaryPopup;
    protected JPopupMenu secondaryPopup;
    private JPanel pngFileNamePanel;
    private JTextField pngFileTextField;
    private JFileChooser pngFileChooser;
    JRadioButtonMenuItem primarySelectedItem;
    JRadioButtonMenuItem secondarySelectedItem;
    Rectangle[] dirtyBoundsList;
    private static final Logger logger = LoggerManager.getLogger((String)"das2.gui.dmia");
    int numInserted;
    int numInsertedSecondary;
    protected ActionListener popupListener;
    protected DasCanvasComponent parent = null;
    private Point dSelectionStart;
    private Point dSelectionEnd;
    private final MousePointSelectionEvent mousePointSelection;
    private int xOffset;
    private int yOffset;
    private int button = 0;
    private MouseMode mouseMode = MouseMode.idle;
    private boolean drawControlPoints = false;
    private DragRenderer resizeRenderer = null;
    private Point resizeStart = null;
    Rectangle dirtyBounds = null;
    private boolean hasFocus = false;
    private Point pressPosition;
    private final boolean headless;
    private Feedback feedback;
    public static final Feedback NULL_FEEDBACK = new Feedback(){

        @Override
        public void setMessage(String message) {
        }
    };
    private boolean hoverHighlite = false;

    public void setMenuLabel(String id) {
        this.getPrimaryPopupMenu().setLabel(id);
        this.getSecondaryPopupMenu().setLabel(id);
    }

    public synchronized void resetName(String name) {
        if (!this.headless) {
            this.getPrimaryPopupMenu().setName("dmia_pop1_" + name);
            this.getSecondaryPopupMenu().setName("dmia_pop2_" + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DasMouseInputAdapter(DasCanvasComponent parent) {
        this.parent = parent;
        this.modules = new ArrayList();
        this.primaryActionButtonMap = new HashMap();
        this.secondaryActionButtonMap = new HashMap();
        this.headless = DasApplication.getDefaultApplication().isHeadless();
        if (!this.headless) {
            DasMouseInputAdapter dasMouseInputAdapter = this;
            synchronized (dasMouseInputAdapter) {
                this.primaryPopup = new JPopupMenu();
                this.primaryPopup.setName("dmia_pop1_" + parent.getDasName());
                this.numInserted = this.createPopup(this.primaryPopup);
                this.secondaryPopup = new JPopupMenu();
                this.secondaryPopup.setName("dmia_pop2_" + parent.getDasName());
                this.numInsertedSecondary = this.createPopup(this.secondaryPopup);
            }
        }
        this.active = null;
        this.mousePointSelection = new MousePointSelectionEvent(this, 0, 0);
        this.resizeRenderer = new BoxRenderer(parent, false);
        this.dirtyBoundsList = new Rectangle[0];
        this.feedback = NULL_FEEDBACK;
    }

    public void setFeedback(Feedback f) {
        if (f == null) {
            throw new NullPointerException("feedback should be set to NULL_FEEDBACK");
        }
        this.feedback = f;
    }

    public Feedback getFeedback() {
        return this.feedback;
    }

    public void replaceMouseModule(MouseModule oldModule, MouseModule newModule) {
        JRadioButtonMenuItem j = (JRadioButtonMenuItem)this.primaryActionButtonMap.get(oldModule);
        this.primaryActionButtonMap.put(newModule, j);
        this.primaryActionButtonMap.remove(oldModule);
        this.secondaryActionButtonMap.put(newModule, this.secondaryActionButtonMap.get(oldModule));
        this.secondaryActionButtonMap.remove(oldModule);
        this.modules.remove(oldModule);
        this.modules.add(newModule);
    }

    public synchronized void removeMouseModule(MouseModule module) {
        JRadioButtonMenuItem j = (JRadioButtonMenuItem)this.primaryActionButtonMap.remove(module);
        if (j != null && !this.headless && this.primaryPopup.isAncestorOf(j)) {
            this.primaryPopup.remove(j);
            --this.numInserted;
        }
        if ((j = (JRadioButtonMenuItem)this.secondaryActionButtonMap.remove(module)) != null && !this.headless && this.secondaryPopup.isAncestorOf(j)) {
            this.secondaryPopup.remove(j);
            --this.numInsertedSecondary;
        }
        this.modules.remove(module);
    }

    public synchronized void addMouseModule(MouseModule module) {
        if (this.headless) {
            DasLogger.getLogger(DasLogger.GUI_LOG).fine("not adding module since headless is true");
        } else {
            MouseModule preExisting = this.getModuleByLabel(module.getLabel());
            if (preExisting != null) {
                DasLogger.getLogger(DasLogger.GUI_LOG).log(Level.FINE, "Replacing mouse module {0}.", module.getLabel());
                this.replaceMouseModule(preExisting, module);
            } else {
                JPopupMenu lprimaryPopup = this.getPrimaryPopupMenu();
                JPopupMenu lsecondaryPopup = this.getSecondaryPopupMenu();
                if (lprimaryPopup == null || lsecondaryPopup == null) {
                    return;
                }
                this.modules.add(module);
                String name = module.getLabel();
                JRadioButtonMenuItem primaryNewItem = new JRadioButtonMenuItem(name);
                JRadioButtonMenuItem secondaryNewItem = new JRadioButtonMenuItem(name);
                primaryNewItem.addActionListener(this.popupListener);
                primaryNewItem.setActionCommand("primary");
                secondaryNewItem.addActionListener(this.popupListener);
                secondaryNewItem.setActionCommand("secondary");
                this.primaryActionButtonMap.put(module, primaryNewItem);
                this.secondaryActionButtonMap.put(module, secondaryNewItem);
                try {
                    int i = this.numInserted + 1 + this.primaryActionButtonMap.size() - 1;
                    if (i > lprimaryPopup.getComponentCount()) {
                        i = lprimaryPopup.getComponentCount();
                    }
                    if (i < 0) {
                        logger.finer("here is that bug where numInserted is negative...");
                        i = 0;
                    }
                    lprimaryPopup.add((Component)primaryNewItem, i);
                    i = this.numInsertedSecondary + 1 + this.secondaryActionButtonMap.size() - 1;
                    if (i > lsecondaryPopup.getComponentCount()) {
                        i = lsecondaryPopup.getComponentCount();
                    }
                    if (i < 0) {
                        logger.finer("here is that bug where numInsertedSecondary is negative...");
                        i = 0;
                    }
                    lsecondaryPopup.add((Component)secondaryNewItem, i);
                }
                catch (IllegalArgumentException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }

    public synchronized JPopupMenu getPrimaryPopupMenu() {
        return this.primaryPopup;
    }

    public synchronized JPopupMenu getSecondaryPopupMenu() {
        return this.secondaryPopup;
    }

    public void cancel() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DasMouseInputAdapter.this.active = null;
                DasMouseInputAdapter.this.getGlassPane().setDragRenderer(null, null, null);
                DasMouseInputAdapter.this.parent.getCanvas().paintImmediately(0, 0, DasMouseInputAdapter.this.parent.getCanvas().getWidth(), DasMouseInputAdapter.this.parent.getCanvas().getHeight());
                DasMouseInputAdapter.this.feedback.setMessage("");
                DasMouseInputAdapter.this.refresh();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public KeyAdapter getKeyAdapter() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ev) {
                logger.finest("keyPressed ");
                if (ev.getKeyCode() == 27 && DasMouseInputAdapter.this.active != null) {
                    DasMouseInputAdapter.this.active = null;
                    DasMouseInputAdapter.this.getGlassPane().setDragRenderer(null, null, null);
                    DasMouseInputAdapter.this.parent.getCanvas().paintImmediately(0, 0, DasMouseInputAdapter.this.parent.getCanvas().getWidth(), DasMouseInputAdapter.this.parent.getCanvas().getHeight());
                    DasMouseInputAdapter.this.feedback.setMessage("");
                    DasMouseInputAdapter.this.refresh();
                    ev.consume();
                } else if (ev.getKeyCode() == 16) {
                    DasMouseInputAdapter.this.drawControlPoints = true;
                    DasMouseInputAdapter.this.parent.repaint();
                } else if (ev.getKeyChar() == 'p') {
                    DasMouseInputAdapter.this.pinned = true;
                    ev.consume();
                    DasMouseInputAdapter.this.feedback.setMessage("pinned, will stay active until escape is pressed");
                } else if (ev.getKeyCode() == 38 || ev.getKeyCode() == 40 || ev.getKeyCode() == 37 || ev.getKeyCode() == 39) {
                    try {
                        int dx;
                        int n = ev.getKeyCode() == 37 ? -1 : (dx = ev.getKeyCode() == 39 ? 1 : 0);
                        int dy = ev.getKeyCode() == 38 ? -1 : (ev.getKeyCode() == 40 ? 1 : 0);
                        Robot robot = new Robot();
                        Point p = MouseInfo.getPointerInfo().getLocation();
                        robot.mouseMove(p.x + dx, p.y + dy);
                    }
                    catch (AWTException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                } else {
                    if (DasMouseInputAdapter.this.active == null) {
                        return;
                    }
                    for (Object active1 : DasMouseInputAdapter.this.active) {
                        ((MouseModule)active1).keyPressed(ev);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent ev) {
                if (ev.getKeyCode() == 16) {
                    DasMouseInputAdapter.this.drawControlPoints = false;
                    DasMouseInputAdapter.this.parent.repaint();
                }
                if (DasMouseInputAdapter.this.active == null) {
                    return;
                }
                for (Object active1 : DasMouseInputAdapter.this.active) {
                    ((MouseModule)active1).keyReleased(ev);
                }
            }

            @Override
            public void keyTyped(KeyEvent ev) {
                if (DasMouseInputAdapter.this.active == null) {
                    return;
                }
                for (Object active1 : DasMouseInputAdapter.this.active) {
                    ((MouseModule)active1).keyTyped(ev);
                }
            }
        };
    }

    public MouseModule getPrimaryModule() {
        ArrayList activ = new ArrayList();
        for (Object module : this.modules) {
            JRadioButtonMenuItem j = (JRadioButtonMenuItem)this.primaryActionButtonMap.get(module);
            if (!j.isSelected()) continue;
            activ.add(module);
        }
        return (MouseModule)activ.get(0);
    }

    public MouseModule getSecondaryModule() {
        ArrayList activ = new ArrayList();
        for (Object module : this.modules) {
            JRadioButtonMenuItem j = (JRadioButtonMenuItem)this.secondaryActionButtonMap.get(module);
            if (!j.isSelected()) continue;
            activ.add(module);
        }
        return (MouseModule)activ.get(0);
    }

    public void setPrimaryModule(MouseModule module) {
        if (this.headless) {
            return;
        }
        JRadioButtonMenuItem j = (JRadioButtonMenuItem)this.primaryActionButtonMap.get(module);
        if (j == null) {
            this.addMouseModule(module);
        }
        Iterator i = this.primaryActionButtonMap.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Object ii = i.next().getValue();
                ((JRadioButtonMenuItem)ii).setSelected(false);
            }
            catch (RuntimeException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                throw ex;
            }
        }
        j = (JRadioButtonMenuItem)this.primaryActionButtonMap.get(module);
        if (j != null) {
            j.setSelected(true);
        }
        this.primarySelectedItem = j;
        this.primary = module;
        this.parent.setCursor(this.primary.getCursor());
    }

    public void setSecondaryModule(MouseModule module) {
        if (this.headless) {
            return;
        }
        JRadioButtonMenuItem j = (JRadioButtonMenuItem)this.secondaryActionButtonMap.get(module);
        if (j == null) {
            this.addMouseModule(module);
        }
        Iterator i = this.secondaryActionButtonMap.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Object ii = i.next().getValue();
                ((JRadioButtonMenuItem)ii).setSelected(false);
            }
            catch (RuntimeException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                throw ex;
            }
        }
        j = (JRadioButtonMenuItem)this.secondaryActionButtonMap.get(module);
        if (j != null) {
            j.setSelected(true);
        }
        this.secondarySelectedItem = j;
        this.secondary = module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createPopup(JPopupMenu popup) {
        Action[] canvasActions;
        Action[] componentActions;
        DasMouseInputAdapter dasMouseInputAdapter = this;
        synchronized (dasMouseInputAdapter) {
            this.popupListener = this.createPopupMenuListener();
        }
        for (Action componentAction : componentActions = this.parent.getActions()) {
            JMenuItem item = new JMenuItem();
            item.setAction(componentAction);
            popup.add(item);
        }
        int numInsert = componentActions.length;
        popup.addSeparator();
        popup.addSeparator();
        for (Action canvasAction : canvasActions = DasCanvas.getActions()) {
            JMenuItem item = new JMenuItem();
            item.setAction(canvasAction);
            popup.add(item);
        }
        return numInsert;
    }

    private ActionListener createPopupMenuListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals("properties")) {
                    DasMouseInputAdapter.this.parent.showProperties();
                } else if (command.equals("print")) {
                    Printable p = ((DasCanvas)DasMouseInputAdapter.this.parent.getParent()).getPrintable();
                    PrinterJob pj = PrinterJob.getPrinterJob();
                    pj.setPrintable(p);
                    if (pj.printDialog()) {
                        try {
                            pj.print();
                        }
                        catch (PrinterException pe) {
                            Object[] message = new Object[]{"Error printing", pe.getMessage()};
                            JOptionPane.showMessageDialog(null, message, "ERROR", 0);
                        }
                    }
                } else if (command.equals("toPng")) {
                    if (DasMouseInputAdapter.this.pngFileNamePanel == null) {
                        DasMouseInputAdapter.this.pngFileNamePanel = new JPanel();
                        DasMouseInputAdapter.this.pngFileNamePanel.setLayout(new BoxLayout(DasMouseInputAdapter.this.pngFileNamePanel, 0));
                        DasMouseInputAdapter.this.pngFileTextField = new JTextField(32);
                        DasMouseInputAdapter.this.pngFileTextField.setMaximumSize(DasMouseInputAdapter.this.pngFileTextField.getPreferredSize());
                        DasMouseInputAdapter.this.pngFileChooser = new JFileChooser();
                        DasMouseInputAdapter.this.pngFileChooser.setApproveButtonText("Select File");
                        DasMouseInputAdapter.this.pngFileChooser.setDialogTitle("Write to PNG");
                        JButton b = new JButton("Browse");
                        b.setActionCommand("pngBrowse");
                        b.addActionListener(this);
                        DasMouseInputAdapter.this.pngFileNamePanel.add(DasMouseInputAdapter.this.pngFileTextField);
                        DasMouseInputAdapter.this.pngFileNamePanel.add(b);
                    }
                    DasMouseInputAdapter.this.pngFileTextField.setText(DasMouseInputAdapter.this.pngFileChooser.getCurrentDirectory().getPath());
                    Object[] options = new String[]{"Write to PNG", "Cancel"};
                    int choice = JOptionPane.showOptionDialog(DasMouseInputAdapter.this.parent, DasMouseInputAdapter.this.pngFileNamePanel, "Write to PNG", 0, 3, null, options, "Ok");
                    if (choice == 0) {
                        DasCanvas canvas = (DasCanvas)DasMouseInputAdapter.this.parent.getParent();
                        try {
                            canvas.writeToPng(DasMouseInputAdapter.this.pngFileTextField.getText());
                        }
                        catch (IOException ioe) {
                            DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)ioe);
                        }
                    }
                } else if (command.equals("pngBrowse")) {
                    int choice = DasMouseInputAdapter.this.pngFileChooser.showDialog(DasMouseInputAdapter.this.parent, "Select File");
                    if (choice == 0) {
                        DasMouseInputAdapter.this.pngFileTextField.setText(DasMouseInputAdapter.this.pngFileChooser.getSelectedFile().getPath());
                    }
                } else if (!command.equals("close")) {
                    if (command.equals("primary")) {
                        if (DasMouseInputAdapter.this.primarySelectedItem != null) {
                            DasMouseInputAdapter.this.primarySelectedItem.setSelected(false);
                        }
                        for (Object module : DasMouseInputAdapter.this.modules) {
                            JRadioButtonMenuItem j = (JRadioButtonMenuItem)DasMouseInputAdapter.this.primaryActionButtonMap.get(module);
                            if (!j.isSelected()) continue;
                            DasMouseInputAdapter.this.primarySelectedItem = j;
                            break;
                        }
                        DasMouseInputAdapter.this.primarySelectedItem.setSelected(true);
                    } else if (command.equals("secondary")) {
                        if (DasMouseInputAdapter.this.secondarySelectedItem != null) {
                            DasMouseInputAdapter.this.secondarySelectedItem.setSelected(false);
                        }
                        for (Object module : DasMouseInputAdapter.this.modules) {
                            JRadioButtonMenuItem j = (JRadioButtonMenuItem)DasMouseInputAdapter.this.secondaryActionButtonMap.get(module);
                            if (!j.isSelected()) continue;
                            DasMouseInputAdapter.this.secondarySelectedItem = j;
                            break;
                        }
                    } else {
                        logger.log(Level.FINE, "{0}", command);
                    }
                }
            }
        };
    }

    private void renderSelection() {
        try {
            for (Object active1 : this.active) {
                DragRenderer dr = ((MouseModule)active1).getDragRenderer();
                this.getGlassPane().setDragRenderer(dr, this.dSelectionStart, this.dSelectionEnd);
            }
        }
        catch (RuntimeException e) {
            DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)e);
        }
    }

    private synchronized void refresh() {
        if (this.dirtyBoundsList.length > 0) {
            Rectangle[] dd = new Rectangle[this.dirtyBoundsList.length];
            for (int i = 0; i < dd.length; ++i) {
                if (this.dirtyBoundsList[i] == null) continue;
                dd[i] = new Rectangle(this.dirtyBoundsList[i]);
            }
            for (Rectangle dd1 : dd) {
                if (dd1 == null) continue;
                this.parent.getCanvas().repaint(dd1);
            }
            for (Rectangle dirtyBoundsList1 : this.dirtyBoundsList) {
                if (dirtyBoundsList1 == null) continue;
                this.parent.getCanvas().repaint(dirtyBoundsList1);
            }
        } else if (this.active != null) {
            this.parent.getCanvas().repaint();
        }
        if (this.active == null) {
            this.dirtyBoundsList = new Rectangle[0];
        }
    }

    public void paint(Graphics g1) {
        Graphics2D g = (Graphics2D)g1.create();
        DasCanvasComponent lparent = this.parent;
        if (lparent == null) {
            return;
        }
        g.translate(-lparent.getX(), -lparent.getY());
        if (this.active != null) {
            this.renderSelection();
        }
        if (this.hasFocus && this.hoverHighlite) {
            g.setColor(new Color(255, 0, 0, 10));
            g.setStroke(new BasicStroke(10.0f));
            g.draw(lparent.getBounds());
            g.dispose();
            return;
        }
        if (this.hasFocus && this.drawControlPoints) {
            this.drawControlPoints(g, lparent);
        }
        g.dispose();
    }

    private void drawControlPoints(Graphics2D g, DasCanvasComponent parent) {
        if (parent.getRow() != DasRow.NULL && parent.getColumn() != DasColumn.NULL) {
            int xLeft = parent.getColumn().getDMinimum();
            int xRight = parent.getColumn().getDMaximum();
            int xMid = (xLeft + xRight) / 2;
            int yTop = parent.getRow().getDMinimum();
            int yBottom = parent.getRow().getDMaximum();
            int yMid = (yTop + yBottom) / 2;
            Graphics2D gg = (Graphics2D)g.create();
            gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gg.setColor(new Color(0, 0, 0, 255));
            int ss = 9;
            gg.fillRect(xLeft + 1, yTop + 1, ss - 2, ss - 2);
            gg.fillRect(xRight - ss + 1, yTop + 1, ss - 2, ss - 2);
            gg.fillRect(xLeft + 1, yBottom - ss + 1, ss - 2, ss - 2);
            gg.fillRect(xRight - ss + 1, yBottom - ss + 1, ss - 2, ss - 2);
            gg.fillRect(xMid + 1 - ss / 2, yTop + 1, ss - 2, ss - 2);
            gg.fillRect(xRight - ss + 1, yMid + 1 - ss / 2, ss - 2, ss - 2);
            gg.fillRect(xMid + 1 - ss / 2, yBottom - ss + 1, ss - 2, ss - 2);
            gg.fillRect(xLeft + 1, yMid - ss / 2 + 1, ss - 2, ss - 2);
            gg.setColor(new Color(255, 255, 255, 100));
            gg.drawRect(xLeft, yTop, ss, ss);
            gg.drawRect(xRight - ss, yTop, ss, ss);
            gg.drawRect(xLeft, yBottom - ss, ss, ss);
            gg.drawRect(xRight - ss, yBottom - ss, ss, ss);
            gg.drawRect(xMid - ss / 2, yTop + 1, ss, ss);
            gg.drawRect(xRight - ss, yMid - ss / 2, ss, ss);
            gg.drawRect(xMid - ss / 2, yBottom - ss, ss, ss);
            gg.drawRect(xLeft, yMid - ss / 2, ss, ss);
            int rr = 4;
            g.setColor(new Color(255, 255, 255, 100));
            gg.fillOval(xMid - rr - 1, yMid - rr - 1, rr * 2 + 3, rr * 2 + 3);
            gg.setColor(new Color(0, 0, 0, 255));
            gg.drawOval(xMid - rr, yMid - rr, rr * 2, rr * 2);
            gg.fillOval(xMid - 1, yMid - 1, 3, 3);
            gg.dispose();
        }
    }

    private MouseMode activateMouseMode(MouseEvent e) {
        boolean xLeftSide = false;
        boolean xRightSide = false;
        boolean xMiddle = false;
        boolean yTopSide = false;
        boolean yBottomSide = false;
        boolean yMiddle = false;
        Point mousePoint = e.getPoint();
        mousePoint.translate(this.parent.getX(), this.parent.getY());
        if (this.parent.getRow() != DasRow.NULL && this.parent.getColumn() != DasColumn.NULL) {
            int xLeft = this.parent.getColumn().getDMinimum();
            int xRight = this.parent.getColumn().getDMaximum();
            int yTop = this.parent.getRow().getDMinimum();
            int yBottom = this.parent.getRow().getDMaximum();
            int xmid = (xLeft + xRight) / 2;
            int ymid = (yTop + yBottom) / 2;
            xLeftSide = mousePoint.getX() < (double)(xLeft + 10);
            xRightSide = mousePoint.getX() > (double)(xRight - 10);
            xMiddle = Math.abs(mousePoint.getX() - (double)xmid) < 4.0;
            yTopSide = mousePoint.getY() < (double)(yTop + 10) && mousePoint.getY() >= (double)yTop;
            yBottomSide = mousePoint.getY() > (double)(yBottom - 10);
            yMiddle = Math.abs(mousePoint.getY() - (double)ymid) < 4.0;
        }
        MouseMode result = MouseMode.idle;
        Cursor cursor = new Cursor(0);
        if ((this.parent instanceof DasColorBar || !(this.parent instanceof DasAxis)) && (e.getModifiersEx() & 0x40) == 64) {
            if (xLeftSide) {
                if (yTopSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(6);
                } else if (yBottomSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(4);
                } else if (yMiddle) {
                    result = MouseMode.resize;
                    cursor = new Cursor(10);
                }
            } else if (xRightSide) {
                if (yTopSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(7);
                } else if (yBottomSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(5);
                } else if (yMiddle) {
                    result = MouseMode.resize;
                    cursor = new Cursor(11);
                }
            } else if (xMiddle && yMiddle) {
                result = MouseMode.move;
                cursor = new Cursor(13);
            } else if (xMiddle && yTopSide) {
                result = MouseMode.resize;
                cursor = new Cursor(8);
            } else if (xMiddle && yBottomSide) {
                result = MouseMode.resize;
                cursor = new Cursor(9);
            }
        }
        if (result == MouseMode.resize) {
            result.resizeBottom = yBottomSide;
            result.resizeTop = yTopSide;
            result.resizeRight = xRightSide;
            result.resizeLeft = xLeftSide;
        } else if (result == MouseMode.move) {
            result.moveStart = e.getPoint();
            result.moveStart.translate(this.parent.getX(), this.parent.getY());
        }
        if (result != this.mouseMode) {
            this.getGlassPane().setCursor(cursor);
        }
        return result;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MouseMode m;
        logger.finest("mouseMoved");
        Point l = this.parent.getLocation();
        this.xOffset = l.x;
        this.yOffset = l.y;
        boolean drawControlPoints0 = this.drawControlPoints;
        boolean bl = this.drawControlPoints = (e.getModifiersEx() & 0x40) == 64;
        if (drawControlPoints0 != this.drawControlPoints) {
            this.parent.repaint();
        }
        this.mouseMode = (m = this.activateMouseMode(e)) != null ? m : MouseMode.idle;
    }

    private void showPopup(JPopupMenu menu, MouseEvent ev) {
        logger.finest("showPopup");
        if (menu != this.getPrimaryPopupMenu() && menu != this.getSecondaryPopupMenu()) {
            throw new IllegalArgumentException("menu must be primary or secondary popup menu");
        }
        ButtonGroup bg = new ButtonGroup();
        for (MouseModule mm : this.modules) {
            JRadioButtonMenuItem j = (JRadioButtonMenuItem)this.primaryActionButtonMap.get(mm);
            j.setText(mm.getLabel());
            bg.add(j);
        }
        menu.show(ev.getComponent(), ev.getX(), ev.getY());
    }

    public void setPinned(boolean b) {
        this.pinned = b;
    }

    public boolean getPinned() {
        return this.pinned;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        logger.log(Level.FINE, "mousePressed {0} on {1}", new Object[]{this.mouseMode, this.parent});
        if (this.pinned) {
            this.active = null;
            this.refresh();
        }
        this.pinned = false;
        Point l = this.parent.getLocation();
        this.parent.requestFocus();
        this.xOffset = l.x;
        this.yOffset = l.y;
        this.pressPosition = e.getPoint();
        Point cp = new Point(e.getPoint());
        cp.translate(this.xOffset, this.yOffset);
        if (!this.parent.acceptContext(cp.x, cp.y)) {
            return;
        }
        if (this.mouseMode == MouseMode.resize) {
            this.resizeStart = new Point(0, 0);
            this.resizeStart.x = this.mouseMode.resizeRight ? 0 + this.xOffset : (this.mouseMode.resizeLeft ? this.parent.getWidth() + this.xOffset : 0 + this.xOffset);
            this.resizeStart.y = this.mouseMode.resizeTop ? this.parent.getHeight() + this.yOffset : (this.mouseMode.resizeBottom ? 0 + this.yOffset : 0 + this.yOffset);
        } else if (this.mouseMode == MouseMode.move) {
            this.mouseMode.moveStart = e.getPoint();
            this.mouseMode.moveStart.translate(this.xOffset, this.yOffset);
        } else if (this.active == null) {
            this.button = e.getButton();
            this.dSelectionStart = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            this.dSelectionEnd = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            if (e.isControlDown() || this.button == 3) {
                if (this.button == 1 || this.button == 3) {
                    this.showPopup(this.getPrimaryPopupMenu(), e);
                } else {
                    this.showPopup(this.getSecondaryPopupMenu(), e);
                }
            } else {
                JRadioButtonMenuItem j;
                this.active = new ArrayList();
                if (this.button == 1 || this.button == 3) {
                    for (Object module : this.modules) {
                        j = (JRadioButtonMenuItem)this.primaryActionButtonMap.get(module);
                        if (!j.isSelected()) continue;
                        this.active.add(module);
                    }
                } else {
                    for (Object module : this.modules) {
                        j = (JRadioButtonMenuItem)this.secondaryActionButtonMap.get(module);
                        if (!j.isSelected()) continue;
                        this.active.add(module);
                    }
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        ArrayList lactive = DasMouseInputAdapter.this.active;
                        if (lactive == null || lactive.isEmpty()) {
                            return;
                        }
                        MouseModule theone = (MouseModule)lactive.get(0);
                        if (theone == null) {
                            return;
                        }
                        try {
                            Method m = theone.getClass().getMethod("mouseRangeSelected", MouseDragEvent.class);
                            if (m.equals(MouseModule.class.getMethod("mouseRangeSelected", MouseDragEvent.class))) {
                                String s = theone.getDirections();
                                if (s == null) {
                                    s = theone.getLabel();
                                }
                                if (!s.startsWith(theone.getLabel())) {
                                    s = theone.getLabel() + ": " + s;
                                }
                                DasMouseInputAdapter.this.feedback.setMessage(s);
                            } else {
                                String s = theone.getDirections();
                                if (s == null) {
                                    s = theone.getLabel();
                                }
                                if (!s.startsWith(theone.getLabel())) {
                                    s = theone.getLabel() + ": " + s;
                                }
                                DasMouseInputAdapter.this.feedback.setMessage(s + ", press escape to cancel and p to pin");
                            }
                        }
                        catch (NoSuchMethodException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                        catch (SecurityException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                };
                SwingUtilities.invokeLater(run);
                this.mouseMode = MouseMode.moduleDrag;
                if (this.parent instanceof DasPlot && !DasDevicePosition.toRectangle(this.parent.getRow(), this.parent.getColumn()).contains(this.dSelectionStart)) {
                    this.active = null;
                    return;
                }
                this.mousePointSelection.set(e.getX() + this.xOffset, e.getY() + this.yOffset);
                for (Object active1 : this.active) {
                    MouseModule j2 = (MouseModule)active1;
                    j2.mousePressed(e);
                    if (!j2.dragRenderer.isPointSelection()) continue;
                    this.mouseDragged(e);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        logger.log(Level.FINE, "mouseDragged {0} on {1}", new Object[]{this.mouseMode, this.parent});
        if (this.mouseMode == MouseMode.resize) {
            Point p = e.getPoint();
            p.translate(this.parent.getX(), this.parent.getY());
            if (!this.mouseMode.resizeBottom && !this.mouseMode.resizeTop) {
                p.y = this.parent.getRow().getDMaximum();
            }
            if (!this.mouseMode.resizeRight && !this.mouseMode.resizeLeft) {
                p.x = this.parent.getColumn().getDMaximum();
            }
            this.getGlassPane().setDragRenderer(this.resizeRenderer, this.resizeStart, p);
            this.getGlassPane().repaint();
        } else if (this.mouseMode == MouseMode.move) {
            Point moveEnd = e.getPoint();
            moveEnd.translate(this.xOffset, this.yOffset);
            int dx = moveEnd.x - this.mouseMode.moveStart.x;
            int dy = moveEnd.y - this.mouseMode.moveStart.y;
            int xmin = this.parent.getColumn().getDMinimum();
            int xmax = this.parent.getColumn().getDMaximum();
            int ymin = this.parent.getRow().getDMinimum();
            int ymax = this.parent.getRow().getDMaximum();
            Point p1 = new Point(xmin + dx, ymin + dy);
            Point p2 = new Point(xmax + dx, ymax + dy);
            this.getGlassPane().setDragRenderer(this.resizeRenderer, p1, p2);
            this.getGlassPane().repaint();
        } else if (this.active != null) {
            this.dSelectionEnd = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            this.mousePointSelection.set((int)this.dSelectionEnd.getX(), (int)this.dSelectionEnd.getY());
            for (Object active1 : this.active) {
                try {
                    MouseModule j = (MouseModule)active1;
                    if (j.dragRenderer.isPointSelection()) {
                        logger.finest("mousePointSelected");
                        j.mousePointSelected(this.mousePointSelection);
                    }
                    if (j.dragRenderer.isUpdatingDragSelection()) {
                        MouseDragEvent de = j.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, e.isShiftDown());
                        if (de == null) {
                            logger.info("dragRenderer isUpdatingDragSelection()==True, but no dragEvent was produced.");
                            return;
                        }
                        logger.finest("mouseRangeSelected");
                        j.mouseRangeSelected(de);
                    }
                    j.mouseDragged(e);
                }
                catch (RuntimeException except) {
                    DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)except);
                }
            }
            this.refresh();
        }
    }

    public MouseModule getActive() {
        if (this.active == null || this.active.isEmpty()) {
            return null;
        }
        return (MouseModule)this.active.get(0);
    }

    private void performResize(MouseEvent e) {
        int dxLeft = this.parent.getColumn().getDMinimum();
        int dxRight = this.parent.getColumn().getDMaximum();
        int dyTop = this.parent.getRow().getDMinimum();
        int dyBottom = this.parent.getRow().getDMaximum();
        int dx = e.getX() + this.xOffset;
        int dy = e.getY() + this.yOffset;
        if (this.mouseMode.resizeRight) {
            dxRight = dx;
        } else if (this.mouseMode.resizeLeft) {
            dxLeft = dx;
        }
        if (this.mouseMode.resizeTop) {
            dyTop = dy;
        } else if (this.mouseMode.resizeBottom) {
            dyBottom = dy;
        }
        this.parent.getColumn().setDPosition(dxLeft, dxRight);
        this.parent.getRow().setDPosition(dyTop, dyBottom);
        this.xOffset += dx;
        this.yOffset += dy;
        this.parent.resize();
        this.getGlassPane().setDragRenderer(null, null, null);
        this.getGlassPane().setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        logger.log(Level.FINE, "mouseReleased {0} on {1}", new Object[]{this.mouseMode, this.parent});
        if (this.mouseMode == MouseMode.resize) {
            this.performResize(e);
            this.getGlassPane().setDragRenderer(null, null, null);
            this.parent.getCanvas().paintImmediately(0, 0, this.parent.getCanvas().getWidth(), this.parent.getCanvas().getHeight());
            this.refresh();
        } else if (this.mouseMode == MouseMode.move) {
            this.performMove(e);
            this.getGlassPane().setDragRenderer(null, null, null);
            this.parent.getCanvas().paintImmediately(0, 0, this.parent.getCanvas().getWidth(), this.parent.getCanvas().getHeight());
            this.refresh();
        } else if (e.getButton() == this.button && this.active != null) {
            for (Object active1 : this.active) {
                MouseModule j = (MouseModule)active1;
                try {
                    MouseDragEvent de = j.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, e.isShiftDown());
                    if (de != null) {
                        j.mouseRangeSelected(de);
                    }
                    this.feedback.setMessage("");
                }
                catch (RuntimeException ex) {
                    DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)ex);
                }
                finally {
                    this.button = 0;
                    try {
                        j.mouseReleased(e);
                    }
                    catch (RuntimeException ex2) {
                        DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)ex2);
                    }
                }
            }
            if (!this.pinned) {
                this.active = null;
                this.getGlassPane().setDragRenderer(null, null, null);
                this.parent.getCanvas().paintImmediately(0, 0, this.parent.getCanvas().getWidth(), this.parent.getCanvas().getHeight());
                this.refresh();
            }
        }
    }

    public MouseModule getMouseModule(int i) {
        return (MouseModule)this.modules.get(i);
    }

    public MouseModule[] getMouseModules() {
        MouseModule[] result = new MouseModule[this.modules.size()];
        result = this.modules.toArray(result);
        return result;
    }

    public String getPrimaryModuleByLabel() {
        MouseModule primary1 = this.getPrimaryModule();
        return primary1 == null ? "" : primary1.getLabel();
    }

    public void setPrimaryModuleByLabel(String label) {
        MouseModule mm = this.getModuleByLabel(label);
        if (mm != null) {
            this.setPrimaryModule(mm);
        }
    }

    public String getSecondaryModuleByLabel() {
        MouseModule secondary1 = this.getPrimaryModule();
        return secondary1 == null ? "" : secondary1.getLabel();
    }

    public void setSecondaryModuleByLabel(String label) {
        MouseModule mm = this.getModuleByLabel(label);
        if (mm != null) {
            this.setSecondaryModule(mm);
        }
    }

    public void setMouseModule(int i, MouseModule mouseModule) {
        this.modules.set(i, mouseModule);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.hasFocus = true;
        if (e.isShiftDown()) {
            this.parent.repaint();
        }
        if (this.primary != null) {
            this.getGlassPane().setCursor(this.primary.getCursor());
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hasFocus = false;
        if (e.isShiftDown()) {
            this.parent.repaint();
        }
        this.getGlassPane().setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceMenuItem(String label, Component b) {
        JPopupMenu localPrimaryPopup;
        int localNumInserted;
        if (this.headless) {
            return;
        }
        DasMouseInputAdapter dasMouseInputAdapter = this;
        synchronized (dasMouseInputAdapter) {
            localNumInserted = this.numInserted;
            localPrimaryPopup = this.primaryPopup;
        }
        MenuElement[] ele = localPrimaryPopup.getSubElements();
        int index = -1;
        for (int i = 0; i < localNumInserted; ++i) {
            if (!(ele[i] instanceof JMenuItem) || !((JMenuItem)ele[i]).getText().contains(label)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            localPrimaryPopup.remove(index);
            localPrimaryPopup.add(b, index);
        } else {
            logger.log(Level.INFO, "unable to find menu item \"{0}\"", label);
            localPrimaryPopup.add(b);
        }
    }

    public synchronized void removeMenuItem(String label) {
        if (this.headless) {
            return;
        }
        MenuElement[] ele = this.primaryPopup.getSubElements();
        int index = -1;
        for (int i = 0; i < this.numInserted; ++i) {
            if (i < ele.length) {
                if (!(ele[i] instanceof JMenuItem) || !((JMenuItem)ele[i]).getText().contains(label)) continue;
                index = i;
                break;
            }
            System.err.println("Suppressing old index out of bounds:");
            new IndexOutOfBoundsException("in removeMenuItem, index out of bounds").printStackTrace();
            break;
        }
        if (index != -1) {
            this.primaryPopup.remove(index);
            --this.numInserted;
            logger.log(Level.FINER, "numInserted: {0}", this.numInserted);
        }
    }

    public synchronized void addMenuItem(Component b) {
        if (this.headless) {
            return;
        }
        if (this.numInserted == 0) {
            this.primaryPopup.insert(new JPopupMenu.Separator(), 0);
            ++this.numInserted;
        }
        if (b instanceof JPopupMenu) {
            if (this.numInserted > 1) {
                this.primaryPopup.insert(new JPopupMenu.Separator(), 0);
                ++this.numInserted;
            }
            JPopupMenu c = (JPopupMenu)b;
            for (MenuElement me : c.getSubElements()) {
                if (me.getComponent() instanceof JRadioButtonMenuItem) continue;
                this.primaryPopup.insert(me.getComponent(), this.numInserted);
                ++this.numInserted;
            }
        } else {
            this.primaryPopup.insert(b, this.numInserted);
            ++this.numInserted;
        }
    }

    public JMenu addMenu(String label) {
        JMenu result = new JMenu(label);
        this.addMenuItem(result);
        return result;
    }

    public int getNumInserted() {
        return this.numInserted;
    }

    private DasCanvas.GlassPane getGlassPane() {
        DasCanvas.GlassPane r = (DasCanvas.GlassPane)((DasCanvas)this.parent.getParent()).getGlassPane();
        if (!r.isVisible()) {
            r.setVisible(true);
        }
        return r;
    }

    public MouseModule getModuleByLabel(String label) {
        MouseModule result = null;
        for (Object module : this.modules) {
            if (!label.equals(((MouseModule)module).getLabel())) continue;
            result = (MouseModule)module;
        }
        return result;
    }

    public boolean isHoverHighlite() {
        return this.hoverHighlite;
    }

    public void setHoverHighlite(boolean value) {
        this.hoverHighlite = value;
    }

    public Point getMousePressPosition() {
        return this.pressPosition;
    }

    public Point getMousePressPositionOnCanvas() {
        if (this.pressPosition == null) {
            return null;
        }
        Point r = this.pressPosition.getLocation();
        r.translate(this.parent.getX(), this.parent.getY());
        return r;
    }

    public void setMousePressPositionOnCanvas(Point p) {
        if (p != null) {
            Point r = p.getLocation();
            r.translate(-this.parent.getX(), -this.parent.getY());
            this.pressPosition = r;
        } else {
            this.pressPosition = null;
        }
    }

    private void performMove(MouseEvent e) {
        Point moveEnd = e.getPoint();
        moveEnd.translate(this.xOffset, this.yOffset);
        int dx = moveEnd.x - this.mouseMode.moveStart.x;
        int dy = moveEnd.y - this.mouseMode.moveStart.y;
        this.xOffset += dx;
        this.yOffset += dy;
        int min = this.parent.getColumn().getDMinimum();
        int max = this.parent.getColumn().getDMaximum();
        this.parent.getColumn().setDPosition(min + dx, max + dx);
        min = this.parent.getRow().getDMinimum();
        max = this.parent.getRow().getDMaximum();
        this.parent.getRow().setDPosition(min + dy, max + dy);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.secondary != null) {
            this.secondary.mouseWheelMoved(e);
        }
    }

    public synchronized void releaseAll() {
        this.active = null;
        this.modules.clear();
        this.primary = null;
        this.secondary = null;
        this.primaryActionButtonMap.clear();
        this.secondaryActionButtonMap.clear();
        this.setFeedback(NULL_FEEDBACK);
        JPopupMenu jp = this.primaryPopup;
        if (jp != null) {
            jp.removeAll();
        }
        this.primaryPopup = null;
        jp = this.secondaryPopup;
        if (jp != null) {
            jp.removeAll();
        }
        this.secondaryPopup = null;
        this.resizeRenderer = null;
        this.mouseMode = null;
        this.secondarySelectedItem = null;
    }

    public static interface Feedback {
        public void setMessage(String var1);
    }

    private static final class MouseMode {
        String s;
        boolean resizeTop = false;
        boolean resizeBottom = false;
        boolean resizeRight = false;
        boolean resizeLeft = false;
        Point moveStart = null;
        static final MouseMode idle = new MouseMode("idle");
        static final MouseMode resize = new MouseMode("resize");
        static final MouseMode move = new MouseMode("move");
        static final MouseMode moduleDrag = new MouseMode("moduleDrag");

        MouseMode(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

