/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import javax.swing.event.EventListenerList;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.event.HorizontalDragRangeRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.event.MouseRangeSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;

public class HorizontalDragRangeSelectorMouseModule
extends MouseModule {
    DasAxis axis;
    private EventListenerList listenerList = new EventListenerList();
    private DataSetConsumer dataSetConsumer;

    public HorizontalDragRangeSelectorMouseModule(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis axis) {
        super(parent, new HorizontalDragRangeRenderer(parent), "Horizontal Drag Range");
        if (!axis.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not horizontal");
        }
        this.dataSetConsumer = dataSetConsumer;
        this.axis = axis;
    }

    public static HorizontalDragRangeSelectorMouseModule create(DasPlot parent) {
        HorizontalDragRangeSelectorMouseModule result = new HorizontalDragRangeSelectorMouseModule(parent, null, parent.getXAxis());
        return result;
    }

    @Override
    public void mouseRangeSelected(MouseDragEvent e0) {
        if (!(e0 instanceof MouseRangeSelectionEvent)) {
            throw new IllegalArgumentException("Event should be MouseRangeSelectionEvent");
        }
        MouseRangeSelectionEvent e = (MouseRangeSelectionEvent)e0;
        Datum min = this.axis.invTransform(e.getMinimum());
        Datum max = this.axis.invTransform(e.getMaximum());
        DataRangeSelectionEvent te = new DataRangeSelectionEvent(this.parent, min, max);
        this.fireDataRangeSelectionListenerDataRangeSelected(te);
    }

    public void addDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.add(DataRangeSelectionListener.class, listener);
    }

    public void removeDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.remove(DataRangeSelectionListener.class, listener);
    }

    public DataRangeSelectionListener getDataRangeSelectionListener(int index) {
        return (DataRangeSelectionListener)this.listenerList.getListenerList()[index * 2 + 1];
    }

    public int getDataRangeSelectionListenerCount() {
        return this.listenerList.getListenerCount();
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent event) {
        if (this.dataSetConsumer instanceof TableDataSetConsumer) {
            event.setDataSet(this.dataSetConsumer.getConsumedDataSet());
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataRangeSelectionListener.class) continue;
            ((DataRangeSelectionListener)listeners[i + 1]).dataRangeSelected(event);
        }
    }
}

