/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.das2.event.DragRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;

public class HorizontalSliceSelectionRenderer
implements DragRenderer {
    DasCanvasComponent parent;
    Rectangle dirtyBounds;

    public HorizontalSliceSelectionRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
    }

    private void drawCrossHair(Graphics g0, Point p) {
        Graphics g = g0.create();
        g.setColor(new Color(0, 0, 0));
        g.setXORMode(Color.white);
        DasColumn col = this.parent.getColumn();
        g.drawLine(col.getDMinimum(), p.y, col.getDMaximum(), p.y);
        g.dispose();
    }

    @Override
    public Rectangle[] renderDrag(Graphics g, Point p1, Point p2) {
        DasColumn col = this.parent.getColumn();
        this.dirtyBounds.setRect(col.getDMinimum(), p2.y, col.getDMaximum(), 1.0);
        this.drawCrossHair(g, p2);
        return new Rectangle[]{this.dirtyBounds};
    }

    @Override
    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        return null;
    }

    @Override
    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    @Override
    public boolean isPointSelection() {
        return true;
    }

    @Override
    public boolean isUpdatingDragSelection() {
        return false;
    }
}

