/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumRangeUtil;
import org.das2.event.AbstractDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.qds.IDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.LoggerManager;

public class WaypointsDragRenderer
extends AbstractDragRenderer {
    Point2D.Double pointerStart = null;
    Point2D.Double pointerLocation = null;
    List<Point2D.Double> wayPoints = new ArrayList<Point2D.Double>();
    int direction = 1;
    private int width = 20;
    public static final String PROP_WIDTH = "width";
    private static final Logger logger = LoggerManager.getLogger((String)"das2.gui.dmia");

    public WaypointsDragRenderer(DasCanvasComponent parent) {
        super(parent);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.getParent().repaint();
    }

    @Override
    public void clear(Graphics g) {
        this.wayPoints.clear();
        this.pointerLocation = null;
        this.getParent().repaint();
    }

    public void addWayPoint() {
        if (this.pointerLocation != null) {
            if (this.direction == 0) {
                this.direction = this.pointerLocation.x > this.pointerStart.x ? 1 : -1;
            }
            if ((this.pointerLocation.x - this.pointerStart.x) * (double)this.direction > 0.0) {
                this.wayPoints.add(this.pointerLocation);
            } else {
                logger.info("wrong direction");
            }
        } else {
            logger.info("no pointer location");
        }
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        int i;
        Graphics2D g = (Graphics2D)g1;
        GeneralPath gen = new GeneralPath();
        if (this.direction > 0) {
            p2.x = this.wayPoints.size() > 0 ? Math.max(p2.x, (int)this.wayPoints.get((int)(this.wayPoints.size() - 1)).x) : Math.max(p2.x, p1.x);
        } else if (this.direction < 0) {
            p2.x = this.wayPoints.size() > 0 ? Math.min(p2.x, (int)this.wayPoints.get((int)(this.wayPoints.size() - 1)).x) : Math.min(p2.x, p1.x);
        }
        gen.moveTo(p1.x, p1.y - this.width);
        for (i = 0; i < this.wayPoints.size(); ++i) {
            gen.lineTo(this.wayPoints.get((int)i).x, this.wayPoints.get((int)i).y - (double)this.width);
        }
        gen.lineTo(p2.x, p2.y - this.width);
        gen.lineTo(p2.x, p2.y + this.width);
        for (i = this.wayPoints.size() - 1; i >= 0; --i) {
            gen.lineTo(this.wayPoints.get((int)i).x, this.wayPoints.get((int)i).y + (double)this.width);
        }
        gen.lineTo(p1.x, p1.y + this.width);
        gen.closePath();
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 100));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.draw(gen);
        g.setStroke(new BasicStroke());
        g.setColor(color0);
        g.draw(gen);
        this.pointerStart = new Point2D.Double(p1.x, p1.y);
        this.pointerLocation = new Point2D.Double(p2.x, p2.y);
        return new Rectangle[0];
    }

    protected QDataSet whereWithin(DasAxis xaxis, DasAxis yaxis, QDataSet xx, QDataSet yy) {
        switch (xx.rank()) {
            case 0: {
                int index = -1;
                double ix = xaxis.transform(xx);
                if (ix < this.pointerStart.x) {
                    return IDataSet.createRank1((int)0);
                }
                for (int i = 0; i < this.wayPoints.size(); ++i) {
                    if (!(ix < this.wayPoints.get((int)i).x)) continue;
                    index = i;
                    break;
                }
                if (index == -1 && ix < this.pointerLocation.x) {
                    index = this.wayPoints.size();
                }
                if (yy.rank() == 0) {
                    yy = Ops.join(null, (QDataSet)yy);
                }
                if (yy.rank() == 1) {
                    double y;
                    if (index == 0 && this.wayPoints.isEmpty()) {
                        double alpha = (ix - this.pointerStart.x) / (this.pointerLocation.x - this.pointerStart.x);
                        y = this.pointerStart.y + alpha * (this.pointerLocation.y - this.pointerStart.y);
                    } else if (index == 0) {
                        double alpha = (ix - this.pointerStart.x) / (this.wayPoints.get((int)index).x - this.pointerStart.x);
                        y = this.pointerStart.y + alpha * (this.wayPoints.get((int)index).y - this.pointerStart.y);
                    } else if (index == this.wayPoints.size()) {
                        double alpha = (ix - this.wayPoints.get((int)(index - 1)).x) / (this.pointerLocation.x - this.wayPoints.get((int)(index - 1)).x);
                        y = this.wayPoints.get((int)(index - 1)).y + alpha * (this.pointerLocation.y - this.wayPoints.get((int)(index - 1)).y);
                    } else if (index > 0 && index < this.wayPoints.size()) {
                        double alpha = (ix - this.wayPoints.get((int)(index - 1)).x) / (this.wayPoints.get((int)index).x - this.wayPoints.get((int)(index - 1)).x);
                        y = this.wayPoints.get((int)(index - 1)).y + alpha * (this.wayPoints.get((int)index).y - this.wayPoints.get((int)(index - 1)).y);
                    } else {
                        return IDataSet.createRank1((int)0);
                    }
                    double ymin = y - (double)this.width;
                    double ymax = y + (double)this.width;
                    Datum dymin = yaxis.invTransform(ymin);
                    Datum dymax = yaxis.invTransform(ymax);
                    QDataSet ww = Ops.within((Object)yy, (Object)DatumRangeUtil.union((Datum)dymin, (Datum)dymax));
                    return Ops.where((QDataSet)ww);
                }
                throw new IllegalArgumentException("yy must be rank 1");
            }
            case 1: {
                DataSetBuilder dsb = new DataSetBuilder(1, 100);
                for (int j = 0; j < xx.length(); ++j) {
                    int index = -1;
                    double ix = xaxis.transform(xx.slice(j));
                    if (ix < this.pointerStart.x || ix > this.pointerLocation.x) continue;
                    for (int i = 0; i < this.wayPoints.size(); ++i) {
                        if (!(ix < this.wayPoints.get((int)i).x)) continue;
                        index = i;
                        break;
                    }
                    if (index == -1 && ix < this.pointerLocation.x) {
                        index = this.wayPoints.size();
                    }
                    if (yy.rank() == 0) {
                        yy = Ops.join(null, (QDataSet)yy);
                    }
                    if (yy.rank() == 1) {
                        double y;
                        double alpha;
                        if (index == 0 && this.wayPoints.isEmpty()) {
                            alpha = (ix - this.pointerStart.x) / (this.pointerLocation.x - this.pointerStart.x);
                            y = this.pointerStart.y + alpha * (this.pointerLocation.y - this.pointerStart.y);
                        } else if (index == 0) {
                            alpha = (ix - this.pointerStart.x) / (this.wayPoints.get((int)index).x - this.pointerStart.x);
                            y = this.pointerStart.y + alpha * (this.wayPoints.get((int)index).y - this.pointerStart.y);
                        } else if (index == this.wayPoints.size()) {
                            alpha = (ix - this.wayPoints.get((int)(index - 1)).x) / (this.pointerLocation.x - this.wayPoints.get((int)(index - 1)).x);
                            y = this.wayPoints.get((int)(index - 1)).y + alpha * (this.pointerLocation.y - this.wayPoints.get((int)(index - 1)).y);
                        } else if (index > 0 && index < this.wayPoints.size()) {
                            alpha = (ix - this.wayPoints.get((int)(index - 1)).x) / (this.wayPoints.get((int)index).x - this.wayPoints.get((int)(index - 1)).x);
                            y = this.wayPoints.get((int)(index - 1)).y + alpha * (this.wayPoints.get((int)index).y - this.wayPoints.get((int)(index - 1)).y);
                        } else {
                            return IDataSet.createRank1((int)0);
                        }
                        double ymin = y - (double)this.width;
                        double ymax = y + (double)this.width;
                        Datum dymin = yaxis.invTransform(ymin);
                        Datum dymax = yaxis.invTransform(ymax);
                        if (Ops.within((Object)yy.slice(j), (Object)DatumRangeUtil.union((Datum)dymin, (Datum)dymax)).value() == 0.0) continue;
                        dsb.nextRecord((double)j);
                        continue;
                    }
                    throw new IllegalArgumentException("yy must be rank 1");
                }
                return dsb.getDataSet();
            }
        }
        throw new IllegalArgumentException("xx must be rank 0");
    }

    public Rectangle getBoundingBox() {
        double ymin = this.pointerStart.y;
        double ymax = this.pointerStart.y;
        for (int i = 0; i < this.wayPoints.size(); ++i) {
            Point2D.Double d = this.wayPoints.get(i);
            ymin = Math.min(ymin, d.y);
            ymax = Math.max(ymax, d.y);
        }
        ymin = Math.min(ymin, this.pointerLocation.y);
        ymax = Math.min(ymax, this.pointerLocation.y);
        Rectangle result = new Rectangle((int)this.pointerStart.x, (int)(ymin - (double)this.width), (int)(this.pointerLocation.x - this.pointerStart.x), (int)(ymax - ymin + (double)(this.width * 2)));
        return result;
    }
}

