/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.ArrowDragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.MoveComponentMouseModule;
import org.das2.graph.AnchorPosition;
import org.das2.graph.AnchorType;
import org.das2.graph.Arrow;
import org.das2.graph.BorderType;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.FillStyle;
import org.das2.graph.GraphUtil;
import org.das2.graph.PlotSymbol;
import org.das2.util.ColorUtil;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.ImageUtil;

public class DasAnnotation
extends DasCanvasComponent {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.graph.annotation");
    private static final boolean DEBUG_GRAPHICS = System.getProperty("das2.graph.dasannotation.debuggraphics", "false").equals("true");
    String templateString;
    GrannyTextRenderer gtr;
    BufferedImage img;
    boolean boundsCalculated = false;
    private Map<String, GrannyTextRenderer.Painter> painters = new HashMap<String, GrannyTextRenderer.Painter>();
    private PointDescriptor pointAt;
    public static final String PROP_TEXT = "text";
    private String url = "";
    public static final String PROP_URL = "url";
    private String padding = "0.5em";
    public static final String PROP_PADDING = "padding";
    private double scale = 1.0;
    public static final String PROP_SCALE = "scale";
    float fontSize = 0.0f;
    public static final String PROP_FONT_SIZE = "fontSize";
    private BorderType borderType = BorderType.NONE;
    public static final String PROP_BORDERTYPE = "borderType";
    private AnchorPosition anchorPosition = AnchorPosition.NW;
    public static final String PROP_ANCHORPOSITION = "anchorPosition";
    private DasPlot plot;
    PropertyChangeListener plotListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            logger.finest("plot change, resizing");
            if (evt.getPropertyName().equals("paintingForPrint")) {
                logger.finest("plot change is trivial, ignoring");
            } else {
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        DasAnnotation.this.resize();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    SwingUtilities.invokeLater(run);
                }
            }
        }
    };
    private DatumRange xrange = DatumRange.newDatumRange((double)0.0, (double)10.0, (Units)Units.dimensionless);
    public static final String PROP_XRANGE = "xrange";
    private DatumRange yrange = DatumRange.newDatumRange((double)0.0, (double)10.0, (Units)Units.dimensionless);
    public static final String PROP_YRANGE = "yrange";
    private Datum pointAtX = Datum.create((int)0);
    public static final String PROP_POINTATX = "pointAtX";
    private Datum pointAtY = Datum.create((int)0);
    public static final String PROP_POINTATY = "pointAtY";
    private String referenceX = "";
    public static final String PROP_REFERENCEX = "referenceX";
    private String referenceY = "";
    public static final String PROP_REFERENCEY = "referenceY";
    private int rotate = 0;
    public static final String PROP_ROTATE = "rotate";
    public static final String PROP_GLOW = "glow";
    private boolean glow = false;
    private PlotSymbol symbol = DefaultPlotSymbol.NONE;
    public static final String PROP_SYMBOL = "symbol";
    private String pointAtOffset = "";
    public static final String PROP_POINTATOFFSET = "pointAtOffset";
    private boolean showArrow = false;
    public static final String PROP_SHOWARROW = "showArrow";
    private BorderType anchorBorderType = BorderType.NONE;
    public static final String PROP_ANCHORBORDERTYPE = "anchorBorderType";
    private Color anchorBackground = new Color(0, 0, 0, 0);
    public static final String PROP_ANCHORBACKGROUND = "anchorBackground";
    private AnchorType anchorType = AnchorType.CANVAS;
    public static final String PROP_ANCHORTYPE = "anchorType";
    private boolean splitAnchorType = false;
    public static final String PROP_SPLITANCHORTYPE = "splitAnchorType";
    private AnchorType verticalAnchorType = AnchorType.CANVAS;
    public static final String PROP_VERTICALANCHORTYPE = "verticalAnchorType";
    private Arrow.HeadStyle arrowStyle = Arrow.HeadStyle.DRAFTING;
    public static final String PROP_ARROWSTYLE = "arrowStyle";
    private String lineThickness = "1.5px";
    public static final String PROP_LINETHICKNESS = "lineThickness";
    private boolean overrideColors = false;
    public static final String PROP_OVERRIDECOLORS = "overrideColors";
    private Color textColor = new Color(0, 0, 0, 0);
    public static final String PROP_TEXTCOLOR = "textColor";
    private String anchorOffset = "";
    public static final String PROP_ANCHOROFFSET = "anchorOffset";

    public void addPainter(String id, GrannyTextRenderer.Painter p) {
        this.painters.put(id, p);
        for (Map.Entry<String, GrannyTextRenderer.Painter> ee : this.painters.entrySet()) {
            if (this.gtr == null) continue;
            this.gtr.addPainter(ee.getKey(), ee.getValue());
        }
    }

    public void removePainter(String id) {
        this.painters.remove(id);
    }

    public void clearPainters() {
        this.painters.clear();
    }

    public DasAnnotation(String string) {
        if (string.startsWith("http:")) {
            this.gtr = null;
            try {
                this.img = ImageIO.read(new URL(string));
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
                this.gtr = GraphUtil.newGrannyTextRenderer();
            }
        } else {
            this.gtr = GraphUtil.newGrannyTextRenderer();
            this.gtr.setString(this.getFont(), "");
        }
        this.templateString = string;
        AbstractAction removeMeAction = new AbstractAction("remove"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DasCanvas canvas = DasAnnotation.this.getCanvas();
                canvas.remove(DasAnnotation.this);
                canvas.revalidate();
            }
        };
        this.getDasMouseInputAdapter().addMenuItem(new JMenuItem(removeMeAction));
        MoveComponentMouseModule mm = new MoveComponentMouseModule(this){
            Point p0;

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                this.p0 = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                int dx = p.x - this.p0.x;
                int dy = p.y - this.p0.y;
                DasAnnotation.this.adjustAnchorOffset(dx, dy);
                DasAnnotation.this.resize();
                DasAnnotation.this.repaint();
            }
        };
        mm.setLabel("Move Annotation");
        mm.setDragRenderer(new MoveComponentMouseModule.MoveRenderer(this){

            @Override
            public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
                int dx = p2.x - p1.x;
                int dy = p2.y - p1.y;
                String s = DasAnnotation.this.calculateAnchorOffset(dx, dy);
                Rectangle bounds = DasAnnotation.this.getActiveRegion().getBounds();
                bounds.translate(p2.x - p1.x, p2.y - p1.y);
                Graphics2D g2 = (Graphics2D)g1.create();
                g2.setColor(Color.GRAY);
                g2.drawString(s, bounds.x, bounds.y);
                if (DasAnnotation.this.getBackground().getRed() > 128) {
                    g2.setColor(Color.LIGHT_GRAY);
                } else {
                    g2.setColor(Color.DARK_GRAY);
                }
                Line2D line = DasAnnotation.this.calculateAnchorLine(bounds, dx, dy);
                g2.draw(line);
                return super.renderDrag(g1, p1, p2);
            }
        });
        this.getDasMouseInputAdapter().setPrimaryModule(mm);
        MouseModule pointAtMouseModule = new MouseModule(this, new ArrowDragRenderer(), "Point At"){
            Point p0;

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (DasAnnotation.this.plot != null) {
                    this.p0 = e.getPoint();
                    this.p0 = SwingUtilities.convertPoint(DasAnnotation.this, this.p0, DasAnnotation.this.plot.getCanvas());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DasAnnotation.this.plot != null) {
                    Datum oldx = DasAnnotation.this.getPointAtX();
                    Datum oldy = DasAnnotation.this.getPointAtY();
                    Datum x = DasAnnotation.this.plot.getXAxis().invTransform(e.getX() + DasAnnotation.this.getX());
                    Datum y = DasAnnotation.this.plot.getYAxis().invTransform(e.getY() + DasAnnotation.this.getY());
                    if (e.isShiftDown()) {
                        String xs = DasAnnotation.this.getReferenceX().trim();
                        if (xs.length() > 0) {
                            DasAnnotation.this.setReferenceX(xs + ";" + x.toString());
                        } else {
                            DasAnnotation.this.setReferenceX(DasAnnotation.this.getPointAtX().toString() + ";" + x.toString());
                        }
                        String ys = DasAnnotation.this.getReferenceY().trim();
                        if (ys.length() > 0) {
                            DasAnnotation.this.setReferenceY(ys + ";" + y.toString());
                        } else {
                            DasAnnotation.this.setReferenceY(DasAnnotation.this.getPointAtY().toString() + ";" + y.toString());
                        }
                    } else {
                        DasAnnotation.this.setReferenceX("");
                        DasAnnotation.this.setReferenceY("");
                    }
                    DasAnnotation.this.setPointAtX(x);
                    DasAnnotation.this.setPointAtY(y);
                    DasAnnotation.this.resize();
                    DasAnnotation.this.setShowArrow(true);
                }
            }
        };
        this.getDasMouseInputAdapter().addMouseModule(pointAtMouseModule);
    }

    private void adjustDataRanges(int dx, int dy) {
    }

    private Line2D calculateAnchorLine(Rectangle bounds, int dx, int dy) {
        int rectY;
        int anchorY;
        int rectX;
        int anchorX;
        Rectangle anchor = this.getAnchorBounds();
        switch (this.anchorPosition) {
            case NW: 
            case SW: 
            case W: {
                anchorX = anchor.x;
                rectX = bounds.x;
                break;
            }
            case OutsideN: 
            case OutsideS: 
            case Center: 
            case N: 
            case S: {
                anchorX = anchor.x + anchor.width / 2;
                rectX = bounds.x + bounds.width / 2;
                break;
            }
            case OutsideE: {
                anchorX = anchor.x + anchor.width;
                rectX = bounds.x + bounds.width;
                break;
            }
            case OutsideW: {
                anchorX = anchor.x;
                rectX = bounds.x;
                break;
            }
            case NE: 
            case SE: 
            case E: 
            case OutsideNE: 
            case OutsideSE: {
                anchorX = anchor.x + anchor.width;
                rectX = bounds.x + bounds.width;
                break;
            }
            case OutsideNW: 
            case OutsideSW: {
                anchorX = anchor.x;
                rectX = bounds.x;
                break;
            }
            case OutsideNNW: 
            case OutsideSSW: {
                anchorX = anchor.x;
                rectX = bounds.x;
                break;
            }
            case OutsideNNE: 
            case OutsideSSE: {
                anchorX = anchor.x + anchor.width;
                rectX = bounds.x + bounds.width;
                break;
            }
            default: {
                anchorX = 0;
                rectX = bounds.x;
            }
        }
        switch (this.anchorPosition) {
            case NW: 
            case N: 
            case NE: {
                anchorY = anchor.y;
                rectY = bounds.y;
                break;
            }
            case OutsideN: {
                anchorY = anchor.y;
                rectY = bounds.y;
                break;
            }
            case OutsideS: 
            case OutsideSSW: 
            case OutsideSSE: {
                anchorY = anchor.y + anchor.height;
                rectY = bounds.y + bounds.height;
                break;
            }
            case OutsideE: 
            case OutsideW: {
                anchorY = anchor.y + anchor.height / 2;
                rectY = bounds.y + bounds.height / 2;
                break;
            }
            case OutsideNE: 
            case OutsideNW: {
                anchorY = anchor.y;
                rectY = bounds.y;
                break;
            }
            case SW: 
            case S: 
            case SE: 
            case OutsideSE: 
            case OutsideSW: {
                anchorY = anchor.y + anchor.height;
                rectY = bounds.y + bounds.height;
                break;
            }
            case OutsideNNW: 
            case OutsideNNE: {
                anchorY = anchor.y;
                rectY = bounds.y;
                break;
            }
            case W: 
            case Center: 
            case E: {
                anchorY = anchor.y + anchor.height / 2;
                rectY = bounds.y + bounds.height / 2;
                break;
            }
            default: {
                anchorY = 0;
                rectY = bounds.y;
            }
        }
        return new Line2D.Double(anchorX, anchorY, rectX, rectY);
    }

    private String calculateAnchorOffset(int dx, int dy) {
        if (this.anchorPosition != AnchorPosition.NW && this.anchorPosition != AnchorPosition.N) {
            if (this.anchorPosition == AnchorPosition.OutsideN) {
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.NE) {
                dx = -dx;
            } else if (this.anchorPosition != AnchorPosition.OutsideNE) {
                if (this.anchorPosition == AnchorPosition.OutsideSE) {
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.OutsideNW) {
                    dx = -dx;
                } else if (this.anchorPosition == AnchorPosition.OutsideSW) {
                    dx = -dx;
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.SW) {
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.SE) {
                    dx = -dx;
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.OutsideNNW) {
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.OutsideNNE) {
                    dx = -dx;
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.OutsideSSE) {
                    dx = -dx;
                } else if (this.anchorPosition == AnchorPosition.Center) {
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.W) {
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.E) {
                    dx = -dx;
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.OutsideW) {
                    dx = -dx;
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.OutsideE) {
                    dy = -dy;
                } else if (this.anchorPosition == AnchorPosition.S) {
                    dy = -dy;
                }
            }
        }
        String offset = this.getAnchorOffset();
        double em = this.getEmSize();
        if (offset.trim().length() == 0) {
            offset = String.format(Locale.US, "%.2fem,%.2fem", (double)dx / em, (double)dy / em);
            return offset;
        }
        try {
            String[] ss = offset.split(",", -2);
            double[] dd = DasDevicePosition.parseLayoutStr(ss[0]);
            dd[1] = dd[1] + (double)dx / em;
            ss[0] = DasDevicePosition.formatLayoutStr(dd);
            dd = DasDevicePosition.parseLayoutStr(ss[1]);
            dd[1] = dd[1] + (double)dy / em;
            ss[1] = DasDevicePosition.formatLayoutStr(dd);
            offset = ss[0] + "," + ss[1];
            return offset;
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
            return offset;
        }
    }

    private void adjustAnchorOffset(int dx, int dy) {
        String newOffset = this.calculateAnchorOffset(dx, dy);
        this.setAnchorOffset(newOffset);
    }

    public void setText(String string) {
        String oldValue = this.templateString;
        this.templateString = string;
        if (this.getGraphics() != null) {
            if (this.url.length() == 0) {
                this.gtr = GraphUtil.newGrannyTextRenderer();
                this.gtr.setString(this.getGraphics(), this.getString());
                for (Map.Entry<String, GrannyTextRenderer.Painter> ee : this.painters.entrySet()) {
                    this.gtr.addPainter(ee.getKey(), ee.getValue());
                }
                this.gtr.setGlow(this.isGlow());
            }
            this.resize();
        }
        this.firePropertyChange(PROP_TEXT, oldValue, string);
        this.repaint();
    }

    public String getText() {
        return this.templateString;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        String oldUrl = this.url;
        if (url.length() == 0) {
            this.url = url;
            this.setText(this.getText());
        } else {
            try {
                this.img = ImageIO.read(new URL(url));
                this.gtr = null;
            }
            catch (IOException ex) {
                this.gtr = GraphUtil.newGrannyTextRenderer();
                this.gtr.setString(this.getGraphics(), url);
            }
        }
        this.url = url;
        this.firePropertyChange(PROP_URL, oldUrl, url);
    }

    public String getPadding() {
        return this.padding;
    }

    public void setPadding(String padding) {
        String oldPadding = this.padding;
        this.padding = padding;
        this.firePropertyChange(PROP_PADDING, oldPadding, padding);
        this.resize();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        double oldScale = this.scale;
        this.scale = scale;
        this.firePropertyChange(PROP_SCALE, oldScale, scale);
        this.resize();
    }

    @Override
    public void resize() {
        Font f = this.getFont();
        if (f != null) {
            super.resize();
            Font thefont = f;
            if (this.fontSize > 0.0f) {
                thefont = f.deriveFont(this.fontSize);
            }
            if (this.gtr != null) {
                this.gtr.setString(thefont, this.getString());
            }
            Rectangle r = this.calcBounds();
            this.setBounds(r);
        }
    }

    @Override
    public Shape getActiveRegion() {
        Rectangle r = this.getAnnotationBubbleBounds();
        return r;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        if (this.getActiveRegion().contains(x, y)) {
            return true;
        }
        return this.pointAt != null && this.pointAt.getPoint().distance(x, y) < 5.0;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.acceptContext(x + this.getX(), y + this.getY());
    }

    private Rectangle calcBoundForPoint(Rectangle r, Datum pointAtX, Datum pointAtY) {
        double heady;
        double headx;
        try {
            headx = (int)this.plot.getXAxis().transform(pointAtX);
        }
        catch (InconvertibleUnitsException ex) {
            headx = (int)this.plot.getXAxis().transform(pointAtX.doubleValue(pointAtX.getUnits()), this.plot.getXAxis().getUnits());
        }
        try {
            heady = (int)this.plot.getYAxis().transform(pointAtY);
        }
        catch (InconvertibleUnitsException ex) {
            heady = (int)this.plot.getYAxis().transform(pointAtY.doubleValue(pointAtY.getUnits()), this.plot.getYAxis().getUnits());
        }
        float s = this.fontSize;
        r.add(headx - (double)s, heady - (double)s);
        r.add(headx + (double)s, heady + (double)s);
        return r;
    }

    private Rectangle calcBounds() {
        int vmax;
        int vmin;
        int hmax;
        int hmin;
        logger.entering("DasAnnotation", "calcBounds");
        Rectangle r = (Rectangle)this.getActiveRegion();
        if (this.pointAt != null) {
            Point head = this.pointAt.getPoint();
            r.add(head);
        }
        if (this.anchorBorderType != BorderType.NONE) {
            Rectangle anchorRect = this.getAnchorBounds();
            r.add(anchorRect);
        }
        if (this.showArrow && this.plot != null) {
            r = this.calcBoundForPoint(r, this.pointAtX, this.pointAtY);
        }
        if (this.referenceX.trim().length() > 0 || this.referenceY.trim().length() > 0) {
            String[] xx = this.referenceX.split("[;,]", -2);
            String[] yy = this.referenceY.split("[;,]", -2);
            int n = Math.max(xx.length, yy.length);
            if (xx.length > 1 && yy.length > 1 && xx.length != yy.length) {
                logger.warning("x and y reference count is different");
            } else {
                for (int i = 0; i < n; ++i) {
                    try {
                        String xs = xx.length == 1 ? xx[0] : xx[i];
                        Datum xd = this.xrange.getUnits().parse(xs);
                        String ys = yy.length == 1 ? yy[0] : yy[i];
                        Datum yd = this.yrange.getUnits().parse(ys);
                        r = this.calcBoundForPoint(r, xd, yd);
                        continue;
                    }
                    catch (ParseException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        int s = Math.max(this.getFont().getSize() / 5, 3);
        r = new Rectangle(r.x - s, r.y - s, r.width + s * 2 + 1, r.height + s * 2 + 1);
        r.add(r.x + r.width + 1, r.y + r.height + 1);
        if (this.anchorType == AnchorType.CANVAS || this.plot == null) {
            hmin = 0;
            hmax = this.getCanvas().getWidth();
        } else if (this.anchorPosition == AnchorPosition.OutsideE || this.anchorPosition == AnchorPosition.OutsideN || this.anchorPosition == AnchorPosition.OutsideS || this.anchorPosition == AnchorPosition.OutsideW || this.anchorPosition == AnchorPosition.OutsideNE || this.anchorPosition == AnchorPosition.OutsideNNE || this.anchorPosition == AnchorPosition.OutsideNNW || this.anchorPosition == AnchorPosition.OutsideNW || this.anchorPosition == AnchorPosition.OutsideSE || this.anchorPosition == AnchorPosition.OutsideSSE || this.anchorPosition == AnchorPosition.OutsideSSW || this.anchorPosition == AnchorPosition.OutsideSW) {
            hmin = 0;
            hmax = this.getCanvas().getWidth();
        } else {
            hmin = this.plot.getColumn().getDMinimum();
            hmax = this.plot.getColumn().getDMaximum();
        }
        if (this.splitAnchorType) {
            if (this.verticalAnchorType == AnchorType.CANVAS || this.plot == null) {
                vmin = 0;
                vmax = this.getCanvas().getHeight();
            } else {
                vmin = this.plot.getRow().getDMinimum();
                vmax = this.plot.getRow().getDMaximum();
            }
        } else if (this.anchorType == AnchorType.CANVAS || this.plot == null) {
            vmin = 0;
            vmax = this.getCanvas().getHeight();
        } else if (this.anchorPosition == AnchorPosition.OutsideE || this.anchorPosition == AnchorPosition.OutsideN || this.anchorPosition == AnchorPosition.OutsideS || this.anchorPosition == AnchorPosition.OutsideW || this.anchorPosition == AnchorPosition.OutsideNE || this.anchorPosition == AnchorPosition.OutsideNNE || this.anchorPosition == AnchorPosition.OutsideNNW || this.anchorPosition == AnchorPosition.OutsideNW || this.anchorPosition == AnchorPosition.OutsideSE || this.anchorPosition == AnchorPosition.OutsideSSE || this.anchorPosition == AnchorPosition.OutsideSSW || this.anchorPosition == AnchorPosition.OutsideSW) {
            vmin = 0;
            vmax = this.getCanvas().getHeight();
        } else {
            vmin = this.plot.getRow().getDMinimum();
            vmax = this.plot.getRow().getDMaximum();
        }
        Rectangle clip = new Rectangle(hmin, vmin, hmax - hmin, vmax - vmin);
        r = r.intersection(clip);
        this.boundsCalculated = true;
        logger.exiting("DasAnnotation", "calcBounds", r);
        return r;
    }

    @Override
    public void paintComponent(Graphics g1) {
        Rectangle r;
        Color fore;
        Graphics2D g = (Graphics2D)g1.create();
        if (DEBUG_GRAPHICS) {
            Rectangle r2 = this.getBounds();
            Graphics2D g_ = (Graphics2D)g.create();
            g_.translate(-this.getX(), -this.getY());
            g_.setClip(null);
            g_.setColor(ColorUtil.STEEL_BLUE);
            g_.drawRect(r2.x, r2.y, r2.width, r2.height);
            g_.dispose();
        }
        double em2 = GraphUtil.parseLayoutLength(this.lineThickness, 0.0, g1.getFont().getSize());
        int rounds = g1.getFont().getSize();
        Stroke stroke0 = g.getStroke();
        g.setStroke(new BasicStroke((float)em2, 1, 1));
        g.translate(-this.getX(), -this.getY());
        Rectangle clip = this.calcBounds();
        g.setClip(clip);
        Color ltextColor = fore = this.getCanvas().getForeground();
        Color back = this.getCanvas().getBackground();
        if (this.isOverrideColors()) {
            fore = this.getForeground();
            ltextColor = this.textColor;
            back = this.getBackground();
        }
        if (this.fontSize > 0.0f) {
            g.setFont(this.getFont().deriveFont(this.fontSize));
        }
        int em = (int)GraphUtil.parseLayoutLength(this.padding, clip.width, this.getEmSize());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.gtr != null) {
            this.gtr.setString((Graphics)g, this.getString());
        }
        try {
            r = this.getAnnotationBubbleBounds();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return;
        }
        if ((this.anchorPosition == AnchorPosition.N || this.anchorPosition == AnchorPosition.OutsideN || this.anchorPosition == AnchorPosition.Center || this.anchorPosition == AnchorPosition.S) && this.gtr != null) {
            this.gtr.setAlignment(0.5f);
        }
        if (this.showArrow) {
            this.paintOneArrow(g, r, Math.max(12.0, em2 * 8.0), stroke0, fore, this.pointAtX, this.pointAtY);
        }
        if (this.referenceX.length() > 0 || this.referenceY.length() > 0) {
            String[] xx = this.referenceX.split("[;,]", -2);
            String[] yy = this.referenceY.split("[;,]", -2);
            int n = Math.max(xx.length, yy.length);
            if (xx.length > 1 && yy.length > 1 && xx.length != yy.length) {
                logger.warning("x and y reference count is different");
            } else {
                for (int i = 0; i < n; ++i) {
                    try {
                        String xs = xx.length == 1 ? xx[0] : xx[i];
                        Datum xd = this.xrange.getUnits().parse(xs);
                        String ys = yy.length == 1 ? yy[0] : yy[i];
                        Datum yd = this.yrange.getUnits().parse(ys);
                        this.paintOneArrow(g, r, Math.max(12.0, em2 * 8.0), stroke0, fore, xd, yd);
                        continue;
                    }
                    catch (ParseException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        g.setColor(back);
        if (this.anchorBackground.getAlpha() > 0) {
            Color c0 = g.getColor();
            g.setColor(this.anchorBackground);
            Rectangle anchorRect = this.getAnchorBounds();
            if (this.anchorBorderType == BorderType.RECTANGLE || this.anchorBorderType == BorderType.NONE) {
                if (anchorRect.width == 0) {
                    g.fill(new Line2D.Double(anchorRect.x, anchorRect.y, anchorRect.x, anchorRect.y + anchorRect.height));
                } else if (anchorRect.height == 0) {
                    g.fill(new Line2D.Double(anchorRect.x, anchorRect.y, anchorRect.x + anchorRect.width, anchorRect.y));
                } else {
                    g.fill(anchorRect);
                }
            } else if (this.anchorBorderType == BorderType.ROUNDED_RECTANGLE) {
                g.fillRoundRect(anchorRect.x, anchorRect.y, anchorRect.width, anchorRect.height, rounds, rounds);
            }
            g.setColor(c0);
        }
        if (this.gtr == null || !this.getString().equals("")) {
            Rectangle bb = this.getAnnotationBubbleBoundsNoRotation();
            if (this.rotate % 90 != 0) {
                Area area = new Area(g.getClip());
                area.add(new Area(DasAnnotation.getRotatedBoundingBox(bb, (double)this.rotate * Math.PI / 180.0)));
                g.setClip(area);
            }
            Graphics2D gtext = this.getAnnotationGraphics(g);
            if (this.borderType == BorderType.RECTANGLE || this.borderType == BorderType.NONE) {
                gtext.fill(new Rectangle(0, 0, bb.width, bb.height));
            } else if (this.borderType == BorderType.ROUNDED_RECTANGLE) {
                gtext.fillRoundRect(0, 0, bb.width, bb.height, rounds, rounds);
            }
            g.setColor(ltextColor);
            int rot = this.rotate % 360;
            if (rot <= -180) {
                rot += 360;
            }
            if (rot > 180) {
                rot -= 360;
            }
            try {
                double ascent = this.gtr == null ? (double)g.getFontMetrics().getAscent() : this.gtr.getAscent();
            }
            catch (IllegalArgumentException ex) {
                double ascent = g.getFontMetrics().getAscent();
            }
            gtext.setColor(ltextColor);
            if (this.gtr != null) {
                try {
                    this.gtr.draw((Graphics)gtext, (float)em, (float)em + (float)this.gtr.getAscent());
                }
                catch (IllegalArgumentException ex) {
                    this.gtr.setString(gtext.getFont(), this.getText());
                    this.gtr.draw((Graphics)gtext, (float)em, (float)em + (float)this.gtr.getAscent());
                }
            } else {
                BufferedImage localImage = this.img;
                if (localImage == null) {
                    try {
                        localImage = ImageIO.read(DasAnnotation.class.getResource("/images/grey100.png"));
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                        return;
                    }
                }
                if (this.scale != 1.0) {
                    int newWidth = (int)((double)localImage.getWidth() * this.scale);
                    int newHeight = (int)((double)localImage.getHeight() * this.scale);
                    boolean printing = this.getCanvas().isPrintingThread();
                    if (printing) {
                        gtext.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        gtext.drawImage(localImage, r.x + em, r.y + em, newWidth, newHeight, this);
                    } else {
                        BufferedImage resized = ImageUtil.getScaledInstance((BufferedImage)localImage, (int)((int)Math.sqrt(newWidth * newWidth + newHeight * newHeight)));
                        gtext.drawImage((Image)resized, r.x + em, r.y + em, this);
                    }
                } else {
                    g.drawImage((Image)localImage, r.x + em, r.y + em, this);
                }
            }
            gtext.setColor(fore);
            if (this.borderType != BorderType.NONE) {
                if (this.borderType == BorderType.RECTANGLE) {
                    gtext.draw(new Rectangle(0, 0, bb.width, bb.height));
                } else if (this.borderType == BorderType.ROUNDED_RECTANGLE) {
                    gtext.drawRoundRect(0, 0, bb.width, bb.height, rounds, rounds);
                } else if (this.borderType == BorderType.UNDERSCORE) {
                    gtext.drawLine(em, bb.height, bb.x + bb.width - (int)em2, bb.height);
                }
            }
            if (this.anchorBorderType != BorderType.NONE) {
                Rectangle anchorRect = this.getAnchorBounds();
                if (this.anchorBorderType == BorderType.RECTANGLE) {
                    if (anchorRect.width == 0) {
                        g.draw(new Line2D.Double(anchorRect.x, anchorRect.y, anchorRect.x, anchorRect.y + anchorRect.height));
                    } else if (anchorRect.height == 0) {
                        g.draw(new Line2D.Double(anchorRect.x, anchorRect.y, anchorRect.x + anchorRect.width, anchorRect.y));
                    } else {
                        g.draw(anchorRect);
                    }
                } else if (this.anchorBorderType == BorderType.ROUNDED_RECTANGLE) {
                    g.drawRoundRect(anchorRect.x, anchorRect.y, anchorRect.width, anchorRect.height, rounds, rounds);
                } else if (this.anchorBorderType == BorderType.UNDERSCORE) {
                    g.draw(anchorRect);
                }
            }
        }
        g.dispose();
        this.getDasMouseInputAdapter().paint(g1);
    }

    private void paintOneArrow(Graphics2D g, Rectangle r, double em2, Stroke stroke0, Color fore, Datum x, Datum y) {
        int headx = 0;
        int heady = 0;
        if (this.plot != null) {
            try {
                headx = (int)this.plot.getXAxis().transform(x);
            }
            catch (InconvertibleUnitsException ex) {
                headx = (int)this.plot.getXAxis().transform(x.doubleValue(x.getUnits()), this.plot.getXAxis().getUnits());
            }
            try {
                heady = (int)this.plot.getYAxis().transform(y);
            }
            catch (InconvertibleUnitsException ex) {
                heady = (int)this.plot.getYAxis().transform(y.doubleValue(y.getUnits()), this.plot.getYAxis().getUnits());
            }
        }
        Point head = new Point(headx, heady);
        Graphics2D g2 = (Graphics2D)g.create();
        Point2D.Double tail2d = new Point2D.Double(r.x + r.width / 2, r.y + r.height / 2);
        Point2D.Double head2d = new Point2D.Double(head.x, head.y);
        Rectangle2D.Double rect2d = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
        Point2D p2d = GraphUtil.lineRectangleIntersection(tail2d, head2d, rect2d);
        Point p = p2d == null ? head : new Point((int)p2d.getX(), (int)p2d.getY());
        Point head0 = new Point(head);
        if (this.showArrow) {
            if (this.pointAtOffset.length() > 0) {
                Line2D.Double line = new Line2D.Double(head.x, head.y, p.x, p.y);
                double lengthPixels = GraphUtil.parseLayoutLength(this.pointAtOffset, ((Line2D)line).getP1().distance(((Line2D)line).getP2()), this.getEmSize());
                Line2D newLine = GraphUtil.shortenLine(line, lengthPixels, 0.0);
                head = new Point((int)newLine.getP1().getX(), (int)newLine.getP1().getY());
            }
            Color glowColor = this.getCanvas().getBackground();
            if (this.gtr.isGlow()) {
                float linethink = (float)(em2 / 12.0);
                if (linethink < 2.0f) {
                    linethink = 2.0f;
                }
                g2.setStroke(new BasicStroke(linethink, 1, 1));
                g2.setColor(glowColor);
                Arrow.paintArrow(g2, head, p, em2, this.arrowStyle);
            } else {
                g2.setStroke(new BasicStroke((float)(em2 / 4.0), 1, 1));
                g2.setColor(new Color(glowColor.getRed(), glowColor.getGreen(), glowColor.getBlue(), 128));
                Arrow.paintArrow(g2, head, p, em2, this.arrowStyle);
            }
            g2.setStroke(stroke0);
            g2.setColor(fore);
            Arrow.paintArrow(g2, head, p, em2, this.arrowStyle);
        }
        if (DefaultPlotSymbol.NONE != this.symbol) {
            this.symbol.draw(g2, head0.x, head0.y, this.fontSize / 3.0f, FillStyle.STYLE_SOLID);
        }
        g2.dispose();
    }

    private Rectangle getAnchorBounds() {
        Rectangle anchorRect = new Rectangle();
        if (this.anchorType == AnchorType.DATA) {
            if (this.plot != null && this.xrange != null && this.yrange != null) {
                this.anchorXToData(anchorRect);
                this.anchorYToData(anchorRect);
                if (this.splitAnchorType && this.verticalAnchorType == AnchorType.CANVAS) {
                    anchorRect.y = this.getRow().getDMinimum();
                    anchorRect.height = this.getRow().getHeight();
                }
            } else {
                anchorRect = DasDevicePosition.toRectangle(this.getRow(), this.getColumn());
                if (this.splitAnchorType && this.verticalAnchorType == AnchorType.DATA) {
                    this.anchorYToData(anchorRect);
                }
            }
        } else if (this.anchorType == AnchorType.PLOT && this.plot != null) {
            anchorRect = DasDevicePosition.toRectangle(this.plot.getRow(), this.plot.getColumn());
            if (this.splitAnchorType && this.verticalAnchorType == AnchorType.DATA) {
                this.anchorYToData(anchorRect);
            }
        } else {
            anchorRect = DasDevicePosition.toRectangle(this.getRow(), this.getColumn());
            if (this.splitAnchorType && this.verticalAnchorType == AnchorType.DATA) {
                this.anchorYToData(anchorRect);
            }
        }
        return anchorRect;
    }

    private void anchorXToData(Rectangle anchorRect) {
        try {
            anchorRect.x = (int)this.plot.getXAxis().transform(this.xrange.min());
            int x1 = (int)this.plot.getXAxis().transform(this.xrange.max());
            if (x1 < anchorRect.x) {
                int t = anchorRect.x;
                anchorRect.x = x1;
                x1 = t;
            }
            anchorRect.width = x1 - anchorRect.x;
        }
        catch (InconvertibleUnitsException ex) {
            if (this.xrange.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)this.plot.getXAxis().getUnits())) {
                anchorRect.x = (int)this.plot.getXAxis().transform(this.xrange.min().value(), this.plot.getXAxis().getUnits());
                int x1 = (int)this.plot.getXAxis().transform(this.xrange.max().value(), this.plot.getXAxis().getUnits());
                if (x1 < anchorRect.x) {
                    int t = anchorRect.x;
                    anchorRect.x = x1;
                    x1 = t;
                }
                anchorRect.width = x1 - anchorRect.x;
            }
            if (this.xrange.min().getUnits() == Units.dimensionless && this.xrange.min().value() == 0.0) {
                logger.fine("unable to convert x units for annotation, transitional state");
            } else {
                logger.info("unable to convert x units for annotation");
            }
            anchorRect.x = this.getColumn().getDMinimum();
            anchorRect.width = this.getColumn().getWidth();
        }
    }

    private void anchorYToData(Rectangle anchorRect) {
        try {
            anchorRect.y = (int)this.plot.getYAxis().transform(this.yrange.min());
            int y1 = (int)this.plot.getYAxis().transform(this.yrange.max());
            if (y1 < anchorRect.y) {
                int t = anchorRect.y;
                anchorRect.y = y1;
                y1 = t;
            }
            anchorRect.height = y1 - anchorRect.y;
        }
        catch (InconvertibleUnitsException ex) {
            if (this.yrange.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)this.plot.getYAxis().getUnits())) {
                anchorRect.y = (int)this.plot.getYAxis().transform(this.yrange.min().value(), this.plot.getYAxis().getUnits());
                int y1 = (int)this.plot.getYAxis().transform(this.yrange.max().value(), this.plot.getYAxis().getUnits());
                if (y1 < anchorRect.y) {
                    int t = anchorRect.y;
                    anchorRect.y = y1;
                    y1 = t;
                }
                anchorRect.height = y1 - anchorRect.y;
            }
            if (this.yrange.min().getUnits() == Units.dimensionless && this.yrange.min().value() == 0.0) {
                logger.fine("unable to convert y units for annotation, transitional state");
            } else {
                logger.info("unable to convert y units for annotation");
            }
            anchorRect.y = this.getRow().getDMinimum();
            anchorRect.height = this.getRow().getHeight();
        }
    }

    private Rectangle getAnnotationBubbleBounds() {
        int rot;
        Rectangle r = this.getAnnotationBubbleBoundsNoRotation();
        if (this.rotate != 0 && ((rot = this.rotate % 360) == 90 || rot == 270 || rot == -90)) {
            Rectangle nr = new Rectangle();
            switch (this.anchorPosition) {
                case Center: {
                    nr.x = r.x + r.width / 2 - r.height / 2;
                    nr.y = r.y + r.height / 2 - r.width / 2;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case NE: {
                    nr.x = r.x + r.width - r.height;
                    nr.y = r.y;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case NW: {
                    nr.x = r.x;
                    nr.y = r.y;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case SW: {
                    nr.x = r.x;
                    nr.y = r.y + r.height - r.width;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case SE: {
                    nr.x = r.x + r.width - r.height;
                    nr.y = r.y + r.height - r.width;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case N: {
                    nr.x = r.x + r.width / 2 - r.height / 2;
                    nr.y = r.y;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case E: {
                    nr.x = r.x + r.width - r.height;
                    nr.y = r.y + r.height / 2 - r.width / 2;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case W: {
                    nr.x = r.x;
                    nr.y = r.y + r.height / 2 - r.width / 2;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case S: {
                    nr.x = r.x + r.width / 2 - r.height / 2;
                    nr.y = r.y + r.height - r.width;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideN: {
                    nr.x = r.x + r.width / 2 - r.height / 2;
                    nr.y = r.y + r.height - r.width;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideS: {
                    nr.x = r.x + r.width / 2 - r.height / 2;
                    nr.y = r.y;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideE: {
                    nr.x = r.x;
                    nr.y = r.y + r.height / 2 - r.width / 2;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideW: {
                    nr.x = r.x + r.width - r.height;
                    nr.y = r.y + r.height / 2 - r.width / 2;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideNNE: {
                    nr.x = r.x + r.width - r.height;
                    nr.y = r.y + r.height - r.width;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideNNW: {
                    nr.x = r.x;
                    nr.y = r.y + r.height - r.width;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideSSE: {
                    nr.x = r.x + r.width - r.height;
                    nr.y = r.y;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideSSW: {
                    nr.x = r.x;
                    nr.y = r.y;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideNE: {
                    nr.x = r.x;
                    nr.y = r.y;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideNW: {
                    nr.x = r.x + r.width - r.height;
                    nr.y = r.y;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideSE: {
                    nr.x = r.x;
                    nr.y = r.y + r.height - r.width;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                case OutsideSW: {
                    nr.x = r.x + r.width - r.height;
                    nr.y = r.y + r.height - r.width;
                    nr.width = r.height;
                    nr.height = r.width;
                    break;
                }
                default: {
                    logger.info("this rotation is not supported");
                }
            }
            r = nr;
        }
        return r;
    }

    public static Rectangle getRotatedBoundingBox(Rectangle rect, double angle) {
        double cx = rect.getCenterX();
        double cy = rect.getCenterY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        double hw = w / 2.0;
        double hh = h / 2.0;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double[][] corners = new double[][]{{-hw, -hh}, {hw, -hh}, {hw, hh}, {-hw, hh}};
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (double[] c : corners) {
            double x = c[0];
            double y = c[1];
            double xr = x * cos - y * sin;
            double yr = x * sin + y * cos;
            double X = cx + xr;
            double Y = cy + yr;
            if (X < minX) {
                minX = X;
            }
            if (X > maxX) {
                maxX = X;
            }
            if (Y < minY) {
                minY = Y;
            }
            if (!(Y > maxY)) continue;
            maxY = Y;
        }
        int newX = (int)Math.floor(minX);
        int newY = (int)Math.floor(minY);
        int newW = (int)Math.ceil(maxX - minX);
        int newH = (int)Math.ceil(maxY - minY);
        return new Rectangle(newX, newY, newW, newH);
    }

    private Graphics2D getAnnotationGraphics(Graphics2D g) {
        g = (Graphics2D)g.create();
        AffineTransform tr = g.getTransform();
        Rectangle r = this.getAnnotationBubbleBoundsNoRotation();
        Rectangle rrot = DasAnnotation.getRotatedBoundingBox(r, (double)(-this.rotate) * Math.PI / 180.0);
        tr.translate(r.x, r.y);
        if (this.rotate != 0) {
            int rot = this.rotate % 360;
            if (rot <= -180) {
                rot += 360;
            }
            if (rot > 180) {
                rot -= 360;
            }
            if (rot == 90 || rot == -90) {
                Rectangle nr = new Rectangle();
                switch (this.anchorPosition) {
                    case Center: {
                        tr.translate(r.width / 2 - r.height / 2, r.height / 2 - r.width / 2);
                        break;
                    }
                    case NE: {
                        tr.translate(r.width - rrot.width, 0.0);
                        break;
                    }
                    case NW: {
                        tr.translate(0.0, 0.0);
                        break;
                    }
                    case SW: {
                        tr.translate(0.0, r.height - rrot.height);
                        break;
                    }
                    case SE: {
                        tr.translate(r.width - rrot.width, r.height - rrot.height);
                        break;
                    }
                    case N: {
                        tr.translate(r.width / 2 - rrot.width / 2, 0.0);
                        break;
                    }
                    case E: {
                        tr.translate(r.width - rrot.width, r.height / 2 - rrot.height / 2);
                        break;
                    }
                    case W: {
                        tr.translate(0.0, r.height / 2 - rrot.height / 2);
                        break;
                    }
                    case S: {
                        tr.translate(r.width / 2 - rrot.width / 2, r.height - rrot.height);
                        break;
                    }
                    case OutsideN: {
                        tr.translate(r.width / 2 - rrot.width / 2, r.height - rrot.height);
                        break;
                    }
                    case OutsideS: {
                        tr.translate(r.width / 2 - rrot.width / 2, 0.0);
                        break;
                    }
                    case OutsideE: {
                        tr.translate(0.0, r.height / 2 - rrot.height / 2);
                        break;
                    }
                    case OutsideW: {
                        tr.translate(r.width - rrot.width, r.height / 2 - rrot.height / 2);
                        break;
                    }
                    case OutsideNNE: {
                        tr.translate(r.width - rrot.width, r.height - rrot.height);
                        break;
                    }
                    case OutsideNNW: {
                        tr.translate(0.0, r.height - rrot.height);
                        break;
                    }
                    case OutsideSSE: {
                        tr.translate(r.width - rrot.width, 0.0);
                        break;
                    }
                    case OutsideSSW: {
                        tr.translate(0.0, 0.0);
                        break;
                    }
                    case OutsideNE: {
                        tr.translate(0.0, 0.0);
                        break;
                    }
                    case OutsideNW: {
                        tr.translate(r.width - rrot.width, 0.0);
                        break;
                    }
                    case OutsideSE: {
                        tr.translate(0.0, r.height - rrot.height);
                        break;
                    }
                    case OutsideSW: {
                        tr.translate(r.width - rrot.width, r.height - rrot.height);
                        break;
                    }
                    default: {
                        logger.info("this rotation is not supported");
                    }
                }
                if (rot == -90) {
                    tr.rotate((double)(-rot) * Math.PI / 180.0, r.height / 2, r.height / 2);
                } else if (rot == 90) {
                    tr.rotate((double)(-rot) * Math.PI / 180.0, r.height / 2, r.width - r.height / 2);
                    tr.translate(0.0, r.width - r.height);
                }
                r = nr;
            } else if (rot == 180) {
                tr.rotate((double)(-rot) * Math.PI / 180.0, r.width / 2, r.height / 2);
            } else {
                tr.rotate((double)(-rot) * Math.PI / 180.0, r.width / 2, r.height / 2);
            }
        }
        g.setTransform(tr);
        return g;
    }

    private Rectangle getAnnotationBubbleBoundsNoRotation() {
        int yoffset;
        int xoffset;
        Rectangle r;
        Rectangle anchor;
        block31: {
            anchor = this.getAnchorBounds();
            DasCanvas canvas = this.getCanvas();
            if (this.gtr == null) {
                r = this.img == null ? new Rectangle(0, 0, (int)(100.0 * this.scale), (int)(100.0 * this.scale)) : new Rectangle(0, 0, (int)((double)this.img.getWidth() * this.scale), (int)((double)this.img.getHeight() * this.scale));
            } else {
                try {
                    r = this.gtr.getBounds();
                }
                catch (IllegalArgumentException ex) {
                    int em1 = (int)this.getEmSize();
                    r = new Rectangle(0, 0, em1, em1);
                }
            }
            int em = (int)this.getEmSize();
            xoffset = 0;
            yoffset = 0;
            if (this.anchorOffset.length() > 0) {
                String[] ss = this.anchorOffset.split(",");
                if (ss.length == 2) {
                    try {
                        if (canvas == null) {
                            xoffset = 0;
                            yoffset = 0;
                            break block31;
                        }
                        double[] dd = DasDevicePosition.parseLayoutStr(ss[0]);
                        xoffset = (int)((double)canvas.getWidth() * dd[0] + (double)em * dd[1] + dd[2]);
                        dd = DasDevicePosition.parseLayoutStr(ss[1]);
                        yoffset = (int)((double)canvas.getHeight() * dd[0] + (double)em * dd[1] + dd[2]);
                    }
                    catch (NumberFormatException | ParseException ex) {
                        logger.log(Level.WARNING, null, ex);
                        xoffset = 0;
                        yoffset = 0;
                    }
                } else {
                    logger.log(Level.WARNING, "anchorOffset is misformatted: {0}", this.anchorOffset);
                }
            }
        }
        int ipadding = (int)GraphUtil.parseLayoutLength(this.padding, r.width, this.getEmSize());
        r.width += ipadding * 2;
        r.height += ipadding * 2;
        switch (this.anchorPosition) {
            case NW: 
            case SW: 
            case W: {
                r.x = anchor.x + xoffset;
                break;
            }
            case OutsideN: 
            case OutsideS: 
            case Center: 
            case N: 
            case S: {
                r.x = anchor.x + anchor.width / 2 - (int)(r.getWidth() / 2.0) + xoffset;
                break;
            }
            case OutsideE: {
                r.x = anchor.x + anchor.width + xoffset;
                break;
            }
            case OutsideW: {
                r.x = anchor.x - r.width - xoffset;
                break;
            }
            case NE: 
            case SE: 
            case E: {
                r.x = anchor.x + anchor.width - r.width - xoffset;
                break;
            }
            case OutsideNE: 
            case OutsideSE: {
                r.x = anchor.x + anchor.width + xoffset;
                break;
            }
            case OutsideNW: 
            case OutsideSW: {
                r.x = anchor.x - r.width - xoffset;
                break;
            }
            case OutsideNNW: 
            case OutsideSSW: {
                r.x = anchor.x + xoffset;
                break;
            }
            case OutsideNNE: 
            case OutsideSSE: {
                r.x = anchor.x + anchor.width - r.width - xoffset;
                break;
            }
        }
        switch (this.anchorPosition) {
            case NW: 
            case N: 
            case NE: {
                r.y = anchor.y + yoffset;
                break;
            }
            case OutsideN: {
                r.y = anchor.y - (int)r.getHeight() - yoffset;
                break;
            }
            case OutsideS: 
            case OutsideSSW: 
            case OutsideSSE: {
                r.y = anchor.y + anchor.height + yoffset;
                break;
            }
            case OutsideE: 
            case OutsideW: {
                r.y = anchor.y + anchor.height / 2 - (int)(r.getHeight() / 2.0) - yoffset;
                break;
            }
            case OutsideNE: 
            case OutsideNW: {
                r.y = anchor.y + yoffset;
                break;
            }
            case SW: 
            case S: 
            case SE: 
            case OutsideSE: 
            case OutsideSW: {
                r.y = anchor.y + anchor.height - r.height - yoffset;
                break;
            }
            case OutsideNNW: 
            case OutsideNNE: {
                r.y = anchor.y - (int)r.getHeight() - yoffset;
                break;
            }
            case W: 
            case Center: 
            case E: {
                r.y = anchor.y + anchor.height / 2 - (int)(r.getHeight() / 2.0) - yoffset;
                break;
            }
        }
        return r;
    }

    public void setPointAt(PointDescriptor p) {
        this.pointAt = p;
        this.repaint();
    }

    public PointDescriptor getPointAt() {
        return this.pointAt;
    }

    private String getString() {
        String s = this.templateString;
        if (this.templateString != null && this.templateString.contains("%") && this.pointAt != null) {
            s = this.templateString.replace("%p", this.pointAt.getLabel());
        }
        return s;
    }

    @Override
    protected void installComponent() {
        super.installComponent();
        if (this.gtr != null) {
            this.gtr.setString(this.getFont(), this.getString());
        }
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        float oldsize = this.fontSize;
        this.fontSize = fontSize;
        Font f = this.getFont();
        if (f == null) {
            if (this.getCanvas() == null) {
                return;
            }
            f = this.getCanvas().getBaseFont();
        }
        if (fontSize > 0.0f) {
            f = f.deriveFont(fontSize);
        }
        Font newFont = f;
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setFont(newFont);
        if (this.gtr != null) {
            this.gtr.setString(g, this.getString());
        }
        this.resize();
        this.repaint();
        this.firePropertyChange(PROP_FONT_SIZE, oldsize, fontSize);
    }

    public BorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(BorderType newborderType) {
        BorderType oldborderType = this.borderType;
        this.borderType = newborderType;
        this.repaint();
        this.firePropertyChange(PROP_BORDERTYPE, (Object)oldborderType, (Object)newborderType);
    }

    public AnchorPosition getAnchorPosition() {
        return this.anchorPosition;
    }

    public void setAnchorPosition(AnchorPosition anchorPosition) {
        AnchorPosition oldAnchorPosition = this.anchorPosition;
        this.anchorPosition = anchorPosition;
        this.firePropertyChange(PROP_ANCHORPOSITION, oldAnchorPosition, anchorPosition);
    }

    public void setPlot(DasPlot p) {
        if (this.plot != null) {
            this.plot.getXAxis().removePropertyChangeListener(this.plotListener);
            this.plot.getYAxis().removePropertyChangeListener(this.plotListener);
        }
        if (p != null) {
            p.getXAxis().addPropertyChangeListener(this.plotListener);
            p.getYAxis().addPropertyChangeListener(this.plotListener);
        }
        this.plot = p;
    }

    public DatumRange getXrange() {
        return this.xrange;
    }

    public void setXrange(DatumRange xrange) {
        DatumRange oldXrange = this.xrange;
        this.xrange = xrange;
        this.resize();
        this.repaint();
        this.firePropertyChange(PROP_XRANGE, oldXrange, xrange);
    }

    public DatumRange getYrange() {
        return this.yrange;
    }

    public void setYrange(DatumRange yrange) {
        DatumRange oldYrange = this.yrange;
        this.yrange = yrange;
        this.resize();
        this.repaint();
        this.firePropertyChange(PROP_YRANGE, oldYrange, yrange);
    }

    public Datum getPointAtX() {
        return this.pointAtX;
    }

    public void setPointAtX(Datum pointAtX) {
        Datum oldPointAtX = this.pointAtX;
        this.pointAtX = pointAtX;
        this.firePropertyChange(PROP_POINTATX, oldPointAtX, pointAtX);
    }

    public Datum getPointAtY() {
        return this.pointAtY;
    }

    public void setPointAtY(Datum pointAtY) {
        Datum oldPointAtY = this.pointAtY;
        this.pointAtY = pointAtY;
        this.firePropertyChange(PROP_POINTATY, oldPointAtY, pointAtY);
    }

    public String getReferenceX() {
        return this.referenceX;
    }

    public void setReferenceX(String referenceX) {
        String oldReferenceX = this.referenceX;
        this.referenceX = referenceX;
        if (!oldReferenceX.equals(this.referenceX)) {
            if (this.boundsCalculated) {
                this.boundsCalculated = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DasAnnotation.this.resize();
                    }
                });
            }
            this.repaint();
        }
        this.firePropertyChange(PROP_REFERENCEX, oldReferenceX, referenceX);
    }

    public String getReferenceY() {
        return this.referenceY;
    }

    public void setReferenceY(String referenceY) {
        String oldReferenceY = this.referenceY;
        this.referenceY = referenceY;
        if (!oldReferenceY.equals(this.referenceY)) {
            if (this.boundsCalculated) {
                this.boundsCalculated = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DasAnnotation.this.resize();
                    }
                });
            }
            this.repaint();
        }
        this.firePropertyChange(PROP_REFERENCEY, oldReferenceY, referenceY);
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int rotate) {
        int oldRotate = this.rotate;
        this.rotate = rotate;
        if (this.boundsCalculated) {
            this.boundsCalculated = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DasAnnotation.this.resize();
                }
            });
        }
        this.repaint();
        this.firePropertyChange(PROP_ROTATE, oldRotate, rotate);
    }

    public boolean isGlow() {
        return this.glow;
    }

    public void setGlow(boolean glow) {
        boolean oldGlow = glow;
        this.glow = glow;
        if (this.gtr != null) {
            this.gtr.setGlow(glow);
            if (oldGlow != glow) {
                this.repaint();
            }
        }
        this.firePropertyChange(PROP_GLOW, oldGlow, glow);
    }

    public PlotSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(PlotSymbol symbol) {
        PlotSymbol oldSymbol = this.symbol;
        this.symbol = symbol;
        this.firePropertyChange(PROP_SYMBOL, oldSymbol, symbol);
    }

    public String getPointAtOffset() {
        return this.pointAtOffset;
    }

    public void setPointAtOffset(String pointAtOffset) {
        String oldPointAtOffset = this.pointAtOffset;
        this.pointAtOffset = pointAtOffset;
        this.firePropertyChange(PROP_POINTATOFFSET, oldPointAtOffset, pointAtOffset);
    }

    public boolean isShowArrow() {
        return this.showArrow;
    }

    public void setShowArrow(boolean showArrow) {
        boolean oldShowArrow = this.showArrow;
        this.showArrow = showArrow;
        this.firePropertyChange(PROP_SHOWARROW, oldShowArrow, showArrow);
    }

    public BorderType getAnchorBorderType() {
        return this.anchorBorderType;
    }

    public void setAnchorBorderType(BorderType anchorBorderType) {
        BorderType oldAnchorBorderType = this.anchorBorderType;
        this.anchorBorderType = anchorBorderType;
        this.repaint();
        this.firePropertyChange(PROP_ANCHORBORDERTYPE, (Object)oldAnchorBorderType, (Object)anchorBorderType);
    }

    public Color getAnchorBackground() {
        return this.anchorBackground;
    }

    public void setAnchorBackground(Color anchorBackground) {
        Color oldAnchorBackground = this.anchorBackground;
        this.anchorBackground = anchorBackground;
        this.repaint();
        this.firePropertyChange(PROP_ANCHORBACKGROUND, oldAnchorBackground, anchorBackground);
    }

    public AnchorType getAnchorType() {
        return this.anchorType;
    }

    public void setAnchorType(AnchorType anchorType) {
        AnchorType oldAnchorType = this.anchorType;
        this.anchorType = anchorType;
        this.firePropertyChange(PROP_ANCHORTYPE, (Object)oldAnchorType, (Object)anchorType);
    }

    public boolean isSplitAnchorType() {
        return this.splitAnchorType;
    }

    public void setSplitAnchorType(boolean splitAnchorType) {
        boolean oldSplitAnchorType = this.splitAnchorType;
        this.splitAnchorType = splitAnchorType;
        this.firePropertyChange(PROP_SPLITANCHORTYPE, oldSplitAnchorType, splitAnchorType);
    }

    public AnchorType getVerticalAnchorType() {
        return this.verticalAnchorType;
    }

    public void setVerticalAnchorType(AnchorType verticalAnchorType) {
        AnchorType oldVerticalAnchorType = this.verticalAnchorType;
        this.verticalAnchorType = verticalAnchorType;
        this.repaint();
        this.firePropertyChange(PROP_VERTICALANCHORTYPE, (Object)oldVerticalAnchorType, (Object)verticalAnchorType);
    }

    public Arrow.HeadStyle getArrowStyle() {
        return this.arrowStyle;
    }

    public void setArrowStyle(Arrow.HeadStyle newarrowStyle) {
        Arrow.HeadStyle oldarrowStyle = this.arrowStyle;
        this.arrowStyle = newarrowStyle;
        this.repaint();
        this.firePropertyChange(PROP_ARROWSTYLE, (Object)oldarrowStyle, (Object)newarrowStyle);
    }

    public String getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(String lineThickness) {
        String oldLineThickness = this.lineThickness;
        this.lineThickness = lineThickness;
        this.repaint();
        this.firePropertyChange(PROP_LINETHICKNESS, oldLineThickness, lineThickness);
    }

    public boolean isOverrideColors() {
        return this.overrideColors;
    }

    public void setOverrideColors(boolean overrideColors) {
        boolean oldOverrideColors = this.overrideColors;
        this.overrideColors = overrideColors;
        this.firePropertyChange(PROP_OVERRIDECOLORS, oldOverrideColors, overrideColors);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        Color oldTextColor = this.textColor;
        this.textColor = textColor;
        this.repaint();
        this.firePropertyChange(PROP_TEXTCOLOR, oldTextColor, textColor);
    }

    public String getAnchorOffset() {
        return this.anchorOffset;
    }

    public void setAnchorOffset(String anchorOffset) {
        String oldAnchorOffset = this.anchorOffset;
        this.anchorOffset = anchorOffset;
        this.firePropertyChange(PROP_ANCHOROFFSET, oldAnchorOffset, anchorOffset);
        this.resize();
    }

    public static interface PointDescriptor {
        public Point getPoint();

        public String getLabel();
    }

    public static class DatumPairPointDescriptor
    implements PointDescriptor {
        DasPlot p;
        Datum x;
        Datum y;

        public DatumPairPointDescriptor(DasPlot p, Datum x, Datum y) {
            this.x = x;
            this.y = y;
            this.p = p;
        }

        @Override
        public Point getPoint() {
            int ix = (int)this.p.getXAxis().transform(this.x);
            int iy = (int)this.p.getYAxis().transform(this.y);
            return new Point(ix, iy);
        }

        @Override
        public String getLabel() {
            return "" + this.x + "," + this.y;
        }
    }
}

