/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Formatter;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasAxis;

public final class DataGeneralPathBuilder {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.graph.renderer.path");
    private final GeneralPath gp;
    private int pointCount = 0;
    private final DasAxis xaxis;
    private final DasAxis yaxis;
    private final Units xunits;
    private final Units yunits;
    private static final Object PEN_UP = "penup";
    private static final Object PEN_DOWN = "pendown";
    private Object pen = PEN_UP;
    private Datum pendingx = null;
    private Datum pendingy = null;
    private double lastx = -1.7976931348623157E308;
    private double lasty = -1.7976931348623157E308;
    private double lastIX = -1.7976931348623157E308;
    private double lastIY = -1.7976931348623157E308;
    private double penPositionX = -1.7976931348623157E308;
    private double penPositionY = -1.7976931348623157E308;
    private double cadence = 0.0;
    private double cadenceExact = 1.0E38;
    private double moduloy = 0.0;
    private double modulox = 0.0;
    private boolean logStep = false;
    private boolean histogramFillFlag;
    private static final double CADENCE_FILL = 1.0E38;
    private boolean histogramMode = false;
    public static final String PROP_HISTOGRAM_MODE = "histogramMode";
    private String name = "";

    public DataGeneralPathBuilder(DasAxis xaxis, DasAxis yaxis) {
        this.gp = new GeneralPath();
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.xunits = xaxis.getUnits();
        this.yunits = yaxis.getUnits();
        logger.fine("-----");
    }

    public void setCadence(Datum sw) {
        if (sw == null) {
            this.cadence = 0.0;
            this.cadenceExact = 1.0E38;
            this.logStep = false;
        } else if (UnitsUtil.isRatiometric((Units)sw.getUnits())) {
            this.cadence = sw.multiply(1.2).doubleValue(Units.logERatio);
            this.cadenceExact = sw.doubleValue(Units.logERatio);
            this.logStep = true;
        } else {
            try {
                this.cadence = sw.multiply(1.2).doubleValue(this.xunits.getOffsetUnits());
                this.cadenceExact = sw.doubleValue(this.xunits.getOffsetUnits());
            }
            catch (InconvertibleUnitsException ex) {
                this.cadence = sw.multiply(1.2).doubleValue(sw.getUnits());
            }
        }
    }

    public void setModuloY(Datum mody) {
        this.moduloy = mody.doubleValue(this.yaxis.getUnits());
    }

    public double getCadenceDouble() {
        return this.cadenceExact;
    }

    public boolean isHistogramMode() {
        return this.histogramMode;
    }

    public void setHistogramMode(boolean histogramMode) {
        this.histogramMode = histogramMode;
    }

    public Units getXUnits() {
        return this.xunits;
    }

    public Units getYUnits() {
        return this.yunits;
    }

    public boolean isCadenceRatiometric() {
        return this.logStep;
    }

    public void addDataPoint(boolean valid, Datum x, Datum y) {
        double xx = x.doubleValue(this.xunits);
        double yy = y.doubleValue(this.yunits);
        this.addDataPoint(valid, xx, yy);
    }

    public void setHistogramFillFlag() {
        this.histogramFillFlag = true;
    }

    public void setName(String name) {
        this.name = name;
        if (name.length() > 0) {
            System.err.println("# ------");
            System.err.println(String.format("from java.awt.geom import GeneralPath", new Object[0]));
            System.err.println(String.format("%s=GeneralPath()", name));
        }
    }

    private void lineTo(double x, double y) {
        if (this.name.length() > 0) {
            System.err.println(new Formatter().format(Locale.US, "%s.lineTo(%.2f,%.2f)", this.name, x, y).toString());
        }
        this.gp.lineTo(x, y);
        this.penPositionX = x;
        this.penPositionY = y;
    }

    private void moveTo(double x, double y) {
        if (this.name.length() > 0) {
            System.err.println(new Formatter().format(Locale.US, "%s.moveTo(%.2f,%.2f)", this.name, x, y).toString());
        }
        this.gp.moveTo(x, y);
        this.penPositionX = x;
        this.penPositionY = y;
    }

    public void addBreak() {
        if (this.pen == PEN_DOWN) {
            if (this.histogramMode) {
                if (this.pendingx != null) {
                    double iPendingX = this.xaxis.transform(this.pendingx);
                    this.lineTo(iPendingX, this.yaxis.transform(this.pendingy));
                }
            } else if (this.pendingx != null) {
                this.lineTo(this.xaxis.transform(this.pendingx), this.yaxis.transform(this.pendingy));
            }
        }
        this.pen = PEN_UP;
        this.pendingx = null;
        this.pendingy = null;
    }

    public void addDataPoint(boolean valid, double x, double y) {
        ++this.pointCount;
        if (this.pointCount == 1) {
            logger.fine("pathBuilder got first point");
        }
        if (this.lastx > x) {
            logger.log(Level.FINE, "data step back: {0} -> {1}", new Object[]{this.xunits.createDatum(this.lastx), this.xunits.createDatum(x)});
        }
        if (this.cadence > 0.0 && this.pen == PEN_DOWN) {
            double step;
            double d = step = this.logStep ? Math.log(x / this.lastx) : x - this.lastx;
            if (step > this.cadence) {
                if (this.pendingx != null) {
                    if (this.histogramMode) {
                        double xtemp = this.pendingx.doubleValue(this.xunits);
                        if (this.cadenceExact != 1.0E38) {
                            double iulx = this.logStep ? this.xaxis.transform(xtemp * (1.0 + this.cadenceExact / 2.0), this.xunits) : this.xaxis.transform(xtemp + this.cadenceExact / 2.0, this.xunits);
                            double iy = this.yaxis.transform(this.pendingy);
                            this.lineTo(iulx, iy);
                        } else {
                            this.lineTo(this.xaxis.transform(this.pendingx), this.yaxis.transform(this.pendingy));
                        }
                    } else {
                        this.lineTo(this.xaxis.transform(this.pendingx), this.yaxis.transform(this.pendingy));
                    }
                }
                this.pen = PEN_UP;
            }
            if (this.moduloy != 0.0 && Math.abs(y - this.lasty) > this.moduloy / 2.0) {
                this.pen = PEN_UP;
            }
        }
        if (this.pen == PEN_UP) {
            if (valid) {
                if (this.histogramMode) {
                    double iulx = this.cadenceExact != 1.0E38 ? (this.logStep ? this.xaxis.transform(x / (1.0 + this.cadenceExact / 2.0), this.xunits) : this.xaxis.transform(x - this.cadenceExact / 2.0, this.xunits)) : this.xaxis.transform(x, this.xunits);
                    double iy = this.yaxis.transform(y, this.yunits);
                    this.moveTo(iulx, iy);
                    this.lastIX = this.xaxis.transform(x, this.xunits);
                    this.lastIY = iy;
                } else {
                    this.moveTo(this.xaxis.transform(x, this.xunits), this.yaxis.transform(y, this.yunits));
                }
                this.pen = PEN_DOWN;
                this.pendingx = this.xunits.createDatum(x);
                this.pendingy = this.yunits.createDatum(y);
            }
        } else if (this.pen == PEN_DOWN) {
            double ix;
            if (valid) {
                if (this.histogramMode) {
                    double iy = this.yaxis.transform(y, this.yunits);
                    if (this.histogramFillFlag) {
                        this.lineTo(this.penPositionX, iy);
                        this.histogramFillFlag = false;
                        this.lastIX = this.xaxis.transform(x, this.xunits);
                    } else {
                        ix = this.xaxis.transform(x, this.xunits);
                        this.lineTo((this.lastIX + ix) / 2.0, this.lastIY);
                        if (this.lastIX > -1.7976931348623157E308) {
                            this.lineTo((this.lastIX + ix) / 2.0, iy);
                        }
                        this.lastIX = ix;
                    }
                    this.lastIY = iy;
                    this.pendingx = this.xunits.createDatum(x);
                    this.pendingy = this.yunits.createDatum(y);
                } else {
                    this.lineTo(this.xaxis.transform(x, this.xunits), this.yaxis.transform(y, this.yunits));
                    this.pendingx = null;
                    this.pendingy = null;
                }
            } else if (!valid) {
                if (this.histogramMode) {
                    if (this.pendingx != null) {
                        double iPendingX = this.xaxis.transform(this.pendingx);
                        ix = this.xaxis.transform(x, this.xunits);
                        this.lineTo((iPendingX + ix) / 2.0, this.yaxis.transform(this.pendingy));
                    }
                } else if (this.pendingx != null) {
                    this.lineTo(this.xaxis.transform(this.pendingx), this.yaxis.transform(this.pendingy));
                }
                this.pen = PEN_UP;
                this.pendingx = null;
                this.pendingy = null;
            }
        }
        this.lastx = x;
        this.lasty = y;
    }

    public GeneralPath getGeneralPath() {
        if (this.name.length() > 0) {
            System.err.println("from org.das2.graph import Painter");
            System.err.println("class MyPainter( Painter ) :");
            System.err.println("    def paint( self, g ) :");
            System.err.println("        g.draw( fillgp )");
            System.err.println("dom.canvases[0].controller.dasCanvas.addTopDecorator( MyPainter() )");
            System.err.println("");
        }
        return this.gp;
    }

    public Point2D getPenPosition() {
        return new Point2D.Double(this.penPositionX, this.penPositionY);
    }

    public void finishThought() {
        if (this.lastIX > -1.7976931348623157E308) {
            this.penPositionX = this.cadenceExact != 1.0E38 ? (this.logStep ? this.xaxis.transform(this.lastx * (1.0 + this.cadenceExact / 2.0), this.xunits) : this.xaxis.transform(this.lastx + this.cadenceExact / 2.0, this.xunits)) : this.xaxis.transform(this.lastx, this.xunits);
            this.penPositionY = this.lastIY;
            this.lineTo(this.penPositionX, this.penPositionY);
            this.pendingx = null;
            this.pendingy = null;
        }
    }

    public void insertLineTo(double x, double y) {
        this.lineTo(x, y);
        this.penPositionX = x;
        this.penPositionY = y;
    }

    public PathIterator getPathIterator() {
        return this.gp.getPathIterator(null);
    }
}

