/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.graph.FillStyle;
import org.das2.graph.PathIterable;
import org.das2.graph.PlotSymbol;

public class DefaultPlotSymbol
implements Enumeration,
Displayable,
PlotSymbol,
PathIterable {
    GeneralPath path;
    String label;
    Icon icon;
    final boolean empty;
    public static final DefaultPlotSymbol CIRCLES = new DefaultPlotSymbol(new Ellipse2D.Double(-0.5, -0.5, 1.0, 1.0), "circles");
    public static final DefaultPlotSymbol TRIANGLES;
    public static final DefaultPlotSymbol TRIANGLES_NORTH;
    public static final DefaultPlotSymbol TRIANGLES_SOUTH;
    public static final DefaultPlotSymbol TRIANGLES_WEST;
    public static final DefaultPlotSymbol TRIANGLES_EAST;
    public static final DefaultPlotSymbol CROSS;
    public static final DefaultPlotSymbol EX;
    public static final DefaultPlotSymbol STAR;
    public static final DefaultPlotSymbol DIAMOND;
    public static final DefaultPlotSymbol BOX;
    public static final DefaultPlotSymbol NONE;

    public DefaultPlotSymbol(Shape p, String label) {
        this.path = new GeneralPath(p);
        this.label = label;
        this.empty = new Area(this.path).isEmpty();
    }

    @Override
    public void draw(Graphics2D g, double x, double y, float size, FillStyle style) {
        AffineTransform at = AffineTransform.getScaleInstance(size, size);
        at.translate(x / (double)size, y / (double)size);
        if (style == FillStyle.STYLE_FILL || style == FillStyle.STYLE_SOLID) {
            g.fill(this.path.createTransformedShape(at));
            if (this.empty) {
                g.draw(this.path.createTransformedShape(at));
            }
        } else if (style == FillStyle.STYLE_OUTLINE) {
            Color back = g.getBackground();
            Color fore = g.getColor();
            g.setColor(back);
            g.fill(this.path.createTransformedShape(at));
            g.setColor(fore);
            g.draw(this.path.createTransformedShape(at));
        } else if (style == FillStyle.STYLE_DRAW || style == FillStyle.STYLE_NONE) {
            g.draw(this.path.createTransformedShape(at));
        }
    }

    @Override
    public PathIterator pathIterator(AffineTransform at) {
        return this.path.getPathIterator(at);
    }

    @Override
    public void drawListIcon(Graphics2D g, int x, int y) {
        ImageIcon i = (ImageIcon)this.getListIcon();
        g.drawImage(i.getImage(), x, y, null);
    }

    @Override
    public Icon getListIcon() {
        if (this.icon == null) {
            BufferedImage i = new BufferedImage(10, 10, 1);
            Graphics2D g = (Graphics2D)((Image)i).getGraphics();
            g.setBackground(Color.white);
            g.setRenderingHints(DasProperties.getRenderingHints());
            g.setColor(Color.white);
            g.fillRect(0, 0, 10, 10);
            g.setColor(Color.black);
            this.draw(g, 5.0, 5.0, 6.0f, FillStyle.STYLE_OUTLINE);
            this.icon = new ImageIcon(i);
        }
        return this.icon;
    }

    @Override
    public String getListLabel() {
        return this.label;
    }

    @Override
    public String toString() {
        return this.label;
    }

    static {
        GeneralPath triangle = new GeneralPath();
        float size = 0.7f;
        triangle.moveTo(0.0f, -size);
        triangle.lineTo(size, size);
        triangle.lineTo(-size, size);
        triangle.lineTo(0.0f, -size);
        TRIANGLES = new DefaultPlotSymbol(triangle, "triangles");
        triangle = new GeneralPath();
        size = 0.7f;
        triangle.moveTo(0.0f, -size);
        triangle.lineTo(size, size);
        triangle.lineTo(-size, size);
        triangle.lineTo(0.0f, -size);
        TRIANGLES_NORTH = new DefaultPlotSymbol(triangle, "trianglesNorth");
        triangle = new GeneralPath();
        size = 0.7f;
        triangle.moveTo(0.0f, -size);
        triangle.lineTo(size, size);
        triangle.lineTo(-size, size);
        triangle.lineTo(0.0f, -size);
        triangle.transform(AffineTransform.getRotateInstance(Math.PI));
        TRIANGLES_SOUTH = new DefaultPlotSymbol(triangle, "trianglesSouth");
        triangle = new GeneralPath();
        size = 0.7f;
        triangle.moveTo(0.0f, -size);
        triangle.lineTo(size, size);
        triangle.lineTo(-size, size);
        triangle.lineTo(0.0f, -size);
        triangle.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
        TRIANGLES_WEST = new DefaultPlotSymbol(triangle, "trianglesWest");
        triangle = new GeneralPath();
        size = 0.7f;
        triangle.moveTo(0.0f, -size);
        triangle.lineTo(size, size);
        triangle.lineTo(-size, size);
        triangle.lineTo(0.0f, -size);
        triangle.transform(AffineTransform.getRotateInstance(1.5707963267948966));
        TRIANGLES_EAST = new DefaultPlotSymbol(triangle, "trianglesEast");
        GeneralPath path = new GeneralPath();
        size = 0.6f;
        path.moveTo(0.0f, -size);
        path.lineTo(0.0f, size);
        path.moveTo(-size, 0.0f);
        path.lineTo(size, 0.0f);
        CROSS = new DefaultPlotSymbol(path, "crosses");
        path = new GeneralPath();
        size = 0.4f;
        path.moveTo(-size, -size);
        path.lineTo(size, size);
        path.moveTo(-size, size);
        path.lineTo(size, -size);
        EX = new DefaultPlotSymbol(path, "exes");
        path = new GeneralPath();
        for (int i = 0; i < 11; ++i) {
            double radius = i % 2 == 0 ? 0.8 : 0.4;
            float x = (float)(radius * Math.sin(Math.PI * (double)i * 36.0 / 180.0));
            float y = (float)(radius * -1.0 * Math.cos(Math.PI * (double)i * 36.0 / 180.0));
            if (i == 0) {
                path.moveTo(x, y);
                continue;
            }
            path.lineTo(x, y);
        }
        STAR = new DefaultPlotSymbol(path, "stars");
        path = new GeneralPath();
        float radius = 0.6f;
        float[] x = new float[]{0.0f, 1.0f, 0.0f, -1.0f, 0.0f};
        float[] y = new float[]{1.0f, 0.0f, -1.0f, 0.0f, 1.0f};
        for (int i = 0; i < x.length; ++i) {
            if (i == 0) {
                path.moveTo(x[i] * radius, y[i] * radius);
                continue;
            }
            path.lineTo(x[i] * radius, y[i] * radius);
        }
        DIAMOND = new DefaultPlotSymbol(path, "diamonds");
        BOX = new DefaultPlotSymbol(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0), "boxes");
        NONE = new DefaultPlotSymbol(new GeneralPath(), "none");
    }
}

