/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.LabelDragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.graph.SpectrogramRenderer;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.TagGenDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.system.DasLogger;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.LoggerManager;

public class EventsRenderer
extends Renderer {
    public static final String PROP_COLOR = "color";
    private boolean useOnlyEventsMap = false;
    private static Logger logger = LoggerManager.getLogger((String)"das2.graphics.renderer.events");
    int[] eventMap;
    private Shape selectionArea;
    public static final TextSpecifier DEFAULT_TEXT_SPECIFIER = new TextSpecifier(){

        @Override
        public String getText(DatumRange dr, Datum d) {
            Datum sy = DatumUtil.asOrderOneUnits((Datum)dr.width());
            if (dr.width().value() == 0.0) {
                if (d.toString().equals(dr.min().toString())) {
                    return d.toString();
                }
                return String.format("%s", d);
            }
            String ssy = sy.toString().trim();
            return String.format("%s (%s)!c%s", dr, ssy, d);
        }
    };
    private MouseModule mouseModule = null;
    private QDataSet cds = null;
    private int renderTimeLimitMs = 3000;
    private boolean useColor = false;
    private Color color = new Color(100, 100, 100);
    private PsymConnector lineStyle = PsymConnector.SOLID;
    public static final String PROP_LINESTYLE = "lineStyle";
    private String lineThick = "";
    public static final String PROP_LINETHICK = "lineThick";
    private boolean opaque = false;
    public static final String PROP_OPAQUE = "opaque";
    protected boolean showLabels = false;
    public static final String PROP_SHOWLABELS = "showLabels";
    private String mode = "";
    public static final String PROP_MODE = "mode";
    protected boolean orbitMode = false;
    public static final String PROP_ORBITMODE = "orbitMode";
    private boolean ganttMode = false;
    public static final String PROP_GANTTMODE = "ganttMode";
    private int rotateLabel = 0;
    public static final String PROP_ROTATELABEL = "rotateLabel";
    protected String fontSize = "1em";
    public static final String PROP_FONTSIZE = "fontSize";
    public static final String PROP_COLOR_SPECIFIER = "colorSpecifier";
    private ColorSpecifier colorSpecifier = null;
    private TextSpecifier textSpecifier = DEFAULT_TEXT_SPECIFIER;

    public static boolean acceptsData(QDataSet ds) {
        return ds.rank() == 2 && Schemes.isEventsList((QDataSet)ds) || ds.rank() == 1 || ds.rank() == 0;
    }

    public static QDataSet doAutorange(QDataSet ds) {
        QDataSet xrange;
        QDataSet xmaxs;
        QDataSet xmins;
        DDataSet yrange = DDataSet.createRank1((int)2);
        yrange.putValue(0, 0.0);
        yrange.putValue(1, 10.0);
        if (ds.rank() == 1 && ds.property("DEPEND_0") == null) {
            if (Schemes.isDatumRange((QDataSet)ds) || Schemes.isCanonicalEvent((QDataSet)ds)) {
                xmins = Ops.reform((QDataSet)ds.slice(0), (int[])new int[]{1});
                xmaxs = Ops.reform((QDataSet)ds.slice(1), (int[])new int[]{1});
            } else {
                xmins = ds;
                xmaxs = ds;
            }
        } else if (ds.rank() == 1 && ds.property("DEPEND_0") != null) {
            xmaxs = xmins = (QDataSet)ds.property("DEPEND_0");
        } else if (ds.rank() == 0) {
            xmaxs = xmins = Ops.join(null, (QDataSet)ds);
        } else {
            xmins = SemanticOps.xtagsDataSet((QDataSet)ds);
            xmaxs = ds.length(0) > 1 ? DataSetOps.unbundle((QDataSet)ds, (int)1) : xmins;
        }
        Units u0 = SemanticOps.getUnits((QDataSet)xmins);
        Units u1 = SemanticOps.getUnits((QDataSet)xmaxs);
        if (xmins.length() == 0) {
            xrange = DDataSet.wrap((double[])new double[]{0.0, 1.0}, (Units)u0);
        } else {
            DDataSet dx;
            if (UnitsUtil.isIntervalOrRatioMeasurement((Units)u1)) {
                xrange = Ops.extent((QDataSet)xmins);
                if (!u1.isConvertibleTo(u0) && u1.isConvertibleTo(u0.getOffsetUnits())) {
                    xmaxs = Ops.add((QDataSet)xmins, (QDataSet)xmaxs);
                    xrange = Ops.extent((QDataSet)xmaxs, (QDataSet)xrange);
                } else {
                    xrange = Ops.extent((QDataSet)xmaxs, (QDataSet)xrange);
                }
            } else {
                xrange = DDataSet.createRank1((int)2);
                ((DDataSet)xrange).putValue(0, 0.0);
                ((DDataSet)xrange).putValue(1, 10.0);
            }
            if (xrange.value(0) < xrange.value(1)) {
                xrange = Ops.rescaleRangeLogLin((QDataSet)xrange, (double)-0.1, (double)1.1);
            } else if (UnitsUtil.isTimeLocation((Units)u0)) {
                dx = DDataSet.wrap((double[])new double[]{-0.5, 0.5}, (Units)Units.hours);
                xrange = Ops.add((QDataSet)xrange, (QDataSet)dx);
            } else {
                dx = DDataSet.wrap((double[])new double[]{-1.0, 1.0}, (Units)u0.getOffsetUnits());
                xrange = Ops.add((QDataSet)xrange, (QDataSet)dx);
            }
        }
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join((QDataSet)yrange);
        return bds;
    }

    Shape selectionArea() {
        return this.selectionArea == null ? SelectionUtil.NULL : this.selectionArea;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        if (this.selectionArea != null) {
            return this.selectionArea.contains(x, y);
        }
        return false;
    }

    @Override
    protected void installRenderer() {
        MouseModule mm = this.getMouseModule();
        DasPlot parent = this.getParent();
        parent.getDasMouseInputAdapter().addMouseModule(mm);
        parent.getDasMouseInputAdapter().setPrimaryModule(mm);
        super.installRenderer();
    }

    @Override
    protected void uninstallRenderer() {
        MouseModule mm = this.getMouseModule();
        DasPlot parent = this.getParent();
        parent.getDasMouseInputAdapter().removeMouseModule(mm);
        super.uninstallRenderer();
    }

    private MouseModule getMouseModule() {
        if (this.mouseModule == null) {
            DasPlot parent = this.getParent();
            this.mouseModule = new MouseModule(parent, new EventLabelDragRenderer(parent), "Event Lookup");
        }
        return this.mouseModule;
    }

    private QDataSet coalesce(QDataSet vds) {
        QDataSet bds = (QDataSet)vds.property("BUNDLE_1");
        DataSetBuilder build = new DataSetBuilder(2, 100, 4);
        DDataSet v = DDataSet.createRank1((int)4);
        QDataSet dep0 = DataSetOps.unbundle((QDataSet)vds, (int)0);
        double tlim = 1.0E-31;
        RankZeroDataSet cad = DataSetUtil.guessCadenceNew((QDataSet)dep0, null);
        if (cad != null) {
            tlim = cad.value() / 100.0;
        }
        int count = 0;
        if (vds.length() == 0) {
            return vds;
        }
        v.putValue(0, vds.value(0, 0));
        v.putValue(1, vds.value(0, 1));
        v.putValue(2, vds.value(0, 2));
        v.putValue(3, vds.value(0, 3));
        for (int i = 1; i < vds.length(); ++i) {
            if (Math.abs(vds.value(i, 0) - vds.value(i - 1, 1)) > tlim || vds.value(i, 3) != vds.value(i - 1, 3) || Math.abs(vds.value(i, 2) - vds.value(i - 1, 2)) > 1.0E-31) {
                build.putValues(-1, (QDataSet)v, 4);
                build.nextRecord();
                v.putValue(0, vds.value(i, 0));
                v.putValue(1, vds.value(i, 1));
                v.putValue(2, vds.value(i, 2));
                v.putValue(3, vds.value(i, 3));
                count = 1;
                continue;
            }
            v.putValue(1, vds.value(i, 1));
            ++count;
        }
        build.putValues(-1, (QDataSet)v, 4);
        build.putProperty("BUNDLE_1", (Object)bds);
        return build.getDataSet();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QDataSet makeCanonical(QDataSet vds) {
        void var4_16;
        QDataSet msgs;
        MutablePropertyDataSet xmaxs;
        MutablePropertyDataSet xmins;
        block34: {
            block35: {
                void var4_10;
                block38: {
                    QDataSet dep0;
                    block36: {
                        block39: {
                            block37: {
                                block32: {
                                    block31: {
                                        block33: {
                                            logger.entering("EventsRenderer", "makeCanonical");
                                            Object var4_2 = null;
                                            if (vds == null) {
                                                return null;
                                            }
                                            if (vds.rank() != 2) break block32;
                                            dep0 = (QDataSet)vds.property("DEPEND_0");
                                            if (dep0 != null) break block33;
                                            try {
                                                xmins = DataSetOps.unbundle((QDataSet)vds, (int)0);
                                                xmaxs = DataSetOps.unbundle((QDataSet)vds, (int)1);
                                            }
                                            catch (IndexOutOfBoundsException ex) {
                                                if (vds.length() == 0) {
                                                    logger.exiting("EventsRenderer", "makeCanonical", "null");
                                                    return null;
                                                }
                                                throw ex;
                                            }
                                            if (this.useColor) {
                                                WritableDataSet writableDataSet = Ops.replicate((int)this.getColor().getRGB(), (int)xmins.length());
                                                break block31;
                                            } else if (vds.length(0) > 3) {
                                                QDataSet qDataSet = DataSetOps.unbundle((QDataSet)vds, (int)2);
                                                break block31;
                                            } else {
                                                WritableDataSet writableDataSet = Ops.replicate((int)this.getColor().getRGB(), (int)xmins.length());
                                            }
                                            break block31;
                                        }
                                        if (dep0.rank() == 2) {
                                            if (!SemanticOps.isBins((QDataSet)dep0)) {
                                                this.postMessage("DEPEND_0 is rank 2 but not bins", DasPlot.WARNING, null, null);
                                                logger.exiting("EventsRenderer", "makeCanonical", "null");
                                                return null;
                                            }
                                            xmins = DataSetOps.slice1((QDataSet)dep0, (int)0);
                                            xmaxs = DataSetOps.slice1((QDataSet)dep0, (int)1);
                                            WritableDataSet writableDataSet = Ops.replicate((int)this.getColor().getRGB(), (int)xmins.length());
                                            Units u0 = SemanticOps.getUnits((QDataSet)xmins);
                                            Units u1 = SemanticOps.getUnits((QDataSet)xmaxs);
                                            if (!u1.isConvertibleTo(u0) && u1.isConvertibleTo(u0.getOffsetUnits())) {
                                                xmaxs = Ops.add((QDataSet)xmins, (QDataSet)xmaxs);
                                            }
                                        } else {
                                            if (dep0.rank() != 1) {
                                                this.postMessage("rank 2 dataset must have dep0 of rank 1 or rank 2 bins", DasPlot.WARNING, null, null);
                                                logger.exiting("EventsRenderer", "makeCanonical", "null");
                                                return null;
                                            }
                                            Datum width = SemanticOps.guessXTagWidth((QDataSet)dep0, null);
                                            if (width != null) {
                                                width = width.divide(2.0);
                                            } else {
                                                QDataSet sort = Ops.sort((QDataSet)dep0);
                                                QDataSet diffs = Ops.diff((QDataSet)DataSetOps.applyIndex((QDataSet)dep0, (int)0, (QDataSet)sort, (boolean)false));
                                                QDataSet w = Ops.reduceMin((QDataSet)diffs, (int)0);
                                                width = DataSetUtil.asDatum((QDataSet)w);
                                            }
                                            xmins = Ops.subtract((QDataSet)dep0, (QDataSet)DataSetUtil.asDataSet((Datum)width));
                                            xmaxs = Ops.add((QDataSet)dep0, (QDataSet)DataSetUtil.asDataSet((Datum)width));
                                            WritableDataSet writableDataSet = Ops.replicate((int)this.getColor().getRGB(), (int)xmins.length());
                                        }
                                    }
                                    msgs = DataSetOps.unbundle((QDataSet)vds, (int)(vds.length(0) - 1));
                                    break block34;
                                }
                                if (vds.rank() != 1) break block35;
                                dep0 = (QDataSet)vds.property("DEPEND_0");
                                if (dep0 != null) break block36;
                                if (!UnitsUtil.isNominalMeasurement((Units)SemanticOps.getUnits((QDataSet)vds))) break block37;
                                xmins = new TagGenDataSet(vds.length(), 1.0, 0.0);
                                xmaxs = new TagGenDataSet(vds.length(), 1.0, 1.0);
                                msgs = vds;
                                break block38;
                            }
                            if (!Schemes.isDatumRange((QDataSet)vds)) break block39;
                            xmins = vds.trim(0, 1);
                            xmaxs = vds.trim(1, 2);
                            String smsg = vds.toString();
                            msgs = Ops.reform((Object)Units.nominal().createDatum((Object)smsg), (int[])new int[]{1});
                            break block38;
                        }
                        if (Schemes.isCanonicalEvent((QDataSet)vds)) {
                            xmins = Ops.reform((QDataSet)vds.slice(0), (int[])new int[]{1});
                            xmaxs = Ops.reform((QDataSet)vds.slice(1), (int[])new int[]{1});
                            int n = vds.length();
                            msgs = Ops.reform((QDataSet)vds.slice(n - 1), (int[])new int[]{1});
                            if (vds.length() == 4 && !this.useColor) {
                                QDataSet qDataSet = Ops.reform((QDataSet)vds.slice(2), (int[])new int[]{1});
                            }
                            break block38;
                        } else {
                            xmins = vds;
                            xmaxs = vds;
                            msgs = vds;
                        }
                        break block38;
                    }
                    if (dep0.rank() == 2) {
                        if (!SemanticOps.isBins((QDataSet)dep0)) {
                            this.postMessage("DEPEND_0 is rank 2 but not bins", DasPlot.WARNING, null, null);
                            logger.exiting("EventsRenderer", "makeCanonical", "null");
                            return null;
                        }
                        xmins = DataSetOps.slice1((QDataSet)dep0, (int)0);
                        xmaxs = DataSetOps.slice1((QDataSet)dep0, (int)1);
                        Units u0 = SemanticOps.getUnits((QDataSet)xmins);
                        Units u1 = SemanticOps.getUnits((QDataSet)xmaxs);
                        if (!u1.isConvertibleTo(u0) && u1.isConvertibleTo(u0.getOffsetUnits())) {
                            xmaxs = Ops.add((QDataSet)xmins, (QDataSet)xmaxs);
                        }
                        msgs = vds;
                    } else {
                        if (dep0.rank() != 1) {
                            this.postMessage("dataset is not correct form", DasPlot.WARNING, null, null);
                            logger.exiting("EventsRenderer", "makeCanonical", "null");
                            return null;
                        }
                        Datum width = SemanticOps.guessXTagWidth((QDataSet)dep0, null);
                        if (width != null) {
                            width = width.divide(2.0);
                        } else {
                            Units dep0units = SemanticOps.getUnits((QDataSet)dep0);
                            if (UnitsUtil.isNominalMeasurement((Units)dep0units)) {
                                throw new IllegalArgumentException("dep0units are norminal units");
                            }
                            QDataSet sort = Ops.sort((QDataSet)dep0);
                            QDataSet diffs = Ops.diff((QDataSet)DataSetOps.applyIndex((QDataSet)dep0, (int)0, (QDataSet)sort, (boolean)false));
                            QDataSet w = Ops.reduceMin((QDataSet)diffs, (int)0);
                            width = DataSetUtil.asDatum((QDataSet)w);
                        }
                        xmins = Ops.subtract((QDataSet)dep0, (QDataSet)DataSetUtil.asDataSet((Datum)width));
                        xmaxs = Ops.add((QDataSet)dep0, (QDataSet)DataSetUtil.asDataSet((Datum)width));
                        msgs = vds;
                    }
                }
                if (var4_10 == null) {
                    Color c0 = this.getColor();
                    int alpha = c0.getAlpha() == 255 ? (this.opaque ? 255 : 128) : c0.getAlpha();
                    Color c1 = new Color(c0.getRed(), c0.getGreen(), c0.getBlue(), alpha);
                    int irgb = c1.getRGB();
                    WritableDataSet writableDataSet = Ops.replicate((int)irgb, (int)xmins.length());
                }
                break block34;
            }
            if (vds.rank() != 0) {
                this.postMessage("dataset must be rank 0, 1 or 2", DasPlot.WARNING, null, null);
                logger.exiting("EventsRenderer", "makeCanonical", "null");
                return null;
            }
            xmaxs = xmins = Ops.replicate((QDataSet)vds, (int)1);
            Color c0 = this.getColor();
            int alpha = c0.getAlpha() == 255 ? (this.opaque ? 255 : 128) : c0.getAlpha();
            Color c1 = new Color(c0.getRed(), c0.getGreen(), c0.getBlue(), alpha);
            int irgb = c1.getRGB();
            WritableDataSet writableDataSet = Ops.replicate((int)irgb, (int)xmins.length());
            msgs = Ops.replicate((QDataSet)vds, (int)1);
        }
        if (this.colorSpecifier != null) {
            void var4_14;
            Units u = SemanticOps.getUnits((QDataSet)msgs);
            ArrayDataSet wds = IDataSet.copy((QDataSet)var4_14);
            for (int i = 0; i < msgs.length(); ++i) {
                wds.putValue(i, (double)this.colorSpecifier.getColor(Datum.create((double)msgs.value(i), (Units)u)).getRGB());
            }
            ArrayDataSet arrayDataSet = wds;
        }
        Units u0 = SemanticOps.getUnits((QDataSet)xmins);
        Units u1 = SemanticOps.getUnits((QDataSet)xmaxs);
        if (u1.isConvertibleTo(u0.getOffsetUnits()) && !u1.isConvertibleTo(u0)) {
            xmaxs = Ops.add((QDataSet)xmins, (QDataSet)xmaxs);
        }
        QDataSet lds = Ops.bundle((QDataSet)xmins, (QDataSet)xmaxs, (QDataSet)var4_16, (QDataSet)msgs);
        logger.exiting("EventsRenderer", "makeCanonical", "lds");
        return lds;
    }

    @Override
    public void render(Graphics2D g1, DasAxis xAxis, DasAxis yAxis) {
        QDataSet xmaxs;
        QDataSet xmins;
        GeneralPath sa = new GeneralPath();
        QDataSet vds = this.getDataSet();
        if (vds == null) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            return;
        }
        if (vds.rank() > 0 && vds.length() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("empty data set");
            return;
        }
        Graphics2D g = g1;
        g.setColor(this.color);
        if (this.cds == null) {
            return;
        }
        String mode = this.mode.intern();
        QDataSet cds1 = this.cds;
        if (mode.equals("gantt2")) {
            xmins = DataSetOps.unbundle((QDataSet)this.cds, (int)0);
            xmaxs = DataSetOps.unbundle((QDataSet)this.cds, (int)1);
            QDataSet allBefore = Ops.lt((Object)xmaxs, (Object)xAxis.getDatumRange().min());
            QDataSet allAfter = Ops.gt((Object)xmins, (Object)xAxis.getDatumRange().max());
            QDataSet r = Ops.where((QDataSet)Ops.not((QDataSet)Ops.or((QDataSet)allBefore, (QDataSet)allAfter)));
            cds1 = Ops.applyIndex((QDataSet)this.cds, (QDataSet)r);
            this.ganttMode = true;
        }
        xmins = DataSetOps.unbundle((QDataSet)cds1, (int)0);
        xmaxs = DataSetOps.unbundle((QDataSet)cds1, (int)1);
        QDataSet msgs = DataSetOps.unbundle((QDataSet)cds1, (int)3);
        Units eu = SemanticOps.getUnits((QDataSet)msgs);
        QDataSet lcolor = DataSetOps.unbundle((QDataSet)cds1, (int)2);
        long t0 = System.currentTimeMillis();
        DasPlot parent = this.getParent();
        Rectangle current = null;
        if (this.lastException != null) {
            this.renderException(g, xAxis, yAxis, this.lastException);
        } else {
            DasColumn column = xAxis.getColumn();
            DasRow row = parent.getRow();
            this.eventMap = new int[column.getWidth()];
            for (int k = 0; k < this.eventMap.length; ++k) {
                this.eventMap[k] = -1;
            }
            QDataSet wxmins = SemanticOps.weightsDataSet((QDataSet)xmins);
            QDataSet xds = xmins;
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            if (!xunits.isConvertibleTo(xAxis.getUnits()) && UnitsUtil.isRatioMeasurement((Units)xunits)) {
                parent.postMessage((Renderer)this, "x axis units changed from \"" + xunits + "\" to \"" + xAxis.getUnits() + "\"", DasPlot.INFO, null, null);
                xunits = xAxis.getUnits();
            }
            if (cds1.length() > 0) {
                boolean drawLineThick;
                int gymin;
                int gymax;
                int ivds0 = 0;
                int ivds1 = xmins.length();
                Font f = this.getParent().getFont();
                if (this.getFontSize() != null && this.getFontSize().length() > 0 && !this.getFontSize().equals("1em")) {
                    try {
                        double[] size = DasDevicePosition.parseLayoutStr(this.getFontSize());
                        double s = (double)f.getSize2D() * size[0] / 100.0 + (double)f.getSize2D() * size[1] + size[2];
                        f = f.deriveFont((float)s);
                    }
                    catch (ParseException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
                g1.setFont(f);
                GrannyTextRenderer gtr = new GrannyTextRenderer();
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                HashMap<Integer, Integer> pam = new HashMap<Integer, Integer>();
                try {
                    QDataSet s = Ops.sort((QDataSet)msgs);
                    QDataSet u = Ops.uniq((QDataSet)msgs, (QDataSet)s);
                    gymax = u.length();
                    gymin = 0;
                    for (int i = 0; i < u.length(); ++i) {
                        map.put((int)msgs.value((int)u.value(i)), i);
                        pam.put(i, (int)msgs.value((int)u.value(i)));
                    }
                }
                catch (IndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                    return;
                }
                int lastMessageTailX = -10000;
                gtr.setString((Graphics)g1, "xxx");
                int textHeight = (int)gtr.getHeight();
                int imin = xAxis.getColumn().getDMinimum();
                int imax = xAxis.getColumn().getDMaximum();
                boolean bl = drawLineThick = this.lineThick.trim().length() > 0;
                if (drawLineThick) {
                    double t = DasDevicePosition.parseLayoutStr(this.lineThick, f.getSize2D(), this.getParent().getWidth(), 1.0);
                    g.setStroke(this.lineStyle.getStroke((float)t));
                }
                for (int i = ivds0; i < ivds1; ++i) {
                    Rectangle r1;
                    long dt = System.currentTimeMillis() - t0;
                    if (i % 10 == 0 && dt > (long)this.renderTimeLimitMs) {
                        parent.postMessage((Renderer)this, "renderer ran out of time, dataset truncated", DasPlot.WARNING, null, null);
                        break;
                    }
                    if (wxmins.value(i) == 0.0) continue;
                    int ixmin = (int)xAxis.transform(xmins.value(i), xunits);
                    int ixmax = (int)xAxis.transform(xmaxs.value(i), xunits);
                    if (ixmax <= -10000 || ixmin >= 10000) continue;
                    int ixmin0 = ixmin;
                    ixmin = Math.max(ixmin, imin);
                    ixmax = Math.min(ixmax, imax);
                    int iwidth = Math.max(ixmax - ixmin, 1);
                    if (lcolor != null) {
                        int irgb = (int)lcolor.value(i);
                        int rr = (irgb & 0xFF0000) >> 16;
                        int gg = (irgb & 0xFF00) >> 8;
                        int bb = irgb & 0xFF;
                        int aa = irgb >> 24 & 0xFF;
                        if (aa > 0) {
                            g.setColor(new Color(rr, gg, bb, aa));
                        } else {
                            g.setColor(new Color(rr, gg, bb, 128));
                        }
                    }
                    if (column.getDMinimum() >= ixmax || ixmin0 >= column.getDMaximum()) continue;
                    if (iwidth == 0) {
                        iwidth = 1;
                    }
                    if (this.orbitMode) {
                        r1 = new Rectangle(ixmin, row.getDMaximum() - textHeight, iwidth - 1, textHeight);
                        g.fill(r1);
                    } else if (this.ganttMode) {
                        int ord = (int)msgs.value(i);
                        Integer iy = (Integer)map.get(ord);
                        if (iy == null) continue;
                        int iymin = row.getDMinimum() + row.getHeight() * iy / (gymax - gymin) + 1;
                        int iymax = row.getDMinimum() + row.getHeight() * (1 + iy) / (gymax - gymin) - 1;
                        r1 = new Rectangle(ixmin, iymin, iwidth, Math.max(iymax - iymin, 2));
                        g.fill(r1);
                    } else if (iwidth <= 1 && drawLineThick) {
                        r1 = new Rectangle(ixmin, row.getDMinimum(), iwidth, row.getHeight());
                        Line2D.Double l1 = new Line2D.Double(ixmin, row.getDMinimum(), ixmin, row.getDMaximum());
                        g.draw(l1);
                    } else {
                        r1 = new Rectangle(ixmin, row.getDMinimum(), iwidth, row.getHeight());
                        g.fill(r1);
                        if (drawLineThick) {
                            g.draw(r1);
                        }
                    }
                    r1.x -= 2;
                    r1.y -= 2;
                    r1.width += 4;
                    r1.height += 4;
                    if (current == null) {
                        current = r1;
                    } else if (current.intersects(r1)) {
                        current = current.union(r1);
                    } else {
                        sa.append(current, false);
                        current = r1;
                    }
                    int im = ixmin - column.getDMinimum();
                    int em0 = im - 1;
                    int em1 = im + iwidth + 1;
                    for (int k = em0; k < em1; ++k) {
                        if (k < 0 || k >= this.eventMap.length) continue;
                        this.eventMap[k] = i;
                    }
                    if (this.showLabels) {
                        DatumRange dr = new DatumRange(xmins.value(i), xmaxs.value(i), xunits);
                        Datum d = eu.createDatum(msgs.value(i));
                        String text = this.textSpecifier.getText(dr, d);
                        gtr.setString((Graphics)g1, text);
                        gtr.draw((Graphics)g1, (float)(ixmin + 2), (float)(row.getDMinimum() + (int)gtr.getAscent()));
                    }
                    if (!this.orbitMode) continue;
                    if (this.rotateLabel == 0) {
                        try {
                            String text = eu.createDatum(msgs.value(i)).toString();
                            gtr.setString((Graphics)g1, text);
                            Color c0 = g1.getColor();
                            g1.setColor(this.getParent().getBackground());
                            gtr.draw((Graphics)g1, (float)(ixmin + 2 - 1), (float)(row.getDMaximum() - textHeight + (int)gtr.getAscent()));
                            gtr.draw((Graphics)g1, (float)(ixmin + 2), (float)(row.getDMaximum() - textHeight + (int)gtr.getAscent() + 1));
                            gtr.draw((Graphics)g1, (float)(ixmin + 2 + 1), (float)(row.getDMaximum() - textHeight + (int)gtr.getAscent()));
                            gtr.draw((Graphics)g1, (float)(ixmin + 2), (float)(row.getDMaximum() - textHeight + (int)gtr.getAscent() - 1));
                            g1.setColor(c0);
                            gtr.draw((Graphics)g1, (float)(ixmin + 2), (float)(row.getDMaximum() - textHeight + (int)gtr.getAscent()));
                            lastMessageTailX = ixmin + 2 + (int)gtr.getWidth();
                        }
                        catch (RuntimeException text) {}
                        continue;
                    }
                    if (this.rotateLabel != 90) continue;
                    try {
                        String text = eu.createDatum(msgs.value(i)).toString();
                        gtr.setString((Graphics)g1, text);
                        Graphics2D g2 = (Graphics2D)g1.create();
                        g2.translate((int)((double)(ixmin0 + 2) + gtr.getAscent()), row.getDMaximum() - textHeight + (int)gtr.getAscent());
                        g2.setColor(this.color);
                        g2.rotate(-1.5707963267948966);
                        gtr.draw((Graphics)g2, (float)textHeight, (float)((int)(gtr.getAscent() - gtr.getHeight())));
                        lastMessageTailX = ixmin + 2 + (int)gtr.getWidth();
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (current != null) {
                    sa.append(current, false);
                }
                if (this.ganttMode) {
                    g1.setColor(this.color);
                    int di = Math.max(1, (gymax - gymin - 1) / (row.getHeight() / textHeight));
                    for (int i = gymin; i < gymax; i += di) {
                        gtr.setString((Graphics)g1, eu.createDatum((Number)pam.get(i)).toString());
                        int iymin = row.getDMinimum() + row.getHeight() * (i - gymin) / (gymax - gymin);
                        Color c0 = g1.getColor();
                        g1.setColor(Color.white);
                        gtr.draw((Graphics)g1, (float)(column.getDMinimum() + textHeight / 3 - 1), (float)(iymin + textHeight));
                        gtr.draw((Graphics)g1, (float)(column.getDMinimum() + textHeight / 3), (float)(iymin + textHeight + 1));
                        gtr.draw((Graphics)g1, (float)(column.getDMinimum() + textHeight / 3 + 1), (float)(iymin + textHeight));
                        gtr.draw((Graphics)g1, (float)(column.getDMinimum() + textHeight / 3), (float)(iymin + textHeight - 1));
                        g1.setColor(c0);
                        gtr.draw((Graphics)g1, (float)(column.getDMinimum() + textHeight / 3), (float)(iymin + textHeight));
                    }
                }
                for (int k1 = 1; k1 <= 2; ++k1) {
                    for (int k2 = -1; k2 <= 1; k2 += 2) {
                        int em0 = k2 == 1 ? 0 : this.eventMap.length - 1;
                        int em1 = k2 == 1 ? this.eventMap.length - k1 : k1;
                        for (int k = em0; k != em1; k += k2) {
                            if (this.eventMap[k] != -1) continue;
                            this.eventMap[k] = this.eventMap[k + k2];
                        }
                    }
                }
            }
        }
        g.dispose();
        this.selectionArea = sa;
    }

    @Override
    public void setDataSet(QDataSet ds) {
        this.cds = this.makeCanonical(ds);
        super.setDataSet(ds);
    }

    @Override
    public Icon getListIcon() {
        return new ImageIcon(SpectrogramRenderer.class.getResource("/images/icons/eventsBar.png"));
    }

    @Override
    public void setControl(String s) {
        if (this.control.equals(s)) {
            return;
        }
        super.setControl(s);
        this.setShowLabels(this.getBooleanControl(PROP_SHOWLABELS, false));
        this.setOrbitMode(this.getBooleanControl(PROP_ORBITMODE, false));
        this.setFontSize(this.getControl(PROP_FONTSIZE, "1em"));
        this.setGanttMode(this.getBooleanControl(PROP_GANTTMODE, false));
        this.setLineStyle(Renderer.decodePlotSymbolConnectorControl(this.getControl(PROP_LINESTYLE, this.lineStyle.toString()), this.lineStyle));
        this.setLineThick(this.getControl(PROP_LINETHICK, ""));
        this.setOpaque(this.getBooleanControl(PROP_OPAQUE, false));
        if (this.hasControl(PROP_COLOR)) {
            this.setColor(this.getColorControl(PROP_COLOR, this.color));
            this.useColor = true;
        } else {
            this.setColor(new Color(100, 100, 100));
        }
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put(PROP_SHOWLABELS, EventsRenderer.encodeBooleanControl(this.isShowLabels()));
        controls.put(PROP_ORBITMODE, EventsRenderer.encodeBooleanControl(this.isOrbitMode()));
        controls.put(PROP_FONTSIZE, this.getFontSize());
        controls.put(PROP_GANTTMODE, EventsRenderer.encodeBooleanControl(this.isGanttMode()));
        controls.put(PROP_LINESTYLE, this.getLineStyle().toString());
        controls.put(PROP_LINETHICK, this.getLineThick());
        controls.put(PROP_OPAQUE, EventsRenderer.encodeBooleanControl(this.isOpaque()));
        if (this.useColor) {
            controls.put(PROP_COLOR, EventsRenderer.encodeColorControl(this.color));
        }
        return Renderer.formatControl(controls);
    }

    public Color getColor() {
        return this.color;
    }

    public PsymConnector getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(PsymConnector lineStyle) {
        PsymConnector oldLineStyle = this.lineStyle;
        this.lineStyle = lineStyle;
        if (!oldLineStyle.equals(lineStyle)) {
            super.invalidateParentCacheImage();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_LINESTYLE, oldLineStyle, lineStyle);
    }

    public String getLineThick() {
        return this.lineThick;
    }

    public void setLineThick(String lineThick) {
        String oldLineThick = this.lineThick;
        this.lineThick = lineThick;
        if (!oldLineThick.equals(lineThick)) {
            super.invalidateParentCacheImage();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_LINETHICK, oldLineThick, lineThick);
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        boolean oldOpaque = this.opaque;
        this.opaque = opaque;
        if (oldOpaque != opaque) {
            this.cds = this.makeCanonical(this.ds);
            super.invalidateParentCacheImage();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_OPAQUE, oldOpaque, opaque);
    }

    public void setColor(Color color) {
        Color old = this.color;
        this.color = color;
        if (!old.equals(color)) {
            this.cds = this.makeCanonical(this.ds);
            super.invalidateParentCacheImage();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, old, color);
    }

    public int getRenderTimeLimitMs() {
        return this.renderTimeLimitMs;
    }

    public void setRenderTimeLimitMs(int renderTimeLimitMs) {
        this.renderTimeLimitMs = renderTimeLimitMs;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        boolean oldShowLabels = this.showLabels;
        this.showLabels = showLabels;
        DasPlot parent = this.getParent();
        if (parent != null) {
            parent.invalidateCacheImage();
            parent.repaint();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_SHOWLABELS, oldShowLabels, showLabels);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        String oldMode = this.mode;
        this.mode = mode;
        this.propertyChangeSupport.firePropertyChange(PROP_MODE, oldMode, mode);
    }

    public boolean isOrbitMode() {
        return this.orbitMode;
    }

    public void setOrbitMode(boolean orbitMode) {
        boolean oldOrbitMode = this.orbitMode;
        this.orbitMode = orbitMode;
        this.propertyChangeSupport.firePropertyChange(PROP_ORBITMODE, oldOrbitMode, orbitMode);
    }

    public boolean isGanttMode() {
        return this.ganttMode;
    }

    public void setGanttMode(boolean ganttMode) {
        boolean oldGanttMode = this.ganttMode;
        this.ganttMode = ganttMode;
        this.propertyChangeSupport.firePropertyChange(PROP_GANTTMODE, oldGanttMode, ganttMode);
    }

    public int getRotateLabel() {
        return this.rotateLabel;
    }

    public void setRotateLabel(int rotateLabel) {
        int oldRotateLabel = this.rotateLabel;
        this.rotateLabel = rotateLabel;
        this.propertyChangeSupport.firePropertyChange(PROP_ROTATELABEL, oldRotateLabel, rotateLabel);
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        String oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.propertyChangeSupport.firePropertyChange(PROP_FONTSIZE, oldFontSize, fontSize);
    }

    public void setColorSpecifier(ColorSpecifier spec) {
        ColorSpecifier old = this.colorSpecifier;
        this.colorSpecifier = spec;
        this.cds = this.makeCanonical(this.ds);
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR_SPECIFIER, old, spec);
        super.invalidateParentCacheImage();
    }

    public ColorSpecifier getColorSpecifier() {
        return this.colorSpecifier;
    }

    public TextSpecifier getTextSpecifier() {
        return this.textSpecifier;
    }

    public void setTextSpecifier(TextSpecifier textSpecifier) {
        TextSpecifier oldTextSpecifier = this.textSpecifier;
        this.textSpecifier = textSpecifier;
        this.propertyChangeSupport.firePropertyChange("textSpecifier", oldTextSpecifier, textSpecifier);
    }

    private class EventLabelDragRenderer
    extends LabelDragRenderer {
        DasPlot parent;

        EventLabelDragRenderer(DasPlot parent) {
            super(parent);
            this.parent = parent;
            this.setTooltip(true);
        }

        @Override
        public Rectangle[] renderDrag(Graphics g, Point p1, Point p2) {
            QDataSet vds = EventsRenderer.this.getDataSet();
            if (vds == null) {
                return new Rectangle[0];
            }
            if (vds.rank() == 0) {
                return new Rectangle[0];
            }
            if (vds.length() == 0) {
                return new Rectangle[0];
            }
            QDataSet ds = EventsRenderer.this.cds;
            if (ds == null) {
                return new Rectangle[0];
            }
            QDataSet xmins = DataSetOps.unbundle((QDataSet)ds, (int)0);
            QDataSet xmaxs = DataSetOps.unbundle((QDataSet)ds, (int)1);
            QDataSet msgs = DataSetOps.unbundle((QDataSet)ds, (int)(ds.length(0) - 1));
            int ix = (int)p2.getX() - this.parent.getColumn().getDMinimum();
            Datum px = this.parent.getXAxis().invTransform(p2.getX());
            if (ix < 0 || EventsRenderer.this.eventMap == null || ix >= EventsRenderer.this.eventMap.length) {
                this.setLabel(null);
            } else {
                Units sxunits = SemanticOps.getUnits((QDataSet)xmins);
                Units zunits = SemanticOps.getUnits((QDataSet)msgs);
                Units sxmaxunits = SemanticOps.getUnits((QDataSet)xmaxs);
                ArrayList<Integer> ii = new ArrayList<Integer>();
                if (EventsRenderer.this.useOnlyEventsMap && EventsRenderer.this.eventMap[ix] > -1) {
                    ii.add(EventsRenderer.this.eventMap[ix]);
                } else {
                    if (EventsRenderer.this.eventMap[ix] > -1) {
                        ii.add(EventsRenderer.this.eventMap[ix]);
                    }
                    for (int i = 0; i < xmaxs.length(); ++i) {
                        double sxmin = xmins.value(i);
                        double sxmax = xmaxs.value(i);
                        sxmax = !sxmaxunits.isConvertibleTo(sxunits) ? (sxmaxunits.isConvertibleTo(sxunits.getOffsetUnits()) ? sxmin + sxmaxunits.convertDoubleTo(sxunits.getOffsetUnits(), sxmax) : sxmin) : sxmaxunits.convertDoubleTo(sxunits, sxmax);
                        if (sxmax < sxmin) {
                            this.setLabel("Error, sxmax<sxmin: " + Datum.create((double)sxmax, (Units)sxunits) + " < " + Datum.create((double)sxmin, (Units)sxmaxunits));
                            continue;
                        }
                        DatumRange dr = new DatumRange(sxmin, sxmax, sxunits);
                        if (!dr.getUnits().isConvertibleTo(px.getUnits())) {
                            logger.fine("inconvertible units");
                            return new Rectangle[0];
                        }
                        if (!dr.contains(px) || ii.contains(i)) continue;
                        ii.add(i);
                    }
                }
                if (ii.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    int count = 0;
                    for (Integer ii1 : ii) {
                        String ss;
                        Datum sz;
                        DatumRange dr;
                        int i = ii1;
                        double sxmin = xmins.value(i);
                        double sxmax = xmaxs.value(i);
                        sxmax = !sxmaxunits.isConvertibleTo(sxunits) ? (sxmaxunits.isConvertibleTo(sxunits.getOffsetUnits()) ? sxmin + sxmaxunits.convertDoubleTo(sxunits.getOffsetUnits(), sxmax) : sxmin) : sxmaxunits.convertDoubleTo(sxunits, sxmax);
                        if (sxmax < sxmin) {
                            dr = new DatumRange(sxmin, sxmin, sxunits);
                            try {
                                sz = zunits.createDatum(msgs.value(i));
                                ss = EventsRenderer.this.textSpecifier.getText(dr, sz);
                            }
                            catch (RuntimeException ex) {
                                ss = "" + dr + " fill";
                            }
                            sb.append(ss).append("!c");
                        } else {
                            dr = new DatumRange(sxmin, sxmax, sxunits);
                            try {
                                sz = zunits.createDatum(msgs.value(i));
                                ss = EventsRenderer.this.textSpecifier.getText(dr, sz);
                            }
                            catch (RuntimeException ex) {
                                ss = "" + dr + " fill";
                            }
                            sb.append(ss).append("!c");
                        }
                        if (++count <= 10) continue;
                        break;
                    }
                    if (ii.size() > count) {
                        sb.append("(").append(ii.size() - count).append(" more items not shown)");
                    }
                    this.setLabel(sb.toString());
                } else {
                    this.setLabel(null);
                }
            }
            return super.renderDrag(g, p1, p2);
        }
    }

    public static interface TextSpecifier {
        public String getText(DatumRange var1, Datum var2);
    }

    public static interface ColorSpecifier {
        public Color getColor(Datum var1);
    }
}

