/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.util.GrannyTextRenderer;

public class RangeLabel
extends DasCanvasComponent {
    private boolean inDebugMode = false;
    private Alignment alignment = Alignment.CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    private DatumRange datumRange;
    public static final String PROP_DATUMRANGE = "datumRange";
    private String wordsAfterLabelSingleDatum = " at ";
    private String wordsAfterLabelDatumRange = " average over ";
    private String dsLabel;
    private double offsetFromPlot = 0.0;
    private TextRect dsLabelRect = new TextRect(" Data: ", new Rectangle());
    private TextRect lDatumRect;
    private TextRect rDatumRect;
    private TextRect addRDatum = new TextRect(" + ", new Rectangle());
    private TextRect toTextRect = new TextRect(" to ", new Rectangle(), new Cursor(13));
    private TextRect rScan = new TextRect(" scan>> ", new Rectangle());
    private TextRect lScan = new TextRect(" <<scan ", new Rectangle());
    private int colMin;
    private int colMax;
    private int rowMin;
    private int rowMax;
    private int layoutWidth;
    private int layoutHeight;
    private TextRect[] layoutAry = new TextRect[6];
    private boolean inSingleMode;
    private TextRect mouseRect;
    private boolean isDragging = false;
    private boolean startedDragAsRange = false;
    private int buttonPress = 0;
    private Point lastPoint;
    private Point pressedPoint;
    private boolean showAnimation = false;
    private static final int LEFT_ANIMATION = 0;
    private static final int CENTER_ANIMATION = 1;
    private static final int RIGHT_ANIMATION = 2;
    private int animationMode;
    private DatumRange validRange;
    private int ovalSize = 4;
    private int halfOvalSize = this.ovalSize / 2;

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
        this.update();
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment va) {
        this.verticalAlignment = va;
        this.update();
    }

    public void setInDebugMode(boolean inDebug) {
        this.inDebugMode = inDebug;
    }

    public boolean getInDebugMode() {
        return this.inDebugMode;
    }

    public DatumRange getDatumRange() {
        return this.datumRange;
    }

    public void setDatumRange(DatumRange dr) {
        DatumRange oldDR = this.datumRange;
        if (this.validRange != null) {
            if (this.inSingleMode) {
                if (dr.min().lt(this.validRange.min())) {
                    dr = new DatumRange(this.validRange.min(), this.validRange.min());
                }
                if (dr.max().gt(this.validRange.max())) {
                    dr = new DatumRange(this.validRange.max(), this.validRange.max());
                }
            } else {
                if (dr.min().lt(this.validRange.min())) {
                    dr = new DatumRange(this.validRange.min(), dr.max());
                }
                if (dr.max().gt(this.validRange.max())) {
                    dr = new DatumRange(dr.min(), this.validRange.max());
                }
            }
        }
        this.datumRange = dr;
        this.lDatumRect.text = this.datumRange.min().toString();
        this.rDatumRect.text = this.datumRange.max().toString();
        this.firePropertyChange(PROP_DATUMRANGE, oldDR, dr);
        this.fireDataRangeSelection();
        this.update();
    }

    public void setWordsAfterLabelSingleDatum(String newWords) {
        this.wordsAfterLabelSingleDatum = newWords;
        this.setDsLabel(this.dsLabel);
    }

    public String getWordsAfterLabelSingleDatum() {
        return this.wordsAfterLabelSingleDatum;
    }

    public void setWordsAfterLabelDatumRange(String newWords) {
        this.wordsAfterLabelDatumRange = newWords;
        this.setDsLabel(this.dsLabel);
    }

    public String getWordsAfterLabelDatumRange() {
        return this.wordsAfterLabelDatumRange;
    }

    public String getDsLabel() {
        return this.dsLabel;
    }

    public void setDsLabel(String dsLabel) {
        this.dsLabel = dsLabel == null ? "" : dsLabel;
        this.dsLabelRect.text = this.inSingleMode ? " " + dsLabel + this.wordsAfterLabelSingleDatum : " " + dsLabel + this.wordsAfterLabelDatumRange;
        this.repaint();
    }

    public double getOffsetFromPlot() {
        return this.offsetFromPlot;
    }

    public void setOffsetFromPlot(double newOffset) {
        this.offsetFromPlot = newOffset;
        this.update();
    }

    public RangeLabel(Datum lDatum, Datum rDatum) {
        this.datumRange = new DatumRange(lDatum, rDatum);
        this.lDatumRect = new TextRect(lDatum.toString(), new Rectangle(), new Cursor(10));
        this.lDatumRect.isShowing = true;
        this.rDatumRect = new TextRect(rDatum.toString(), new Rectangle(), new Cursor(11));
        this.rDatumRect.isShowing = true;
        this.toTextRect.isShowing = true;
        this.dsLabelRect.isShowing = true;
        if (this.datumRange.min().equals(this.datumRange.max())) {
            this.inSingleMode = true;
        }
        MouseAdapter ma = this.getMouseAdapter();
        this.addMouseMotionListener(ma);
        this.addMouseWheelListener(ma);
        this.addMouseListener(ma);
        this.putClientProperty("layeredContainerLayer", DasCanvas.AXIS_LAYER);
        this.setValidRange(this.datumRange);
    }

    public RangeLabel(DatumRange dr) {
        this(dr.min(), dr.max());
    }

    public RangeLabel() {
        this(Datum.create((int)0, (Units)Units.dimensionless), Datum.create((int)10, (Units)Units.dimensionless));
    }

    @Override
    public void resize() {
        this.setSizingParams();
        this.setLayout(this.inSingleMode, new GrannyTextRenderer());
        this.setlayoutAry(this.inSingleMode);
        Rectangle rect = new Rectangle(this.lScan.rect);
        rect.add(this.dsLabelRect.rect);
        rect.add(this.lDatumRect.rect);
        if (this.inSingleMode) {
            rect.add(this.addRDatum.rect);
        } else {
            rect.add(this.toTextRect.rect);
            rect.add(this.rDatumRect.rect);
        }
        rect.add(this.rScan.rect);
        this.setBounds(rect);
    }

    private void setSizingParams() {
        this.colMin = this.getColumn().getDMinimum();
        this.colMax = this.getColumn().getDMaximum();
        this.rowMin = this.getRow().getDMinimum();
        this.rowMax = this.getRow().getDMaximum();
        this.layoutWidth = this.colMax - this.colMin;
        this.layoutHeight = this.rowMax - this.rowMin;
    }

    private void setLayout(boolean inSingle, GrannyTextRenderer gtr) {
        int totalWidth = 0;
        if (inSingle) {
            gtr.setString(this.getFont(), this.lScan.text);
            int width = (int)gtr.getWidth();
            totalWidth += width;
            this.lScan.lPixel = -width;
            this.lScan.rPixel = this.lScan.lPixel + width + 1;
            gtr.setString(this.getFont(), this.dsLabelRect.text);
            width = (int)gtr.getWidth();
            totalWidth += width;
            this.dsLabelRect.lPixel = this.lScan.rPixel;
            this.dsLabelRect.rPixel = this.dsLabelRect.lPixel + width + 1;
            gtr.setString(this.getFont(), this.lDatumRect.text);
            width = (int)gtr.getWidth();
            totalWidth += width;
            this.lDatumRect.lPixel = this.dsLabelRect.rPixel;
            this.lDatumRect.rPixel = this.lDatumRect.lPixel + width + 1;
            gtr.setString(this.getFont(), this.addRDatum.text);
            width = (int)gtr.getWidth();
            totalWidth += width;
            this.addRDatum.lPixel = this.lDatumRect.rPixel;
            this.addRDatum.rPixel = this.addRDatum.lPixel + width + 1;
            gtr.setString(this.getFont(), this.rScan.text);
            width = (int)gtr.getWidth();
            this.rScan.lPixel = this.addRDatum.rPixel;
            this.rScan.rPixel = this.rScan.lPixel + width + 1;
            int xOffset = 0;
            switch (this.alignment) {
                case LEFT: {
                    xOffset = 0;
                    break;
                }
                case CENTER: {
                    xOffset = (this.colMax - this.colMin - totalWidth) / 2;
                    break;
                }
                case RIGHT: {
                    xOffset = this.colMax - this.colMin - totalWidth;
                    break;
                }
                default: {
                    xOffset = 0;
                }
            }
            this.lScan.lPixel += xOffset;
            this.lScan.rPixel += xOffset;
            this.dsLabelRect.lPixel += xOffset;
            this.dsLabelRect.rPixel += xOffset;
            this.lDatumRect.lPixel += xOffset;
            this.lDatumRect.rPixel += xOffset;
            this.addRDatum.lPixel += xOffset;
            this.addRDatum.rPixel += xOffset;
            this.rScan.lPixel += xOffset;
            this.rScan.rPixel += xOffset;
            this.lScan.setRect();
            this.dsLabelRect.setRect();
            this.lDatumRect.setRect();
            this.addRDatum.setRect();
            this.rScan.setRect();
        } else {
            gtr.setString(this.getFont(), this.lScan.text);
            int width = (int)gtr.getWidth();
            this.lScan.lPixel = -width;
            this.lScan.rPixel = this.lScan.lPixel + width + 1;
            gtr.setString(this.getFont(), this.dsLabelRect.text);
            width = (int)gtr.getWidth();
            totalWidth += width;
            this.dsLabelRect.lPixel = 0;
            this.dsLabelRect.rPixel = this.dsLabelRect.lPixel + width + 1;
            gtr.setString(this.getFont(), this.lDatumRect.text);
            width = (int)gtr.getWidth();
            totalWidth += width;
            this.lDatumRect.lPixel = this.dsLabelRect.rPixel;
            this.lDatumRect.rPixel = this.lDatumRect.lPixel + width + 1;
            gtr.setString(this.getFont(), this.toTextRect.text);
            width = (int)gtr.getWidth();
            totalWidth += width;
            this.toTextRect.lPixel = this.lDatumRect.rPixel;
            this.toTextRect.rPixel = this.toTextRect.lPixel + width + 1;
            gtr.setString(this.getFont(), this.rDatumRect.text);
            width = (int)gtr.getWidth();
            totalWidth += width;
            this.rDatumRect.lPixel = this.toTextRect.rPixel;
            this.rDatumRect.rPixel = this.rDatumRect.lPixel + width + 1;
            gtr.setString(this.getFont(), this.rScan.text);
            width = (int)gtr.getWidth();
            this.rScan.lPixel = this.rDatumRect.rPixel;
            this.rScan.rPixel = this.rScan.lPixel + width + 1;
            int xOffset = 0;
            switch (this.alignment) {
                case LEFT: {
                    xOffset = 0;
                    break;
                }
                case CENTER: {
                    xOffset = (this.colMax - this.colMin - totalWidth) / 2;
                    break;
                }
                case RIGHT: {
                    xOffset = this.colMax - this.colMin - totalWidth;
                    break;
                }
                default: {
                    xOffset = 0;
                }
            }
            this.lScan.lPixel += xOffset;
            this.lScan.rPixel += xOffset;
            this.dsLabelRect.lPixel += xOffset;
            this.dsLabelRect.rPixel += xOffset;
            this.lDatumRect.lPixel += xOffset;
            this.lDatumRect.rPixel += xOffset;
            this.toTextRect.lPixel += xOffset;
            this.toTextRect.rPixel += xOffset;
            this.rDatumRect.lPixel += xOffset;
            this.rDatumRect.rPixel += xOffset;
            this.rScan.lPixel += xOffset;
            this.rScan.rPixel += xOffset;
            this.lScan.setRect();
            this.dsLabelRect.setRect();
            this.lDatumRect.setRect();
            this.toTextRect.setRect();
            this.rDatumRect.setRect();
            this.rScan.setRect();
        }
    }

    private void setlayoutAry(boolean inSingle) {
        if (inSingle) {
            this.layoutAry[0] = this.lScan;
            this.layoutAry[1] = this.dsLabelRect;
            this.layoutAry[2] = this.lDatumRect;
            this.layoutAry[3] = this.addRDatum;
            this.layoutAry[4] = this.rScan;
            this.layoutAry[5] = null;
        } else {
            this.layoutAry[0] = this.lScan;
            this.layoutAry[1] = this.dsLabelRect;
            this.layoutAry[2] = this.lDatumRect;
            this.layoutAry[3] = this.toTextRect;
            this.layoutAry[4] = this.rDatumRect;
            this.layoutAry[5] = this.rScan;
        }
    }

    public void setInSingleMode(boolean inSingle) {
        this.inSingleMode = inSingle;
        this.setDsLabel(this.dsLabel);
        this.setSizingParams();
        this.setlayoutAry(inSingle);
        this.repaint();
    }

    public void resetInSingleMode() {
        if (this.datumRange.min().equals(this.datumRange.max())) {
            this.setInSingleMode(true);
        } else {
            this.setInSingleMode(false);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.inDebugMode) {
            Color cColor = g.getColor();
            g.setColor(Color.MAGENTA);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(cColor);
        }
        g.translate(-this.getX(), -this.getY());
        float fontMultiplier = 1.0f;
        g.setFont(g.getFont().deriveFont((float)g.getFont().getSize() * fontMultiplier));
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        this.setSizingParams();
        this.setLayout(this.inSingleMode, gtr);
        this.setlayoutAry(this.inSingleMode);
        for (TextRect tr : this.layoutAry) {
            if (tr == null) continue;
            try {
                tr.paint(gtr, g);
            }
            catch (Exception ex) {
                Logger.getLogger(RangeLabel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.showAnimation) {
            switch (this.animationMode) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    this.centerAnimation(g);
                    break;
                }
                default: {
                    System.err.println("Animation not set to valid state");
                }
            }
        }
    }

    private void setMouseRect(int x, int y) {
        x += this.getX();
        y += this.getY();
        TextRect trBuf = null;
        for (TextRect tr : this.layoutAry) {
            if (tr == null || !tr.rect.contains(x, y)) continue;
            trBuf = tr;
            trBuf.isShowing = true;
            break;
        }
        if (this.mouseRect != trBuf && this.mouseRect != null) {
            if (this.mouseRect != this.lDatumRect && this.mouseRect != this.rDatumRect && this.mouseRect != this.toTextRect && this.mouseRect != this.dsLabelRect) {
                this.mouseRect.isShowing = false;
            }
            this.repaint();
        }
        this.mouseRect = trBuf;
        if (this.mouseRect != null) {
            this.getCanvas().getGlassPane().setCursor(this.mouseRect.cursor);
            this.repaint();
        }
    }

    private MouseAdapter getMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RangeLabel.this.setMouseRect(e.getX(), e.getY());
                if (e.getButton() == 1) {
                    if (RangeLabel.this.mouseRect == RangeLabel.this.lScan) {
                        RangeLabel.this.scanLeft();
                    } else if (RangeLabel.this.mouseRect == RangeLabel.this.rScan) {
                        RangeLabel.this.scanRight();
                    } else if (RangeLabel.this.mouseRect == RangeLabel.this.addRDatum) {
                        RangeLabel.this.addRDatum();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RangeLabel.this.setMouseRect(e.getX(), e.getY());
                RangeLabel.this.pressedPoint = e.getPoint();
                RangeLabel.this.lastPoint = e.getPoint();
                if (e.getButton() == 1) {
                    RangeLabel.this.buttonPress = 1;
                    if (RangeLabel.this.mouseRect == RangeLabel.this.lDatumRect || RangeLabel.this.mouseRect == RangeLabel.this.rDatumRect || RangeLabel.this.mouseRect == RangeLabel.this.toTextRect) {
                        RangeLabel.this.isDragging = true;
                        if (!RangeLabel.this.inSingleMode) {
                            RangeLabel.this.startedDragAsRange = true;
                        } else {
                            RangeLabel.this.startedDragAsRange = false;
                        }
                    }
                } else if (e.getButton() == 2) {
                    RangeLabel.this.buttonPress = 2;
                    if (RangeLabel.this.mouseRect == RangeLabel.this.lDatumRect || RangeLabel.this.mouseRect == RangeLabel.this.rDatumRect || RangeLabel.this.mouseRect == RangeLabel.this.toTextRect) {
                        RangeLabel.this.isDragging = true;
                        RangeLabel.this.getCanvas().getGlassPane().setCursor(new Cursor(13));
                        System.err.println("middle button pressed");
                        if (!RangeLabel.this.inSingleMode) {
                            RangeLabel.this.startedDragAsRange = true;
                        } else {
                            RangeLabel.this.startedDragAsRange = false;
                        }
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int xUpdatingDrag = e.getX() - ((RangeLabel)RangeLabel.this).lastPoint.x;
                int xTotalDrag = e.getX() - ((RangeLabel)RangeLabel.this).pressedPoint.x;
                RangeLabel.this.lastPoint = e.getPoint();
                if (RangeLabel.this.buttonPress == 1) {
                    if (RangeLabel.this.mouseRect == RangeLabel.this.lDatumRect) {
                        RangeLabel.this.showAnimation = true;
                        RangeLabel.this.lDatumDrag(xUpdatingDrag, xTotalDrag);
                    } else if (RangeLabel.this.mouseRect == RangeLabel.this.rDatumRect) {
                        RangeLabel.this.showAnimation = true;
                        RangeLabel.this.rDatumDrag(xUpdatingDrag);
                    } else if (RangeLabel.this.mouseRect == RangeLabel.this.toTextRect) {
                        RangeLabel.this.showAnimation = true;
                        RangeLabel.this.middleButtonDrag(xUpdatingDrag);
                    }
                } else if (RangeLabel.this.buttonPress == 2 && (RangeLabel.this.mouseRect == RangeLabel.this.lDatumRect || RangeLabel.this.mouseRect == RangeLabel.this.rDatumRect || RangeLabel.this.mouseRect == RangeLabel.this.toTextRect)) {
                    RangeLabel.this.animationMode = 1;
                    RangeLabel.this.middleButtonDrag(xUpdatingDrag);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (RangeLabel.this.isDragging) {
                    RangeLabel.this.setDatumRange(RangeLabel.this.datumRange);
                    RangeLabel.this.isDragging = false;
                    RangeLabel.this.startedDragAsRange = false;
                    RangeLabel.this.showAnimation = false;
                }
                RangeLabel.this.resetInSingleMode();
                RangeLabel.this.setMouseRect(e.getX(), e.getY());
                RangeLabel.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!RangeLabel.this.isDragging) {
                    if (RangeLabel.this.mouseRect != RangeLabel.this.lDatumRect && RangeLabel.this.mouseRect != RangeLabel.this.toTextRect && RangeLabel.this.mouseRect != RangeLabel.this.rDatumRect && RangeLabel.this.mouseRect != RangeLabel.this.dsLabelRect && RangeLabel.this.mouseRect != null) {
                        ((RangeLabel)RangeLabel.this).mouseRect.isShowing = false;
                    }
                    RangeLabel.this.showAnimation = false;
                    RangeLabel.this.mouseRect = null;
                    RangeLabel.this.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!RangeLabel.this.isDragging) {
                    RangeLabel.this.setMouseRect(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (RangeLabel.this.mouseRect == RangeLabel.this.lDatumRect || RangeLabel.this.mouseRect == RangeLabel.this.toTextRect || RangeLabel.this.mouseRect == RangeLabel.this.rDatumRect) {
                    RangeLabel.this.wheelRotation(e.getWheelRotation());
                    RangeLabel.this.repaint();
                }
            }
        };
    }

    private void scanLeft() {
        if (this.inSingleMode) {
            Datum singleScanDatum = Datum.create((double)1.0, (Units)this.datumRange.getUnits());
            this.setDatumRange(new DatumRange(this.datumRange.min().subtract(singleScanDatum), this.datumRange.max().subtract(singleScanDatum)));
        } else {
            this.setDatumRange(this.datumRange.previous());
        }
    }

    private void scanRight() {
        if (this.inSingleMode) {
            Datum singleScanDatum = Datum.create((double)1.0, (Units)this.datumRange.getUnits());
            this.setDatumRange(new DatumRange(this.datumRange.min().add(singleScanDatum), this.datumRange.max().add(singleScanDatum)));
        } else {
            this.setDatumRange(this.datumRange.next());
        }
    }

    private void addRDatum() {
        this.setDatumRange(new DatumRange(this.datumRange.min(), this.validRange.max()));
        this.resetInSingleMode();
    }

    private void lDatumDrag(int xDrag, int xTotalDrag) {
        this.showAnimation = true;
        Datum dragDatum = this.scaleDragValue(xDrag);
        if (this.inSingleMode) {
            this.animationMode = 1;
            if (this.startedDragAsRange) {
                if (this.datumRange.min().add(dragDatum).gt(this.datumRange.max())) {
                    return;
                }
                this.setDatumRange(new DatumRange(this.datumRange.min().add(dragDatum), this.datumRange.max()));
                return;
            }
            this.setDatumRange(new DatumRange(this.datumRange.min().add(dragDatum), this.datumRange.min().add(dragDatum)));
        } else {
            this.animationMode = 1;
            Datum newLDatum = this.datumRange.min().add(dragDatum);
            if (newLDatum.gt(this.datumRange.max())) {
                this.setDatumRange(new DatumRange(this.datumRange.max(), this.datumRange.max()));
            } else {
                this.setDatumRange(new DatumRange(newLDatum, this.datumRange.max()));
            }
        }
    }

    private void rDatumDrag(int xDrag) {
        this.showAnimation = true;
        this.animationMode = 1;
        Datum dragDatum = this.scaleDragValue(xDrag);
        Datum newRDatum = this.datumRange.max().add(dragDatum);
        if (newRDatum.lt(this.datumRange.min())) {
            this.setDatumRange(new DatumRange(this.datumRange.min(), this.datumRange.min()));
        } else {
            this.setDatumRange(new DatumRange(this.datumRange.min(), newRDatum));
        }
    }

    private void middleButtonDrag(int xDrag) {
        this.showAnimation = true;
        this.animationMode = 1;
        Datum dragDatum = this.scaleDragValue(xDrag);
        DatumRange checkRange = new DatumRange(this.datumRange.min().add(dragDatum), this.datumRange.max().add(dragDatum));
        if (checkRange.min().lt(this.validRange.min()) || checkRange.max().gt(this.validRange.max())) {
            return;
        }
        this.setDatumRange(checkRange);
    }

    private void wheelRotation(int amount) {
        Datum datumAmount = this.scaleDragValue(amount);
        if (this.inSingleMode) {
            this.setDatumRange(new DatumRange(this.datumRange.min().add(datumAmount), this.datumRange.min().add(datumAmount)));
        } else if (amount > 0) {
            this.setDatumRange(new DatumRange(this.datumRange.min().subtract(datumAmount), this.datumRange.max().add(datumAmount)));
        } else if (amount < 0 && (this.datumRange.max().add(datumAmount).gt(this.datumRange.min().subtract(datumAmount)) || this.datumRange.min().subtract(datumAmount).lt(this.datumRange.max().add(datumAmount)))) {
            this.setDatumRange(new DatumRange(this.datumRange.min().subtract(datumAmount), this.datumRange.max().add(datumAmount)));
        }
    }

    public DatumRange getValidRange() {
        return this.validRange;
    }

    public final void setValidRange(DatumRange validRange) {
        this.validRange = validRange;
    }

    private void centerAnimation(Graphics g) {
        Units units = this.validRange.getUnits().getOffsetUnits();
        TextRect lRectForAnim = this.dsLabelRect;
        TextRect rRectForAnim = this.rScan;
        int textBaseLine = this.lDatumRect.rect.y + (int)this.getEmSize();
        int startX = lRectForAnim.rect.x;
        int endX = rRectForAnim.rect.x;
        g.drawOval(startX, textBaseLine, this.ovalSize, this.ovalSize);
        g.drawOval(endX, textBaseLine, this.ovalSize, this.ovalSize);
        g.drawLine(startX + this.halfOvalSize, textBaseLine + this.halfOvalSize, endX + this.halfOvalSize, textBaseLine + this.halfOvalSize);
        int width = endX - startX;
        double dataWidth = this.validRange.width().doubleValue(units);
        double pixPerData = (double)width / dataWidth;
        double lDist = this.datumRange.min().subtract(this.validRange.min()).doubleValue(units);
        int lDatumLineX = (int)(lDist * pixPerData);
        double rDist = this.datumRange.max().subtract(this.validRange.min()).doubleValue(units);
        int rDatumLineX = (int)(rDist * pixPerData);
        int datIndicatorHeight = (int)(this.getEmSize() / 4.0);
        g.drawLine(lDatumLineX += startX + this.halfOvalSize, textBaseLine + this.halfOvalSize, lDatumLineX, textBaseLine + this.halfOvalSize + datIndicatorHeight);
        g.drawLine(rDatumLineX += startX + this.halfOvalSize, textBaseLine + this.halfOvalSize, rDatumLineX, textBaseLine + this.halfOvalSize + datIndicatorHeight);
        Color curCol = g.getColor();
        g.setColor(Color.gray);
        g.fillRect(lDatumLineX, textBaseLine + this.halfOvalSize, rDatumLineX - lDatumLineX, datIndicatorHeight);
        g.setColor(curCol);
    }

    private Datum scaleDragValue(int xDrag) {
        return this.validRange.width().multiply((double)xDrag / (double)this.layoutWidth);
    }

    public void addDataRangeSelectionListener(DataRangeSelectionListener drsl) {
        this.listenerList.add(DataRangeSelectionListener.class, drsl);
    }

    public void removeDataRangeSelectionListener(DataRangeSelectionListener drsl) {
        this.listenerList.remove(DataRangeSelectionListener.class, drsl);
    }

    private void fireDataRangeSelection() {
        DataRangeSelectionEvent drse = new DataRangeSelectionEvent(this, this.datumRange.min(), this.datumRange.max());
        for (DataRangeSelectionListener d : (DataRangeSelectionListener[])this.listenerList.getListeners(DataRangeSelectionListener.class)) {
            d.dataRangeSelected(drse);
        }
    }

    class TextRect {
        String text;
        int lPixel;
        int rPixel;
        Cursor cursor = new Cursor(0);
        Rectangle rect;
        boolean isShowing = false;

        private int getPixelWidth() {
            return this.rPixel - this.lPixel;
        }

        protected void setRect() {
            this.rect.setBounds(this.lPixel + RangeLabel.this.colMin, RangeLabel.this.rowMin - (int)(2.0 * RangeLabel.this.getEmSize()) - (int)(RangeLabel.this.offsetFromPlot * RangeLabel.this.getEmSize()), this.getPixelWidth(), (int)(2.0 * RangeLabel.this.getEmSize()));
        }

        public TextRect(String text, Rectangle rect) {
            this.text = text;
            this.rect = rect;
        }

        public TextRect(String text, Rectangle rect, Cursor c) {
            this(text, rect);
            this.cursor = c;
        }

        private void paint(GrannyTextRenderer gtr, Graphics g) throws Exception {
            gtr.setString(g, this.text);
            if (this.isShowing) {
                if (RangeLabel.this.verticalAlignment == VerticalAlignment.TOP) {
                    gtr.draw(g, (float)this.rect.x, (float)(RangeLabel.this.rowMin - (int)RangeLabel.this.getEmSize() - (int)(RangeLabel.this.offsetFromPlot * RangeLabel.this.getEmSize())));
                }
                if (this == RangeLabel.this.addRDatum || this == RangeLabel.this.lScan || this == RangeLabel.this.rScan) {
                    g.drawRect(this.rect.x, this.rect.y, this.rect.width - 1, this.rect.height - (int)(0.6 * RangeLabel.this.getEmSize()));
                }
            }
            if (RangeLabel.this.inDebugMode) {
                g.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height - 1);
                if (RangeLabel.this.mouseRect == this) {
                    g.setColor(new Color(0.5f, 0.5f, 0.0f, 0.2f));
                    g.fillRect(((RangeLabel)RangeLabel.this).mouseRect.rect.x, ((RangeLabel)RangeLabel.this).mouseRect.rect.y, ((RangeLabel)RangeLabel.this).mouseRect.rect.width, ((RangeLabel)RangeLabel.this).mouseRect.rect.height);
                    g.setColor(Color.black);
                }
            }
        }
    }

    public static enum VerticalAlignment {
        TOP,
        BOTTOM;

    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

