/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import java.awt.Color;
import org.das2.math.Circle;
import org.das2.math.Edge;
import org.das2.math.Int;
import org.das2.math.RealPoint;
import org.das2.math.RealWindow;
import org.das2.math.RealWindowGraphics;
import org.das2.math.Triangulation;
import org.das2.math.TriangulationAlgorithm;
import org.das2.math.Vector;

class CubicAlgorithm
extends TriangulationAlgorithm {
    int s;
    int t;
    int u;
    int i;
    Circle bC = new Circle();
    static final String algName = "O(n^3)";
    int nFaces;

    public CubicAlgorithm(Triangulation t, RealWindow w, int nPoints) {
        super(t, w, algName, nPoints);
    }

    @Override
    public void reset() {
        this.nFaces = 0;
        this.triCanvas.needToClear = true;
        super.reset();
    }

    @Override
    public void draw(RealWindowGraphics rWG, Triangulation tri) {
        if (this.state[2]) {
            if (this.aniControl.animate(1)) {
                rWG.drawTriangle(tri.point[this.s], tri.point[this.t], tri.point[this.u], Color.green);
                rWG.drawLine(tri.point[this.s], tri.point[this.t], Color.blue);
            }
            if (this.aniControl.animate(3)) {
                rWG.drawCircle(this.bC, Color.green);
            }
        } else if (this.state[1]) {
            if (this.aniControl.animate(2)) {
                rWG.drawPoint(tri.point[this.i], Color.orange);
            }
        } else if (this.state[4]) {
            if (this.aniControl.animate(1)) {
                rWG.drawTriangle(tri.point[this.s], tri.point[this.t], tri.point[this.u], Color.red);
                rWG.drawLine(tri.point[this.s], tri.point[this.t], Color.blue);
            }
            if (this.aniControl.animate(3)) {
                rWG.drawCircle(this.bC, Color.red);
            }
            if (this.aniControl.animate(2)) {
                rWG.drawPoint(tri.point[this.s], Color.red);
            }
        } else if (this.state[0]) {
            tri.draw(rWG, Color.black, Color.black);
        } else {
            tri.draw(rWG, Color.black, Color.black);
        }
    }

    @Override
    public synchronized void triangulate(Triangulation tri) {
        int nFaces = 0;
        Int s = new Int();
        Int t = new Int();
        this.findClosestNeighbours(tri.point, tri.nPoints, s, t);
        int seedEdge = tri.addEdge(s.getValue(), t.getValue(), -1, -1);
        for (int currentEdge = 0; currentEdge < tri.nEdges; ++currentEdge) {
            if (tri.edge[currentEdge].l == -1) {
                this.completeFacet(currentEdge, tri, nFaces);
                this.animate(0);
            }
            if (tri.edge[currentEdge].r != -1) continue;
            this.completeFacet(currentEdge, tri, nFaces);
            this.animate(0);
        }
    }

    public void findClosestNeighbours(RealPoint[] p, int nPoints, Int u, Int v) {
        int t = 0;
        int s = 0;
        float min = Float.MAX_VALUE;
        for (int i = 0; i < nPoints - 1; ++i) {
            for (int j = i + 1; j < nPoints; ++j) {
                float d = p[i].distanceSq(p[j]);
                if (!(d < min)) continue;
                s = i;
                t = j;
                min = d;
            }
        }
        u.setValue(s);
        v.setValue(t);
    }

    public void completeFacet(int eI, Triangulation tri, int nFaces) {
        Edge[] e = tri.edge;
        RealPoint[] p = tri.point;
        if (e[eI].l == -1) {
            this.s = e[eI].s;
            this.t = e[eI].t;
        } else if (e[eI].r == -1) {
            this.s = e[eI].t;
            this.t = e[eI].s;
        } else {
            return;
        }
        this.u = 0;
        while (this.u < tri.nPoints) {
            if (this.u != this.s && this.u != this.t && (double)Vector.crossProduct(p[this.s], p[this.t], p[this.u]) > 0.0) {
                this.bC.circumCircle(p[this.s], p[this.t], p[this.u]);
                this.animate(2);
                boolean pointFree = true;
                this.i = 0;
                while (this.i < tri.nPoints) {
                    if (this.i != this.s && this.i != this.t && this.i != this.u) {
                        this.animate(1);
                        float cP = Vector.crossProduct(p[this.s], p[this.t], p[this.i]);
                        if ((double)cP > 0.0 && this.bC.inside(p[this.i])) {
                            this.animate(4);
                            pointFree = false;
                            break;
                        }
                    }
                    ++this.i;
                }
                this.animate(0);
                if (pointFree) break;
            }
            ++this.u;
        }
        if (this.u < tri.nPoints) {
            int bP = this.u;
            tri.updateLeftFace(eI, this.s, this.t, nFaces);
            ++nFaces;
            eI = tri.findEdge(bP, this.s);
            if (eI == -1) {
                eI = tri.addEdge(bP, this.s, nFaces, -1);
            } else {
                tri.updateLeftFace(eI, bP, this.s, nFaces);
            }
            eI = tri.findEdge(this.t, bP);
            if (eI == -1) {
                eI = tri.addEdge(this.t, bP, nFaces, -1);
            } else {
                tri.updateLeftFace(eI, this.t, bP, nFaces);
            }
        } else {
            tri.updateLeftFace(eI, this.s, this.t, 0);
        }
    }
}

