/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import java.util.Random;

public class PoissonDistribution {
    private static final Fac fac = new Fac();
    static PoissonInver poissonInver = new PoissonInver();
    static PoissonRatioUniforms poissonRatioUniforms = new PoissonRatioUniforms();

    public static int poisson(double L, Random random) {
        if (L < 17.0) {
            if (L < 1.0E-6) {
                if (L == 0.0) {
                    return 0;
                }
                if (L < 0.0) {
                    throw new IllegalArgumentException("Parameter negative in poisson function");
                }
                return PoissonDistribution.PoissonLow(L, random);
            }
            return PoissonDistribution.poissonInver.PoissonInver(L, random);
        }
        if (L > 2.0E9) {
            throw new IllegalArgumentException("Parameter too big in poisson function");
        }
        return PoissonDistribution.poissonRatioUniforms.PoissonRatioUniforms(L, random);
    }

    private static int PoissonLow(double L, Random random) {
        double d = Math.sqrt(L);
        if (random.nextDouble() >= d) {
            return 0;
        }
        double r = random.nextDouble() * d;
        if (r > L * (1.0 - L)) {
            return 0;
        }
        if (r > 0.5 * L * L * (1.0 - L)) {
            return 1;
        }
        return 2;
    }

    private static class PoissonRatioUniforms {
        private final double SHAT1 = 2.9430355293715387;
        private final double SHAT2 = 0.8989161620588988;
        private static double p_L_last = -1.0;
        private static double p_a;
        private static double p_h;
        private static double p_g;
        private static double p_q;
        private static int p_bound;
        private static int mode;

        private PoissonRatioUniforms() {
        }

        private int PoissonRatioUniforms(double L, Random random) {
            int k;
            double lf;
            double x;
            double u;
            if (p_L_last != L) {
                p_L_last = L;
                p_a = L + 0.5;
                mode = (int)L;
                p_g = Math.log(L);
                p_q = (double)mode * p_g - fac.lnFac(mode);
                p_h = Math.sqrt(2.9430355293715387 * (L + 0.5)) + 0.8989161620588988;
                p_bound = (int)(p_a + 6.0 * p_h);
            }
            while ((u = random.nextDouble()) == 0.0 || (x = p_a + p_h * (random.nextDouble() - 0.5) / u) < 0.0 || x >= (double)p_bound || !((lf = (double)(k = (int)x) * p_g - fac.lnFac(k) - p_q) >= u * (4.0 - u) - 3.0) && (u * (u - lf) > 1.0 || !(2.0 * Math.log(u) <= lf))) {
            }
            return k;
        }
    }

    private static class PoissonInver {
        double p_L_last = -1.0;
        double p_f0;

        private PoissonInver() {
        }

        private int PoissonInver(double L, Random random) {
            int bound = 130;
            if (L != this.p_L_last) {
                this.p_L_last = L;
                this.p_f0 = Math.exp(-L);
            }
            while (true) {
                double r = random.nextDouble();
                int x = 0;
                double f = this.p_f0;
                do {
                    if ((r -= f) <= 0.0) {
                        return x;
                    }
                    f *= L;
                    r *= (double)(++x);
                } while (x <= 130);
            }
        }
    }

    private static class Fac {
        private static final int FAK_LEN = 1024;
        private final double[] fac_table = new double[1024];
        private static boolean initialized = false;
        private final double C0 = 0.9189385332046727;
        private final double C1 = 0.08333333333333333;
        private final double C3 = -0.002777777777777778;

        Fac() {
        }

        private void init() {
            this.fac_table[0] = 0.0;
            double sum = 0.0;
            for (int i = 1; i < 1024; ++i) {
                this.fac_table[i] = sum += Math.log(i);
            }
            initialized = true;
        }

        public double lnFac(int n) {
            if (n < 1024) {
                if (n <= 1) {
                    if (n < 0) {
                        throw new IllegalArgumentException("Parameter negative in LnFac function");
                    }
                    return 0.0;
                }
                if (!initialized) {
                    this.init();
                }
                return this.fac_table[n];
            }
            double n1 = n;
            double r = 1.0 / n1;
            return (n1 + 0.5) * Math.log(n1) - n1 + 0.9189385332046727 + r * (0.08333333333333333 + r * r * -0.002777777777777778);
        }
    }
}

