/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math.fft.jnt;

import org.das2.math.fft.ComplexArray;
import org.das2.math.fft.jnt.ComplexDoubleFFT;
import org.das2.math.fft.jnt.Factorize;

public class ComplexDoubleFFT_Mixed
extends ComplexDoubleFFT {
    static final double PI = Math.PI;
    private int[] factors;
    private double[][][] twiddle;
    private int[] available_factors = new int[]{7, 6, 5, 4, 3, 2};

    public ComplexDoubleFFT_Mixed(int n) {
        super(n);
        this.setup_wavetable(n);
    }

    @Override
    public void transform(ComplexArray.Double data, int i0, int stride) {
        this.checkData(data, i0, stride);
        this.transform_internal(data, i0, stride, -1);
    }

    @Override
    public void backtransform(ComplexArray.Double data, int i0, int stride) {
        this.checkData(data, i0, stride);
        this.transform_internal(data, i0, stride, 1);
    }

    void setup_wavetable(int n) {
        if (n <= 0) {
            throw new Error("length must be positive integer : " + n);
        }
        this.n = n;
        this.factors = Factorize.factor(n, this.available_factors);
        double d_theta = Math.PI * -2 / (double)n;
        int product = 1;
        this.twiddle = new double[this.factors.length][][];
        for (int i = 0; i < this.factors.length; ++i) {
            int factor = this.factors[i];
            int product_1 = product;
            int q = n / (product *= factor);
            this.twiddle[i] = new double[q + 1][2 * (factor - 1)];
            double[][] twid = this.twiddle[i];
            for (int j = 1; j < factor; ++j) {
                twid[0][2 * (j - 1)] = 1.0;
                twid[0][2 * (j - 1) + 1] = 0.0;
            }
            for (int k = 1; k <= q; ++k) {
                int m = 0;
                for (int j = 1; j < factor; ++j) {
                    m += k * product_1;
                    double theta = d_theta * (double)(m %= n);
                    twid[k][2 * (j - 1)] = Math.cos(theta);
                    twid[k][2 * (j - 1) + 1] = Math.sin(theta);
                }
            }
        }
    }

    void transform_internal(ComplexArray.Double data, int i0, int stride, int sign) {
        int i;
        if (this.n == 1) {
            return;
        }
        ComplexArray.Double scratch = ComplexArray.newArray(new double[this.n], new double[this.n]);
        int product = 1;
        boolean state = false;
        block8: for (i = 0; i < this.factors.length; ++i) {
            int ostride;
            int out0;
            ComplexArray.Double out;
            int istride;
            int in0;
            ComplexArray.Double in;
            int factor = this.factors[i];
            product *= factor;
            if (!state) {
                in = data;
                in0 = i0;
                istride = stride;
                out = scratch;
                out0 = 0;
                ostride = 1;
                state = true;
            } else {
                in = scratch;
                in0 = 0;
                istride = 1;
                out = data;
                out0 = i0;
                ostride = stride;
                state = false;
            }
            switch (factor) {
                case 2: {
                    this.pass_2(i, in, in0, istride, out, out0, ostride, sign, product);
                    continue block8;
                }
                case 3: {
                    this.pass_3(i, in, in0, istride, out, out0, ostride, sign, product);
                    continue block8;
                }
                case 4: {
                    this.pass_4(i, in, in0, istride, out, out0, ostride, sign, product);
                    continue block8;
                }
                case 5: {
                    this.pass_5(i, in, in0, istride, out, out0, ostride, sign, product);
                    continue block8;
                }
                case 6: {
                    this.pass_6(i, in, in0, istride, out, out0, ostride, sign, product);
                    continue block8;
                }
                case 7: {
                    this.pass_7(i, in, in0, istride, out, out0, ostride, sign, product);
                    continue block8;
                }
                default: {
                    this.pass_n(i, in, in0, istride, out, out0, ostride, sign, factor, product);
                }
            }
        }
        if (state) {
            for (i = 0; i < this.n; ++i) {
                data.setReal(i0 + stride * i, scratch.getReal(i));
                data.setImag(i0 + stride * i, scratch.getImag(i));
            }
        }
    }

    void pass_2(int fi, ComplexArray.Double in, int in0, int istride, ComplexArray.Double out, int out0, int ostride, int sign, int product) {
        int factor = 2;
        int m = this.n / factor;
        int q = this.n / product;
        int product_1 = product / factor;
        int di = istride * m;
        int dj = ostride * product_1;
        int i = in0;
        int j = out0;
        for (int k = 0; k < q; ++k) {
            double[] twids = this.twiddle[fi][k];
            double w_real = twids[0];
            double w_imag = (double)(-sign) * twids[1];
            for (int k1 = 0; k1 < product_1; ++k1) {
                double z0_real = in.getReal(i);
                double z0_imag = in.getImag(i);
                double z1_real = in.getReal(i + di);
                double z1_imag = in.getImag(i + di);
                i += istride;
                out.setReal(j, z0_real + z1_real);
                out.setImag(j, z0_imag + z1_imag);
                double x_real = z0_real - z1_real;
                double x_imag = z0_imag - z1_imag;
                out.setReal(j + dj, w_real * x_real - w_imag * x_imag);
                out.setImag(j + dj, w_real * x_imag + w_imag * x_real);
                j += ostride;
            }
            j += (factor - 1) * dj;
        }
    }

    void pass_3(int fi, ComplexArray.Double in, int in0, int istride, ComplexArray.Double out, int out0, int ostride, int sign, int product) {
        int factor = 3;
        int m = this.n / factor;
        int q = this.n / product;
        int product_1 = product / factor;
        int jump = (factor - 1) * product_1;
        double tau = (double)sign * Math.sqrt(3.0) / 2.0;
        int di = istride * m;
        int dj = ostride * product_1;
        int i = in0;
        int j = out0;
        for (int k = 0; k < q; ++k) {
            double[] twids = this.twiddle[fi][k];
            double w1_real = twids[0];
            double w1_imag = (double)(-sign) * twids[1];
            double w2_real = twids[2];
            double w2_imag = (double)(-sign) * twids[3];
            for (int k1 = 0; k1 < product_1; ++k1) {
                double z0_real = in.getReal(i);
                double z0_imag = in.getImag(i);
                double z1_real = in.getReal(i + di);
                double z1_imag = in.getImag(i + di);
                double z2_real = in.getReal(i + 2 * di);
                double z2_imag = in.getImag(i + 2 * di);
                i += istride;
                double t1_real = z1_real + z2_real;
                double t1_imag = z1_imag + z2_imag;
                double t2_real = z0_real - t1_real / 2.0;
                double t2_imag = z0_imag - t1_imag / 2.0;
                double t3_real = tau * (z1_real - z2_real);
                double t3_imag = tau * (z1_imag - z2_imag);
                out.setReal(j, z0_real + t1_real);
                out.setImag(j, z0_imag + t1_imag);
                double x_real = t2_real - t3_imag;
                double x_imag = t2_imag + t3_real;
                out.setReal(j + dj, w1_real * x_real - w1_imag * x_imag);
                out.setImag(j + dj, w1_real * x_imag + w1_imag * x_real);
                x_real = t2_real + t3_imag;
                x_imag = t2_imag - t3_real;
                out.setReal(j + 2 * dj, w2_real * x_real - w2_imag * x_imag);
                out.setImag(j + 2 * dj, w2_real * x_imag + w2_imag * x_real);
                j += ostride;
            }
            j += (factor - 1) * dj;
        }
    }

    void pass_4(int fi, ComplexArray.Double in, int in0, int istride, ComplexArray.Double out, int out0, int ostride, int sign, int product) {
        int factor = 4;
        int m = this.n / factor;
        int q = this.n / product;
        int p_1 = product / factor;
        int jump = (factor - 1) * p_1;
        int i = in0;
        int j = out0;
        int di = istride * m;
        int dj = ostride * p_1;
        for (int k = 0; k < q; ++k) {
            double[] twids = this.twiddle[fi][k];
            double w1_real = twids[0];
            double w1_imag = (double)(-sign) * twids[1];
            double w2_real = twids[2];
            double w2_imag = (double)(-sign) * twids[3];
            double w3_real = twids[4];
            double w3_imag = (double)(-sign) * twids[5];
            for (int k1 = 0; k1 < p_1; ++k1) {
                double z0_real = in.getReal(i);
                double z0_imag = in.getImag(i);
                double z1_real = in.getReal(i + di);
                double z1_imag = in.getImag(i + di);
                double z2_real = in.getReal(i + 2 * di);
                double z2_imag = in.getImag(i + 2 * di);
                double z3_real = in.getReal(i + 3 * di);
                double z3_imag = in.getImag(i + 3 * di);
                i += istride;
                double t1_real = z0_real + z2_real;
                double t1_imag = z0_imag + z2_imag;
                double t2_real = z1_real + z3_real;
                double t2_imag = z1_imag + z3_imag;
                double t3_real = z0_real - z2_real;
                double t3_imag = z0_imag - z2_imag;
                double t4_real = (double)sign * (z1_real - z3_real);
                double t4_imag = (double)sign * (z1_imag - z3_imag);
                out.setReal(j, t1_real + t2_real);
                out.setImag(j, t1_imag + t2_imag);
                double x_real = t3_real - t4_imag;
                double x_imag = t3_imag + t4_real;
                out.setReal(j + dj, w1_real * x_real - w1_imag * x_imag);
                out.setImag(j + dj, w1_real * x_imag + w1_imag * x_real);
                x_real = t1_real - t2_real;
                x_imag = t1_imag - t2_imag;
                out.setReal(j + 2 * dj, w2_real * x_real - w2_imag * x_imag);
                out.setImag(j + 2 * dj, w2_real * x_imag + w2_imag * x_real);
                x_real = t3_real + t4_imag;
                x_imag = t3_imag - t4_real;
                out.setReal(j + 3 * dj, w3_real * x_real - w3_imag * x_imag);
                out.setImag(j + 3 * dj, w3_real * x_imag + w3_imag * x_real);
                j += ostride;
            }
            j += (factor - 1) * dj;
        }
    }

    void pass_5(int fi, ComplexArray.Double in, int in0, int istride, ComplexArray.Double out, int out0, int ostride, int sign, int product) {
        int factor = 5;
        int m = this.n / factor;
        int q = this.n / product;
        int p_1 = product / factor;
        int jump = (factor - 1) * p_1;
        double tau = Math.sqrt(5.0) / 4.0;
        double sin_2pi_by_5 = (double)sign * Math.sin(1.2566370614359172);
        double sin_2pi_by_10 = (double)sign * Math.sin(0.6283185307179586);
        int i = in0;
        int j = out0;
        int di = istride * m;
        int dj = ostride * p_1;
        for (int k = 0; k < q; ++k) {
            double[] twids = this.twiddle[fi][k];
            double w1_real = twids[0];
            double w1_imag = (double)(-sign) * twids[1];
            double w2_real = twids[2];
            double w2_imag = (double)(-sign) * twids[3];
            double w3_real = twids[4];
            double w3_imag = (double)(-sign) * twids[5];
            double w4_real = twids[6];
            double w4_imag = (double)(-sign) * twids[7];
            for (int k1 = 0; k1 < p_1; ++k1) {
                double z0_real = in.getReal(i);
                double z0_imag = in.getImag(i);
                double z1_real = in.getReal(i + di);
                double z1_imag = in.getImag(i + di);
                double z2_real = in.getReal(i + 2 * di);
                double z2_imag = in.getImag(i + 2 * di);
                double z3_real = in.getReal(i + 3 * di);
                double z3_imag = in.getImag(i + 3 * di);
                double z4_real = in.getReal(i + 4 * di);
                double z4_imag = in.getImag(i + 4 * di);
                i += istride;
                double t1_real = z1_real + z4_real;
                double t1_imag = z1_imag + z4_imag;
                double t2_real = z2_real + z3_real;
                double t2_imag = z2_imag + z3_imag;
                double t3_real = z1_real - z4_real;
                double t3_imag = z1_imag - z4_imag;
                double t4_real = z2_real - z3_real;
                double t4_imag = z2_imag - z3_imag;
                double t5_real = t1_real + t2_real;
                double t5_imag = t1_imag + t2_imag;
                double t6_real = tau * (t1_real - t2_real);
                double t6_imag = tau * (t1_imag - t2_imag);
                double t7_real = z0_real - t5_real / 4.0;
                double t7_imag = z0_imag - t5_imag / 4.0;
                double t8_real = t7_real + t6_real;
                double t8_imag = t7_imag + t6_imag;
                double t9_real = t7_real - t6_real;
                double t9_imag = t7_imag - t6_imag;
                double t10_real = sin_2pi_by_5 * t3_real + sin_2pi_by_10 * t4_real;
                double t10_imag = sin_2pi_by_5 * t3_imag + sin_2pi_by_10 * t4_imag;
                double t11_real = sin_2pi_by_10 * t3_real - sin_2pi_by_5 * t4_real;
                double t11_imag = sin_2pi_by_10 * t3_imag - sin_2pi_by_5 * t4_imag;
                out.setReal(j, z0_real + t5_real);
                out.setImag(j, z0_imag + t5_imag);
                double x_real = t8_real - t10_imag;
                double x_imag = t8_imag + t10_real;
                out.setReal(j + dj, w1_real * x_real - w1_imag * x_imag);
                out.setImag(j + dj, w1_real * x_imag + w1_imag * x_real);
                x_real = t9_real - t11_imag;
                x_imag = t9_imag + t11_real;
                out.setReal(j + 2 * dj, w2_real * x_real - w2_imag * x_imag);
                out.setImag(j + 2 * dj, w2_real * x_imag + w2_imag * x_real);
                x_real = t9_real + t11_imag;
                x_imag = t9_imag - t11_real;
                out.setReal(j + 3 * dj, w3_real * x_real - w3_imag * x_imag);
                out.setImag(j + 3 * dj, w3_real * x_imag + w3_imag * x_real);
                x_real = t8_real + t10_imag;
                x_imag = t8_imag - t10_real;
                out.setReal(j + 4 * dj, w4_real * x_real - w4_imag * x_imag);
                out.setImag(j + 4 * dj, w4_real * x_imag + w4_imag * x_real);
                j += ostride;
            }
            j += (factor - 1) * dj;
        }
    }

    void pass_6(int fi, ComplexArray.Double in, int in0, int istride, ComplexArray.Double out, int out0, int ostride, int sign, int product) {
        int factor = 6;
        int m = this.n / factor;
        int q = this.n / product;
        int p_1 = product / factor;
        int jump = (factor - 1) * p_1;
        double tau = (double)sign * Math.sqrt(3.0) / 2.0;
        int i = in0;
        int j = out0;
        int di = istride * m;
        int dj = ostride * p_1;
        for (int k = 0; k < q; ++k) {
            double[] twids = this.twiddle[fi][k];
            double w1_real = twids[0];
            double w1_imag = (double)(-sign) * twids[1];
            double w2_real = twids[2];
            double w2_imag = (double)(-sign) * twids[3];
            double w3_real = twids[4];
            double w3_imag = (double)(-sign) * twids[5];
            double w4_real = twids[6];
            double w4_imag = (double)(-sign) * twids[7];
            double w5_real = twids[8];
            double w5_imag = (double)(-sign) * twids[9];
            for (int k1 = 0; k1 < p_1; ++k1) {
                double z0_real = in.getReal(i);
                double z0_imag = in.getImag(i);
                double z1_real = in.getReal(i + di);
                double z1_imag = in.getImag(i + di);
                double z2_real = in.getReal(i + 2 * di);
                double z2_imag = in.getImag(i + 2 * di);
                double z3_real = in.getReal(i + 3 * di);
                double z3_imag = in.getImag(i + 3 * di);
                double z4_real = in.getReal(i + 4 * di);
                double z4_imag = in.getImag(i + 4 * di);
                double z5_real = in.getReal(i + 5 * di);
                double z5_imag = in.getImag(i + 5 * di);
                i += istride;
                double ta1_real = z2_real + z4_real;
                double ta1_imag = z2_imag + z4_imag;
                double ta2_real = z0_real - ta1_real / 2.0;
                double ta2_imag = z0_imag - ta1_imag / 2.0;
                double ta3_real = tau * (z2_real - z4_real);
                double ta3_imag = tau * (z2_imag - z4_imag);
                double a0_real = z0_real + ta1_real;
                double a0_imag = z0_imag + ta1_imag;
                double a1_real = ta2_real - ta3_imag;
                double a1_imag = ta2_imag + ta3_real;
                double a2_real = ta2_real + ta3_imag;
                double a2_imag = ta2_imag - ta3_real;
                double tb1_real = z5_real + z1_real;
                double tb1_imag = z5_imag + z1_imag;
                double tb2_real = z3_real - tb1_real / 2.0;
                double tb2_imag = z3_imag - tb1_imag / 2.0;
                double tb3_real = tau * (z5_real - z1_real);
                double tb3_imag = tau * (z5_imag - z1_imag);
                double b0_real = z3_real + tb1_real;
                double b0_imag = z3_imag + tb1_imag;
                double b1_real = tb2_real - tb3_imag;
                double b1_imag = tb2_imag + tb3_real;
                double b2_real = tb2_real + tb3_imag;
                double b2_imag = tb2_imag - tb3_real;
                out.setReal(j, a0_real + b0_real);
                out.setImag(j, a0_imag + b0_imag);
                double x_real = a1_real - b1_real;
                double x_imag = a1_imag - b1_imag;
                out.setReal(j + dj, w1_real * x_real - w1_imag * x_imag);
                out.setImag(j + dj, w1_real * x_imag + w1_imag * x_real);
                x_real = a2_real + b2_real;
                x_imag = a2_imag + b2_imag;
                out.setReal(j + 2 * dj, w2_real * x_real - w2_imag * x_imag);
                out.setImag(j + 2 * dj, w2_real * x_imag + w2_imag * x_real);
                x_real = a0_real - b0_real;
                x_imag = a0_imag - b0_imag;
                out.setReal(j + 3 * dj, w3_real * x_real - w3_imag * x_imag);
                out.setImag(j + 3 * dj, w3_real * x_imag + w3_imag * x_real);
                x_real = a1_real + b1_real;
                x_imag = a1_imag + b1_imag;
                out.setReal(j + 4 * dj, w4_real * x_real - w4_imag * x_imag);
                out.setImag(j + 4 * dj, w4_real * x_imag + w4_imag * x_real);
                x_real = a2_real - b2_real;
                x_imag = a2_imag - b2_imag;
                out.setReal(j + 5 * dj, w5_real * x_real - w5_imag * x_imag);
                out.setImag(j + 5 * dj, w5_real * x_imag + w5_imag * x_real);
                j += ostride;
            }
            j += (factor - 1) * dj;
        }
    }

    void pass_7(int fi, ComplexArray.Double in, int in0, int istride, ComplexArray.Double out, int out0, int ostride, int sign, int product) {
        int factor = 7;
        int m = this.n / factor;
        int q = this.n / product;
        int p_1 = product / factor;
        int jump = (factor - 1) * p_1;
        double c1 = Math.cos(0.8975979010256552);
        double c2 = Math.cos(1.7951958020513104);
        double c3 = Math.cos(2.6927937030769655);
        double s1 = (double)(-sign) * Math.sin(0.8975979010256552);
        double s2 = (double)(-sign) * Math.sin(1.7951958020513104);
        double s3 = (double)(-sign) * Math.sin(2.6927937030769655);
        int i = in0;
        int j = out0;
        int di = istride * m;
        int dj = ostride * p_1;
        for (int k = 0; k < q; ++k) {
            double[] twids = this.twiddle[fi][k];
            double w1_real = twids[0];
            double w1_imag = (double)(-sign) * twids[1];
            double w2_real = twids[2];
            double w2_imag = (double)(-sign) * twids[3];
            double w3_real = twids[4];
            double w3_imag = (double)(-sign) * twids[5];
            double w4_real = twids[6];
            double w4_imag = (double)(-sign) * twids[7];
            double w5_real = twids[8];
            double w5_imag = (double)(-sign) * twids[9];
            double w6_real = twids[10];
            double w6_imag = (double)(-sign) * twids[11];
            for (int k1 = 0; k1 < p_1; ++k1) {
                double z0_real = in.getReal(i);
                double z0_imag = in.getImag(i);
                double z1_real = in.getReal(i + di);
                double z1_imag = in.getImag(i + di);
                double z2_real = in.getReal(i + 2 * di);
                double z2_imag = in.getImag(i + 2 * di);
                double z3_real = in.getReal(i + 3 * di);
                double z3_imag = in.getImag(i + 3 * di);
                double z4_real = in.getReal(i + 4 * di);
                double z4_imag = in.getImag(i + 4 * di);
                double z5_real = in.getReal(i + 5 * di);
                double z5_imag = in.getImag(i + 5 * di);
                double z6_real = in.getReal(i + 6 * di);
                double z6_imag = in.getImag(i + 6 * di);
                i += istride;
                double t0_real = z1_real + z6_real;
                double t0_imag = z1_imag + z6_imag;
                double t1_real = z1_real - z6_real;
                double t1_imag = z1_imag - z6_imag;
                double t2_real = z2_real + z5_real;
                double t2_imag = z2_imag + z5_imag;
                double t3_real = z2_real - z5_real;
                double t3_imag = z2_imag - z5_imag;
                double t4_real = z4_real + z3_real;
                double t4_imag = z4_imag + z3_imag;
                double t5_real = z4_real - z3_real;
                double t5_imag = z4_imag - z3_imag;
                double t6_real = t2_real + t0_real;
                double t6_imag = t2_imag + t0_imag;
                double t7_real = t5_real + t3_real;
                double t7_imag = t5_imag + t3_imag;
                double b0_real = z0_real + t6_real + t4_real;
                double b0_imag = z0_imag + t6_imag + t4_imag;
                double b1_real = ((c1 + c2 + c3) / 3.0 - 1.0) * (t6_real + t4_real);
                double b1_imag = ((c1 + c2 + c3) / 3.0 - 1.0) * (t6_imag + t4_imag);
                double b2_real = (2.0 * c1 - c2 - c3) / 3.0 * (t0_real - t4_real);
                double b2_imag = (2.0 * c1 - c2 - c3) / 3.0 * (t0_imag - t4_imag);
                double b3_real = (c1 - 2.0 * c2 + c3) / 3.0 * (t4_real - t2_real);
                double b3_imag = (c1 - 2.0 * c2 + c3) / 3.0 * (t4_imag - t2_imag);
                double b4_real = (c1 + c2 - 2.0 * c3) / 3.0 * (t2_real - t0_real);
                double b4_imag = (c1 + c2 - 2.0 * c3) / 3.0 * (t2_imag - t0_imag);
                double b5_real = (s1 + s2 - s3) / 3.0 * (t7_real + t1_real);
                double b5_imag = (s1 + s2 - s3) / 3.0 * (t7_imag + t1_imag);
                double b6_real = (2.0 * s1 - s2 + s3) / 3.0 * (t1_real - t5_real);
                double b6_imag = (2.0 * s1 - s2 + s3) / 3.0 * (t1_imag - t5_imag);
                double b7_real = (s1 - 2.0 * s2 - s3) / 3.0 * (t5_real - t3_real);
                double b7_imag = (s1 - 2.0 * s2 - s3) / 3.0 * (t5_imag - t3_imag);
                double b8_real = (s1 + s2 + 2.0 * s3) / 3.0 * (t3_real - t1_real);
                double b8_imag = (s1 + s2 + 2.0 * s3) / 3.0 * (t3_imag - t1_imag);
                double T0_real = b0_real + b1_real;
                double T0_imag = b0_imag + b1_imag;
                double T1_real = b2_real + b3_real;
                double T1_imag = b2_imag + b3_imag;
                double T2_real = b4_real - b3_real;
                double T2_imag = b4_imag - b3_imag;
                double T3_real = -b2_real - b4_real;
                double T3_imag = -b2_imag - b4_imag;
                double T4_real = b6_real + b7_real;
                double T4_imag = b6_imag + b7_imag;
                double T5_real = b8_real - b7_real;
                double T5_imag = b8_imag - b7_imag;
                double T6_real = -b8_real - b6_real;
                double T6_imag = -b8_imag - b6_imag;
                double T7_real = T0_real + T1_real;
                double T7_imag = T0_imag + T1_imag;
                double T8_real = T0_real + T2_real;
                double T8_imag = T0_imag + T2_imag;
                double T9_real = T0_real + T3_real;
                double T9_imag = T0_imag + T3_imag;
                double T10_real = T4_real + b5_real;
                double T10_imag = T4_imag + b5_imag;
                double T11_real = T5_real + b5_real;
                double T11_imag = T5_imag + b5_imag;
                double T12_real = T6_real + b5_real;
                double T12_imag = T6_imag + b5_imag;
                out.setReal(j, b0_real);
                out.setImag(j, b0_imag);
                double x_real = T7_real + T10_imag;
                double x_imag = T7_imag - T10_real;
                out.setReal(j + dj, w1_real * x_real - w1_imag * x_imag);
                out.setImag(j + dj, w1_real * x_imag + w1_imag * x_real);
                x_real = T9_real + T12_imag;
                x_imag = T9_imag - T12_real;
                out.setReal(j + 2 * dj, w2_real * x_real - w2_imag * x_imag);
                out.setImag(j + 2 * dj, w2_real * x_imag + w2_imag * x_real);
                x_real = T8_real - T11_imag;
                x_imag = T8_imag + T11_real;
                out.setReal(j + 3 * dj, w3_real * x_real - w3_imag * x_imag);
                out.setImag(j + 3 * dj, w3_real * x_imag + w3_imag * x_real);
                x_real = T8_real + T11_imag;
                x_imag = T8_imag - T11_real;
                out.setReal(j + 4 * dj, w4_real * x_real - w4_imag * x_imag);
                out.setImag(j + 4 * dj, w4_real * x_imag + w4_imag * x_real);
                x_real = T9_real - T12_imag;
                x_imag = T9_imag + T12_real;
                out.setReal(j + 5 * dj, w5_real * x_real - w5_imag * x_imag);
                out.setImag(j + 5 * dj, w5_real * x_imag + w5_imag * x_real);
                x_real = T7_real - T10_imag;
                x_imag = T7_imag + T10_real;
                out.setReal(j + 6 * dj, w6_real * x_real - w6_imag * x_imag);
                out.setImag(j + 6 * dj, w6_real * x_imag + w6_imag * x_real);
                j += ostride;
            }
            j += (factor - 1) * dj;
        }
    }

    void pass_n(int fi, ComplexArray.Double in, int in0, int istride, ComplexArray.Double out, int out0, int ostride, int sign, int factor, int product) {
        int k;
        int k1;
        int e1;
        int e;
        int i = 0;
        int j = 0;
        int m = this.n / factor;
        int q = this.n / product;
        int p_1 = product / factor;
        int jump = (factor - 1) * p_1;
        for (i = 0; i < m; ++i) {
            out.setReal(out0 + ostride * i, in.getReal(in0 + istride * i));
            out.setImag(out0 + ostride * i, in.getImag(in0 + istride * i));
        }
        for (e = 1; e < (factor - 1) / 2 + 1; ++e) {
            for (i = 0; i < m; ++i) {
                int idx = i + e * m;
                int idxc = i + (factor - e) * m;
                out.setReal(out0 + ostride * idx, in.getReal(in0 + istride * idx) + in.getReal(in0 + istride * idxc));
                out.setImag(out0 + ostride * idx, in.getImag(in0 + istride * idx) + in.getImag(in0 + istride * idxc));
                out.setReal(out0 + ostride * idxc, in.getReal(in0 + istride * idx) - in.getReal(in0 + istride * idxc));
                out.setImag(out0 + ostride * idxc, in.getImag(in0 + istride * idx) - in.getImag(in0 + istride * idxc));
            }
        }
        for (i = 0; i < m; ++i) {
            in.setReal(in0 + istride * i, out.getReal(out0 + ostride * i));
            in.setImag(in0 + istride * i, out.getImag(out0 + ostride * i));
        }
        for (e1 = 1; e1 < (factor - 1) / 2 + 1; ++e1) {
            for (i = 0; i < m; ++i) {
                in.setReal(in0 + istride * i, in.getReal(in0 + istride * i) + out.getReal(out0 + ostride * (i + e1 * m)));
                in.setImag(in0 + istride * i, in.getImag(in0 + istride * i) + out.getImag(out0 + ostride * (i + e1 * m)));
            }
        }
        double[] twiddl = this.twiddle[fi][q];
        for (e = 1; e < (factor - 1) / 2 + 1; ++e) {
            int idx = e;
            int em = e * m;
            int ecm = (factor - e) * m;
            for (i = 0; i < m; ++i) {
                in.setReal(in0 + istride * (i + em), out.getReal(out0 + ostride * i));
                in.setImag(in0 + istride * (i + em), out.getImag(out0 + ostride * i));
                in.setReal(in0 + istride * (i + ecm), out.getReal(out0 + ostride * i));
                in.setImag(in0 + istride * (i + ecm), out.getImag(out0 + ostride * i));
            }
            for (e1 = 1; e1 < (factor - 1) / 2 + 1; ++e1) {
                double w_imag;
                double w_real;
                if (idx == 0) {
                    w_real = 1.0;
                    w_imag = 0.0;
                } else {
                    w_real = twiddl[2 * (idx - 1)];
                    w_imag = (double)(-sign) * twiddl[2 * (idx - 1) + 1];
                }
                for (i = 0; i < m; ++i) {
                    double ap = w_real * out.getReal(out0 + ostride * (i + e1 * m));
                    double am = w_imag * out.getImag(out0 + ostride * (i + (factor - e1) * m));
                    double bp = w_real * out.getImag(out0 + ostride * (i + e1 * m));
                    double bm = w_imag * out.getReal(out0 + ostride * (i + (factor - e1) * m));
                    in.setReal(in0 + istride * (i + em), in.getReal(in0 + istride * (i + em)) + (ap - am));
                    in.setImag(in0 + istride * (i + em), in.getImag(in0 + istride * (i + em)) + (bp + bm));
                    in.setReal(in0 + istride * (i + ecm), in.getReal(in0 + istride * (i + ecm)) + (ap + am));
                    in.setImag(in0 + istride * (i + ecm), in.getImag(in0 + istride * (i + ecm)) + (bp - bm));
                }
                idx += e;
                idx %= factor;
            }
        }
        i = 0;
        j = 0;
        for (k1 = 0; k1 < p_1; ++k1) {
            out.setReal(out0 + ostride * k1, in.getReal(in0 + istride * k1));
            out.setImag(out0 + ostride * k1, in.getImag(in0 + istride * k1));
        }
        for (e1 = 1; e1 < factor; ++e1) {
            for (k1 = 0; k1 < p_1; ++k1) {
                out.setReal(out0 + ostride * (k1 + e1 * p_1), in.getReal(in0 + istride * (k1 + e1 * m)));
                out.setImag(out0 + ostride * (k1 + e1 * p_1), in.getImag(in0 + istride * (k1 + e1 * m)));
            }
        }
        i = p_1;
        j = product;
        for (k = 1; k < q; ++k) {
            for (k1 = 0; k1 < p_1; ++k1) {
                out.setReal(out0 + ostride * j, in.getReal(in0 + istride * i));
                out.setImag(out0 + ostride * j, in.getImag(in0 + istride * i));
                ++i;
                ++j;
            }
            j += jump;
        }
        i = p_1;
        j = product;
        for (k = 1; k < q; ++k) {
            twiddl = this.twiddle[fi][k];
            for (k1 = 0; k1 < p_1; ++k1) {
                for (e1 = 1; e1 < factor; ++e1) {
                    double x_real = in.getReal(in0 + istride * (i + e1 * m));
                    double x_imag = in.getImag(in0 + istride * (i + e1 * m));
                    double w_real = twiddl[2 * (e1 - 1)];
                    double w_imag = (double)(-sign) * twiddl[2 * (e1 - 1) + 1];
                    out.setReal(out0 + ostride * (j + e1 * p_1), w_real * x_real - w_imag * x_imag);
                    out.setImag(out0 + ostride * (j + e1 * p_1), w_real * x_imag + w_imag * x_real);
                }
                ++i;
                ++j;
            }
            j += jump;
        }
    }
}

