/*
 * Decompiled with CFR 0.152.
 */
package org.das2.persistence;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.persistence.DatumPersistenceDelegate;
import org.das2.persistence.DatumRangePersistenceDelegate;
import org.das2.persistence.UnitsPersistenceDelegate;

public class StatePersistence {
    private StatePersistence() {
    }

    public static void saveState(OutputStream out, Object state) throws IOException {
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(out));
        e.setPersistenceDelegate(DatumRange.class, new DatumRangePersistenceDelegate());
        e.setPersistenceDelegate(Units.class, new UnitsPersistenceDelegate());
        e.setPersistenceDelegate(Datum.class, new DatumPersistenceDelegate());
        e.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                e.printStackTrace();
            }
        });
        e.writeObject(state);
        e.close();
    }

    public static Object restoreState(InputStream in) throws IOException {
        XMLDecoder decode = new XMLDecoder(in);
        return decode.readObject();
    }
}

