/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.stream.DataTransferType;
import org.das2.stream.SkeletonDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamXDescriptor
implements SkeletonDescriptor,
Cloneable {
    private Datum base;
    private Units units = null;
    private DataTransferType transferType = DataTransferType.SUN_REAL4;
    Map properties = new HashMap();

    public StreamXDescriptor() {
    }

    public StreamXDescriptor(Element element) {
        if (element.getTagName().equals("x")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        String baseString;
        String unitsString;
        DataTransferType type;
        String typeStr = element.getAttribute("type");
        this.transferType = type = DataTransferType.getByName(typeStr);
        if (type instanceof DataTransferType.Time) {
            unitsString = element.getAttribute("units");
            try {
                this.units = Units.lookupTimeUnits((String)unitsString);
                ((DataTransferType.Time)type).resetUnits(this.units);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex);
            }
            if (this.units == null) {
                throw new NullPointerException("units set to null");
            }
        } else {
            unitsString = element.getAttribute("units");
            this.units = Units.lookupUnits((String)unitsString);
            if (this.units == null) {
                throw new NullPointerException("units set to null");
            }
        }
        if ((baseString = element.getAttribute("base")) != null && !baseString.equals("")) {
            this.base = TimeUtil.createValid((String)baseString);
        }
    }

    private void processLegacyElement(Element element) {
        DataTransferType type;
        String typeStr = element.getAttribute("type");
        this.transferType = type = DataTransferType.getByName(typeStr);
    }

    public Datum getBase() {
        return this.base;
    }

    public void setBase(Datum base) {
        this.base = base;
    }

    @Override
    public int getSizeBytes() {
        return this.transferType.getSizeBytes();
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
        if (units == null) {
            throw new NullPointerException("units set to null");
        }
    }

    public void setDataTransferType(DataTransferType transferType) {
        this.transferType = transferType;
        if (transferType instanceof DataTransferType.Time) {
            if (this.units == null) {
                throw new IllegalArgumentException("please set the units first!!!");
            }
            ((DataTransferType.Time)transferType).resetUnits(this.units);
        }
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    public Datum readDatum(ByteBuffer input) {
        int p = input.position();
        try {
            return Datum.create((double)this.transferType.read(input), (Units)this.units);
        }
        catch (NullPointerException ex) {
            System.err.println("** Strange null pointer exception that shows up in hudson test: http://sarahandjeremy.net:8080/hudson/job/autoplot-test140/");
            System.err.println("transferType: " + this.transferType);
            System.err.println("input: " + input);
            System.err.println("first four: " + input.get(0) + " " + input.get(1) + " " + input.get(2) + " " + input.get(3));
            System.err.println("pointer pos: " + p);
            System.err.println("pointer four: " + input.get(p + 0) + " " + input.get(p + 1) + " " + input.get(p + 2) + " " + input.get(p + 3));
            System.err.println("units: " + this.units);
            ex.printStackTrace();
            throw ex;
        }
    }

    @Override
    public DatumVector read(ByteBuffer input) {
        return DatumVector.newDatumVector((double[])new double[]{this.transferType.read(input)}, (Units)this.units);
    }

    public void writeDatum(Datum datum, ByteBuffer output) {
        this.transferType.write(datum.doubleValue(this.units), output);
    }

    @Override
    public void write(DatumVector input, ByteBuffer output) {
        this.transferType.write(input.doubleValue(0, this.units), output);
    }

    @Override
    public Element getDOMElement(Document document) {
        Element element = document.createElement("x");
        if (this.base != null) {
            element.setAttribute("base", this.base.toString());
        }
        element.setAttribute("units", this.units.toString());
        element.setAttribute("type", this.transferType.toString());
        return element;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Map getProperties() {
        return new HashMap(this.properties);
    }
}

