/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.graph.DasAnnotation;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.util.awt.PdfGraphicsOutput;

public class GrannyTextDemo {
    JPanel contentPane;
    protected DasPlot plot;

    private synchronized JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
        }
        return this.contentPane;
    }

    public JFrame showFrame() {
        JFrame frame = new JFrame("Granny Text Demo");
        frame.getContentPane().add(this.getContentPane());
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        return frame;
    }

    private void printCanvas(DasCanvas canvas) throws FileNotFoundException, IOException {
        PdfGraphicsOutput go = new PdfGraphicsOutput();
        FileOutputStream out = new FileOutputStream(new File("/tmp/ap/jeremy.pdf"));
        go.setGraphicsShapes(false);
        go.setOutputStream((OutputStream)out);
        go.setSize(canvas.getWidth(), canvas.getHeight());
        go.start();
        canvas.print(go.getGraphics());
        go.finish();
    }

    private Action getPrintAction(final DasCanvas c) {
        return new AbstractAction("print"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GrannyTextDemo.this.printCanvas(c);
                }
                catch (IOException ex) {
                    Logger.getLogger(GrannyTextDemo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
    }

    public GrannyTextDemo(String text) {
        int width = 500;
        int height = 100;
        this.getContentPane().setLayout(new BorderLayout());
        DasCanvas canvas = new DasCanvas(width, height);
        canvas.setFont(Font.decode("Roboto-24"));
        this.getContentPane().add((Component)canvas, "Center");
        JButton button = new JButton(this.getPrintAction(canvas));
        this.getContentPane().add((Component)button, "South");
        DasRow row = DasRow.create(canvas, null, "20%", "80%");
        DasColumn col = DasColumn.create(canvas, null, "20%", "80%");
        DasAnnotation anno = new DasAnnotation(text);
        anno.setFontSize(20.0f);
        canvas.add(anno, row, col);
        canvas.revalidate();
    }

    public static void main(String[] args) {
        new GrannyTextDemo("Serif <b>in</b> &uarr; 1917!c!c<i><u>HELLO</i></u> There!").showFrame();
    }
}

