/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.UnknownHostException;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemFactory;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.GitHubFileSystem;
import org.das2.util.filesystem.HttpFileSystem;

public class HttpFileSystemFactory
implements FileSystemFactory {
    @Override
    public FileSystem createFileSystem(URI root) throws FileSystem.FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        String h;
        try {
            h = root.toURL().getHost();
        }
        catch (MalformedURLException ex) {
            h = "";
        }
        String githubPath = GitHubFileSystem.isGithubFileSystem(h, root.getPath());
        if (githubPath != null) {
            int offset = githubPath.split("/").length - 1;
            GitHubFileSystem result = GitHubFileSystem.createGitHubFileSystem(root, offset);
            return result;
        }
        HttpFileSystem hfs = HttpFileSystem.createHttpFileSystem(root);
        if (!FileSystemSettings.hasAllPermission()) {
            hfs.setAppletMode(true);
        }
        return hfs;
    }
}

