/*
 * Decompiled with CFR 0.152.
 */
package test.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.filesystem.FileSystem;

public class TestFileSystemLockup {
    public static void main(String[] args) {
        final long t0 = System.currentTimeMillis();
        System.err.println("The old filesystem would only allow one FS to be created at a time, possibly locking out others.");
        System.err.println("hard-coding delays in create simulates the problems seen.");
        System.err.println("hard-coding delays in getFile shows things are okay if done later.");
        int i = 0;
        while (i < 7) {
            final int fi = i++;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        FileSystem fs = fi > 2 ? FileSystem.create("file:/home/jbf/temp/fstest/fs3") : FileSystem.create("file:/home/jbf/temp/fstest/fs" + fi);
                        long t1 = System.currentTimeMillis();
                        File ff = fs.getFileObject("afile").getFile();
                        long ts0 = System.currentTimeMillis() - t0;
                        long ts1 = System.currentTimeMillis() - t1;
                        System.err.printf("%6.3f %6.3f %s %d\n", (double)ts0 / 1000.0, (double)ts1 / 1000.0, ff, fs.hashCode());
                    }
                    catch (FileNotFoundException ex) {
                        Logger.getLogger(TestFileSystemLockup.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (FileSystem.FileSystemOfflineException ex) {
                        Logger.getLogger(TestFileSystemLockup.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (UnknownHostException ex) {
                        Logger.getLogger(TestFileSystemLockup.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TestFileSystemLockup.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            };
            new Thread(run).start();
        }
    }
}

