/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.autoplot.aggregator.AggregatingDataSourceEditorPanel;
import org.autoplot.aggregator.AggregatingDataSourceFactory;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceRecognizer;
import org.autoplot.datasource.DataSourceRegistry;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DataSourceEditorPanelUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.uri");

    public static DataSourceEditorPanel getDataSourceEditorPanel(JPanel parent, String uri) {
        logger.entering("org.autoplot.datasource.DataSourceEditorPanelUtil", "getDataSourceEditorPanel");
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }
        DataSourceEditorPanel edit = DataSourceEditorPanelUtil.getDataSourceEditorPanel(uri);
        if (edit == null) {
            throw new IllegalArgumentException("can''t get editor for " + uri);
        }
        try {
            if (!edit.reject(uri)) {
                edit.prepare(uri, null, (ProgressMonitor)new NullProgressMonitor());
                edit.setURI(uri);
                JPanel editPanel = edit.getPanel();
                editPanel.setAlignmentX(0.0f);
                parent.add(editPanel);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        logger.exiting("org.autoplot.datasource.DataSourceEditorPanelUtil", "getDataSourceEditorPanel");
        return edit;
    }

    public static DataSourceEditorPanel getDataSourceEditorPanel(URI uri) {
        return DataSourceEditorPanelUtil.getDataSourceEditorPanel(uri.toString());
    }

    public static DataSourceEditorPanel getDataSourceEditorPanel(String suri) {
        String surl = suri;
        String ext = DataSetURI.getExt(surl);
        if (ext != null && (ext.equals("json") || ext.equals("xml"))) {
            try {
                if (DataSetURI.isAggregating(surl)) {
                    String delegateUri = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(surl, (ProgressMonitor)new NullProgressMonitor());
                    File f = DataSetURI.getFile(delegateUri, (ProgressMonitor)new AlertNullProgressMonitor("download on event thread"));
                    String ext2 = DataSourceRecognizer.guessDataSourceType(f);
                    if (ext2 != null) {
                        ext = ext2;
                    }
                } else {
                    File f = DataSetURI.getFile(suri, (ProgressMonitor)new AlertNullProgressMonitor("download on event thread"));
                    String ext2 = DataSourceRecognizer.guessDataSourceType(f);
                    if (ext2 != null) {
                        ext = ext2;
                    }
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        if (DataSetURI.isAggregating(surl)) {
            String eext = DataSetURI.getExplicitExt(surl);
            if (eext != null) {
                AggregatingDataSourceEditorPanel result = new AggregatingDataSourceEditorPanel();
                DataSourceEditorPanel edit = DataSourceEditorPanelUtil.getEditorByExt(eext);
                if (edit != null) {
                    result.setDelegateEditorPanel(edit);
                    try {
                        String delegateUri = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(surl, (ProgressMonitor)new NullProgressMonitor());
                        if (edit.reject(delegateUri)) {
                            logger.log(Level.WARNING, null, "delegate editor rejects URI, ignoring: " + suri);
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                    result.setName(edit.getPanel().getName());
                }
                return result;
            }
            return new AggregatingDataSourceEditorPanel();
        }
        DataSourceEditorPanel edit = DataSourceEditorPanelUtil.getEditorByExt(ext);
        return edit;
    }

    public static DataSourceEditorPanel getEditorByExt(String extension) {
        DataSourceEditorPanel result;
        if (extension == null) {
            return null;
        }
        Object o = DataSourceRegistry.getInstance().dataSourceEditorByExt.get(extension = DataSourceRegistry.getExtension(extension));
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                Class<?> clas = Class.forName((String)o);
                Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
                result = (DataSourceEditorPanel)constructor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            result = (DataSourceEditorPanel)o;
        }
        return result;
    }
}

