/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.das2.datum.LoggerManager;
import org.das2.util.FileUtil;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DataSourceRecognizer {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.xml");
    public static final String TYPE_HELM = "HELM";
    public static final String TYPE_SPASE = "SPASE";
    public static final String TYPE_VOTABLE = "VOTABLE";
    public static final String TYPE_MISC = "MISC";
    private Object type;
    private static final String ID_XML_TYPE = "got the type";

    public static String guessDataSourceType(File f) throws IOException {
        FileChannel channel = new FileInputStream(f).getChannel();
        long len = f.length();
        len = Math.min(len, 1024L);
        MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, len);
        MappedByteBuffer fer = channel.map(FileChannel.MapMode.READ_ONLY, channel.size() - len, len);
        if (buf.limit() > 5 && buf.get(0) == 60 && buf.get(1) == 63 && buf.get(2) == 120 && buf.get(3) == 109 && buf.get(4) == 108) {
            return DataSourceRecognizer.guessDataSourceTypeXML(f);
        }
        if (buf.limit() > 1 && buf.get(0) == 123) {
            for (int i = 1023; i > 1000; --i) {
                byte c = fer.get(i);
                if (Character.isWhitespace(c)) continue;
                if (c != 125) break;
                return DataSourceRecognizer.guessDataSourceTypeJSON(f);
            }
            return null;
        }
        return null;
    }

    public static String guessDataSourceTypeXML(File f) throws IOException {
        XMLReader xmlReader = null;
        MyDefaultHandler handler = new MyDefaultHandler();
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
        }
        catch (ParserConfigurationException | SAXException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        try {
            xmlReader.parse(f.toURI().toString());
        }
        catch (RuntimeException ex) {
        }
        catch (SAXException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return handler.type;
    }

    public static String guessDataSourceTypeJSON(File f) throws IOException {
        try {
            long t0 = System.currentTimeMillis();
            String json = FileUtil.readFileToString((File)f);
            System.err.println("read to string: " + (System.currentTimeMillis() - t0));
            JSONObject obj = new JSONObject(json);
            System.err.println("read to JSONObject: " + (System.currentTimeMillis() - t0));
            if (obj.has("crs") && obj.has("fields")) {
                return "vap+tfcat";
            }
            return null;
        }
        catch (JSONException ex) {
            return null;
        }
    }

    private static class MyDefaultHandler
    extends DefaultHandler {
        private String type;

        private MyDefaultHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (localName) {
                case "VOTABLE": {
                    this.type = "vap+xml";
                    throw new RuntimeException(DataSourceRecognizer.ID_XML_TYPE);
                }
                case "Spase": {
                    this.type = "vap+xml";
                    throw new RuntimeException(DataSourceRecognizer.ID_XML_TYPE);
                }
                case "Eventlist": {
                    this.type = "vap+xml";
                    throw new RuntimeException(DataSourceRecognizer.ID_XML_TYPE);
                }
                case "Product_Observational": {
                    this.type = "vap+pds4";
                    throw new RuntimeException(DataSourceRecognizer.ID_XML_TYPE);
                }
                case "Product_Collection": {
                    this.type = "vap+pds4";
                    throw new RuntimeException(DataSourceRecognizer.ID_XML_TYPE);
                }
                case "Product_Bundle": {
                    this.type = "vap+pds4";
                    throw new RuntimeException(DataSourceRecognizer.ID_XML_TYPE);
                }
            }
            throw new IllegalArgumentException("Unrecognized XML type: " + uri);
        }
    }
}

