/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoRangeUtil;
import org.autoplot.AutoplotUI;
import org.autoplot.RenderType;
import org.autoplot.RenderTypeUtil;
import org.autoplot.ReplaceFilePanel;
import org.autoplot.Sandbox;
import org.autoplot.Util;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.ReferenceCache;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.autoplot.datasource.capability.Caching;
import org.autoplot.dom.Application;
import org.autoplot.dom.Axis;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Options;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotController;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementController;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.BoundsRenderer;
import org.das2.graph.ContoursRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.EventsRenderer;
import org.das2.graph.HugeScatterRenderer;
import org.das2.graph.PitchAngleDistributionRenderer;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PolarPlotRenderer;
import org.das2.graph.PsymConnector;
import org.das2.graph.RGBImageRenderer;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.StackedHistogramRenderer;
import org.das2.graph.TickCurveRenderer;
import org.das2.graph.VectorPlotRenderer;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetAnnotations;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;
import org.das2.system.RequestProcessor;
import org.das2.util.AboutUtil;
import org.das2.util.ExceptionHandler;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.LocalFileSystem;
import org.das2.util.filesystem.WebFileSystem;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AutoplotUtil {
    public static final int SERIES_SIZE_LIMIT = 80000;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.gui");
    public static final int DS_LENGTH_LIMIT = 10000000;
    public static final boolean is32bit;
    public static final String javaVersionWarning;
    private static final TrustManager[] trustAllCerts;
    private static final HostnameVerifier allHostsValid;

    @Deprecated
    public static QDataSet bounds(QDataSet dataSet, RenderType renderType) throws Exception {
        return AutoRangeUtil.bounds(dataSet, renderType);
    }

    public static BufferedImage createImage(QDataSet ds, int width, int height) {
        DasCanvas c = new DasCanvas(width, height);
        AutoplotUtil.createPlot(c, ds, null, null);
        BufferedImage im = c.getImage(width, height);
        return im;
    }

    public static DasPlot createPlot(DasCanvas c, QDataSet ds, DasPlot recyclable, DasColorBar cb) {
        SeriesRenderer rend1;
        RenderType type;
        DasColumn col;
        DasRow row;
        DasPlot result;
        if (c == null) {
            if (recyclable != null) {
                c = recyclable.getCanvas();
            }
            if (c == null) {
                c = new DasCanvas(640, 480);
            }
        }
        if (recyclable != null) {
            result = recyclable;
            row = result.getRow();
            col = result.getColumn();
        } else {
            row = DasRow.create((DasCanvas)c);
            col = DasColumn.create((DasCanvas)c);
            result = DasPlot.createDummyPlot();
            result.addRenderer((Renderer)new SeriesRenderer());
        }
        List<Renderer> recycleRends = Arrays.asList(result.getRenderers());
        Renderer oldRend = null;
        if (ds != null) {
            type = AutoplotUtil.guessRenderType(ds);
            oldRend = recycleRends.get(0);
            rend1 = AutoplotUtil.maybeCreateRenderer(type, oldRend, cb, false);
            rend1.setDataSet(ds);
        } else {
            type = RenderType.series;
            rend1 = new SeriesRenderer();
        }
        if (RenderTypeUtil.needsColorbar(type)) {
            if (cb == null) {
                cb = new DasColorBar(Datum.create((int)0), Datum.create((int)1), false);
                c.add((DasCanvasComponent)cb, row, col.createAttachedColumn(1.03, 1.07));
                rend1.setColorBar(cb);
            } else {
                cb.setVisible(true);
            }
        }
        try {
            if (ds != null) {
                QDataSet bounds = AutoplotUtil.bounds(ds, type);
                result.getXAxis().setDatumRange(DataSetUtil.asDatumRange((QDataSet)bounds.slice(0)));
                result.getYAxis().setDatumRange(DataSetUtil.asDatumRange((QDataSet)bounds.slice(1)));
                if (cb != null) {
                    QDataSet ss = bounds.slice(2);
                    cb.setDatumRange(DataSetUtil.asDatumRange((QDataSet)ss));
                    cb.setLog("log".equals(ss.property("SCALE_TYPE")));
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        if (oldRend != rend1) {
            result.removeRenderer(oldRend);
            result.addRenderer((Renderer)rend1);
        }
        if (recyclable == null) {
            c.add((DasCanvasComponent)result, row, col);
            c.revalidate();
            c.validate();
        }
        result.resize();
        return result;
    }

    public static ImageIcon scaleIcon(ImageIcon icon, int w, int h) {
        double aspect = (double)icon.getIconHeight() / (double)icon.getIconWidth();
        if (h == -1) {
            h = (int)((double)w * aspect);
        } else if (w == -1) {
            w = (int)((double)h / aspect);
        }
        BufferedImage image = (BufferedImage)icon.getImage();
        return new ImageIcon(AutoplotUtil.scaleImage(image, w, h));
    }

    public static BufferedImage scaleImage(BufferedImage image, int w, int h) {
        BufferedImage result = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)result.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setTransform(AffineTransform.getScaleInstance((double)w / (double)image.getWidth(), (double)h / (double)image.getHeight()));
        g2.drawImage((Image)image, 0, 0, null);
        return result;
    }

    public static List<String> getUrls(List<Bookmark> recent) {
        ArrayList<String> urls = new ArrayList<String>(recent.size());
        for (Bookmark b : recent) {
            if (!(b instanceof Bookmark.Item)) continue;
            urls.add(((Bookmark.Item)b).getUri());
        }
        return urls;
    }

    public static void replaceFile(Component parent, Application dom) {
        DataSourceFilter dsf = dom.getController().getDataSourceFilter();
        if (dsf.getUri() == null || dsf.getUri().equals("")) {
            JOptionPane.showMessageDialog(parent, "Focus plot element has no data");
        } else {
            if (dsf.getUri().startsWith("vap+internal:")) {
                List<DataSourceFilter> pes = DomUtil.getParentsFor(dom, dsf.getUri());
                if (pes.isEmpty()) {
                    JOptionPane.showMessageDialog(parent, "Unable to resolve parents");
                    return;
                }
                dsf = pes.get(0);
            }
            URISplit split = URISplit.parse((String)dsf.getUri());
            if (split.file == null || split.file.length() == 0) {
                JOptionPane.showMessageDialog(parent, "<html>URI should refer to a file, but this doesn't: <br>" + dsf.getUri());
                return;
            }
            Application dom2 = (Application)dom.copy();
            String oldf = split.file;
            ReplaceFilePanel p = new ReplaceFilePanel();
            p.setCurrentFile(oldf);
            p.setApplicationModel(dom.getController().getApplicationModel());
            int result = AutoplotUtil.showConfirmDialog(parent, p, "Replace Filename", 2);
            if (result == 0) {
                String newf = p.getSelectedFile();
                dom.getController().getApplicationModel().addRecent(newf);
                split = URISplit.parse((String)newf);
                newf = split.file;
                for (DataSourceFilter i : dom2.getDataSourceFilters()) {
                    String oldf1 = i.getUri();
                    String newf1 = oldf1.replace(oldf, newf);
                    i.setUri(newf1);
                }
                dom.syncTo(dom2);
                dom.getController().waitUntilIdle();
                dom.getController().setDataSourceFilter(dsf);
                AutoplotUtil.resetZoomX(dom);
            }
        }
    }

    public static void reloadAll(Application dom) {
        ReferenceCache.getInstance().reset();
        DataSetAnnotations.getInstance().reset();
        for (DataSourceFilter dataSourceFilter : dom.getDataSourceFilters()) {
            if (dataSourceFilter.getUri() != null && !dataSourceFilter.getUri().startsWith("vap+internal:")) {
                final DataSourceFilter fdsf = dataSourceFilter;
                Caching c = fdsf.getController().getCaching();
                if (c != null) {
                    c.reset();
                }
                RequestProcessor.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        fdsf.getController().update();
                    }
                });
                continue;
            }
            System.err.println("not updating: " + dataSourceFilter.getUri());
        }
        for (DomNode domNode : dom.getPlots()) {
            if (((Plot)domNode).getTicksURI() == null || ((Plot)domNode).getTicksURI().length() <= 0) continue;
            String oldTicksURI = ((Plot)domNode).getTicksURI();
            ((Plot)domNode).setTicksURI("");
            ((Plot)domNode).setTicksURI(oldTicksURI);
        }
    }

    private static void doSearchToolTips1(JComponent aThis, Pattern p, Map<Component, String> result) {
        String s = aThis.getToolTipText();
        boolean foundIt = false;
        if (s != null && p.matcher(s).find()) {
            result.put(aThis, s);
            foundIt = true;
        }
        if (!foundIt) {
            Border b;
            s = null;
            if (aThis instanceof JLabel) {
                s = ((JLabel)aThis).getText();
            } else if (aThis instanceof JMenuItem) {
                s = ((JMenuItem)aThis).getText();
            } else if (aThis instanceof JButton) {
                s = ((JButton)aThis).getText();
            } else if (aThis instanceof JCheckBox) {
                s = ((JCheckBox)aThis).getText();
            } else if (aThis instanceof JPanel && (b = ((JPanel)aThis).getBorder()) instanceof TitledBorder) {
                s = ((TitledBorder)b).getTitle();
            }
            if (s != null && p.matcher(s).find()) {
                result.put(aThis, s);
            }
        }
        for (int i = 0; i < aThis.getComponentCount(); ++i) {
            Component kid = aThis.getComponent(i);
            if (kid == null || !(kid instanceof JComponent)) continue;
            AutoplotUtil.doSearchToolTips1((JComponent)kid, p, result);
        }
        if (aThis instanceof JMenu) {
            JMenu m = (JMenu)aThis;
            for (int i = 0; i < m.getItemCount(); ++i) {
                JMenuItem item = m.getItem(i);
                if (item == null) continue;
                AutoplotUtil.doSearchToolTips1(item, p, result);
            }
        }
    }

    static void doSearchToolTips(final Container aThis) {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField tf = new JTextField();
        panel.add(new JLabel("<html>Experimental Tooltips documentation search.  Enter the search keyword:"));
        panel.add((Component)tf, "South");
        int i = JOptionPane.showConfirmDialog(aThis, panel, "Experimental Tooltips documentation search", 2);
        if (i == 0) {
            final String search = tf.getText();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    LinkedHashMap result = new LinkedHashMap();
                    Pattern p = Pattern.compile(search, 2);
                    for (int i = 0; i < aThis.getComponentCount(); ++i) {
                        Component kid = aThis.getComponent(i);
                        if (kid == null || !(kid instanceof JComponent)) continue;
                        AutoplotUtil.doSearchToolTips1((JComponent)kid, p, result);
                    }
                    for (Map.Entry e : result.entrySet()) {
                        System.err.println((String)e.getValue());
                    }
                    if (aThis instanceof JFrame) {
                        JMenuBar mb = ((JFrame)aThis).getJMenuBar();
                        for (int i = 0; i < mb.getMenuCount(); ++i) {
                            JMenu m = mb.getMenu(i);
                            if (m == null) continue;
                            AutoplotUtil.doSearchToolTips1(m, p, result);
                        }
                    }
                    JTable t = new JTable(result.size(), 2);
                    t.setCellEditor(null);
                    t.setMinimumSize(new Dimension(800, 480));
                    t.setPreferredSize(new Dimension(800, 480));
                    TableModel m = t.getModel();
                    t.getColumnModel().getColumn(0).setHeaderValue("Component");
                    t.getColumnModel().getColumn(0).setPreferredWidth(120);
                    t.getColumnModel().getColumn(0).setMaxWidth(120);
                    t.getColumnModel().getColumn(1).setHeaderValue("ToolTip");
                    int i = 0;
                    for (Map.Entry e : result.entrySet()) {
                        String l = e.getKey().getClass().toString().replaceAll("class ", "");
                        String tooltip = e.getValue().toString();
                        int j = l.lastIndexOf(46);
                        l = l.substring(j + 1);
                        m.setValueAt(l, i, 0);
                        m.setValueAt(tooltip, i, 1);
                        if (tooltip.startsWith("<html>")) {
                            int linecount = tooltip.split("<br>").length;
                            t.setRowHeight(i, linecount * 20);
                        } else {
                            t.setRowHeight(i, 20);
                        }
                        ++i;
                    }
                    JScrollPane sp = new JScrollPane(t);
                    AutoplotUtil.showConfirmDialog2(aThis, sp, "Tooltips search results", 2);
                }
            };
            new Thread(run).start();
        }
    }

    protected static void doManageFilesystems(final Component parent) {
        FileSystem[] fss = FileSystem.peekInstances();
        Arrays.sort(fss, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        final JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 2;
        p.add((Component)new JLabel("<html><em>Double-click on file system name to reset status</em>"), c);
        ++c.gridy;
        for (FileSystem fs : fss) {
            c.weightx = 0.8;
            c.gridx = 0;
            c.anchor = 17;
            JLabel l = new JLabel(fs.toString());
            p.add((Component)l, c);
            final FileSystem ffs = fs;
            l.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                                FileSystem.reset((FileSystem)ffs);
                                try {
                                    FileSystem fileSystem = FileSystem.create((URI)ffs.getRootURI());
                                }
                                catch (FileNotFoundException | UnknownHostException | FileSystem.FileSystemOfflineException ex) {
                                    Logger.getLogger(AutoplotUtil.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                Runnable run2 = new Runnable(){

                                    @Override
                                    public void run() {
                                        SwingUtilities.getWindowAncestor(p).setVisible(false);
                                        AutoplotUtil.doManageFilesystems(parent);
                                    }
                                };
                                SwingUtilities.invokeLater(run2);
                            }
                        };
                        new Thread(run).start();
                    }
                }
            });
            c.weightx = 0.1;
            c.gridx = 1;
            c.anchor = 13;
            p.add((Component)new JLabel("  "), c);
            c.weightx = 0.1;
            c.gridx = 2;
            c.anchor = 13;
            if (fs instanceof LocalFileSystem) {
                p.add((Component)new JLabel("ok"), c);
            } else if (fs instanceof WebFileSystem) {
                String s;
                String string = s = ((WebFileSystem)fs).isOffline() ? "offline" : "ok";
                if (((WebFileSystem)fs).isOffline()) {
                    s = "<html>" + s + "<br>" + ((WebFileSystem)fs).getOfflineMessage();
                }
                l = new JLabel(s);
                p.add((Component)l, c);
            }
            ++c.gridy;
        }
        if (fss.length == 0) {
            p.add((Component)new JLabel("(no active filesystems)"), c);
        }
        c.weighty = 1.0;
        p.add((Component)new JLabel(" "), c);
        JScrollPane pp = new JScrollPane(p);
        pp.setPreferredSize(new Dimension(640, 480));
        pp.getVerticalScrollBar().setUnitIncrement(p.getFont().getSize());
        AutoplotUtil.showMessageDialog(parent, pp, "Active Filesystems", 0);
    }

    public static void maybeLoadSystemProperties() {
        File config = new File(new File(AutoplotSettings.settings().resolveProperty("autoplotData")), "config");
        if (!config.exists() && !config.mkdirs()) {
            logger.log(Level.WARNING, "mkdir {0} failed", config);
            return;
        }
        File propFile = new File(config, "system.properties");
        if (!propFile.exists()) {
            try (PrintWriter w = new PrintWriter(new FileWriter(propFile));){
                w.println("# Autoplot loads these system properties on startup.  See https://github.com/autoplot/documentation/blob/main/md/systemProperties.md");
                w.println("");
                w.println("# reference cache allows some URIs to be resolved once per plot.");
                w.println("#enableReferenceCache=true");
                w.println("");
                w.println("# use new LANL-requested Nearest Neighbor rebinning that looks at bin boundaries.");
                w.println("#useLanlNearestNeighbor=true");
                w.println("");
                w.println("# do check on index and rank with commonly used datasets, at a slight performance cost.");
                w.println("#rangeChecking=true");
                w.println("");
                w.println("#email RTEs by default, instead of HTTP POST, when firewall prohibits put calls.");
                w.println("#autoplot.emailrte=true");
                w.println("");
                w.println("# use wget to download data instead of Java's built-in network protocols. Should be command line or empty.");
                w.println("#AP_WGET=/usr/local/wget");
                w.println("");
                w.println("# use curl to download data instead of Java's built-in network protocols. Should be command line or empty.");
                w.println("#AP_CURL=/usr/bin/curl");
                w.println("");
                w.println("# provide option in save dialog to embed data within a zip file.");
                w.println("#allowEmbedData=true");
                w.println("");
                w.println("# don't show icon in legend when there is only one renderer.");
                w.println("#reluctantLegendIcons=true");
                w.println("");
                w.println("# monitor the event thread for hangs.  See autoplot_data/log/, if the app hangs.");
                w.println("#enableResponseMonitor=true");
                w.println("");
                w.println("# turn off certificate checks.");
                w.println("#noCheckCertificate=true");
                w.println("");
                w.println("# use huge scatter for large data sets.");
                w.println("#useHugeScatter=true");
                w.println("");
                w.println("# HAPI cache location.");
                w.println("#HAPI_DATA=${HOME}/hapi_data");
                w.println("");
                w.println("# Enable HAPI Caching.");
                w.println("#hapiServerCache=true");
                w.println("");
                w.println("# Enable Flat LAF, a consistent Look and Feel which can be run on any platform");
                w.println("#flatLAF=true");
                w.println("");
                w.println("# Set the Flat LAF font and size");
                w.println("#flatLAFFont=Roboto-24");
                w.println("");
                w.close();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "write initial {0} failed.  {1}", new Object[]{propFile, ex});
            }
        } else {
            logger.log(Level.FINER, "loading %s", propFile);
            Properties props = new Properties();
            try (FileInputStream in = new FileInputStream(propFile);){
                props.load(in);
                for (Map.Entry<Object, Object> p : props.entrySet()) {
                    logger.log(Level.FINEST, "%s=%s", new Object[]{p.getKey(), p.getValue()});
                    if (System.getProperty((String)p.getKey()) != null) continue;
                    System.setProperty((String)p.getKey(), (String)p.getValue());
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public static void showUserExceptionDialog(Component parent, String string, final Exception ex, final ExceptionHandler exh) {
        JPanel p = new JPanel(new BorderLayout());
        JLabel l1 = new JLabel(string);
        p.add((Component)l1, "Center");
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)new JButton(new AbstractAction("Details..."){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent((ActionEvent)ev);
                JComponent c = (JComponent)ev.getSource();
                JDialog dia = (JDialog)SwingUtilities.getWindowAncestor(c);
                dia.dispose();
                exh.handleUncaught((Throwable)ex);
            }
        }), "East");
        p.add((Component)p1, "South");
        JOptionPane.showMessageDialog(parent, p);
    }

    @Deprecated
    public static AutoRangeUtil.AutoRangeDescriptor autoRange(QDataSet hist, QDataSet ds, Map properties) {
        return AutoRangeUtil.autoRange(hist, ds, properties);
    }

    public static QDataSet toDataSet(AutoRangeUtil.AutoRangeDescriptor ard) {
        DDataSet result = DDataSet.createRank1((int)2);
        Units u = ard.range.getUnits();
        if (u == null) {
            u = Units.dimensionless;
        }
        result.putValue(0, ard.range.min().doubleValue(u));
        result.putValue(1, ard.range.max().doubleValue(u));
        result.putProperty("BINS_0", (Object)"min,max");
        if (ard.log) {
            result.putProperty("SCALE_TYPE", (Object)"log");
        }
        if (u != Units.dimensionless) {
            result.putProperty("UNITS", (Object)u);
        }
        return result;
    }

    public static boolean resetZoomY(Application dom) {
        Plot plot = dom.getController().getPlot();
        return AutoplotUtil.resetZoomY(dom, plot);
    }

    public static boolean resetZoomY(Application dom, Plot plot) {
        boolean result = true;
        Axis axis = plot.getYaxis();
        List<PlotElement> pes = DomUtil.getPlotElementsFor(dom, plot);
        boolean alsoBindings = true;
        if (alsoBindings) {
            List<BindingModel> plots = DomUtil.findBindings(dom, plot.getYaxis(), "range");
            for (BindingModel b : plots) {
                Plot other;
                Axis oa;
                if (b.getDstId().equals(plot.getYaxis().getId())) {
                    oa = (Axis)DomUtil.getElementById(dom, b.getSrcId());
                    other = DomUtil.getPlotForAxis(dom, oa);
                } else {
                    oa = (Axis)DomUtil.getElementById(dom, b.getDstId());
                    other = DomUtil.getPlotForAxis(dom, oa);
                }
                pes.addAll(DomUtil.getPlotElementsFor(dom, other));
            }
        }
        DatumRange range = null;
        for (PlotElement pe : pes) {
            QDataSet ds;
            if (!pe.isActive() || (ds = pe.getController().getDataSet()) == null) continue;
            if ((ds = SemanticOps.trim((QDataSet)ds, (DatumRange)plot.getXaxis().getRange(), null)).rank() > 0 && ds.length() == 0) break;
            if (ds.rank() == 0 || ds.rank() == 1 && ds.length() == 1) {
                if (ds.rank() == 1) {
                    ds = ds.slice(0);
                }
                if (range == null) {
                    range = new DatumRange(DataSetUtil.asDatum((QDataSet)ds), DataSetUtil.asDatum((QDataSet)ds));
                    continue;
                }
                range = DatumRangeUtil.union((DatumRange)range, (Datum)DataSetUtil.asDatum((QDataSet)ds));
                continue;
            }
            PlotElement pcopy1 = (PlotElement)pe.copy();
            PlotElementController.doAutoranging(pcopy1, Collections.singletonMap("SCALE_TYPE", axis.isLog() ? "log" : "linear"), ds, true);
            if (range == null) {
                range = pcopy1.getPlotDefaults().getYaxis().getRange();
                continue;
            }
            range = DatumRangeUtil.union((DatumRange)range, (DatumRange)pcopy1.getPlotDefaults().getYaxis().getRange());
        }
        if (range != null && range.width().value() == 0.0) {
            logger.info("Y autorange returns zero-width");
            range = UnitsUtil.isRatioMeasurement((Units)range.getUnits()) && range.min().value() != 0.0 ? DatumRangeUtil.union(range, (Datum)range.getUnits().createDatum(0)) : null;
        }
        if (range != null) {
            axis.getController().setRangeAutomatically(range, axis.isLog());
        }
        PlotController.doHints(axis, axis.getAutoRangeHints());
        return result;
    }

    public static boolean resetZoomX(Application dom) {
        Plot plot = dom.getController().getPlot();
        return AutoplotUtil.resetZoomX(dom, plot);
    }

    public static boolean resetZoomX(Application dom, Plot plot) {
        boolean result = true;
        Axis axis = plot.getXaxis();
        List<PlotElement> pes = DomUtil.getPlotElementsFor(dom, plot);
        boolean alsoBindings = true;
        if (alsoBindings) {
            List<BindingModel> plots = DomUtil.findBindings(dom, plot.getXaxis(), "range");
            for (BindingModel b : plots) {
                Plot other;
                Axis oa;
                DomNode oo;
                if (b.getDstId().equals(plot.getXaxis().getId())) {
                    oo = DomUtil.getElementById(dom, b.getSrcId());
                    if (!(oo instanceof Axis)) continue;
                    oa = (Axis)DomUtil.getElementById(dom, b.getSrcId());
                    other = DomUtil.getPlotForAxis(dom, oa);
                } else {
                    oo = DomUtil.getElementById(dom, b.getDstId());
                    if (!(oo instanceof Axis)) continue;
                    oa = (Axis)oo;
                    other = DomUtil.getPlotForAxis(dom, oa);
                }
                pes.addAll(DomUtil.getPlotElementsFor(dom, other));
            }
        }
        DatumRange range = null;
        for (PlotElement pe : pes) {
            QDataSet ds;
            if (!pe.isActive() || (ds = pe.getController().getDataSet()) == null) continue;
            if ((ds = SemanticOps.trim((QDataSet)ds, null, (DatumRange)plot.getYaxis().getRange())).length() == 0) break;
            PlotElement pcopy1 = (PlotElement)pe.copy();
            PlotElementController.doAutoranging(pcopy1, Collections.singletonMap("SCALE_TYPE", axis.isLog() ? "log" : "linear"), ds, true);
            if (range == null) {
                range = pcopy1.getPlotDefaults().getXaxis().getRange();
                continue;
            }
            range = DatumRangeUtil.union((DatumRange)range, (DatumRange)pcopy1.getPlotDefaults().getXaxis().getRange());
        }
        if (range != null && range.width().value() == 0.0) {
            logger.info("X autorange returns zero-width");
            range = UnitsUtil.isRatioMeasurement((Units)range.getUnits()) && range.min().value() != 0.0 ? DatumRangeUtil.union(range, (Datum)range.getUnits().createDatum(0)) : null;
        }
        if (range != null) {
            axis.getController().setRangeAutomatically(range, axis.isLog());
        }
        PlotController.doHints(axis, axis.getAutoRangeHints());
        return result;
    }

    public static boolean resetZoomZ(Application dom) {
        Plot plot = dom.getController().getPlot();
        return AutoplotUtil.resetZoomZ(dom, plot);
    }

    public static boolean resetZoomZ(Application dom, Plot plot) {
        boolean result = true;
        Axis axis = plot.getZaxis();
        List<PlotElement> pes = DomUtil.getPlotElementsFor(dom, plot);
        boolean alsoBindings = true;
        if (alsoBindings) {
            List<BindingModel> plots = DomUtil.findBindings(dom, plot.getZaxis(), "range");
            for (BindingModel b : plots) {
                Plot other;
                Axis oa;
                if (b.getDstId().equals(plot.getZaxis().getId())) {
                    oa = (Axis)DomUtil.getElementById(dom, b.getSrcId());
                    other = DomUtil.getPlotForAxis(dom, oa);
                } else {
                    oa = (Axis)DomUtil.getElementById(dom, b.getDstId());
                    other = DomUtil.getPlotForAxis(dom, oa);
                }
                pes.addAll(DomUtil.getPlotElementsFor(dom, other));
            }
        }
        DatumRange range = null;
        for (PlotElement pe : pes) {
            QDataSet ds;
            if (!pe.isActive() || !RenderTypeUtil.needsColorbar(pe.getRenderType()) || (ds = pe.getController().getDataSet()) == null) continue;
            if ((ds = SemanticOps.trim((QDataSet)ds, (DatumRange)plot.getXaxis().getRange(), (DatumRange)plot.getYaxis().getRange())).length() == 0) break;
            PlotElement pcopy1 = (PlotElement)pe.copy();
            PlotElementController.doAutoranging(pcopy1, Collections.singletonMap("SCALE_TYPE", axis.isLog() ? "log" : "linear"), ds, true);
            if (range == null) {
                range = pcopy1.getPlotDefaults().getZaxis().getRange();
                continue;
            }
            range = DatumRangeUtil.union((DatumRange)range, (DatumRange)pcopy1.getPlotDefaults().getZaxis().getRange());
        }
        if (range != null) {
            axis.getController().setRangeAutomatically(range, axis.isLog());
        }
        PlotController.doHints(axis, axis.getAutoRangeHints());
        return result;
    }

    @Deprecated
    public static AutoRangeUtil.AutoRangeDescriptor autoRange(QDataSet ds, Map properties) {
        return AutoRangeUtil.autoRange(ds, properties);
    }

    @Deprecated
    public static AutoRangeUtil.AutoRangeDescriptor autoRange(QDataSet ds, Map properties, boolean ignoreDsProps) {
        return AutoRangeUtil.autoRange(ds, properties, ignoreDsProps);
    }

    public static void openBrowser(String url) {
        DataSourceUtil.openBrowser((String)url);
    }

    public static Document readDoc(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource source = new InputSource(new InputStreamReader(is));
        Document document = builder.parse(source);
        return document;
    }

    public static Map<String, Object> extractProperties(QDataSet ds) {
        QDataSet j1;
        Object v;
        String key;
        int i;
        Map result = DataSetUtil.getProperties((QDataSet)ds);
        for (i = 0; i < 4; ++i) {
            key = "DEPEND_" + i;
            v = ds.property(key);
            if (v == null) continue;
            result.put(key, AutoplotUtil.extractProperties((QDataSet)v));
        }
        for (i = 0; i < 50 && (v = ds.property(key = "PLANE_" + i)) != null; ++i) {
            result.put(key, AutoplotUtil.extractProperties((QDataSet)v));
        }
        if (SemanticOps.isJoin((QDataSet)ds) && ds.length() > 0 && ds.rank() == 3 && (j1 = (QDataSet)ds.slice(0).property("DEPEND_1")) != null) {
            Object v1;
            HashMap<String, Object> h1 = (HashMap<String, Object>)result.get("DEPEND_1");
            if (h1 == null) {
                h1 = new HashMap<String, Object>();
            }
            if ((v1 = j1.property("LABEL")) != null) {
                h1.put("LABEL", v1);
            }
            if ((v1 = j1.property("UNITS")) != null) {
                h1.put("UNITS", v1);
            }
            result.put("DEPEND_1", h1);
        }
        return result;
    }

    public static Map<String, Object> mergeProperties(Map<String, Object> properties, Map<String, Object> deflt) {
        if (deflt == null) {
            return properties;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(deflt);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object val = entry.getValue();
            String key = entry.getKey();
            if (val instanceof Map) {
                result.put(key, AutoplotUtil.mergeProperties((Map)val, (Map)deflt.get(key)));
                continue;
            }
            result.put(key, val);
        }
        return result;
    }

    public static String getProperty(String name, String deft) {
        try {
            return System.getProperty(name, deft);
        }
        catch (SecurityException ex) {
            return deft;
        }
    }

    public static void setDevicePosition(DasDevicePosition row, String spec) throws ParseException {
        int i = spec.indexOf(44);
        if (i == -1) {
            throw new IllegalArgumentException("spec must contain one comma");
        }
        double[] ddmin = DasDevicePosition.parseLayoutStr((String)spec.substring(0, i));
        double[] ddmax = DasDevicePosition.parseLayoutStr((String)spec.substring(i + 1));
        row.setMinimum(ddmin[0]);
        row.setEmMinimum(ddmin[1]);
        row.setPtMinimum((int)ddmin[2]);
        row.setMaximum(ddmax[0]);
        row.setEmMaximum(ddmax[1]);
        row.setPtMaximum((int)ddmax[2]);
    }

    public static String formatDevicePosition(DasDevicePosition pos) {
        return DasDevicePosition.formatLayoutStr((DasDevicePosition)pos, (boolean)true) + ", " + DasDevicePosition.formatLayoutStr((DasDevicePosition)pos, (boolean)false);
    }

    private static boolean isVectorOrBundleIndex(QDataSet dep1) {
        boolean result = false;
        Units dep1Units = (Units)dep1.property("UNITS");
        if (dep1Units != null && dep1Units instanceof EnumerationUnits) {
            result = true;
        }
        if (dep1.property("COORDINATE_FRAME") != null) {
            result = true;
        }
        return result;
    }

    public static RenderType guessRenderType(QDataSet fillds) {
        RenderType spec;
        boolean useHugeScatter;
        RenderType specPref;
        block45: {
            specPref = RenderType.spectrogram;
            Options o = new Options();
            Preferences prefs = AutoplotSettings.settings().getPreferences(o.getClass());
            boolean nn = prefs.getBoolean("nearestNeighbor", o.isNearestNeighbor());
            if (nn) {
                specPref = RenderType.nnSpectrogram;
            }
            useHugeScatter = "true".equals(System.getProperty("useHugeScatter", "true"));
            String srenderType = (String)fillds.property("RENDER_TYPE");
            if (srenderType != null) {
                if (srenderType.equals("time_series")) {
                    RenderType spec2 = useHugeScatter && fillds.length() > 80000 ? RenderType.hugeScatter : RenderType.series;
                    return spec2;
                }
                if (srenderType.equals("waveform")) {
                    RenderType spec3 = useHugeScatter ? RenderType.hugeScatter : RenderType.series;
                    return spec3;
                }
                try {
                    RenderType spec4 = srenderType.equals("spectrogram") ? specPref : RenderType.valueOf(srenderType);
                    return spec4;
                }
                catch (IllegalArgumentException e) {
                    int i = srenderType.indexOf(62);
                    if (i <= -1) break block45;
                    try {
                        srenderType = srenderType.substring(0, i);
                        RenderType spec5 = srenderType.equals("spectrogram") ? specPref : RenderType.valueOf(srenderType.substring(0, i));
                        return spec5;
                    }
                    catch (IllegalArgumentException e2) {
                        System.err.println("unable to resolve render type for: " + srenderType + " in " + fillds);
                    }
                }
            }
        }
        QDataSet dep1 = (QDataSet)fillds.property("DEPEND_1");
        QDataSet plane0 = (QDataSet)fillds.property("PLANE_0");
        QDataSet bundle1 = (QDataSet)fillds.property("BUNDLE_1");
        QDataSet dep0 = (QDataSet)fillds.property("DEPEND_0");
        boolean isRank3WaveformXYZ = Schemes.isRank3WaveformXYZ((QDataSet)fillds);
        if (isRank3WaveformXYZ) {
            bundle1 = (QDataSet)fillds.property("BUNDLE_2");
        }
        if (fillds.property("JOIN_0") != null) {
            if (fillds.length() == 0) {
                return RenderType.series;
            }
            dep1 = (QDataSet)fillds.property("DEPEND_1", 0);
            plane0 = (QDataSet)fillds.property("PLANE_0", 0);
            bundle1 = (QDataSet)fillds.property("BUNDLE_1", 0);
        }
        if (fillds.rank() == 2 && SemanticOps.isRank2Waveform((QDataSet)fillds)) {
            if (useHugeScatter) {
                return RenderType.hugeScatter;
            }
            return RenderType.series;
        }
        if (fillds.rank() >= 2) {
            boolean trivialBundle = false;
            if (dep1 != null && !AutoplotUtil.isVectorOrBundleIndex(dep1) && bundle1 != null && bundle1.length() > 0) {
                trivialBundle = true;
                Units u0 = (Units)bundle1.property("UNITS", 0);
                for (int j = 0; j < bundle1.length(); ++j) {
                    if (bundle1.property("NAME") == null || bundle1.property("UNITS") == u0) continue;
                    trivialBundle = false;
                }
            }
            if (trivialBundle) {
                if (isRank3WaveformXYZ) {
                    RenderType spec6 = useHugeScatter && fillds.length() > 80000 ? RenderType.hugeScatter : RenderType.series;
                    return spec6;
                }
                return specPref;
            }
            if (bundle1 != null && bundle1.length() < 30 || dep1 != null && AutoplotUtil.isVectorOrBundleIndex(dep1)) {
                spec = useHugeScatter && fillds.length() > 80000 ? RenderType.hugeScatter : RenderType.series;
                if (bundle1 != null) {
                    Units u3;
                    if (bundle1.length() == 3 && bundle1.property("DEPEND_0", 2) != null) {
                        spec = RenderType.colorScatter;
                    } else if (dep0 == null && bundle1.length() == 3 && bundle1.property("DEPENDNAME_0", 2) != null) {
                        spec = RenderType.colorScatter;
                    } else if (Schemes.isXYZScatter((QDataSet)fillds) && fillds.property("DEPEND_0") == null && !Schemes.isEventsList((QDataSet)fillds)) {
                        spec = Schemes.isNominalAtScatter((QDataSet)fillds) ? RenderType.digital : RenderType.colorScatter;
                    } else if (Schemes.isXYScatter((QDataSet)fillds) && fillds.property("DEPEND_0") == null) {
                        spec = RenderType.scatter;
                    } else if (bundle1.length() == 3 || bundle1.length() == 4 || bundle1.length() == 5) {
                        if (Schemes.isEventsList((QDataSet)fillds)) {
                            spec = RenderType.eventsBar;
                        } else {
                            u3 = (Units)bundle1.property("UNITS", bundle1.length() - 1);
                            if (UnitsUtil.isOrdinalMeasurement((Units)u3)) {
                                spec = RenderType.digital;
                            }
                        }
                    } else {
                        u3 = (Units)bundle1.property("UNITS", bundle1.length() - 1);
                        if (u3 != null && UnitsUtil.isOrdinalMeasurement((Units)u3)) {
                            spec = RenderType.eventsBar;
                        }
                    }
                }
            } else {
                int[] dims = DataSetUtil.qubeDims((QDataSet)fillds);
                spec = dep1 == null && fillds.rank() == 2 && fillds.length() > 3 && fillds.length(0) < 4 ? RenderType.series : (fillds.rank() == 2 && dims != null && dims[0] == 2 && dims[1] == 2 ? RenderType.bounds : (fillds.rank() == 3 && dims != null && dims[1] == 2 && dims[2] == 2 ? RenderType.bounds : (Schemes.isBundleDescriptor((QDataSet)fillds) ? RenderType.digital : specPref)));
            }
        } else if (fillds.rank() == 0 || fillds.rank() == 1 && (SemanticOps.isBundle((QDataSet)fillds) || Schemes.isComplexNumbers((QDataSet)fillds))) {
            spec = RenderType.digital;
        } else if (SemanticOps.getUnits((QDataSet)fillds) instanceof EnumerationUnits) {
            spec = dep0 == null ? RenderType.digital : RenderType.eventsBar;
        } else if (Schemes.isDatumRange((QDataSet)fillds) || Schemes.isCanonicalEvent((QDataSet)fillds)) {
            spec = RenderType.eventsBar;
        } else {
            spec = useHugeScatter && fillds.length() > 80000 ? RenderType.hugeScatter : RenderType.series;
            if (plane0 != null) {
                Units u = (Units)plane0.property("UNITS");
                if (u == null) {
                    u = Units.dimensionless;
                }
                if (u != null && (UnitsUtil.isRatioMeasurement((Units)u) || UnitsUtil.isIntervalMeasurement((Units)u))) {
                    spec = RenderType.colorScatter;
                }
            }
        }
        return spec;
    }

    public static boolean isParsableDouble(String myString) {
        String Digits = "(\\p{Digit}+)";
        String HexDigits = "(\\p{XDigit}+)";
        String Exp = "[eE][+-]?(\\p{Digit}+)";
        String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
        return Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", myString);
    }

    public static Renderer maybeCreateRenderer(RenderType renderType, Renderer recyclable, DasColorBar colorbar, boolean justRenderType) {
        SeriesRenderer result;
        boolean conf;
        boolean bl = conf = !justRenderType;
        if (renderType == RenderType.spectrogram) {
            SpectrogramRenderer result2;
            if (recyclable != null && recyclable instanceof SpectrogramRenderer) {
                result2 = (SpectrogramRenderer)recyclable;
                if (conf) {
                    result2.setRebinner(SpectrogramRenderer.RebinnerEnum.binAverage);
                }
            } else {
                result2 = new SpectrogramRenderer(null, colorbar);
                result2.setDataSetLoader(null);
            }
            if (conf) {
                result2.setRebinner(SpectrogramRenderer.RebinnerEnum.binAverage);
            }
            return result2;
        }
        if (renderType == RenderType.nnSpectrogram) {
            SpectrogramRenderer result3;
            SpectrogramRenderer.RebinnerEnum nn = "true".equals(System.getProperty("useLanlNearestNeighbor", "false")) ? SpectrogramRenderer.RebinnerEnum.lanlNearestNeighbor : SpectrogramRenderer.RebinnerEnum.nearestNeighbor;
            if (recyclable != null && recyclable instanceof SpectrogramRenderer) {
                result3 = (SpectrogramRenderer)recyclable;
                if (conf) {
                    result3.setRebinner(nn);
                }
            } else {
                SpectrogramRenderer result4 = new SpectrogramRenderer(null, colorbar);
                result4.setDataSetLoader(null);
                if (conf) {
                    result4.setRebinner(nn);
                }
                return result4;
            }
            result3.setRebinner(nn);
            return result3;
        }
        if (renderType == RenderType.hugeScatter) {
            if (recyclable != null && recyclable instanceof HugeScatterRenderer) {
                return recyclable;
            }
            HugeScatterRenderer result5 = new HugeScatterRenderer(null);
            result5.setEnvelope(1);
            result5.setDataSetLoader(null);
            return result5;
        }
        if (renderType == RenderType.digital) {
            if (recyclable != null && recyclable instanceof DigitalRenderer) {
                return recyclable;
            }
            DigitalRenderer result6 = new DigitalRenderer();
            result6.setDataSetLoader(null);
            return result6;
        }
        if (renderType == RenderType.image) {
            if (recyclable != null && recyclable instanceof RGBImageRenderer) {
                return recyclable;
            }
            RGBImageRenderer result7 = new RGBImageRenderer();
            result7.setDataSetLoader(null);
            return result7;
        }
        if (renderType == RenderType.eventsBar) {
            if (recyclable != null && recyclable instanceof EventsRenderer) {
                return recyclable;
            }
            EventsRenderer result8 = new EventsRenderer();
            result8.setDataSetLoader(null);
            return result8;
        }
        if (renderType == RenderType.stackedHistogram) {
            if (recyclable != null && recyclable instanceof StackedHistogramRenderer) {
                return recyclable;
            }
            StackedHistogramRenderer result9 = new StackedHistogramRenderer((DasAxis)colorbar);
            result9.setDataSetLoader(null);
            return result9;
        }
        if (renderType == RenderType.vectorPlot) {
            if (recyclable != null && recyclable instanceof VectorPlotRenderer) {
                return recyclable;
            }
            VectorPlotRenderer result10 = new VectorPlotRenderer();
            result10.setDataSetLoader(null);
            return result10;
        }
        if (renderType == RenderType.orbitPlot) {
            if (recyclable != null && recyclable instanceof TickCurveRenderer) {
                return recyclable;
            }
            TickCurveRenderer result11 = new TickCurveRenderer();
            result11.setDataSetLoader(null);
            return result11;
        }
        if (renderType == RenderType.contour) {
            if (recyclable != null && recyclable instanceof ContoursRenderer) {
                return recyclable;
            }
            ContoursRenderer result12 = new ContoursRenderer();
            result12.setDataSetLoader(null);
            return result12;
        }
        if (renderType == RenderType.polar) {
            if (recyclable != null && recyclable instanceof PolarPlotRenderer) {
                return recyclable;
            }
            PolarPlotRenderer result13 = new PolarPlotRenderer(colorbar);
            result13.setDataSetLoader(null);
            return result13;
        }
        if (renderType == RenderType.pitchAngleDistribution) {
            if (recyclable != null && recyclable instanceof PitchAngleDistributionRenderer) {
                return recyclable;
            }
            PitchAngleDistributionRenderer result14 = new PitchAngleDistributionRenderer(colorbar);
            result14.setDataSetLoader(null);
            return result14;
        }
        if (renderType == RenderType.bounds) {
            if (recyclable != null && recyclable instanceof BoundsRenderer) {
                return recyclable;
            }
            BoundsRenderer result15 = new BoundsRenderer();
            result15.setDataSetLoader(null);
            return result15;
        }
        if (renderType == RenderType.internal) {
            return recyclable;
        }
        if (recyclable != null && recyclable instanceof SeriesRenderer) {
            result = (SeriesRenderer)recyclable;
        } else {
            result = new SeriesRenderer();
            result.setDataSetLoader(null);
        }
        if (justRenderType) {
            return result;
        }
        if (renderType == RenderType.colorScatter) {
            result.setColorBar(colorbar);
            result.setColorByDataSetId("PLANE_0");
        } else {
            result.setColorByDataSetId("");
        }
        if (renderType == RenderType.series) {
            result.setPsymConnector(PsymConnector.SOLID);
            result.setHistogram(false);
            result.setFillToReference(false);
        } else if (renderType == RenderType.scatter) {
            result.setPsymConnector(PsymConnector.NONE);
            result.setPsym((PlotSymbol)DefaultPlotSymbol.CIRCLES);
            result.setFillToReference(false);
        } else if (renderType == RenderType.colorScatter) {
            result.setPsymConnector(PsymConnector.NONE);
            result.setPsym((PlotSymbol)DefaultPlotSymbol.CIRCLES);
            result.setSymSize(3.0);
            result.setFillToReference(false);
        } else if (renderType == RenderType.stairSteps) {
            result.setPsymConnector(PsymConnector.SOLID);
            result.setFillToReference(true);
            result.setHistogram(true);
        } else if (renderType == RenderType.fillToZero) {
            result.setPsymConnector(PsymConnector.SOLID);
            result.setFillToReference(true);
            result.setHistogram(false);
        }
        return result;
    }

    public static Image getAutoplotIcon() {
        return new ImageIcon(AutoplotUtil.class.getResource("/resources/logo64.png")).getImage();
    }

    public static Image getNoIcon() {
        return new ImageIcon(AutoplotUtil.class.getResource("/resources/logo64.png")).getImage();
    }

    public static Icon cancelIcon() {
        return new ImageIcon(AutoplotUtil.class.getResource("/com/cottagesystems/jdiskhog/resources/cancel14.png"));
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        if (message instanceof Component) {
            final Component editorPane = (Component)message;
            editorPane.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    Dialog dialog;
                    Window window = SwingUtilities.getWindowAncestor(editorPane);
                    if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dialog.setResizable(true);
                            }
                        });
                    }
                }
            });
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, messageType, new ImageIcon(AutoplotUtil.getAutoplotIcon()));
    }

    public static void showMessageDialog(Component parentComponent, Object message) {
        AutoplotUtil.showMessageDialog(parentComponent, message, "Message", 0);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        if (optionType != 2) {
            return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType);
        }
        return AutoplotUtil.showConfirmDialog2(parentComponent, message, title, optionType);
    }

    public static int showConfirmDialog2(Component parent, Object omessage, String title, int optionType) {
        return WindowManager.showConfirmDialog((Component)parent, (Object)omessage, (String)title, (int)optionType);
    }

    public static String getProcessId(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static String getAboutAutoplotHtml(ApplicationModel model) throws IOException {
        SecurityManager sm;
        StringBuilder buffy = new StringBuilder();
        buffy.append("<html>\n");
        URL aboutHtml = AutoplotUI.class.getResource("aboutAutoplot.html");
        String releaseTag = AboutUtil.getReleaseTag();
        if (aboutHtml != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(aboutHtml.openStream()));
            Object object = null;
            try {
                String s = reader.readLine();
                while (s != null) {
                    s = s.replaceAll("\\#\\{tag\\}", releaseTag);
                    buffy.append(s);
                    s = reader.readLine();
                }
            }
            catch (Throwable s) {
                object = s;
                throw s;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable s) {
                            ((Throwable)object).addSuppressed(s);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        buffy.append("<h2>Build Information:</h2>");
        buffy.append("<ul>");
        buffy.append("<li>release tag: ").append(AboutUtil.getReleaseTag()).append("</li>");
        buffy.append("<li>build url: ").append(AboutUtil.getJenkinsURL()).append("</li>");
        List<String> bi = Util.getBuildInfos();
        for (String ss : bi) {
            buffy.append("    <li>").append(ss);
        }
        buffy.append("</ul>");
        buffy.append("<h2>Open Source Components:</h2>");
        buffy.append("Autoplot uses many open-source components, such as: <br>");
        buffy.append("jsyntaxpane, Jython, Netbeans (Jython completion), OpenDAP, CDF, FITS, NetCDF, POI HSSF (Excel), Batik (SVG), iText (PDF), JSON, JavaCSV, JPG Metadata Extractor, Imgscalr, utils4j, JDiskHog, and Das2.");
        buffy.append("<h2>Runtime Information:</h2>");
        String javaVersion = System.getProperty("java.version");
        String arch = System.getProperty("os.arch");
        DecimalFormat nf = new DecimalFormat("0.0");
        String mem = nf.format(Runtime.getRuntime().maxMemory() / 1000000L);
        String tmem = nf.format(Runtime.getRuntime().totalMemory() / 1000000L);
        String fmem = nf.format(Runtime.getRuntime().freeMemory() / 1000000L);
        String nmem = "???";
        try {
            Class<?> VM = Class.forName("sun.misc.VM");
            Method maxDirectMemory = VM.getDeclaredMethod("maxDirectMemory", new Class[0]);
            Object result = maxDirectMemory.invoke(null, (Object[])null);
            if (result != null && result instanceof Long) {
                nmem = nf.format((Long)result / 1000000L);
            }
        }
        catch (ClassNotFoundException VM) {
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        String pwd = new File("foo.txt").getAbsoluteFile().getParent();
        String pid = AutoplotUtil.getProcessId("???");
        String host = InetAddress.getLocalHost().getHostName();
        String memWarning = "";
        if (Runtime.getRuntime().maxMemory() / 1000000L < 700L) {
            memWarning = "<li> Available RAM is low, severely limiting capabilities (<a href=\"http://autoplot.org/lowMem\">info</a>)";
        }
        String bits = is32bit ? "32" : "64";
        String bitsWarning = is32bit ? "(<a href=\"https://autoplot.org/32bit\">severely limiting capabilities</a>)" : "(recommended)";
        String javaVersionWarning = "";
        Pattern p = Pattern.compile("(\\d+\\.\\d+)\\.\\d+\\_(\\d+)");
        Matcher m = p.matcher(javaVersion);
        if (m.matches()) {
            double major = Double.parseDouble(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            javaVersionWarning = major < 1.8 || major == 1.8 && minor < 102 ? "(<a href=\"https://autoplot.org/javaVersion\">limiting access to CDAWeb</a>)" : "(recommended)";
        }
        String autoplotData = AutoplotSettings.settings().resolveProperty("autoplotData");
        String fscache = AutoplotSettings.settings().resolveProperty("fscache");
        String sandbox = model.isSandboxed() ? ((sm = System.getSecurityManager()) != null ? (sm == Sandbox.getSandboxManager() ? "true" : "true, but not sandbox security manager.") : "true, BUT NO SECURITY MANAGER IS PRESENT") : "false";
        String aboutContent = "<ul><li>Java version: " + javaVersion + " " + javaVersionWarning + memWarning + "<li>Java home: " + System.getProperty("java.home") + "<li>max memory (MB): " + mem + " (memory available to process)<li>total memory (MB): " + tmem + " (amount allocated to the process)<li>free memory (MB): " + fmem + " (amount available before more must be allocated)<li>native memory limit (MB): " + nmem + " (amount of native memory available to the process)<li>sandbox: " + sandbox + "<li>noCheckCertificates: " + (HttpsURLConnection.getDefaultHostnameVerifier() == allHostsValid) + "<li>arch: " + arch + "<li>release type: " + System.getProperty("autoplot.release.type", "???") + "<li>" + bits + " bit Java " + bitsWarning + "<li>hostname: " + host + "<li>pid: " + pid + "<li>pwd: " + pwd + "<li>autoplotData: " + autoplotData + "<li>fscache: " + fscache + "</ul>";
        buffy.append(aboutContent);
        buffy.append("</html>");
        return buffy.toString();
    }

    public static void disableCertificates() {
        logger.info("disabling HTTP certificate checks.");
        try {
            System.setProperty("autoplot.disable.certs", String.valueOf(true));
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public static void maybeInitializeEditorColors() {
        File config = new File(new File(AutoplotSettings.settings().resolveProperty("autoplotData")), "config");
        if (!config.exists() && !config.mkdirs()) {
            logger.log(Level.WARNING, "mkdir {0} failed", config);
            return;
        }
        File propFile = new File(config, "jsyntaxpane.properties");
        if (!propFile.exists()) {
            try (PrintWriter w = new PrintWriter(new FileWriter(propFile));){
                w.println("TokenMarker.Color = 0xffeeaa");
                w.println("PairMarker.Color = 0xffbb77");
                w.println("LineNumbers.Foreground = 0x333300");
                w.println("LineNumbers.Background = 0xeeeeff");
                w.println("LineNumbers.CurrentBack = 0xccccee");
                w.println("CaretColor = 0x000000");
                w.println("Background = 0xFFFFFF");
                w.println("SelectionColor = 0x556677");
                w.println("# These are the various Attributes for each TokenType.");
                w.println("# The keys of this map are the TokenType Strings, and the values are:");
                w.println("# color (hex, or integer), Font.Style attribute");
                w.println("# Style is one of: 0 = plain, 1=bold, 2=italic, 3=bold/italic");
                w.println("Style.OPERATOR = 0x000000, 0");
                w.println("Style.DELIMITER = 0x000000, 1");
                w.println("Style.KEYWORD = 0x3333ee, 0");
                w.println("Style.KEYWORD2 = 0x3333ee, 3");
                w.println("Style.TYPE = 0x000000, 2");
                w.println("Style.TYPE2 = 0x000000, 1");
                w.println("Style.TYPE3 = 0x000000, 3");
                w.println("Style.STRING = 0xcc6600, 0");
                w.println("Style.STRING2 = 0xcc6600, 1");
                w.println("Style.NUMBER = 0x999933, 1");
                w.println("Style.REGEX = 0xcc6600, 0");
                w.println("Style.IDENTIFIER = 0x000000, 0");
                w.println("Style.COMMENT = 0x339933, 2");
                w.println("Style.COMMENT2 = 0x339933, 3");
                w.println("Style.DEFAULT = 0x000000, 0");
                w.println("Style.WARNING = 0xCC0000, 0");
                w.println("Style.ERROR = 0xCC0000, 3");
                w.close();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "write initial {0} failed.  {1}", new Object[]{propFile, ex});
            }
        }
    }

    static {
        String s = System.getProperty("sun.arch.data.model");
        is32bit = s == null ? !(s = System.getProperty("os.arch")).contains("64") : s.equals("32");
        String javaVersion = System.getProperty("java.version");
        Pattern p = Pattern.compile("(\\d+\\.\\d+)\\.\\d+\\_(\\d+)");
        Matcher m = p.matcher(javaVersion);
        if (m.matches()) {
            double major = Double.parseDouble(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            javaVersionWarning = major < 1.8 || major == 1.8 && minor < 102 ? " (oldJRE)" : "";
        } else {
            javaVersionWarning = "";
        }
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            public String toString() {
                return "AutoplotTrustAllTrustManager";
            }
        }};
        allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }

            public String toString() {
                return "AutoplotTrustAllHostnamesHostnameManager";
            }
        };
    }
}

