/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.autoplot.dom.Application;
import org.autoplot.dom.DomOps;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class FixLayoutPanel
extends JPanel {
    Application dom0 = null;
    Application dom = null;
    private JCheckBox hideTimeAxesCheckBox;
    private JCheckBox hideTitlesCheckBox;
    private JCheckBox hideYAxesCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox moveLegendsToOutsideNECheckBox;
    private JCheckBox verticalSpacingCheckBox;
    private JComboBox<String> verticalSpacingComboBox;
    private BindingGroup bindingGroup;

    public FixLayoutPanel() {
        this.initComponents();
    }

    public void setOptions(Map<String, String> options) {
        for (Map.Entry<String, String> e : options.entrySet()) {
            switch (e.getKey()) {
                case "hideTitles": {
                    this.hideTitlesCheckBox.setSelected(Boolean.valueOf(e.getValue()));
                    break;
                }
                case "hideTimeAxes": {
                    this.hideTimeAxesCheckBox.setSelected(Boolean.valueOf(e.getValue()));
                    break;
                }
                case "hideYAxes": {
                    this.hideYAxesCheckBox.setSelected(Boolean.valueOf(e.getValue()));
                    break;
                }
                case "verticalSpacing": {
                    this.verticalSpacingCheckBox.setSelected(true);
                    this.verticalSpacingComboBox.setSelectedItem(e.getValue());
                    break;
                }
                case "moveLegendsToOutsideNE": {
                    this.moveLegendsToOutsideNECheckBox.setSelected(Boolean.valueOf(e.getValue()));
                }
            }
        }
    }

    public Map<String, String> getOptions() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.hideTitlesCheckBox.isSelected()) {
            result.put("hideTitles", "true");
        }
        if (this.hideTimeAxesCheckBox.isSelected()) {
            result.put("hideTimeAxes", "true");
        }
        if (this.hideYAxesCheckBox.isSelected()) {
            result.put("hideYAxes", "true");
        }
        if (this.verticalSpacingCheckBox.isSelected()) {
            result.put("verticalSpacing", this.verticalSpacingComboBox.getSelectedItem().toString());
            result.put("horizontalSpacing", this.verticalSpacingComboBox.getSelectedItem().toString());
        }
        if (this.moveLegendsToOutsideNECheckBox.isSelected()) {
            result.put("moveLegendsToOutsideNE", "true");
        }
        return result;
    }

    public void setPreview(Application dom) {
        this.dom = dom;
        this.dom0 = (Application)dom.copy();
    }

    private void updatePreview() {
        if (this.dom != null) {
            this.dom.syncTo(this.dom0);
            DomOps.fixLayout(this.dom, this.getOptions());
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jLabel1 = new JLabel();
        this.verticalSpacingCheckBox = new JCheckBox();
        this.verticalSpacingComboBox = new JComboBox();
        this.moveLegendsToOutsideNECheckBox = new JCheckBox();
        this.hideTimeAxesCheckBox = new JCheckBox();
        this.hideTitlesCheckBox = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.hideYAxesCheckBox = new JCheckBox();
        this.jLabel1.setText("Fix Layout");
        this.verticalSpacingCheckBox.setText("Spacing between plots:");
        this.verticalSpacingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixLayoutPanel.this.verticalSpacingCheckBoxActionPerformed(evt);
            }
        });
        this.verticalSpacingComboBox.setEditable(true);
        this.verticalSpacingComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0.0em", "0.5em", "1.0em", "1.5em", "2.0em", "2.5em", "3.0em", "3.5em", "4.0em", " "}));
        this.verticalSpacingComboBox.setSelectedIndex(1);
        this.verticalSpacingComboBox.setToolTipText("");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.verticalSpacingCheckBox, (Property)ELProperty.create((String)"${selected}"), this.verticalSpacingComboBox, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.verticalSpacingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixLayoutPanel.this.verticalSpacingComboBoxActionPerformed(evt);
            }
        });
        this.moveLegendsToOutsideNECheckBox.setText("Move legends to outside NE");
        this.moveLegendsToOutsideNECheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixLayoutPanel.this.moveLegendsToOutsideNECheckBoxActionPerformed(evt);
            }
        });
        this.hideTimeAxesCheckBox.setText("Hide time (X) axes");
        this.hideTimeAxesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixLayoutPanel.this.hideTimeAxesCheckBoxActionPerformed(evt);
            }
        });
        this.hideTitlesCheckBox.setText("Hide Titles");
        this.hideTitlesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixLayoutPanel.this.hideTitlesCheckBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("<html>Fix Layout will try to recover empty spots and overlaps to make the layout easier to read.  You can also turn off titles and axis labels to recover more room.");
        this.jLabel2.setVerticalAlignment(1);
        this.hideYAxesCheckBox.setText("Hide Y axes");
        this.hideYAxesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixLayoutPanel.this.hideYAxesCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 12, Short.MAX_VALUE).addComponent(this.jLabel1).addGap(329, 329, 329)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moveLegendsToOutsideNECheckBox).addGroup(layout.createSequentialGroup().addComponent(this.verticalSpacingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verticalSpacingComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.hideTimeAxesCheckBox).addGap(18, 18, 18).addComponent(this.hideYAxesCheckBox)).addComponent(this.hideTitlesCheckBox)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 69, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.verticalSpacingCheckBox).addComponent(this.verticalSpacingComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideTitlesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hideTimeAxesCheckBox).addComponent(this.hideYAxesCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveLegendsToOutsideNECheckBox).addGap(0, 101, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    private void verticalSpacingCheckBoxActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void hideTitlesCheckBoxActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void hideTimeAxesCheckBoxActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void moveLegendsToOutsideNECheckBoxActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void verticalSpacingComboBoxActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void hideYAxesCheckBoxActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }
}

