/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.autoplot.PlotStylePanel;
import org.autoplot.dom.PlotElement;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class DigitalStylePanel
extends JPanel
implements PlotStylePanel.StylePanel {
    EnumerationEditor ened;
    Renderer renderer;
    BindingGroup elementBindingContext;
    private String control = "";
    public static final String PROP_CONTROL = "control";
    private JPanel alignPanel;
    private ColorEditor colorEditor1;
    private JPanel colorPanel;
    private JTextField fillLabelTF;
    private JComboBox<String> fontSizeCB;
    private JComboBox<String> formatCB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;

    public DigitalStylePanel() {
        this.initComponents();
        this.colorEditor1.setValue((Object)Color.BLACK);
        this.colorPanel.add(this.colorEditor1.getSmallEditor());
        this.ened = new EnumerationEditor();
        this.ened.setValue((Object)DigitalRenderer.Align.CENTER);
        this.alignPanel.add(this.ened.getCustomEditor());
        this.ened.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DigitalStylePanel.this.update();
            }
        });
        this.colorEditor1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DigitalStylePanel.this.update();
            }
        });
        this.fontSizeCB.setModel(new DefaultComboBoxModel<String>(new String[]{"", "0.8em", "1.2em", "8pt"}));
        this.fontSizeCB.setSelectedItem("");
        this.validate();
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        this.updateGUI(this.renderer);
        this.firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    private void update() {
        String c;
        String oldValue = this.control;
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("fontSize", (String)this.fontSizeCB.getSelectedItem());
        controls.put("format", this.formatCB.getSelectedItem().toString().trim());
        controls.put("color", Renderer.encodeColorControl((Color)((Color)this.colorEditor1.getValue())));
        controls.put("align", this.ened.getValue().toString());
        controls.put("fillLabel", this.fillLabelTF.getText());
        this.control = c = Renderer.formatControl(controls);
        this.firePropertyChange(PROP_CONTROL, oldValue, c);
    }

    private void updateGUI(Renderer renderer) {
        this.control = renderer.getControl();
        this.fontSizeCB.setSelectedItem(renderer.getControl("fontSize", ""));
        this.colorEditor1.setValue((Object)renderer.getColorControl("color", Color.BLACK));
        this.formatCB.setSelectedItem(renderer.getControl("format", ""));
        try {
            this.ened.setValue((Object)DigitalRenderer.Align.valueOf((String)renderer.getControl("align", "CENTER")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.fillLabelTF.setText(renderer.getControl("fillLabel", "fill"));
    }

    @Override
    public void doElementBindings(PlotElement element) {
        this.renderer = element.getController().getRenderer();
        this.updateGUI(this.renderer);
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)element, (Property)BeanProperty.create((String)"renderControl"), (Object)this, (Property)BeanProperty.create((String)PROP_CONTROL)));
        if (this.elementBindingContext != null) {
            this.releaseElementBindings();
        }
        bc.bind();
        this.repaint();
        this.elementBindingContext = bc;
    }

    @Override
    public void releaseElementBindings() {
        if (this.elementBindingContext != null) {
            this.elementBindingContext.unbind();
            this.elementBindingContext = null;
        }
    }

    private void initComponents() {
        this.colorEditor1 = new ColorEditor();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.colorPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.alignPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.fillLabelTF = new JTextField();
        this.formatCB = new JComboBox();
        this.fontSizeCB = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("Digital"));
        this.jLabel1.setText("Font Size:");
        this.jLabel1.setToolTipText("Font size relative to the plot font size, like 0.5em means half of the plot's font size.");
        this.jLabel2.setText("Color:");
        this.colorPanel.setLayout(new BorderLayout());
        this.jLabel3.setText("Format:");
        this.jLabel3.setToolTipText("Format specifier like %9.2f");
        this.jLabel4.setText("Align:");
        this.alignPanel.setLayout(new BorderLayout());
        this.jLabel5.setText("Fill Label:");
        this.jLabel5.setToolTipText("Use this text to indicate a fill value");
        this.fillLabelTF.setText("fill");
        this.fillLabelTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DigitalStylePanel.this.fillLabelTFActionPerformed(evt);
            }
        });
        this.fillLabelTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DigitalStylePanel.this.focusLost(evt);
            }
        });
        this.formatCB.setEditable(true);
        this.formatCB.setModel(new DefaultComboBoxModel<String>(new String[]{"%.2f", "%.1E", "%d", "%c", "%x", "%o"}));
        this.formatCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DigitalStylePanel.this.formatCBActionPerformed(evt);
            }
        });
        this.fontSizeCB.setEditable(true);
        this.fontSizeCB.setModel(new DefaultComboBoxModel<String>(new String[]{"0.8em", "1.2em", "8pt"}));
        this.fontSizeCB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DigitalStylePanel.this.fontSizeCBFocusLost(evt);
            }
        });
        this.fontSizeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DigitalStylePanel.this.fontSizeCBActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.alignPanel, -1, -1, Short.MAX_VALUE).addGap(4, 4, 4)).addGroup(layout.createSequentialGroup().addComponent(this.colorPanel, -2, 100, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.fontSizeCB, 0, 146, Short.MAX_VALUE).addComponent(this.formatCB, 0, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addGap(18, 18, 18).addComponent(this.fillLabelTF, -2, 76, -2))).addGap(2, 2, 2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2)).addComponent(this.colorPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(35, 35, 35)).addGroup(layout.createSequentialGroup().addComponent(this.fontSizeCB, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.formatCB, -2, -1, -2)))).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(8, 8, 8)).addGroup(layout.createSequentialGroup().addComponent(this.alignPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fillLabelTF, -2, -1, -2).addComponent(this.jLabel5)).addContainerGap(20, Short.MAX_VALUE)));
    }

    private void focusLost(FocusEvent evt) {
        this.update();
    }

    private void fillLabelTFActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void formatCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void fontSizeCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void fontSizeCBFocusLost(FocusEvent evt) {
        this.update();
    }
}

