/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dods;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import opendap.Version;
import opendap.dap.BaseType;
import opendap.dap.DAP2Exception;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DConnect;
import opendap.dap.DDS;
import opendap.dap.DDSException;
import opendap.dap.DFloat32;
import opendap.dap.DFloat64;
import opendap.dap.DGrid;
import opendap.dap.DSequence;
import opendap.dap.DStructure;
import opendap.dap.Float32PrimitiveVector;
import opendap.dap.Float64PrimitiveVector;
import opendap.dap.Int16PrimitiveVector;
import opendap.dap.Int32PrimitiveVector;
import opendap.dap.NoSuchVariableException;
import opendap.dap.PrimitiveVector;
import opendap.dap.StatusUI;
import org.autoplot.dods.ArrayUtil;
import org.autoplot.dods.DodsVarDataSet;
import org.autoplot.metatree.MetadataUtil;
import org.das2.datum.Units;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;

public class DodsAdapter {
    private static final Logger logger = Logger.getLogger("apdss.opendap");
    private final URL source;
    private String variable;
    private String constraint;
    private DDS dds;
    private final HashMap<String, Object> properties;
    private String depend0Name;
    private String depend1Name;
    private double addOffset = 0.0;
    private double scaleFactor = 1.0;
    private final Units[] dimUnits = new Units[8];
    private final HashMap[] dimProperties = new HashMap[8];
    private Units units;
    private final String[] dependName = new String[8];

    public DodsAdapter(URL source, String variable) {
        logger.entering("org.autoplot.dods.DodsAdapter", "DodsAdapter");
        this.source = source;
        this.variable = variable;
        this.properties = new HashMap();
        logger.exiting("org.autoplot.dods.DodsAdapter", "DodsAdapter");
    }

    void setVariable(String variable) {
        this.variable = variable;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setConstraint(String c) {
        if (!c.startsWith("?")) {
            throw new IllegalArgumentException("constraint must start with question mark(?)");
        }
        this.constraint = c;
    }

    public String getConstraint() {
        return this.constraint;
    }

    private long getSizeForType(DArray v, boolean streaming) {
        PrimitiveVector pv = v.getPrimitiveVector();
        Enumeration e = v.getDimensions();
        int n = 1;
        while (e.hasMoreElements()) {
            DArrayDimension a = (DArrayDimension)e.nextElement();
            n *= a.getSize();
        }
        if (pv instanceof Float32PrimitiveVector) {
            return 4 * n * (streaming ? v.getFirstDimension().getSize() : 1);
        }
        if (pv instanceof Float64PrimitiveVector) {
            return 8 * n * (streaming ? v.getFirstDimension().getSize() : 1);
        }
        if (pv instanceof Int32PrimitiveVector) {
            return 4 * n * (streaming ? v.getFirstDimension().getSize() : 1);
        }
        if (pv instanceof Int16PrimitiveVector) {
            return 2 * n * (streaming ? v.getFirstDimension().getSize() : 1);
        }
        return n;
    }

    private long getSizeForType(BaseType v, boolean streaming) {
        if (v instanceof DFloat64) {
            return 8L;
        }
        if (v instanceof DFloat32) {
            return 4L;
        }
        if (v instanceof DArray) {
            return this.getSizeForType((DArray)v, streaming);
        }
        throw new IllegalArgumentException("not supported: " + v);
    }

    private long calcSize(Map<String, Object> attr) throws MalformedURLException, IOException, opendap.dap.parser.ParseException {
        try {
            logger.entering("org.autoplot.dods.DodsAdapter", "calcSize");
            DDS ldds = new DDS();
            URL url = new URL(this.getSource().toString() + ".dds" + this.constraint);
            logger.log(Level.FINE, "calcSize opening {0}", url);
            try (InputStream in = url.openStream();){
                ldds.parse(in);
            }
            Enumeration variables = ldds.getVariables();
            long size = 0L;
            while (variables.hasMoreElements()) {
                String n;
                Object o = variables.nextElement();
                if (o instanceof DSequence) {
                    Enumeration enume1 = ((DSequence)o).getVariables();
                    n = ((DSequence)o).getName();
                    int j = 0;
                    while (enume1.hasMoreElements()) {
                        Object ele = enume1.nextElement();
                        if (ele instanceof DStructure) {
                            DStructure ds = (DStructure)ele;
                            Enumeration enume2 = ds.getVariables();
                            while (enume2.hasMoreElements()) {
                                Object k = enume2.nextElement();
                                long s = this.getSizeForType((BaseType)k, true);
                                j = (int)((long)j + s);
                                logger.log(Level.FINE, "   calcSize {0}: {1}", new Object[]{((BaseType)k).getName(), s});
                            }
                            continue;
                        }
                        if (ele instanceof DSequence) {
                            j += 0;
                            continue;
                        }
                        if (ele instanceof BaseType) {
                            long s = this.getSizeForType((BaseType)ele, true);
                            j = (int)((long)j + s);
                            logger.log(Level.FINE, "   calcSize {0}: {1}", new Object[]{((BaseType)ele).getName(), s});
                            continue;
                        }
                        throw new IllegalArgumentException("huh");
                    }
                    String srecCount = (String)attr.get("recCount");
                    size = srecCount != null ? (long)j * Long.parseLong(srecCount) : -1L;
                } else if (o instanceof DGrid) {
                    DGrid dg = (DGrid)o;
                    n = dg.getName();
                    Enumeration enume1 = dg.getVariables();
                    int j = 0;
                    while (enume1.hasMoreElements()) {
                        Object ele = enume1.nextElement();
                        if (ele instanceof DStructure) {
                            DStructure ds = (DStructure)ele;
                            Enumeration enume2 = ds.getVariables();
                            while (enume2.hasMoreElements()) {
                                Object k = enume2.nextElement();
                                long s = this.getSizeForType((BaseType)k, false);
                                j = (int)((long)j + s);
                                logger.log(Level.FINE, "   calcSize {0}: {1}", new Object[]{((BaseType)k).getName(), s});
                            }
                            continue;
                        }
                        if (ele instanceof DSequence) {
                            j += 0;
                            continue;
                        }
                        if (!(ele instanceof BaseType)) continue;
                        j = (int)((long)j + this.getSizeForType((BaseType)ele, false));
                    }
                    size = j;
                } else {
                    DArray v = (DArray)o;
                    n = ((DArray)o).getName();
                    Enumeration dimensions = v.getDimensions();
                    long s1 = this.getSizeForType(v, false);
                    s1 *= 2L;
                    while (dimensions.hasMoreElements()) {
                        DArrayDimension d = (DArrayDimension)dimensions.nextElement();
                        s1 *= (long)d.getSize();
                    }
                    size += s1;
                }
                logger.log(Level.FINE, "calcSize {0}: {1}", new Object[]{n, size});
            }
            logger.exiting("org.autoplot.dods.DodsAdapter", "calcSize");
            return size;
        }
        catch (DDSException e) {
            throw new RuntimeException(e);
        }
    }

    private StatusUI adaptStatusUI(final ProgressMonitor mon) {
        return new StatusUI(){
            long byteCount = 0L;

            public void incrementByteCount(int bytes) {
                this.byteCount += (long)bytes;
                mon.setTaskProgress(this.byteCount);
                if (mon.getTaskSize() == -1L) {
                    mon.setProgressMessage(String.format("%d KBytes loaded", this.byteCount / 1024L));
                }
            }

            public boolean userCancelled() {
                return mon.isCancelled();
            }

            public void finished() {
                mon.finished();
            }
        };
    }

    public void loadDataset(ProgressMonitor mon, Map<String, Object> attr) throws FileNotFoundException, MalformedURLException, IOException, opendap.dap.parser.ParseException, DDSException, DDSException, CancelledOperationException, DAP2Exception {
        logger.entering("org.autoplot.dods.DodsAdapter", "loadDataset");
        if (this.constraint == null) {
            this.constraint = "";
        }
        long size = this.calcSize(attr);
        mon.setTaskSize(size);
        if (mon.isCancelled()) {
            throw new CancelledOperationException("OpenDap load cancelled");
        }
        logger.log(Level.FINE, "constructing dconnect on {0}", this.source.toString());
        DConnect dconnect = new DConnect(this.source.toString(), true);
        StatusUI statusUI = this.adaptStatusUI(mon);
        mon.started();
        try {
            logger.log(Level.FINE, "calling dconnect.getData constraint={0}", this.constraint);
            if (mon.isCancelled()) {
                throw new CancelledOperationException("OpenDap load cancelled");
            }
            this.dds = dconnect.getData(this.constraint, statusUI);
            logger.log(Level.FINE, "called dconnect.getData -> {0}", this.dds);
            if (this.dds == null) {
                System.err.println("Webstart/Opendap interaction results in dconnect.getData -> null");
                System.err.println("opendap.Version.getVersionString()=" + Version.getVersionString());
                throw new IllegalArgumentException("unable to load data, for unknown reason.");
            }
        }
        catch (DDSException ex) {
            if (mon.isCancelled()) {
                logger.log(Level.FINE, ex.getMessage(), ex);
                throw new CancelledOperationException("Dods load cancelled");
            }
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw ex;
        }
        finally {
            if (!mon.isFinished()) {
                mon.finished();
            }
            logger.exiting("org.autoplot.dods.DodsAdapter", "loadDataset");
        }
    }

    public QDataSet getDataSet(Map<String, Object> attributes) {
        DodsVarDataSet zds;
        block38: {
            logger.entering("org.autoplot.dods.DodsAdapter", "getDataSet");
            if (attributes == null) {
                attributes = new HashMap<String, Object>();
            }
            try {
                BaseType btvar = this.dds.getVariable(this.variable);
                String type = btvar.getTypeName();
                if (type.equals("Grid")) {
                    DGrid zgrid = (DGrid)btvar;
                    DArray z = (DArray)zgrid.getVar(0);
                    zds = this.properties.isEmpty() ? DodsVarDataSet.newDataSet(z, attributes) : DodsVarDataSet.newDataSet(z, this.properties);
                    if (zds.property("UNITS") == null) {
                        zds.putProperty("UNITS", this.units);
                    }
                    for (int idim = 0; idim < z.numDimensions(); ++idim) {
                        DArray t = (DArray)zgrid.getVar(idim + 1);
                        HashMap<String, Object> tprops = new HashMap<String, Object>();
                        tprops.put("UNITS", this.dimUnits[idim]);
                        if (this.dimProperties[idim] != null) {
                            String[] ss;
                            for (String s : ss = DataSetUtil.dimensionProperties()) {
                                if (!this.dimProperties[idim].containsKey(s)) continue;
                                tprops.put(s, this.dimProperties[idim].get(s));
                            }
                        }
                        DodsVarDataSet tds = DodsVarDataSet.newDataSet(t, tprops);
                        zds.putProperty("DEPEND_" + idim, tds);
                    }
                    break block38;
                }
                if (type.equals("Array")) {
                    DArray z = (DArray)btvar;
                    zds = this.properties.isEmpty() ? DodsVarDataSet.newDataSet(z, attributes) : DodsVarDataSet.newDataSet(z, this.properties);
                    if (zds.property("UNITS") == null) {
                        zds.putProperty("UNITS", this.units);
                    }
                    if (zds.property("UNITS") == null) {
                        String s = String.valueOf(attributes.get("units"));
                        zds = DodsAdapter.checkTimeUnits(s, (MutablePropertyDataSet)zds);
                    }
                    for (int idim = 0; idim < z.numDimensions(); ++idim) {
                        if (this.dependName[idim] == null) continue;
                        DArray t = (DArray)this.dds.getVariable(this.dependName[idim]);
                        HashMap<String, Object> tprops = new HashMap<String, Object>();
                        tprops.put("UNITS", this.dimUnits[idim]);
                        String[] ss = DataSetUtil.dimensionProperties();
                        for (String s : ss) {
                            if (this.dimProperties[idim] == null || !this.dimProperties[idim].containsKey(s)) continue;
                            tprops.put(s, this.dimProperties[idim].get(s));
                        }
                        DodsVarDataSet tds = DodsVarDataSet.newDataSet(t, tprops);
                        if (DataSetUtil.isMonotonic((QDataSet)tds)) {
                            tds.putProperty("MONOTONIC", Boolean.TRUE);
                        }
                        zds.putProperty("DEPEND_" + idim, tds);
                    }
                    break block38;
                }
                if (type.equals("Sequence")) {
                    int j;
                    DSequence dseq = (DSequence)btvar;
                    int cols = dseq.elementCount(true);
                    int rows = dseq.getRowCount();
                    WritableDataSet[] dss = new WritableDataSet[cols];
                    String[] labels = new String[cols];
                    Type t = Type.scalars;
                    for (int i = 0; i < rows; ++i) {
                        Vector v = dseq.getRow(i);
                        j = 0;
                        for (Object ele : v) {
                            if (ele instanceof DStructure) {
                                DStructure ds = (DStructure)ele;
                                Enumeration enume = ds.getVariables();
                                while (enume.hasMoreElements()) {
                                    Object k = enume.nextElement();
                                    if (i == 0) {
                                        if ((BaseType)k instanceof DArray) {
                                            dss[j] = DDataSet.createRank2((int)rows, (int)((DArray)k).getLength());
                                            t = Type.spectrogram;
                                        } else {
                                            dss[j] = DDataSet.createRank1((int)rows);
                                        }
                                        labels[j] = ((BaseType)k).getName();
                                        dss[j].putProperty("NAME", (Object)labels[j]);
                                    }
                                    this.putValue(dss[j], i, (BaseType)k);
                                    ++j;
                                }
                                continue;
                            }
                            if (ele instanceof BaseType) {
                                if (i == 0) {
                                    if ((BaseType)ele instanceof DArray) {
                                        dss[j] = DDataSet.createRank2((int)rows, (int)((DArray)ele).getLength());
                                        t = Type.spectrogram;
                                    } else {
                                        dss[j] = DDataSet.createRank1((int)rows);
                                    }
                                    labels[j] = ((BaseType)ele).getName();
                                    dss[j].putProperty("NAME", (Object)labels[j]);
                                }
                                this.putValue(dss[j], i, (BaseType)ele);
                                ++j;
                                continue;
                            }
                            throw new IllegalArgumentException("only BaseType and DStructure supported");
                        }
                    }
                    if (cols > 2 && t == Type.scalars) {
                        t = Type.vectors;
                    }
                    WritableDataSet zresult = null;
                    if (t == Type.spectrogram || t == Type.scalars) {
                        dss[cols - 1].putProperty("DEPEND_0", (Object)dss[0]);
                        zresult = dss[cols - 1];
                        if (t == Type.spectrogram) {
                            dss[cols - 1].putProperty("DEPEND_1", (Object)DataSetOps.slice0((QDataSet)dss[1], (int)0));
                        }
                    } else if (t == Type.vectors) {
                        DDataSet rresult = DDataSet.createRank2((int)rows, (int)(cols - 1));
                        for (j = 0; j < cols - 1; ++j) {
                            WritableDataSet ds = dss[j + 1];
                            for (int i = 0; i < rows; ++i) {
                                rresult.putValue(i, j, ds.value(i));
                            }
                        }
                        rresult.putProperty("DEPEND_1", (Object)DataSetOps.trim((QDataSet)Ops.labelsDataset((String[])labels), (int)1, (int)(cols - 1)));
                        rresult.putProperty("DEPEND_0", (Object)dss[0]);
                        zresult = rresult;
                    }
                    if (zresult == null) {
                        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)t));
                    }
                    MutablePropertyDataSet dep0 = (MutablePropertyDataSet)zresult.property("DEPEND_0");
                    String sunits = (String)MetadataUtil.getNode(attributes, (String[])new String[]{labels[0], "units"});
                    DodsAdapter.checkTimeUnits(sunits, dep0);
                    WritableDataSet writableDataSet = zresult;
                    return writableDataSet;
                }
                throw new IllegalStateException("not supported dds type:" + type);
            }
            catch (NoSuchVariableException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                logger.exiting("org.autoplot.dods.DodsAdapter", "getDataSet");
            }
        }
        DodsVarDataSet ds = zds;
        return ds;
    }

    protected static MutablePropertyDataSet checkTimeUnits(String sunits, MutablePropertyDataSet dep0) {
        if (sunits != null && sunits.contains("since")) {
            try {
                Units u = Units.lookupTimeUnits((String)sunits);
                dep0.putProperty("UNITS", (Object)u);
            }
            catch (ParseException ex) {
                if (sunits.equals("days since 1-1-1 00:00:0.0")) {
                    dep0 = Ops.maybeCopy((QDataSet)Ops.subtract((QDataSet)dep0, (QDataSet)DataSetUtil.asDataSet((double)719529.0)));
                    try {
                        dep0.putProperty("UNITS", (Object)Units.lookupTimeUnits((String)"days since 1970-01-01T00:00:00Z"));
                    }
                    catch (ParseException ex1) {
                        logger.log(Level.SEVERE, null, ex1);
                    }
                }
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return dep0;
    }

    public String getDepend0Name() {
        return this.depend0Name;
    }

    public void setDepend0Name(String depend0Name) {
        this.depend0Name = depend0Name;
    }

    public String getDepend1Name() {
        return this.depend1Name;
    }

    public void setDepend1Name(String depend1Name) {
        this.depend1Name = depend1Name;
    }

    public double getAddOffset() {
        return this.addOffset;
    }

    public void setAddOffset(double addOffset) {
        this.addOffset = addOffset;
        this.properties.put("add_offset", addOffset);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.properties.put("scale_factor", scaleFactor);
    }

    public void setValidRange(double min, double max) {
        this.properties.put("valid_range", "" + min + "," + max);
    }

    public Units getDimUnits(int index) {
        return this.dimUnits[index];
    }

    public void setDimUnits(int index, Units dimUnits) {
        this.dimUnits[index] = dimUnits;
    }

    public void putAllProperties(Map p) {
        this.properties.putAll(p);
    }

    public void setDimProperties(int dim, Map p) {
        this.dimProperties[dim] = new HashMap(p);
    }

    public HashMap getDimProperties(int i) {
        return this.dimProperties[i];
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public String getDependName(int index) {
        return this.dependName[index];
    }

    public void setDependName(int index, String dependName) {
        this.dependName[index] = dependName;
    }

    public URL getSource() {
        return this.source;
    }

    private void putValue(WritableDataSet result, int i, BaseType value) {
        if (value instanceof DFloat64) {
            result.putValue(i, ((DFloat64)value).getValue());
        } else if (value instanceof DFloat32) {
            result.putValue(i, (double)((DFloat32)value).getValue());
        } else if (value instanceof DArray) {
            ArrayUtil.putValues(result, i, ((DArray)value).getPrimitiveVector().getInternalStorage());
        } else {
            throw new IllegalArgumentException("not supported: " + value);
        }
    }

    private static enum Type {
        spectrogram,
        vectors,
        scalars;

    }
}

