/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.io.Serializable;
import java.util.IdentityHashMap;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public class Basis
implements Serializable {
    public static final Basis physicalZero = new Basis("", "physical zero", null, 0.0, null);
    public static final Basis fahrenheit = new Basis("fahrenheit", "fahrenheit", physicalZero, 255.37, "celcius degrees");
    public static final Basis kelvin = new Basis("kelvin", "kelvin", physicalZero, 0.0, "celcius degrees");
    public static final Basis centigrade = new Basis("centigrade", "centigrade", physicalZero, 273.15, "celcius degrees");
    public static final Basis since2000 = new Basis("since2000", "since 2000-01-01T00:00Z", null, 0.0, null);
    public static final Basis since2020 = new Basis("since2020", "since 2020-01-01T00:00Z", since2000, 6.31152E8, "seconds");
    public static final Basis since2010 = new Basis("since2010", "since 2010-01-01T00:00Z", since2000, 3.156192E8, "seconds");
    public static final Basis since1980 = new Basis("since1980", "since 1980-01-01T00:00Z", since2000, -6.31152E8, "seconds");
    public static final Basis since1970 = new Basis("since1970", "since 1970-01-01T00:00Z", since2000, -9.380448E8, "seconds");
    public static final Basis since1958 = new Basis("since1958", "since 1958-01-01T00:00Z", since2000, -1.325376E9, "seconds");
    public static final Basis modifiedJulian = new Basis("modifiedJulian", "since 1858-11-17T00:00Z", since2000, 4.4534016E9, "seconds");
    public static final Basis julian = new Basis("julian", "since noon, January 1, 4713 BCE", since2000, 2.118134448E11, "seconds");
    public static final Basis since0000 = new Basis("since0000", "since 01-Jan-0000T00:00Z", since2000, 6.3113904E10, "seconds");
    private IdentityHashMap<Basis, Datum> bases;
    private IdentityHashMap<Basis, Double> basesMagnitude;
    private IdentityHashMap<Basis, String> basesUnitsString;
    private final String id;
    private final String description;
    private final Basis parent;

    public Basis(String id, String description, Basis parent, double d, String offsetUnitsString) {
        this.id = id;
        this.description = description;
        this.parent = parent;
        if (parent != null) {
            parent.basesMagnitude.put(this, d);
            parent.basesUnitsString.put(this, offsetUnitsString);
        } else {
            this.bases = new IdentityHashMap();
            this.basesMagnitude = new IdentityHashMap();
            this.basesUnitsString = new IdentityHashMap();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.id + "(" + this.description + ")";
    }

    public synchronized double getOffset(Basis basis, Units u) {
        Datum d;
        Units us;
        if (this.parent == null) {
            if (!this.bases.containsKey(basis)) {
                Units us2 = Units.getByName(this.basesUnitsString.get(basis));
                Datum d2 = us2.createDatum(this.basesMagnitude.get(basis));
                this.bases.put(basis, d2);
            }
            return this.bases.get(basis).doubleValue(u);
        }
        if (!this.parent.bases.containsKey(this)) {
            if (this.parent.basesUnitsString.containsKey(this)) {
                us = Units.getByName(this.parent.basesUnitsString.get(this));
                d = us.createDatum(this.parent.basesMagnitude.get(this));
                this.parent.bases.put(this, d);
            } else {
                throw new IllegalArgumentException("unable to find basis for " + this);
            }
        }
        if (!this.parent.bases.containsKey(basis)) {
            if (this.parent.basesUnitsString.containsKey(basis)) {
                us = Units.getByName(this.parent.basesUnitsString.get(basis));
                d = us.createDatum(this.parent.basesMagnitude.get(basis));
                this.parent.bases.put(basis, d);
            } else {
                throw new IllegalArgumentException("unable to find basis for " + this);
            }
        }
        double d0 = this.parent.bases.get(this).doubleValue(u);
        double d1 = this.parent.bases.get(basis).doubleValue(u);
        return d0 - d1;
    }

    public void registerConverter(Basis toBasis, double d, Units u) {
        this.bases.put(toBasis, u.createDatum(d));
    }

    public static void main(String[] args) {
        Basis since2010x = new Basis("since2010", "since 2010-01-01T00:00Z", since2000, 3.156192E14, "microseconds");
        Basis since2011 = new Basis("since2011", "since 2011-01-01T00:00Z", since2000, 3.471552E14, "microseconds");
        System.err.println(since2011.getOffset(since2010x, Units.days));
        System.err.println(centigrade.getOffset(fahrenheit, Units.fahrenheitDegrees));
    }
}

