/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.DomainDivider;
import org.das2.datum.LinearDomainDivider;
import org.das2.datum.LogLinDomainDivider;
import org.das2.datum.Units;

public class LogDomainDivider
implements DomainDivider {
    private final LinearDomainDivider expDivider;

    protected LogDomainDivider() {
        this(new LinearDomainDivider());
    }

    private LogDomainDivider(LinearDomainDivider expDivider) {
        this.expDivider = expDivider;
    }

    @Override
    public DomainDivider coarserDivider(boolean superset) {
        return new LogDomainDivider((LinearDomainDivider)this.expDivider.coarserDivider(superset));
    }

    @Override
    public DomainDivider finerDivider(boolean superset) {
        if (this.expDivider.getSignificand() == 1 && this.expDivider.getExponent() == 0) {
            return new LogLinDomainDivider();
        }
        return new LogDomainDivider((LinearDomainDivider)this.expDivider.finerDivider(superset));
    }

    @Override
    public DatumVector boundaries(Datum min, Datum max) {
        Datum dmax;
        long nb;
        if (!min.isFinite() || !max.isFinite()) {
            System.err.println("min and max must be finite");
        }
        if ((nb = this.boundaryCount(min, max)) > 1000000L) {
            throw new IllegalArgumentException("too many divisions requested (" + nb + ")");
        }
        double logmin = Math.log10(min.doubleValue());
        double logmax = Math.log10(max.doubleValue());
        Datum dmin = Datum.create(logmin);
        double[] exponents = this.expDivider.boundaries(dmin, dmax = Datum.create(logmax)).toDoubleArray(Units.dimensionless);
        if ((long)exponents.length != nb) {
            throw new IllegalArgumentException("fatal error in LogDomainDivider");
        }
        double[] result = new double[exponents.length];
        int i = 0;
        while ((long)i < nb) {
            result[i] = Math.pow(10.0, exponents[i]);
            ++i;
        }
        return DatumVector.newDatumVector(result, min.getUnits());
    }

    @Override
    public long boundaryCount(Datum min, Datum max) {
        if (min.doubleValue() > max.doubleValue()) {
            return 0L;
        }
        if (min.doubleValue() <= 0.0 && max.doubleValue() > 0.0) {
            throw new IllegalArgumentException("LogDomainDivider: input range cannot contain zero");
        }
        double logmin = Math.log10(min.doubleValue());
        double logmax = Math.log10(max.doubleValue());
        return this.expDivider.boundaryCount(Datum.create(logmin), Datum.create(logmax));
    }

    @Override
    public DatumRange rangeContaining(Datum v) {
        double logv = Math.log10(v.doubleValue());
        DatumRange exponentRange = this.expDivider.rangeContaining(Datum.create(logv));
        double rangeMin = Math.pow(10.0, exponentRange.min().doubleValue());
        double rangeMax = Math.pow(10.0, exponentRange.max().doubleValue());
        return new DatumRange(rangeMin, rangeMax, v.getUnits());
    }

    public String toString() {
        return "log decadeDivider= " + this.expDivider;
    }

    public static void main(String[] args) {
        LogDomainDivider div = new LogDomainDivider();
        DatumRange dr = DatumRangeUtil.newDimensionless(0.2, 1000.0);
        System.err.println(div.boundaryCount(dr.min(), dr.max()));
        System.err.println(div.boundaries(dr.min(), dr.max()));
        System.err.println(div.rangeContaining(dr.min()));
        DomainDivider div2 = div.coarserDivider(false);
        System.err.println(div2.boundaryCount(dr.min(), dr.max()));
        System.err.println(div2.boundaries(dr.min(), dr.max()));
        div2 = div.finerDivider(false);
        System.err.println(div2.boundaryCount(dr.min(), dr.max()));
        System.err.println(div2.boundaries(dr.min(), dr.max()));
    }
}

