/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.HttpUtil;
import org.das2.datum.LoggerManager;
import org.das2.datum.OrbitDatumRange;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;

public class Orbits {
    private static final Logger LOGGER = LoggerManager.getLogger("das2.datum.orbits");
    private final String sc;
    private final LinkedHashMap<String, DatumRange> orbits;
    private URL url;
    private String last;
    private static HashMap<String, Orbits> missions = new HashMap();
    private static HashMap<String, String> nonmissions = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LinkedHashMap<String, DatumRange> readOrbits(String sc, List<URL> source) throws IOException {
        ArrayList<Object> urls = new ArrayList<Object>();
        if (SwingUtilities.isEventDispatchThread()) {
            LOGGER.warning("read orbits called on event thread");
        }
        try {
            if (sc.contains(":")) {
                urls.add(new URL(sc));
            } else {
                switch (sc) {
                    case "rbspa-pp": 
                    case "rbspb-pp": {
                        String fsc = sc.replace("-", "_");
                        urls.add(new URL("http://www-pw.physics.uiowa.edu/rbsp/orbits/" + fsc));
                        urls.add(new URL("https://emfisis.physics.uiowa.edu/pub/orbits/" + fsc));
                        URL lurl = Orbits.class.getResource("/orbits/" + fsc);
                        if (lurl == null) {
                            LOGGER.warning("null found in orbits URLs indicates expected orbit was not found on classpath");
                            break;
                        }
                        urls.add(lurl);
                        break;
                    }
                    case "crres": {
                        urls.add(new URL("https://space.physics.uiowa.edu/das2/Orbits/crres.dat"));
                        break;
                    }
                    case "cassini": {
                        urls.add(new URL("http://www-pw.physics.uiowa.edu/~jbf/cassini/cassiniOrbits.txt"));
                        break;
                    }
                    case "psp-aa": {
                        urls.add(new URL("https://raw.githubusercontent.com/autoplot/orbits/main/psp/psp-aa.txt"));
                        break;
                    }
                    case "psp-aa25": {
                        urls.add(new URL("https://raw.githubusercontent.com/autoplot/orbits/main/psp/psp-aa25.txt"));
                        break;
                    }
                    default: {
                        urls.add(new URL("https://raw.githubusercontent.com/das-developers/das2meta/main/orbits/" + sc + ".dat"));
                        urls.add(new URL("https://space.physics.uiowa.edu/das2/Orbits/" + sc + ".dat"));
                    }
                }
            }
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        InputStream in = null;
        IOException exfirst = null;
        URL sourceUrl = null;
        for (URL uRL : urls) {
            URLConnection connect = null;
            try {
                LOGGER.log(Level.FINE, "Orbits trying to connect to {0}", uRL);
                connect = uRL.openConnection();
                connect.setConnectTimeout(5000);
                connect = HttpUtil.checkRedirect(connect);
                in = connect.getInputStream();
                LOGGER.log(Level.FINE, "  got input stream from {0}", uRL);
                sourceUrl = uRL;
                break;
            }
            catch (IOException ex) {
                try {
                    if (connect != null && connect instanceof HttpURLConnection && ((HttpURLConnection)connect).getResponseCode() == 401) {
                        LOGGER.info("HTTP connection needs credentials, which must be in the URL.");
                    }
                    LOGGER.log(Level.FINE, ex.getMessage(), ex);
                }
                catch (IOException ex2) {
                    LOGGER.log(Level.FINE, ex.getMessage(), ex2);
                }
                if (exfirst != null) continue;
                exfirst = ex;
            }
        }
        if (in == null) {
            if (exfirst != null) {
                throw exfirst;
            }
            throw new IllegalArgumentException("I/O Exception prevents reading orbits from \"" + urls.get(0) + "\"");
        }
        LinkedHashMap<String, DatumRange> result = new LinkedHashMap<String, DatumRange>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));){
            String s = bufferedReader.readLine();
            int col = -1;
            int labelColumn = -1;
            while (s != null) {
                String[] ss = s.trim().split("\\s+");
                if (ss.length > 0 && ss[0].startsWith("#")) {
                    s = bufferedReader.readLine();
                    continue;
                }
                if (ss.length > 2 && (ss[1].startsWith("1") || ss[1].startsWith("2"))) {
                    String s0;
                    Datum d2;
                    Datum d1;
                    block61: {
                        try {
                            if (col > -1) {
                                try {
                                    d1 = TimeUtil.create(ss[col]);
                                    d2 = TimeUtil.create(ss[col + 1]);
                                    if (ss.length <= labelColumn) {
                                        LOGGER.info("number of columns changes, reverting to old logic");
                                        labelColumn = 2;
                                    }
                                    s0 = ss[col == 0 ? labelColumn : 0];
                                    break block61;
                                }
                                catch (ParseException ex) {
                                    s = bufferedReader.readLine();
                                    continue;
                                }
                            }
                            if (ss[0].length() <= 4) {
                                throw new ParseException("time is too short", 0);
                            }
                            d1 = TimeUtil.create(ss[0]);
                            d2 = TimeUtil.create(ss[1]);
                            s0 = ss[2];
                            col = 0;
                            labelColumn = ss.length - 1;
                        }
                        catch (ParseException ex) {
                            try {
                                d1 = TimeUtil.create(ss[1]);
                                d2 = TimeUtil.create(ss[2]);
                                s0 = ss[0];
                                col = 1;
                                labelColumn = 0;
                            }
                            catch (ParseException ex1) {
                                s = bufferedReader.readLine();
                                continue;
                            }
                        }
                    }
                    if (d1.gt(d2)) {
                        LOGGER.log(Level.WARNING, "dropping invalid orbit: {0}", s);
                    } else {
                        try {
                            result.put(Orbits.trimOrbit(s0), new DatumRange(d1, d2));
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.log(Level.WARNING, "{0}: {1}", new Object[]{ex.getMessage(), s});
                        }
                    }
                }
                s = bufferedReader.readLine();
            }
        }
        finally {
            LOGGER.log(Level.FINE, "read orbits for {0}", sc);
        }
        if (result.isEmpty()) {
            throw new IOException("no orbits found in files: " + urls);
        }
        source.add(sourceUrl);
        return result;
    }

    private Orbits(String sc, LinkedHashMap<String, DatumRange> orbits) {
        this.sc = sc;
        this.orbits = orbits;
    }

    public DatumRange getDatumRange(String orbit) throws ParseException {
        DatumRange s = this.orbits.get(orbit = Orbits.trimOrbit(orbit));
        if (s == null) {
            throw new ParseException("unable to find orbit: " + orbit + " for " + this.sc, 0);
        }
        LOGGER.log(Level.FINEST, "orbit {0} -> {1} to {2}", new Object[]{s.min(), s.max()});
        return s;
    }

    public String getOrbit(Datum d) {
        for (String s : this.orbits.keySet()) {
            try {
                if (!this.getDatumRange(s).contains(d)) continue;
                return s;
            }
            catch (ParseException ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return null;
    }

    public String getOrbitOnOrBefore(Datum d) {
        String best = null;
        Datum bestDist = null;
        for (String s : this.orbits.keySet()) {
            try {
                Datum possibleBest = this.getDatumRange(s).min();
                if (!possibleBest.le(d) || best != null && !d.subtract(possibleBest).lt(bestDist)) continue;
                best = s;
                bestDist = d.subtract(possibleBest);
            }
            catch (ParseException ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return best;
    }

    public String next(String orbit) {
        boolean next = false;
        orbit = Orbits.trimOrbit(orbit);
        for (String s : this.orbits.keySet()) {
            if (next) {
                return s;
            }
            if (!s.equals(orbit)) continue;
            next = true;
        }
        return null;
    }

    public String prev(String orbit) {
        String prev = null;
        orbit = Orbits.trimOrbit(orbit);
        for (String s : this.orbits.keySet()) {
            if (s.equals(orbit)) {
                return prev;
            }
            prev = s;
        }
        return null;
    }

    public static String trimOrbit(String orbit) {
        int i;
        orbit = orbit.trim();
        for (i = 0; i < orbit.length() && orbit.charAt(i) == '_'; ++i) {
        }
        while (i < orbit.length() && orbit.charAt(i) == '0') {
            ++i;
        }
        if (i == orbit.length()) {
            return "0";
        }
        orbit = orbit.substring(i);
        return orbit;
    }

    public int compare(String a, String b) {
        if (a.equals(b)) {
            return 0;
        }
        int ia = -1;
        int ib = -1;
        int i = 0;
        a = Orbits.trimOrbit(a);
        b = Orbits.trimOrbit(b);
        for (String s : this.orbits.keySet()) {
            if (s.equals(a)) {
                ia = i;
            }
            if (s.equals(b)) {
                ib = i;
            }
            ++i;
        }
        if (ia == -1) {
            throw new IllegalArgumentException("not an orbit id: " + a);
        }
        if (ib == -1) {
            throw new IllegalArgumentException("not an orbit id: " + b);
        }
        return ia < ib ? -1 : (ia == ib ? 0 : 1);
    }

    public String first() {
        return this.orbits.keySet().iterator().next();
    }

    public String last() {
        return this.last;
    }

    public String getSpacecraft() {
        return this.sc;
    }

    public static Map<String, String> getSpacecraftIdExamples() {
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
        names.put("rbspa-pp", "RBSP-A (Van Allen Probe A)");
        names.put("rbspb-pp", "RBSP-B (Van Allen Probe B)");
        names.put("crres", "CRRES");
        names.put("de1", "Dynamics Explorer");
        names.put("cassini", "Cassini Spacecraft");
        names.put("cassini.perikrone.24hr", "Cassini Spacecraft around perikrone");
        names.put("cassini.perikrone.120min", "Cassini Spacecraft around perikrone");
        names.put("cassini.perikrone.40min", "Cassini Spacecraft around perikrone");
        names.put("cassini", "Cassini Spacecraft");
        names.put("marsx", "marsx");
        names.put("junoPJ", "Juno at perijove");
        names.put("junoPJ_2hr", "Juno at perijove");
        names.put("junoEqx", "Juno at Eqx");
        names.put("junoEntire", "Juno (Whole Orbits)");
        names.put("psp-aa", "Parker Solar Probe aphelion to aphelion");
        names.put("psp-aa25", "Parker Solar Probe where orbit is within 0.25 AU");
        return names;
    }

    public static synchronized void reset() {
        missions = new HashMap();
        nonmissions = new HashMap();
    }

    public static synchronized Orbits resetOrbitsFor(String sc) {
        missions.remove(sc);
        return Orbits.getOrbitsFor(sc);
    }

    public static synchronized Orbits getOrbitsFor(String sc) {
        String error;
        if (sc.startsWith("/")) {
            throw new IllegalArgumentException("orbit identifier cannot start with /, did you mean file:/?");
        }
        Orbits orbits = missions.get(sc);
        if (orbits == null && (error = nonmissions.get(sc)) != null) {
            throw new IllegalArgumentException(error);
        }
        if (orbits != null && !orbits.orbits.isEmpty()) {
            return orbits;
        }
        try {
            String last;
            LOGGER.log(Level.FINE, "** reading orbits for {0}", sc);
            ArrayList<URL> source = new ArrayList<URL>();
            LinkedHashMap<String, DatumRange> lorbits = Orbits.readOrbits(sc, source);
            orbits = new Orbits(sc, lorbits);
            Iterator<String> o = lorbits.keySet().iterator();
            String string = last = o.hasNext() ? o.next() : null;
            while (o.hasNext()) {
                last = o.next();
            }
            orbits.last = last;
            if (source.size() == 1) {
                orbits.url = (URL)source.get(0);
            }
            missions.put(sc, orbits);
            LOGGER.log(Level.FINE, "** done reading orbits for {0}", sc);
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.INFO, "** not orbits: {0}", sc);
            nonmissions.put(sc, "Not found: " + ex.getMessage());
            throw new IllegalArgumentException("Unable to find orbits file for " + sc, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "** not orbits: {0}", sc);
            nonmissions.put(sc, ex.getMessage());
            throw new IllegalArgumentException("Unable to read orbits file for " + sc, ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.INFO, "** not orbits: {0}", sc);
            nonmissions.put(sc, ex.getMessage());
            throw ex;
        }
        return orbits;
    }

    public static boolean isOrbitsFile(String sc) {
        if (missions.containsKey(sc)) {
            return true;
        }
        if (nonmissions.containsKey(sc)) {
            return false;
        }
        try {
            Orbits.getOrbitsFor(sc);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public URL getURL() {
        return this.url;
    }

    public static void main(String[] args) throws ParseException {
        Orbits o = Orbits.getOrbitsFor("cassini");
        System.err.println(o.getDatumRange("120"));
        System.err.println(o.next("120"));
        TimeParser tp = TimeParser.create("$5(o,id=cassini)", "o", new OrbitFieldHandler(), new Object[0]);
        DatumRange dr = tp.parse("____C").getTimeRange();
        System.err.println(dr);
        System.err.println(tp.format(dr));
        tp = TimeParser.create("$5(o,id=crres)", "o", new OrbitFieldHandler(), new Object[0]);
        dr = tp.parse("__132").getTimeRange();
        System.err.println(dr);
        System.err.println(tp.format(dr));
        DatumRange dr2 = TimeParser.create("$(o,id=crres)").parse("599").getTimeRange();
        System.err.println(dr2);
        DatumRange o600 = dr2.next();
        System.err.println(o600);
        System.err.println("-generate a list--");
        List<DatumRange> drs = DatumRangeUtil.generateList(DatumRangeUtil.parseTimeRangeValid("1991-03-27 through 1991-03-29"), o600);
        for (DatumRange dr1 : drs) {
            System.err.println(dr1);
        }
    }

    public static class OrbitFieldHandler
    implements TimeParser.FieldHandler {
        Orbits o;
        OrbitDatumRange orbitDatumRange;
        char pad = (char)95;

        @Override
        public String configure(Map<String, String> args) {
            String id = args.get("id");
            if (id == null) {
                if (args.get("sc") != null) {
                    throw new IllegalArgumentException("orbit should be specified with id, not sc");
                }
                throw new IllegalArgumentException("orbit id not specified");
            }
            this.o = Orbits.getOrbitsFor(id);
            if (args.containsKey("pad")) {
                this.pad = TimeParser.getPad(args);
                if (this.pad == '\u0000') {
                    this.pad = (char)32;
                }
            }
            return null;
        }

        @Override
        public String getRegex() {
            return ".*";
        }

        @Override
        public void parse(String fieldContent, TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, Map<String, String> extra) throws ParseException {
            int i;
            for (i = 0; i < fieldContent.length() && fieldContent.charAt(i) == this.pad; ++i) {
            }
            DatumRange dr = this.o.getDatumRange(fieldContent.substring(i).trim());
            TimeUtil.TimeStruct tsmin = TimeUtil.toTimeStruct(dr.min());
            TimeUtil.TimeStruct tsmax = TimeUtil.toTimeStruct(dr.max());
            startTime.year = tsmin.year;
            startTime.month = tsmin.month;
            startTime.day = tsmin.day;
            startTime.doy = tsmin.doy;
            startTime.hour = tsmin.hour;
            startTime.minute = tsmin.hour;
            startTime.seconds = tsmin.seconds;
            startTime.millis = tsmin.millis;
            startTime.micros = tsmin.micros;
            startTime.nanos = tsmin.nanos;
            timeWidth.year = tsmax.year - tsmin.year;
            timeWidth.month = tsmax.month - tsmin.month;
            timeWidth.day = tsmax.day - tsmin.day;
            timeWidth.doy = tsmax.doy - tsmin.doy;
            timeWidth.hour = tsmax.hour - tsmin.hour;
            timeWidth.minute = tsmax.hour - tsmin.hour;
            timeWidth.seconds = tsmax.seconds - tsmin.seconds;
            timeWidth.millis = tsmax.millis - tsmin.millis;
            timeWidth.micros = tsmax.micros - tsmin.micros;
            timeWidth.nanos = tsmax.nanos - tsmin.nanos;
            this.orbitDatumRange = new OrbitDatumRange(this.o.sc, fieldContent.substring(i).trim());
        }

        public OrbitDatumRange getOrbitRange() {
            return this.orbitDatumRange;
        }

        @Override
        public String format(TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, int length, Map<String, String> extra) throws IllegalArgumentException {
            DatumRange seek = new DatumRange(TimeUtil.toDatum(startTime), TimeUtil.toDatum(TimeUtil.add(startTime, timeWidth)));
            String result = null;
            for (String s : this.o.orbits.keySet()) {
                DatumRange dr;
                try {
                    dr = this.o.getDatumRange(s);
                }
                catch (ParseException ex) {
                    throw new RuntimeException(ex);
                }
                double nmin = DatumRangeUtil.normalize(dr, seek.min());
                if (seek.width().value() == 0.0) {
                    if (!(nmin >= -0.001) || !(nmin < 1.001)) continue;
                    result = s;
                    break;
                }
                double nmax = DatumRangeUtil.normalize(dr, seek.max());
                if (!(nmin > -0.8) || !(nmin < 0.2) || !(nmax - nmin < 0.01) && (!(nmax > 0.8) || !(nmax < 1.2))) continue;
                result = s;
                break;
            }
            if (result == null) {
                DatumRange dr = new DatumRange(TimeUtil.toDatum(startTime), TimeUtil.toDatum(startTime.add(timeWidth)));
                throw new IllegalArgumentException("unable to find orbit for timerange for range: " + dr);
            }
            if (length < 0) {
                length = 5;
            }
            int n = length - result.length();
            StringBuilder ppad = new StringBuilder("");
            for (int i = 0; i < n; ++i) {
                ppad.append(this.pad);
            }
            ppad.append(result);
            return ppad.toString();
        }
    }
}

