/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeTemplatorFieldPicker;

public class TimeTemplator
extends JPanel {
    private String[] formatted;
    private JButton fieldTypeButton;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JButton sortByButton;
    private JTextField templateTextField;

    public TimeTemplator() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.templateTextField = new JTextField();
        this.fieldTypeButton = new JButton();
        this.sortByButton = new JButton();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.templateTextField.setText("rte_2066281937_20151101_050235_jbf.xml");
        this.templateTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TimeTemplator.this.templateTextFieldMouseClicked(evt);
            }
        });
        this.fieldTypeButton.setText("Field Type...");
        this.fieldTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeTemplator.this.fieldTypeButtonActionPerformed(evt);
            }
        });
        this.sortByButton.setText("Sort By");
        this.sortByButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeTemplator.this.sortByButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.templateTextField, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldTypeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortByButton, -2, 59, -2)));
        layout.linkSize(0, this.fieldTypeButton, this.sortByButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.templateTextField, -2, -1, -2).addComponent(this.fieldTypeButton).addComponent(this.sortByButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 275, Short.MAX_VALUE)));
    }

    private void templateTextFieldMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            // empty if block
        }
    }

    private void fieldTypeButtonActionPerformed(ActionEvent evt) {
        int i0 = this.templateTextField.getSelectionStart();
        int i1 = this.templateTextField.getSelectionEnd();
        TimeTemplatorFieldPicker ttfp = new TimeTemplatorFieldPicker();
        ttfp.setFormatted(this.formatted);
        ttfp.setTemplate(this.templateTextField.getText());
        ttfp.setSelection(i0, i1);
        JDialog d = new JDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        d.getContentPane().add(ttfp);
        d.pack();
        d.setLocationRelativeTo(this);
        d.setVisible(true);
        this.templateTextField.setText(ttfp.getTemplate());
    }

    private void sortByButtonActionPerformed(ActionEvent evt) {
        int i1;
        final int i0 = this.templateTextField.getSelectionStart();
        if (i0 == (i1 = this.templateTextField.getSelectionEnd())) {
            this.setFormattedTable(this.formatted);
            return;
        }
        int imax = Integer.MIN_VALUE;
        int imin = Integer.MAX_VALUE;
        if (this.formatted != null) {
            LinkedHashMap<String, Integer> other = new LinkedHashMap<String, Integer>();
            for (String formatted1 : this.formatted) {
                if (i0 >= formatted1.length()) continue;
                String s = formatted1.substring(i0, i1);
                try {
                    int i = Integer.parseInt(s);
                    imin = Math.min(imin, i);
                    imax = Math.max(imax, i);
                }
                catch (NumberFormatException ex) {
                    Integer i = (Integer)other.get(s);
                    if (i == null) {
                        other.put(s, 1);
                        continue;
                    }
                    other.put(s, i + 1);
                }
            }
            List<String> sformatted = Arrays.asList(this.formatted);
            Collections.sort(sformatted, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    if (i0 > s1.length()) {
                        return 1;
                    }
                    if (i0 > s2.length()) {
                        return -1;
                    }
                    s1 = s1.substring(i0, i1);
                    s2 = s2.substring(i0, i1);
                    return s1.compareTo(s2);
                }
            });
            this.setFormattedTable(sformatted.toArray(new String[sformatted.size()]));
        }
    }

    private void setFormattedTable(String[] formatted) {
        TimeParser tp;
        try {
            tp = TimeParser.create(this.templateTextField.getText());
        }
        catch (IllegalArgumentException ex) {
            tp = null;
        }
        DefaultTableModel dtm = new DefaultTableModel(formatted.length, 2);
        for (int i = 0; i < formatted.length; ++i) {
            dtm.setValueAt(formatted[i], i, 0);
            try {
                dtm.setValueAt(tp.parse(formatted[i]).getTimeRange().toString(), i, 1);
                continue;
            }
            catch (ParseException ex) {
                dtm.setValueAt("", i, 1);
                continue;
            }
            catch (IllegalArgumentException ex) {
                dtm.setValueAt("", i, 1);
            }
        }
        this.jTable1.setModel(dtm);
        this.formatted = formatted;
    }

    public void setFormatted(String[] formatted) {
        this.setFormattedTable(formatted);
        this.templateTextField.setText(formatted[0]);
    }

    public static void main(String[] args) {
        String[] ll = new File("/home/jbf/uploads/").list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        TimeTemplator me = new TimeTemplator();
        me.setFormatted(ll);
        JOptionPane.showConfirmDialog(null, me);
    }
}

