/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.image4j.codec.ico.ICODecoder;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.ui.PromptComboBoxEditor;
import org.autoplot.hapi.HapiCacheManager;
import org.autoplot.hapi.HapiDataSource;
import org.autoplot.hapi.HapiServer;
import org.autoplot.hapi.HapiUtil;
import org.autoplot.hapi.JSONArrayIterator;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.util.LoggerManager;
import org.das2.util.TickleTimer;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HapiDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.hapi");
    private JSONArray idsJSON;
    private boolean supportsBinary;
    private URL defaultServer;
    private Datum myValidTime;
    private Component firstParameter = null;
    private boolean initialized = false;
    private List<JCheckBox> parameterCheckboxes = new ArrayList<JCheckBox>();
    private static final Icon NULL_ICON;
    private String currentParameters = null;
    private URL currentServer = null;
    private DatumRange currentRange = null;
    private String currentId = null;
    private String currentExtra = null;
    private JSONObject currentInfo = null;
    private int lastParamIndex = -1;
    private String providedTimeRange = null;
    TickleTimer resetVariableTimer = new TickleTimer(100L, new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                String s = HapiDataSourceEditorPanel.this.currentId;
                if (s != null && s.trim().length() > 0) {
                    HapiDataSourceEditorPanel.this.resetId(HapiServer.encodeURL((String)HapiDataSourceEditorPanel.this.serversComboBox.getSelectedItem()), s);
                } else {
                    HapiDataSourceEditorPanel.this.parametersPanel.removeAll();
                    HapiDataSourceEditorPanel.this.parametersPanel.add(new JLabel(" "));
                    HapiDataSourceEditorPanel.this.titleLabel.setText(" ");
                }
            }
            catch (MalformedURLException ex) {
                JOptionPane.showMessageDialog(HapiDataSourceEditorPanel.this.parametersPanel, ex.toString());
            }
        }
    });
    private static final Map<String, ImageIcon> icons;
    private JCheckBox binaryCB;
    private JButton cachedFileButton;
    private JButton clearAllB;
    private JButton clearButton;
    private RecentComboBox datasetFilterComboBox;
    private JCheckBox disableCacheCheckBox;
    private JComboBox<String> exampleTimeRangesCB;
    private JButton extraInfoButton;
    private RecentComboBox hapiServerRecentComboBox;
    private JList<JSONObject> idsList2;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JLabel messagesLabel;
    private RecentComboBox parameterFilterComboBox;
    private JPanel parametersPanel;
    private JScrollPane parametersScrollPane;
    private JComboBox<String> serversComboBox;
    private JButton setAllB;
    private RecentComboBox timeRangeComboBox;
    private JLabel titleLabel;
    private static final int MAX_LENGTH_CHARACTERS = 100000;

    private DatumRange getRange(JSONObject info) {
        try {
            if (info.has("firstDate") && info.has("lastDate")) {
                String firstDate = info.getString("firstDate");
                String lastDate = info.getString("lastDate");
                if (firstDate != null && lastDate != null) {
                    Datum t2;
                    Datum t1 = Units.us2000.parse(firstDate);
                    if (t1.le(t2 = Units.us2000.parse(lastDate))) {
                        return new DatumRange(t1, t2);
                    }
                    logger.warning("firstDate and lastDate are out of order, ignoring.");
                }
            } else if (info.has("startDate")) {
                String startDate = info.getString("startDate");
                String stopDate = info.has("stopDate") ? info.getString("stopDate") : null;
                if (stopDate != null) {
                    stopDate = HapiDataSource.parseTime(stopDate).toString();
                }
                if (startDate != null) {
                    Datum t2;
                    Datum t1 = Units.us2000.parse(startDate);
                    Datum datum = t2 = stopDate == null ? this.myValidTime : Units.us2000.parse(stopDate);
                    if (t1.le(t2)) {
                        return new DatumRange(t1, t2);
                    }
                    logger.warning("firstDate and lastDate are out of order, ignoring.");
                }
            }
        }
        catch (ParseException | JSONException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    public HapiDataSourceEditorPanel() {
        try {
            this.myValidTime = TimeUtil.create((String)"2200-01-01T00:00");
        }
        catch (ParseException ex) {
            Logger.getLogger(HapiDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            List<String> servers = HapiServer.getKnownServers();
            this.defaultServer = new URL(servers.get(servers.size() - 1));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        this.initComponents();
        this.idsList2.setCellRenderer(this.getCellRenderer());
        this.hapiServerRecentComboBox.setPreferenceNode("hapi.servers");
        PromptComboBoxEditor editor = new PromptComboBoxEditor("search");
        editor.setTooltipText(this.hapiServerRecentComboBox.getToolTipText());
        this.hapiServerRecentComboBox.setEditor((ComboBoxEditor)editor);
        ((JTextField)editor.getEditorComponent()).setColumns(10);
        this.hapiServerRecentComboBox.invalidate();
        this.hapiServerRecentComboBox.revalidate();
        this.datasetFilterComboBox.setPreferenceNode("hapi.filters");
        editor = new PromptComboBoxEditor("search regex");
        editor.setTooltipText(this.datasetFilterComboBox.getToolTipText());
        this.datasetFilterComboBox.setEditor((ComboBoxEditor)editor);
        ((JTextField)editor.getEditorComponent()).setColumns(10);
        this.datasetFilterComboBox.invalidate();
        this.datasetFilterComboBox.revalidate();
        this.parameterFilterComboBox.setPreferenceNode("hapi.filters");
        editor = new PromptComboBoxEditor("search");
        editor.setTooltipText(this.datasetFilterComboBox.getToolTipText());
        this.parameterFilterComboBox.setEditor((ComboBoxEditor)editor);
        ((JTextField)editor.getEditorComponent()).setColumns(7);
        this.parameterFilterComboBox.invalidate();
        this.parameterFilterComboBox.revalidate();
        this.timeRangeComboBox.setPreferenceNode("timerange");
        this.parametersScrollPane.getVerticalScrollBar().setUnitIncrement(this.parametersPanel.getFont().getSize());
        this.parametersPanel.setLayout(new BoxLayout(this.parametersPanel, 1));
        this.serversComboBox.setEnabled(false);
        this.serversComboBox.setModel(new DefaultComboBoxModel<String>(HapiServer.getKnownServersArray()));
        this.loadKnownServersSoon();
        this.idsList2.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                String id;
                JSONObject joid = this.idsList2.getSelectedValue();
                String string = id = joid == null ? null : joid.optString("id", "???");
                if (id == null) {
                    return;
                }
                if (!id.equals(this.currentId)) {
                    this.currentParameters = null;
                }
                if (this.currentId != null && this.currentId.equals(id)) {
                    return;
                }
                this.currentId = this.currentServer != null ? id : null;
                if (this.currentId == null) {
                    this.titleLabel.setText(" ");
                    return;
                }
                if (this.currentId.startsWith("Error:")) {
                    return;
                }
                this.titleLabel.setText("Retrieving info for " + this.currentId + "...");
                this.parametersPanel.removeAll();
                this.parametersPanel.revalidate();
                this.parametersPanel.repaint();
                this.resetVariableTimer.tickle();
            }
        });
        this.datasetFilterComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                Runnable run = () -> HapiDataSourceEditorPanel.this.resetServerCatalog(HapiDataSourceEditorPanel.this.currentServer);
                SwingUtilities.invokeLater(run);
            }
        });
        this.parameterFilterComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                Runnable run = () -> {
                    try {
                        HapiDataSourceEditorPanel.this.resetIdImmediately(HapiDataSourceEditorPanel.this.currentId, HapiDataSourceEditorPanel.this.currentInfo);
                    }
                    catch (JSONException ex) {
                        ex.printStackTrace();
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        });
    }

    private ListCellRenderer getCellRenderer() {
        return new ListCellRenderer<Object>(){
            private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            @Override
            public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                JSONObject jovalue = (JSONObject)value;
                if (jovalue.has("title")) {
                    label.setText("<html>" + jovalue.optString("id", "???") + ": <em>" + jovalue.optString("title", "") + "</em></html>");
                } else {
                    label.setText("<html>" + jovalue.optString("id", "???") + "</html>");
                }
                return label;
            }
        };
    }

    private JSONObject getJsonObjectFor(String id) {
        ListModel<JSONObject> jos = this.idsList2.getModel();
        JSONObject selection = null;
        for (int i = 0; i < jos.getSize(); ++i) {
            JSONObject jo = jos.getElementAt(i);
            if (!jo.optString("id", "???").equals(id)) continue;
            selection = jo;
        }
        return selection;
    }

    private static String findFavIcon(String hapiString) {
        try {
            URL hapi = new URL(hapiString);
            return new URL(hapi.getProtocol() + "://" + hapi.getHost() + "/favicon.ico").toString();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private static Icon iconFor(Object o, boolean wait) {
        String faviconUrl = HapiDataSourceEditorPanel.findFavIcon(o.toString());
        ImageIcon result = icons.get(faviconUrl);
        if (result == null && wait) {
            try {
                long t1 = System.currentTimeMillis();
                try {
                    File ff = DataSetURI.getFile((String)faviconUrl, null);
                    List bbs = ICODecoder.read((File)ff);
                    BufferedImage useThis = null;
                    for (BufferedImage bb : bbs) {
                        if (bb.getWidth() >= 20) continue;
                        useThis = bb;
                        break;
                    }
                    if (useThis == null) {
                        BufferedImage im = (BufferedImage)bbs.get(0);
                        int h = im.getWidth(null);
                        int w = im.getHeight(null);
                        int s = 20;
                        int h1 = Math.min(24, s * w / h);
                        BufferedImage bi = new BufferedImage(s, h1, 2);
                        Graphics2D g = bi.createGraphics();
                        g.drawImage(im, 0, 0, s, h1, null, null);
                        useThis = bi;
                    }
                    result = new ImageIcon(useThis);
                }
                catch (IOException ex) {
                    result = null;
                }
                logger.log(Level.FINE, "time to load icon for {0}: {1} ms", new Object[]{o, System.currentTimeMillis() - t1});
                icons.put(faviconUrl, result);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        if (result == null) {
            return NULL_ICON;
        }
        return result;
    }

    public void loadKnownServersImmediately() {
        String[] servers1 = HapiServer.listHapiServersArray();
        String item = (String)this.hapiServerRecentComboBox.getSelectedItem();
        if (item == null) {
            item = "";
        }
        if ((item = item.trim()).length() > 0) {
            Pattern p = Pattern.compile(item, 2);
            ArrayList<String> newServers = new ArrayList<String>();
            for (int i = 0; i < servers1.length; ++i) {
                if (!p.matcher(servers1[i]).find()) continue;
                newServers.add(servers1[i]);
            }
            servers1 = newServers.toArray(new String[newServers.size()]);
        }
        final String[] servers = servers1;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                HapiDataSourceEditorPanel.this.serversComboBox.setModel(new DefaultComboBoxModel<String>(servers));
                HapiDataSourceEditorPanel.this.serversComboBox.setRenderer(new IconCellRenderer());
                try {
                    HapiDataSourceEditorPanel.this.defaultServer = new URL(servers[0]);
                }
                catch (MalformedURLException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                if (HapiDataSourceEditorPanel.this.currentServer != null) {
                    HapiDataSourceEditorPanel.this.serversComboBox.setSelectedItem(HapiDataSourceEditorPanel.this.currentServer.toString());
                } else {
                    HapiDataSourceEditorPanel.this.serversComboBox.setSelectedIndex(0);
                }
                HapiDataSourceEditorPanel.this.serversComboBox.setEnabled(true);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void loadKnownServersSoon() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                HapiDataSourceEditorPanel.this.loadKnownServersImmediately();
            }
        };
        new Thread(run, "loadKnownServers").start();
        run = new Runnable(){

            @Override
            public void run() {
                String[] servers;
                for (String s : servers = HapiServer.listHapiServersArray()) {
                    Icon i = HapiDataSourceEditorPanel.iconFor(s, true);
                    if (i == null) continue;
                    logger.log(Level.FINER, "iconHeight={0}", i.getIconHeight());
                }
            }
        };
        new Thread(run, "loadKnownServerIcons").start();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.serversComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.parametersScrollPane = new JScrollPane();
        this.parametersPanel = new JPanel();
        this.clearAllB = new JButton();
        this.setAllB = new JButton();
        this.extraInfoButton = new JButton();
        this.titleLabel = new JLabel();
        this.cachedFileButton = new JButton();
        this.parameterFilterComboBox = new RecentComboBox();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.idsList2 = new JList();
        this.clearButton = new JButton();
        this.datasetFilterComboBox = new RecentComboBox();
        this.messagesLabel = new JLabel();
        this.binaryCB = new JCheckBox();
        this.timeRangeComboBox = new RecentComboBox();
        this.exampleTimeRangesCB = new JComboBox();
        this.disableCacheCheckBox = new JCheckBox();
        this.hapiServerRecentComboBox = new RecentComboBox();
        this.jLabel1.setText("HAPI Server:");
        this.serversComboBox.setEditable(true);
        this.serversComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"http://tsds.org/get/IMAGE/PT1M/hapi", " "}));
        this.serversComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.serversComboBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Time Range: ");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/hapi/calendar.png")));
        this.jButton1.setToolTipText("Time Range Tool");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(210);
        this.parametersPanel.setMinimumSize(new Dimension(100, 0));
        GroupLayout parametersPanelLayout = new GroupLayout(this.parametersPanel);
        this.parametersPanel.setLayout(parametersPanelLayout);
        parametersPanelLayout.setHorizontalGroup(parametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 485, Short.MAX_VALUE));
        parametersPanelLayout.setVerticalGroup(parametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 195, Short.MAX_VALUE));
        this.parametersScrollPane.setViewportView(this.parametersPanel);
        this.clearAllB.setText("Clear All");
        this.clearAllB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.clearAllBActionPerformed(evt);
            }
        });
        this.setAllB.setText("Set All");
        this.setAllB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.setAllBActionPerformed(evt);
            }
        });
        this.extraInfoButton.setText("Extra Info");
        this.extraInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.extraInfoButtonActionPerformed(evt);
            }
        });
        this.titleLabel.setText(" ");
        this.cachedFileButton.setText("Cached Files...");
        this.cachedFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.cachedFileButtonActionPerformed(evt);
            }
        });
        this.parameterFilterComboBox.setToolTipText("search bar, any parameter or parameter description containing regular expression (.* matches anything) is shown");
        this.parameterFilterComboBox.setMaximumSize(new Dimension(1028, Short.MAX_VALUE));
        this.parameterFilterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.parameterFilterComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parametersScrollPane, -1, 497, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.clearAllB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setAllB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cachedFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.extraInfoButton)).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.titleLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.parameterFilterComboBox, -2, -1, -2).addGap(4, 4, 4)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel, -2, 17, -2).addComponent((Component)this.parameterFilterComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parametersScrollPane, -1, 186, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearAllB).addComponent(this.setAllB).addComponent(this.extraInfoButton).addComponent(this.cachedFileButton))));
        this.jSplitPane1.setRightComponent(this.jPanel3);
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jScrollPane2.setMinimumSize(new Dimension(100, 22));
        this.idsList2.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.idsList2);
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/hapi/clearTextButton.png")));
        this.clearButton.setToolTipText("clear search bar");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.datasetFilterComboBox.setToolTipText("search bar, any id or title containing regular expression (.* matches anything) is shown");
        this.datasetFilterComboBox.setMaximumSize(new Dimension(1028, Short.MAX_VALUE));
        this.datasetFilterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.datasetFilterComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.datasetFilterComboBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 183, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearButton).addComponent((Component)this.datasetFilterComboBox, -2, -1, -2)).addGap(0, 216, Short.MAX_VALUE)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.jScrollPane2, -1, 214, Short.MAX_VALUE))));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.messagesLabel.setText("(messages here)");
        this.binaryCB.setText("Use Binary");
        this.binaryCB.setToolTipText("Some servers support binary data transfers, and this will use binary to transfer data.");
        this.binaryCB.setEnabled(false);
        this.exampleTimeRangesCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Example Time Ranges"}));
        this.exampleTimeRangesCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HapiDataSourceEditorPanel.this.exampleTimeRangesCBItemStateChanged(evt);
            }
        });
        this.disableCacheCheckBox.setText("Disable Cache");
        this.hapiServerRecentComboBox.setToolTipText("search bar for HAPI server, any server containing regular expression (.* matches anything) is shown");
        this.hapiServerRecentComboBox.setMaximumSize(new Dimension(1028, Short.MAX_VALUE));
        this.hapiServerRecentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.hapiServerRecentComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 712, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serversComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.hapiServerRecentComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.timeRangeComboBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exampleTimeRangesCB, -2, 224, -2)).addGroup(layout.createSequentialGroup().addComponent(this.messagesLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableCacheCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryCB))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.serversComboBox, -2, -1, -2).addComponent((Component)this.hapiServerRecentComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messagesLabel).addComponent(this.binaryCB, -1, 25, Short.MAX_VALUE).addComponent(this.disableCacheCheckBox)).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.timeRangeComboBox, -2, -1, -2)).addComponent(this.jButton1).addComponent(this.exampleTimeRangesCB, -2, -1, -2)).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        TimeRangeTool tt = new TimeRangeTool();
        tt.setSelectedRange(this.timeRangeComboBox.getText());
        int r = JOptionPane.showConfirmDialog(this, tt, "Select Time Range", 2);
        if (r == 0) {
            this.timeRangeComboBox.setText(tt.getSelectedRange());
        }
    }

    private JSONObject createMessageObject(String msg) {
        JSONObject jo = new JSONObject();
        try {
            jo.put("id", (Object)msg);
        }
        catch (JSONException ex) {
            throw new IllegalArgumentException(ex);
        }
        return jo;
    }

    private void serversComboBoxActionPerformed(ActionEvent evt) {
        try {
            if (!this.initialized) {
                return;
            }
            final URL url = HapiServer.encodeURL((String)this.serversComboBox.getSelectedItem());
            if (this.currentServer == null || !url.toExternalForm().equals(this.currentServer.toExternalForm())) {
                DefaultListModel<JSONObject> m = new DefaultListModel<JSONObject>();
                JSONObject jo = this.createMessageObject("Reading list of available datasets...");
                m.add(0, jo);
                this.idsList2.setModel(m);
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        HapiDataSourceEditorPanel.this.resetServer(url);
                    }
                    catch (IOException | JSONException ex) {
                        logger.log(Level.SEVERE, null, ex);
                        DefaultListModel<JSONObject> m = new DefaultListModel<JSONObject>();
                        m.add(0, HapiDataSourceEditorPanel.this.createMessageObject("Error: unable to connect"));
                        HapiDataSourceEditorPanel.this.idsList2.setModel(m);
                    }
                }
            };
            new Thread(run, "resetServer").start();
        }
        catch (MalformedURLException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void clearAllBActionPerformed(ActionEvent evt) {
        boolean first = this.currentServer == null || !this.currentServer.toString().contains("https://cdaweb.gsfc.nasa.gov/registry/hdp/hapi");
        for (Component component : this.parameterCheckboxes) {
            if (!(component instanceof JCheckBox)) continue;
            if (first) {
                ((JCheckBox)component).setSelected(true);
                first = false;
                continue;
            }
            ((JCheckBox)component).setSelected(false);
        }
    }

    private void setAllBActionPerformed(ActionEvent evt) {
        for (Component component : this.parameterCheckboxes) {
            if (!(component instanceof JCheckBox)) continue;
            ((JCheckBox)component).setSelected(true);
        }
    }

    private void extraInfoButtonActionPerformed(ActionEvent evt) {
        final JEditorPane jep = new JEditorPane();
        jep.setContentType("text/html");
        jep.setText(this.currentExtra);
        jep.setEditable(false);
        jep.setOpaque(false);
        jep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(hle.getURL().toURI());
                    }
                    catch (IOException | URISyntaxException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            }
        });
        final JScrollPane p = new JScrollPane(jep);
        p.setPreferredSize(new Dimension(800, 400));
        p.setMaximumSize(new Dimension(800, 400));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jep.setCaretPosition(0);
                p.getVerticalScrollBar().setValue(0);
            }
        });
        JOptionPane.showMessageDialog(this, p, "Extra Info", 1);
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.datasetFilterComboBox.setSelectedItem((Object)"");
        this.parameterFilterComboBox.setSelectedItem((Object)"");
    }

    private void datasetFilterComboBoxActionPerformed(ActionEvent evt) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                HapiDataSourceEditorPanel.this.resetServerCatalog(HapiDataSourceEditorPanel.this.currentServer);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void exampleTimeRangesCBItemStateChanged(ItemEvent evt) {
        String s = (String)this.exampleTimeRangesCB.getSelectedItem();
        if (!s.startsWith("Example")) {
            this.timeRangeComboBox.setSelectedItem((Object)s);
        }
    }

    private void cachedFileButtonActionPerformed(ActionEvent evt) {
        LinkedHashMap<String, DatumRange> ff;
        String[] params = this.getParameters(true).split(",");
        String str = (String)this.timeRangeComboBox.getSelectedItem();
        String format = this.binaryCB.isSelected() ? "binary" : "csv";
        try {
            DatumRange tr = str == null ? this.currentRange : DatumRangeUtil.parseTimeRange((String)str);
            if (tr == null) {
                JOptionPane.showMessageDialog(this, "id doesn't provide range");
                return;
            }
            ff = HapiUtil.getCacheFiles(this.currentServer, this.currentId, params, tr, format);
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this, "Unable to parse timerange: " + str);
            return;
        }
        if (ff == null) {
            JOptionPane.showMessageDialog(this, "No cache files found in the interval");
            return;
        }
        File cacheFolder = HapiUtil.cacheFolder(this.currentServer, "/data/" + this.currentId);
        HapiCacheManager mm = new HapiCacheManager();
        String[] ss = ff.keySet().toArray(new String[ff.size()]);
        mm.setFiles(cacheFolder, ss);
        if (JOptionPane.showConfirmDialog(this, mm, "Manage Cached Data", 2) == 0) {
            System.err.println("cacheFolder: " + cacheFolder);
            for (String s : ff.keySet()) {
                File f1 = new File(cacheFolder, s);
                if (f1.delete()) continue;
                logger.log(Level.INFO, "unable to delete {0}", f1);
            }
        }
    }

    private void parameterFilterComboBoxActionPerformed(ActionEvent evt) {
        this.resetVariableTimer.tickle("resetFilter");
    }

    private void hapiServerRecentComboBoxActionPerformed(ActionEvent evt) {
        this.loadKnownServersSoon();
    }

    public boolean reject(String uri) throws Exception {
        return false;
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        int i;
        URISplit split = URISplit.parse((String)uri);
        if (split.file == null || split.file.equals("file:///")) {
            split.file = this.defaultServer.toString();
        }
        if (!split.file.endsWith("/hapi") && (i = split.file.lastIndexOf("/hapi")) > -1) {
            split.file = split.file.substring(0, i + 5);
        }
        try {
            this.serversComboBox.setSelectedItem(split.file);
            this.idsJSON = HapiServer.getCatalog(new URL(split.file));
        }
        catch (IOException ex) {
            this.messagesLabel.setText("Unable to connect to server");
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void setParameters(String parameters) {
        for (Component component : this.parameterCheckboxes) {
            if (!(component instanceof JCheckBox)) continue;
            ((JCheckBox)component).setSelected(false);
        }
        if (parameters.length() > 0) {
            String[] ss = parameters.split(",");
            boolean bl = false;
            for (Component component : this.parameterCheckboxes) {
                void var3_5;
                if (!(component instanceof JCheckBox)) continue;
                String name = ((JCheckBox)component).getName();
                ((JCheckBox)component).setSelected(false);
                for (String s : ss) {
                    if (!s.equals(name)) continue;
                    ((JCheckBox)component).setSelected(true);
                    if (var3_5 <= 0 || this.firstParameter != null) continue;
                    this.firstParameter = component;
                }
                ++var3_5;
            }
        } else {
            for (Component component : this.parameterCheckboxes) {
                if (!(component instanceof JCheckBox)) continue;
                ((JCheckBox)component).setSelected(true);
            }
        }
        if (this.firstParameter != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Rectangle r = HapiDataSourceEditorPanel.this.firstParameter.getBounds();
                    HapiDataSourceEditorPanel.this.parametersScrollPane.getViewport().setViewPosition(new Point(0, Math.max(0, r.y - HapiDataSourceEditorPanel.this.parametersScrollPane.getHeight() / 4)));
                }
            });
        }
    }

    private String getParameters(boolean enumerate) {
        StringBuilder b = new StringBuilder();
        boolean areAllTrue = true;
        for (Component component : this.parameterCheckboxes) {
            if (!(component instanceof JCheckBox)) continue;
            if (((JCheckBox)component).isSelected()) {
                b.append(",").append(component.getName());
                continue;
            }
            areAllTrue = false;
        }
        if (areAllTrue && !enumerate) {
            return "";
        }
        return b.substring(1);
    }

    public void setURI(String uri) {
        String timerange;
        URISplit split = URISplit.parse((String)uri);
        if (split.file == null || split.file.equals("file:///")) {
            split.file = this.defaultServer.toString();
        } else {
            int i;
            if (!split.file.endsWith("/hapi") && (i = split.file.lastIndexOf("/hapi")) > -1) {
                split.file = split.file.substring(0, i + 5);
            }
            try {
                this.currentServer = new URL(split.file);
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        try {
            this.serversComboBox.setSelectedItem(HapiServer.decodeURL(HapiServer.encodeURL(split.file)));
        }
        catch (MalformedURLException ex) {
            this.serversComboBox.setSelectedItem(split.file);
        }
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String id = (String)params.get("id");
        if (id != null) {
            try {
                id = URLDecoder.decode(id, "UTF-8");
                JSONObject selected = this.getJsonObjectFor(id);
                if (selected != null) {
                    this.idsList2.setSelectedValue(selected, true);
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            this.currentId = id;
        }
        if ((timerange = (String)params.get("timerange")) != null) {
            this.timeRangeComboBox.setText(timerange);
        }
        this.providedTimeRange = timerange;
        String parameters = (String)params.get("parameters");
        if (parameters != null) {
            this.currentParameters = parameters = HapiServer.decodeURLParameters(parameters);
            this.setParameters(this.currentParameters);
            this.resetVariableTimer.tickle("initialUpdate");
        } else {
            this.resetVariableTimer.tickle("initialUpdateNoParams");
        }
        if ("binary".equals(params.get("format"))) {
            this.binaryCB.setSelected(true);
        } else {
            this.binaryCB.setSelected(false);
        }
        if (!HapiServer.useCache()) {
            this.cachedFileButton.setVisible(false);
            this.disableCacheCheckBox.setVisible(false);
        }
        this.disableCacheCheckBox.setSelected("F".equals(params.get("cache")));
        this.messagesLabel.setText("Select dataset above");
        this.initialized = true;
        this.serversComboBox.setSelectedItem(split.file);
    }

    public void markProblems(List<String> problems) {
    }

    public JPanel getPanel() {
        return this;
    }

    public String getURI() {
        String parameters = this.getParameters(false);
        JSONObject joId = this.idsList2.getSelectedValue();
        String id = joId == null ? null : joId.optString("id", "???");
        id = id == null ? "" : HapiServer.encodeURLParameters(id);
        String uri = "vap+hapi:";
        try {
            uri = uri + HapiServer.encodeURL(this.serversComboBox.getSelectedItem().toString()).toString();
        }
        catch (MalformedURLException ex) {
            uri = uri + this.serversComboBox.getSelectedItem().toString();
        }
        uri = uri + "?id=" + id + "&timerange=" + this.timeRangeComboBox.getText().replaceAll(" ", "+");
        if (this.binaryCB.isSelected() && this.binaryCB.isEnabled()) {
            uri = uri + "&format=binary";
        }
        if (this.disableCacheCheckBox.isSelected()) {
            uri = uri + "&cache=F";
        }
        if (parameters.length() > 0) {
            return uri + "&parameters=" + HapiServer.encodeURLParameters(parameters);
        }
        return uri;
    }

    private void loadServerCapabilities(URL server) throws JSONException {
        boolean binaryIsEnabled = false;
        try {
            JSONObject capabilitiesDoc = HapiServer.getCapabilities(server);
            if (capabilitiesDoc.has("outputFormats")) {
                JSONArray outputFormats = capabilitiesDoc.getJSONArray("outputFormats");
                for (int i = 0; i < outputFormats.length(); ++i) {
                    if (!outputFormats.getString(i).equals("binary")) continue;
                    binaryIsEnabled = true;
                }
            } else {
                JSONArray capabilities = capabilitiesDoc.getJSONArray("capabilities");
                for (int i = 0; i < capabilities.length(); ++i) {
                    JSONObject c = capabilities.getJSONObject(i);
                    if (!c.has("formats")) continue;
                    JSONArray formats = c.getJSONArray("formats");
                    for (int j = 0; j < formats.length(); ++j) {
                        if (!formats.getString(j).equals("binary")) continue;
                        binaryIsEnabled = true;
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        this.supportsBinary = binaryIsEnabled;
    }

    private void resetServerCatalog(URL server) {
        try {
            if (!EventQueue.isDispatchThread()) {
                System.err.println("Here Jeremy");
            }
            String filter = this.datasetFilterComboBox.getSelectedItem().toString().trim();
            DefaultListModel<JSONObject> model = new DefaultListModel<JSONObject>();
            int maxCharacters = 0;
            for (JSONObject catalogEntry : new JSONArrayIterator(this.idsJSON)) {
                if (filter.length() > 0) {
                    Pattern p = Pattern.compile(filter, 2);
                    String id = catalogEntry.getString("id");
                    String title = null;
                    if (catalogEntry.has("title")) {
                        title = catalogEntry.getString("title");
                    }
                    if (!p.matcher(id).find() && (title == null || !p.matcher(title).find())) continue;
                    model.addElement(catalogEntry);
                    maxCharacters = Math.max(catalogEntry.getString("id").length(), maxCharacters);
                    continue;
                }
                model.addElement(catalogEntry);
                maxCharacters = Math.max(catalogEntry.getString("id").length(), maxCharacters);
            }
            this.idsList2.setModel(model);
            int maxLenPixels = maxCharacters * 8;
            maxLenPixels = Math.min(maxLenPixels, 600);
            maxLenPixels = Math.max(maxLenPixels, 300);
            this.jSplitPane1.setDividerLocation(maxLenPixels);
            if (!String.valueOf(server).equals(String.valueOf(this.currentServer))) {
                this.idsList2.setSelectedIndex(0);
                this.currentServer = server;
                this.idsList2.ensureIndexIsVisible(0);
            } else if (this.currentId != null) {
                this.idsList2.setSelectedValue(this.getJsonObjectFor(this.currentId), true);
            } else {
                int i = this.idsList2.getSelectedIndex();
                this.idsList2.ensureIndexIsVisible(i == -1 ? 0 : i);
            }
            this.binaryCB.setEnabled(this.supportsBinary);
        }
        catch (JSONException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void resetServer(final URL server) throws IOException, JSONException {
        this.idsJSON = HapiServer.getCatalog(server);
        this.loadServerCapabilities(server);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                HapiDataSourceEditorPanel.this.datasetFilterComboBox.setSelectedItem((Object)"");
                HapiDataSourceEditorPanel.this.resetServerCatalog(server);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private String getHtmlFor(Object o) throws JSONException {
        StringBuilder s = new StringBuilder();
        if (o instanceof JSONArray) {
            JSONArray joa = (JSONArray)o;
            for (int i = 0; i < joa.length(); ++i) {
                s.append(this.getHtmlFor(joa.get(i))).append("<br>");
            }
        } else if (o instanceof JSONObject) {
            JSONObject jo = (JSONObject)o;
            s.append("<table>");
            Iterator iter = jo.keys();
            while (iter.hasNext()) {
                String k = iter.next().toString();
                Object v = jo.get(k);
                String sv = this.getHtmlFor(v);
                s.append("<tr valign=top><td>").append(k).append("</td><td>").append(sv).append("</td></tr>");
            }
            s.append("</table>");
        } else if (o instanceof String) {
            Pattern p;
            String so = String.valueOf(o);
            if (so.startsWith("spase:")) {
                so = "<a href=\"http://spase.info/registry/render?id=" + so + "\">" + so + "</a>";
            } else if (so.startsWith("http://") || so.startsWith("https://") || so.startsWith("ftp://")) {
                so = "<a href=\"" + so + "\">" + so + "</a>";
            } else if (so.startsWith("doi:") || so.startsWith("DOI:")) {
                so = "<a href=\"https://doi.org/" + so.substring(4) + "\">" + so + "</a>";
            } else if (so.startsWith("10.") && so.length() > 7 && (p = Pattern.compile("(10[.][0-9]{3,}[^\\s\"/<>]*/[^\\s\"<>]+)")).matcher(so).matches()) {
                so = "<a href=\"https://doi.org/" + so + "\">" + so + "</a>";
            }
            s.append(so);
        } else {
            s.append(o.toString());
        }
        return s.toString();
    }

    private static Datum cadenceArrayToDatum(int[] array) {
        double seconds = (double)array[6] / 1.0E9;
        seconds += (double)array[5];
        seconds += (double)(array[4] * 60);
        seconds += (double)(array[3] * 3600);
        seconds += (double)(array[2] * 86400);
        seconds += (double)(array[1] * 86400 * 30);
        return Units.seconds.createDatum(seconds += (double)(array[0] * 86400 * 365));
    }

    public static String getDurationForHumans(long milliseconds) {
        if (milliseconds < 2000L) {
            return milliseconds + " milliseconds";
        }
        if (milliseconds < 120000L) {
            return String.format(Locale.US, "%.1f", (double)milliseconds / 1000.0) + " seconds";
        }
        if (milliseconds < 0x6DDD00L) {
            return String.format(Locale.US, "%.1f", (double)milliseconds / 60000.0) + " minutes";
        }
        if (milliseconds < 172800000L) {
            return String.format(Locale.US, "%.1f", (double)milliseconds / 3600000.0) + " hours";
        }
        double ddays = (double)milliseconds / 8.64E7;
        if (ddays < 48.0) {
            return String.format(Locale.US, "%.1f", ddays) + " days";
        }
        if (ddays < 400.0) {
            return String.format(Locale.US, "%.1f", ddays / 7.0) + " weeks";
        }
        return String.format(Locale.US, "%.1f", ddays / 365.0) + " years";
    }

    private void resetIdReportError(URL server, String id, Exception ex) {
        logger.log(Level.SEVERE, null, ex);
        this.parametersPanel.removeAll();
        this.parametersPanel.add(new JLabel("Error reported on server:"));
        String s = ex.getMessage();
        this.parametersPanel.add(new JLabel(s));
        JLabel space = new JLabel(" ");
        this.parametersPanel.add(space);
        final URL url = HapiServer.createURL(server, "info", Collections.singletonMap("id", id));
        JButton l = new JButton("Load URL in Browser");
        l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (IOException | URISyntaxException ex1) {
                    logger.log(Level.SEVERE, null, ex1);
                }
            }
        });
        this.parametersPanel.add(l);
        this.titleLabel.setText("");
    }

    private void resetIdImmediately(String id, JSONObject info) throws JSONException {
        DatumRange range;
        for (JSONObject item : new JSONArrayIterator(this.idsJSON)) {
            if (!item.getString("id").equals(id)) continue;
            if (item.has("title")) {
                String title = item.getString("title");
                this.titleLabel.setText(title);
                this.titleLabel.setToolTipText(title);
                this.titleLabel.setMinimumSize(new Dimension(100, this.titleLabel.getFont().getSize()));
                continue;
            }
            this.titleLabel.setText(id);
        }
        JSONArray parameters = info.getJSONArray("parameters");
        String parameterFilter = (String)this.parameterFilterComboBox.getSelectedItem();
        if (parameterFilter == null) {
            parameterFilter = "";
        }
        Pattern p = parameterFilter.length() > 0 ? Pattern.compile(parameterFilter, 2) : null;
        StringBuilder extra = new StringBuilder();
        extra.append("<html><table>");
        Iterator iter = info.keys();
        while (iter.hasNext()) {
            String k = iter.next().toString();
            Object v = info.get(k);
            extra.append("<tr valign=top><td>").append(k).append("</td><td>");
            String s = this.getHtmlFor(v);
            if (v.toString().length() > 100000) {
                extra.append("<i>(").append(v.toString().length()).append(" characters)</i>");
            } else {
                extra.append(s);
            }
            extra.append("</td></tr>");
        }
        extra.append("</table></html>");
        this.currentExtra = extra.toString();
        this.parametersPanel.removeAll();
        this.parameterCheckboxes.clear();
        String[] sparams = new String[parameters.length()];
        Boolean startRank2 = null;
        for (int i = 0; i < parameters.length(); ++i) {
            String labelDesc;
            JSONObject parameter = parameters.getJSONObject(i);
            sparams[i] = parameter.getString("name");
            JCheckBox cb = new JCheckBox(sparams[i]);
            String label = sparams[i];
            if (parameter.has("size")) {
                label = label + parameter.getString("size");
            }
            cb.setName(sparams[i]);
            if (i == 0) {
                cb.setSelected(true);
            } else if (startRank2 == null) {
                startRank2 = label.contains("[");
                cb.setSelected(true);
            } else {
                boolean otherIsRank2 = label.contains("[");
                cb.setSelected(otherIsRank2 ? false : startRank2 == false);
            }
            final int fi = i;
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((e.getModifiers() & 1) == 1 && HapiDataSourceEditorPanel.this.lastParamIndex > -1) {
                        int i;
                        if (HapiDataSourceEditorPanel.this.lastParamIndex < fi) {
                            for (i = HapiDataSourceEditorPanel.this.lastParamIndex; i <= fi; ++i) {
                                ((JCheckBox)HapiDataSourceEditorPanel.this.parameterCheckboxes.get(i)).setSelected(true);
                            }
                        } else {
                            for (i = fi; i <= HapiDataSourceEditorPanel.this.lastParamIndex; ++i) {
                                ((JCheckBox)HapiDataSourceEditorPanel.this.parameterCheckboxes.get(i)).setSelected(true);
                            }
                        }
                    }
                    HapiDataSourceEditorPanel.this.lastParamIndex = fi;
                    String label = ((JCheckBox)HapiDataSourceEditorPanel.this.parameterCheckboxes.get(fi)).getText();
                    boolean rank2 = label.contains("[");
                    for (int i = 1; i < HapiDataSourceEditorPanel.this.parameterCheckboxes.size(); ++i) {
                        Component c = (Component)HapiDataSourceEditorPanel.this.parameterCheckboxes.get(i);
                        if (!(c instanceof JCheckBox) || c == (JCheckBox)HapiDataSourceEditorPanel.this.parameterCheckboxes.get(fi)) continue;
                        boolean otherIsRank2 = ((JCheckBox)c).getText().contains("[");
                        boolean isAlreadySelected = ((JCheckBox)c).isSelected();
                        ((JCheckBox)c).setSelected(otherIsRank2 ? false : isAlreadySelected && !rank2);
                    }
                }
            });
            if (parameter.has("description")) {
                String d = parameter.getString("description");
                if (d.length() > 80) {
                    cb.setToolTipText(d);
                    labelDesc = label + ": " + d.substring(0, 80) + "...";
                } else {
                    cb.setToolTipText(d);
                    labelDesc = label + ": " + d;
                }
            } else {
                labelDesc = label;
            }
            cb.setText(labelDesc);
            this.parameterCheckboxes.add(cb);
            if (p == null || p.matcher(labelDesc).find()) {
                this.parametersPanel.add(cb);
                continue;
            }
            cb.setSelected(false);
        }
        this.parametersPanel.setToolTipText("shift-click will select range of parameters");
        this.parametersPanel.revalidate();
        this.parametersPanel.repaint();
        if (this.currentParameters != null) {
            this.setParameters(this.currentParameters);
        }
        if ((range = this.getRange(info)) == null) {
            logger.warning("server is missing required startDate and stopDate parameters.");
            this.messagesLabel.setText("range is not provided (non-compliant server)");
        } else {
            DatumRange sampleRange = null;
            if (info.has("sampleStartDate") && info.has("sampleStopDate")) {
                try {
                    Datum t1 = Units.us2000.parse(info.getString("sampleStartDate"));
                    Datum t2 = Units.us2000.parse(info.getString("sampleStopDate"));
                    if (!t1.isFill()) {
                        logger.info("parse error in sampleStartDate");
                        sampleRange = new DatumRange(t1, t2);
                    }
                }
                catch (ParseException | JSONException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            if (sampleRange == null) {
                Datum cadence = Units.seconds.createDatum(60);
                if (info.has("cadence")) {
                    try {
                        int[] icadence = DatumRangeUtil.parseISO8601Duration((String)info.getString("cadence"));
                        cadence = HapiDataSourceEditorPanel.cadenceArrayToDatum(icadence);
                    }
                    catch (ParseException ex) {
                        logger.log(Level.WARNING, "parse error in cadence: {0}", info.getString("cadence"));
                    }
                }
                if (range.max().ge(this.myValidTime)) {
                    logger.warning("server is missing required stopDate parameter.");
                    this.messagesLabel.setText(range.min().toString() + " to ?");
                    sampleRange = new DatumRange(range.min(), range.min().add(1.0, Units.days));
                } else {
                    Datum end;
                    this.messagesLabel.setText(range.toString());
                    if (cadence.ge(Units.days.createDatum(1))) {
                        end = TimeUtil.nextMidnight((Datum)range.max());
                        end = end.subtract(10.0, Units.days);
                        sampleRange = range.max().subtract(end).ge(Datum.create((int)1, (Units)Units.days)) ? new DatumRange(end, end.add(10.0, Units.days)) : new DatumRange(end.subtract(10.0, Units.days), end);
                    } else if (cadence.ge(Units.seconds.createDatum(1))) {
                        end = TimeUtil.prevMidnight((Datum)range.max());
                        sampleRange = range.max().subtract(end).ge(Datum.create((int)1, (Units)Units.hours)) ? new DatumRange(end, end.add(1.0, Units.days)) : new DatumRange(end.subtract(1.0, Units.days), end);
                    } else {
                        end = TimeUtil.prev((int)4, (Datum)range.max());
                        sampleRange = range.max().subtract(end).ge(Datum.create((int)1, (Units)Units.minutes)) ? new DatumRange(end, end.add(1.0, Units.hours)) : new DatumRange(end.subtract(1.0, Units.hours), end);
                    }
                    if (!sampleRange.intersects(range)) {
                        sampleRange = sampleRange.next();
                    }
                }
            } else {
                String s = range.toString();
                if (info.has("modificationDate")) {
                    try {
                        Datum tmod = Units.us2000.parse(info.getString("modificationDate"));
                        Datum ago = TimeUtil.now().subtract(tmod);
                        s = s + "   last modified " + HapiDataSourceEditorPanel.getDurationForHumans((long)ago.doubleValue(Units.milliseconds)) + " ago.";
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                this.messagesLabel.setText(s);
            }
            DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>(new String[]{"Example Time Ranges", sampleRange.toString()});
            this.exampleTimeRangesCB.setModel(m);
            if (this.providedTimeRange == null) {
                this.timeRangeComboBox.setText(sampleRange.toString());
            }
        }
    }

    private void resetId(final URL server, final String id) {
        JSONObject info;
        try {
            this.currentInfo = info = HapiServer.getInfo(server, id);
        }
        catch (IOException | JSONException ex) {
            logger.log(Level.SEVERE, null, ex);
            this.currentInfo = null;
            this.resetIdReportError(server, id, (Exception)ex);
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    HapiDataSourceEditorPanel.this.resetIdImmediately(id, info);
                }
                catch (JSONException ex) {
                    HapiDataSourceEditorPanel.this.resetIdReportError(server, id, (Exception)((Object)ex));
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public static void main(String[] args) {
        JOptionPane.showConfirmDialog(null, new HapiDataSourceEditorPanel());
    }

    static {
        BufferedImage image = new BufferedImage(16, 16, 2);
        Graphics g = image.getGraphics();
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, 16, 16);
        g.drawRect(0, 0, 15, 15);
        NULL_ICON = new ImageIcon(image);
        icons = Collections.synchronizedMap(new HashMap());
    }

    private static class IconCellRenderer
    implements ListCellRenderer {
        DefaultListCellRenderer r = new DefaultListCellRenderer();

        private IconCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.r.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = HapiDataSourceEditorPanel.iconFor(value, false);
            ((DefaultListCellRenderer)c).setIcon(icon);
            return c;
        }
    }
}

