/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.autoplot.hapi.HapiServer;
import org.das2.datum.DatumRange;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FloatReadAccess;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qstream.AsciiTimeTransferType;
import org.das2.qstream.DoubleTransferType;
import org.das2.qstream.IntegerTransferType;
import org.das2.qstream.TransferType;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HapiDataSourceFormat
implements DataSourceFormat {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.hapi");

    private void upload(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String key = (String)params.get("key");
        if (key == null) {
            throw new IllegalArgumentException("missing key");
        }
        if (data.rank() != 2) {
            throw new IllegalArgumentException("data must be rank 2 bundle");
        }
        StringBuilder dataBuilder = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            QDataSet slice = data.slice(i);
            for (int j = 0; j < data.length(i); ++j) {
                if (j > 0) {
                    dataBuilder.append(',');
                }
                dataBuilder.append(slice.slice(j).svalue());
            }
            dataBuilder.append("\n");
        }
        HttpClient client = new HttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(3000);
        PostMethod postMethod = new PostMethod(split.file + "?" + URISplit.formatParams((Map)params));
        Charset ch = Charset.forName("UTF-8");
        byte[] dataBytes = dataBuilder.toString().getBytes(ch);
        Part[] parts = new Part[]{new StringPart("key", key), new FilePart("data", (PartSource)new ByteArrayPartSource("data", dataBytes), "text/csv", ch.name())};
        postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
        int statusCode1 = client.executeMethod((HttpMethod)postMethod);
        if (statusCode1 != 200) {
            postMethod.releaseConnection();
            throw new IllegalAccessException(postMethod.getStatusLine().toString());
        }
        postMethod.releaseConnection();
    }

    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        Object drvalid;
        Object j1;
        int i;
        String format;
        String id;
        logger.log(Level.FINE, "formatData {0} {1}", new Object[]{uri, data});
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String s = split.file;
        if (!s.startsWith("file://")) {
            this.upload(uri, data, mon);
            return;
        }
        s = s.substring(7);
        int ix = s.lastIndexOf(".hapi");
        if (ix == -1) {
            throw new IllegalArgumentException("uri must end in .hapi");
        }
        File hapiDir = new File(s.substring(0, ix));
        if (!(hapiDir = new File(hapiDir, "hapi")).exists()) {
            logger.log(Level.FINE, "mkdir {0}", hapiDir);
            if (!hapiDir.mkdirs()) {
                throw new IOException("failed to mkdirs: " + hapiDir);
            }
        }
        if ((id = (String)params.get("id")) == null || id.length() == 0) {
            id = "data";
        }
        if ((format = (String)params.get("format")) == null || format.length() == 0) {
            format = "csv";
        }
        File infoFile = new File(new File(hapiDir, "info"), id + ".json");
        JSONObject jo = new JSONObject();
        jo.put("HAPI", (Object)"2.0");
        jo.put("modificationDate", (Object)TimeUtil.now().toString());
        jo.put("status", (Object)this.getHapiStatusObject());
        JSONArray parameters = new JSONArray();
        ArrayList<QDataSet> dss = new ArrayList<QDataSet>();
        ArrayList<FloatReadAccess> ffds = new ArrayList<FloatReadAccess>();
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep0 == null) {
            throw new IllegalArgumentException("data must have a DEPEND_0");
        }
        dss.add(dep0);
        ffds.add(null);
        boolean dep1IsOrdinal = false;
        QDataSet dep1 = (QDataSet)data.property("DEPEND_1");
        if (dep1 != null && dep1.rank() == 1) {
            if (UnitsUtil.isOrdinalMeasurement((Units)SemanticOps.getUnits((QDataSet)dep1))) {
                dep1IsOrdinal = true;
            } else {
                dep1IsOrdinal = true;
                for (int i2 = 0; dep1IsOrdinal && i2 < dep1.length(); ++i2) {
                    if (dep1.value(i2) == (double)(i2 + 1)) continue;
                    dep1IsOrdinal = false;
                }
            }
        }
        FloatReadAccess fra = (FloatReadAccess)data.capability(FloatReadAccess.class);
        if ((dep1IsOrdinal || data.property("DEPEND_1") == null) && SemanticOps.isBundle((QDataSet)data)) {
            for (i = 0; i < data.length(0); ++i) {
                dss.add(Ops.unbundle((QDataSet)data, (int)i));
                ffds.add(fra);
            }
        } else {
            dss.add(data);
            ffds.add(fra);
        }
        String groupTitle = (String)data.property("TITLE");
        if (groupTitle == null) {
            groupTitle = (String)data.property("LABEL");
        }
        if (groupTitle == null) {
            groupTitle = Ops.guessName((QDataSet)data);
        }
        i = 0;
        for (QDataSet ds : dss) {
            Units u = SemanticOps.getUnits((QDataSet)ds);
            if (UnitsUtil.isTimeLocation((Units)u)) {
                JSONObject time = new JSONObject();
                time.put("length", 24);
                time.put("name", (Object)"Time");
                time.put("type", (Object)"isotime");
                time.put("fill", JSONObject.NULL);
                time.put("units", (Object)"UTC");
                parameters.put(i, (Object)time);
            } else {
                Number f;
                j1 = new JSONObject();
                j1.put("name", (Object)Ops.guessName((QDataSet)ds, (String)("data" + i)));
                j1.put("description", ds.property("TITLE"));
                if (u == Units.dimensionless) {
                    j1.put("units", JSONObject.NULL);
                } else {
                    j1.put("units", (Object)u.toString());
                }
                j1.put("type", (Object)"double");
                if (ds.rank() > 1) {
                    j1.put("size", (Object)DataSetUtil.qubeDims((QDataSet)ds.slice(0)));
                }
                if ((f = (Number)ds.property("FILL_VALUE")) != null) {
                    j1.put("fill", (Object)f.toString());
                } else {
                    j1.put("fill", JSONObject.NULL);
                }
                if (ds.rank() >= 2) {
                    j1.put("bins", (Object)this.getBinsFor(ds));
                }
                parameters.put(i, j1);
            }
            ++i;
        }
        DatumRange dr = DataSetUtil.asDatumRange((QDataSet)Ops.extent((QDataSet)dep0));
        if (dep0.property("VALID_MIN") != null && dep0.property("VALID_MAX") != null) {
            double vmax;
            Units tu = SemanticOps.getUnits((QDataSet)dep0);
            double vmin = (Double)dep0.property("VALID_MIN");
            drvalid = DatumRange.newRange((double)vmin, (double)(vmax = ((Double)dep0.property("VALID_MAX")).doubleValue()), (Units)tu);
            if (drvalid.min().gt(tu.parse("1900-01-01")) && drvalid.max().lt(tu.parse("2200-01-01"))) {
                dr = drvalid;
            }
        }
        jo.put("startDate", (Object)dr.min().toString());
        jo.put("stopDate", (Object)dr.max().toString());
        jo.put("sampleStartDate", (Object)dr.min().toString());
        jo.put("sampleStopDate", (Object)dr.max().toString());
        jo.put("parameters", (Object)parameters);
        File parentFile = infoFile.getParentFile();
        if (parentFile == null) {
            throw new IllegalArgumentException("info has no parent");
        }
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IllegalArgumentException("unable to make folder for info file.");
        }
        FileWriter fw = new FileWriter(infoFile);
        j1 = null;
        try {
            fw.write(jo.toString(4));
        }
        catch (Throwable vmax) {
            j1 = vmax;
            throw vmax;
        }
        finally {
            if (fw != null) {
                if (j1 != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable vmax) {
                        ((Throwable)j1).addSuppressed(vmax);
                    }
                } else {
                    fw.close();
                }
            }
        }
        this.updateCatalog(hapiDir, id, groupTitle);
        File capabilitiesFile = new File(hapiDir, "capabilities.json");
        JSONObject c = new JSONObject();
        c.put("HAPI", (Object)"2.0");
        JSONArray f = new JSONArray();
        f.put(0, (Object)"csv");
        f.put(1, (Object)"binary");
        c.put("outputFormats", (Object)f);
        c.put("status", (Object)this.getHapiStatusObject());
        FileWriter fw2 = new FileWriter(capabilitiesFile);
        drvalid = null;
        try {
            c.write((Writer)fw2);
            fw2.write(c.toString(4));
        }
        catch (Throwable throwable) {
            drvalid = throwable;
            throw throwable;
        }
        finally {
            if (fw2 != null) {
                if (drvalid != null) {
                    try {
                        fw2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)drvalid).addSuppressed(throwable);
                    }
                } else {
                    fw2.close();
                }
            }
        }
        String ext = format.equals("binary") ? ".binary" : ".csv";
        File dataFile = new File(new File(hapiDir, "data"), id + ext);
        if (!dataFile.getParentFile().exists() && !dataFile.getParentFile().mkdirs()) {
            throw new IOException("unable to mkdir: " + dataFile.getParentFile());
        }
        if (format.equals("binary")) {
            Object u;
            TransferType[] tts = new TransferType[dss.size()];
            int nbytes = 0;
            for (int ids = 0; ids < dss.size(); ++ids) {
                QDataSet ds = (QDataSet)dss.get(ids);
                u = SemanticOps.getUnits((QDataSet)ds);
                tts[ids] = UnitsUtil.isTimeLocation((Units)u) ? new AsciiTimeTransferType(24, (Units)u) : (UnitsUtil.isNominalMeasurement((Units)u) ? new IntegerTransferType() : new DoubleTransferType());
                nbytes += tts[ids].sizeBytes();
            }
            int nrec = ((QDataSet)dss.get(0)).length();
            FileOutputStream out = new FileOutputStream(dataFile);
            u = null;
            try {
                FileChannel channel = out.getChannel();
                ByteBuffer buf = ByteBuffer.allocate(nbytes);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                for (int irec = 0; irec < nrec; ++irec) {
                    for (int ids = 0; ids < dss.size(); ++ids) {
                        QDataSet ds = (QDataSet)dss.get(ids);
                        TransferType tt = tts[ids];
                        if (ds.rank() == 1) {
                            tt.write(ds.value(irec), buf);
                            continue;
                        }
                        if (ds.rank() == 2) {
                            for (int j = 0; j < ds.length(0); ++j) {
                                tt.write(ds.value(irec, j), buf);
                            }
                            continue;
                        }
                        if (ds.rank() <= 2) continue;
                        QDataSet ds1 = ds.slice(irec);
                        QubeDataSetIterator iter = new QubeDataSetIterator(ds1);
                        while (iter.hasNext()) {
                            iter.next();
                            double d = iter.getValue(ds1);
                            tt.write(d, buf);
                        }
                    }
                    buf.flip();
                    channel.write(buf);
                    buf.flip();
                }
            }
            catch (Throwable channel) {
                u = channel;
                throw channel;
            }
            finally {
                if (out != null) {
                    if (u != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable channel) {
                            ((Throwable)u).addSuppressed(channel);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        DatumFormatter[] dfs = new DatumFormatter[dss.size()];
        for (int ids = 0; ids < dss.size(); ++ids) {
            QDataSet ds = (QDataSet)dss.get(ids);
            Units u = SemanticOps.getUnits((QDataSet)ds);
            dfs[ids] = UnitsUtil.isTimeLocation((Units)u) ? new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS'Z')") : (UnitsUtil.isNominalMeasurement((Units)u) ? DataSetUtil.bestFormatter((QDataSet)ds) : DefaultDatumFormatterFactory.getInstance().defaultFormatter());
        }
        int nrec = ((QDataSet)dss.get(0)).length();
        try (FileWriter fw3 = new FileWriter(dataFile);){
            for (int irec = 0; irec < nrec; ++irec) {
                String delim = "";
                for (int ids = 0; ids < dss.size(); ++ids) {
                    QDataSet ds = (QDataSet)dss.get(ids);
                    DatumFormatter df = dfs[ids];
                    Units u = SemanticOps.getUnits((QDataSet)ds);
                    if (ids > 0) {
                        delim = ",";
                    }
                    boolean uIsOrdinal = UnitsUtil.isOrdinalMeasurement((Units)u);
                    fra = (FloatReadAccess)ffds.get(ids);
                    if (ds.rank() == 1) {
                        if (ids > 0) {
                            fw3.write(delim);
                        }
                        if (fra != null) {
                            fw3.write(String.valueOf(fra.fvalue(irec)));
                            continue;
                        }
                        fw3.write(df.format(u.createDatum(ds.value(irec)), u));
                        continue;
                    }
                    if (ds.rank() == 2) {
                        if (fra != null) {
                            for (int j = 0; j < ds.length(0); ++j) {
                                if (ids > 0) {
                                    fw3.write(delim);
                                }
                                fw3.write(String.valueOf(fra.fvalue(irec, j)));
                            }
                            continue;
                        }
                        for (int j = 0; j < ds.length(0); ++j) {
                            if (ids > 0) {
                                fw3.write(delim);
                            }
                            fw3.write(df.format(u.createDatum(ds.value(irec, j)), u));
                        }
                        continue;
                    }
                    if (ds.rank() <= 2) continue;
                    QDataSet ds1 = ds.slice(irec);
                    QubeDataSetIterator iter = new QubeDataSetIterator(ds1);
                    while (iter.hasNext()) {
                        iter.next();
                        double d = iter.getValue(ds1);
                        if (ids > 0) {
                            fw3.write(delim);
                        }
                        if (uIsOrdinal) {
                            fw3.write("\"");
                            fw3.write(df.format(u.createDatum(d), u));
                            fw3.write("\"");
                            continue;
                        }
                        fw3.write(df.format(u.createDatum(d), u));
                    }
                }
                fw3.write("\n");
            }
        }
    }

    private JSONObject getHapiStatusObject() throws JSONException {
        JSONObject jo1 = new JSONObject();
        jo1.put("code", 1200);
        jo1.put("message", (Object)"OK request successful");
        return jo1;
    }

    private void updateCatalog(File hapiDir, String id, String groupTitle) throws JSONException, IOException {
        JSONObject item;
        JSONArray catalogArray;
        JSONObject catalog;
        File catalogFile = new File(hapiDir, "catalog.json");
        if (catalogFile.exists()) {
            StringBuilder builder = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(catalogFile), HapiServer.UTF8));){
                String line = in.readLine();
                while (line != null) {
                    builder.append(line);
                    line = in.readLine();
                }
            }
            catalog = new JSONObject(builder.toString());
            catalogArray = catalog.getJSONArray("catalog");
        } else {
            catalog = new JSONObject();
            catalog.put("HAPI", (Object)"2.0");
            catalogArray = new JSONArray();
            catalog.put("catalog", (Object)catalogArray);
        }
        int itemIndex = -1;
        for (int j = 0; j < catalogArray.length(); ++j) {
            JSONObject item1 = catalogArray.getJSONObject(j);
            if (!item1.get("id").equals(id)) continue;
            itemIndex = j;
        }
        catalog.put("status", (Object)this.getHapiStatusObject());
        if (itemIndex == -1) {
            item = new JSONObject();
            item.put("id", (Object)id);
            item.put("title", (Object)groupTitle);
            catalogArray.put(catalogArray.length(), (Object)item);
        } else {
            item = catalogArray.getJSONObject(itemIndex);
            item.put("id", (Object)id);
            item.put("title", (Object)groupTitle);
        }
        try (FileWriter fw = new FileWriter(catalogFile);){
            fw.write(catalog.toString(4));
        }
    }

    public boolean canFormat(QDataSet ds) {
        return !SemanticOps.isJoin((QDataSet)ds);
    }

    public String getDescription() {
        return "HAPI Info response";
    }

    private JSONArray getBinsFor(QDataSet ds) throws JSONException {
        JSONArray binsArray = new JSONArray();
        int[] qube = DataSetUtil.qubeDims((QDataSet)ds);
        for (int i = 1; i < ds.rank(); ++i) {
            int j;
            JSONObject jo;
            Units u;
            String n;
            String desc;
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (dep == null) {
                dep = Ops.findgen((int)qube[i]);
            }
            if ((desc = (String)dep.property("TITLE")) == null) {
                desc = (String)dep.property("LABEL");
            }
            if (dep.rank() == 2) {
                if (SemanticOps.isBins((QDataSet)dep)) {
                    n = Ops.guessName((QDataSet)dep, (String)("dep" + i));
                    u = SemanticOps.getUnits((QDataSet)dep);
                    jo = new JSONObject();
                    jo.put("name", (Object)n);
                    if (u == Units.dimensionless) {
                        jo.put("units", JSONObject.NULL);
                    } else {
                        jo.put("units", (Object)u.toString());
                    }
                    JSONArray ranges = new JSONArray();
                    for (j = 0; j < qube[i]; ++j) {
                        JSONArray range = new JSONArray();
                        range.put(0, dep.value(j, 0));
                        range.put(1, dep.value(j, 1));
                        ranges.put(j, (Object)range);
                    }
                    jo.put("ranges", (Object)ranges);
                    if (desc != null) {
                        jo.put("description", (Object)desc);
                    }
                    binsArray.put(i - 1, (Object)jo);
                    continue;
                }
                throw new IllegalArgumentException("independent variable must be a simple 1-D array");
            }
            n = Ops.guessName((QDataSet)dep, (String)("dep" + i));
            u = SemanticOps.getUnits((QDataSet)dep);
            jo = new JSONObject();
            jo.put("name", (Object)n);
            if (u == Units.dimensionless) {
                jo.put("units", JSONObject.NULL);
            } else {
                jo.put("units", (Object)u.toString());
            }
            JSONArray centers = new JSONArray();
            for (j = 0; j < qube[i]; ++j) {
                centers.put(j, dep.value(j));
            }
            jo.put("centers", (Object)centers);
            if (desc != null) {
                jo.put("description", (Object)desc);
            }
            QDataSet binMax = (QDataSet)dep.property("BIN_MAX");
            QDataSet binMin = (QDataSet)dep.property("BIN_MIN");
            if (binMin != null && binMax != null) {
                JSONArray ranges = new JSONArray();
                for (int j2 = 0; j2 < qube[i]; ++j2) {
                    JSONArray range = new JSONArray();
                    range.put(0, binMin.value(j2, 0));
                    range.put(1, binMax.value(j2, 1));
                    ranges.put(j2, (Object)range);
                }
                jo.put("ranges", (Object)ranges);
            }
            binsArray.put(i - 1, (Object)jo);
        }
        return binsArray;
    }

    public boolean streamData(Map<String, String> params, Iterator<QDataSet> dataIt, OutputStream out) throws Exception {
        String format = params.get("format");
        if (format == null || format.length() == 0) {
            format = "csv";
        }
        WritableByteChannel channel = null;
        OutputStreamWriter fw = null;
        if (format.equals("binary")) {
            channel = Channels.newChannel(out);
        } else if (format.equals("csv")) {
            fw = new OutputStreamWriter(out);
        }
        while (dataIt.hasNext()) {
            QDataSet data = dataIt.next();
            ArrayList<QDataSet> dss = new ArrayList<QDataSet>();
            ArrayList<FloatReadAccess> ffds = new ArrayList<FloatReadAccess>();
            QDataSet dep0 = (QDataSet)data.property("CONTEXT_0");
            if (dep0 == null) {
                throw new IllegalArgumentException("data must have a DEPEND_0");
            }
            dss.add(dep0);
            ffds.add(null);
            boolean dep1IsOrdinal = false;
            QDataSet dep1 = (QDataSet)data.property("DEPEND_1");
            if (dep1 != null && dep1.rank() == 1) {
                if (UnitsUtil.isOrdinalMeasurement((Units)SemanticOps.getUnits((QDataSet)dep1))) {
                    dep1IsOrdinal = true;
                } else {
                    dep1IsOrdinal = true;
                    for (int i = 0; dep1IsOrdinal && i < dep1.length(); ++i) {
                        if (dep1.value(i) == (double)(i + 1)) continue;
                        dep1IsOrdinal = false;
                    }
                }
            }
            FloatReadAccess fra = (FloatReadAccess)data.capability(FloatReadAccess.class);
            if ((dep1IsOrdinal || data.property("DEPEND_1") == null) && SemanticOps.isBundle((QDataSet)data)) {
                for (int i = 0; i < data.length(0); ++i) {
                    dss.add(Ops.unbundle((QDataSet)data, (int)i));
                    ffds.add(fra);
                }
            } else {
                dss.add(data);
                ffds.add(fra);
            }
            if (format.equals("binary")) {
                TransferType[] tts = new TransferType[dss.size()];
                int nbytes = 0;
                block7: for (int ids = 0; ids < dss.size(); ++ids) {
                    QDataSet ds = (QDataSet)dss.get(ids);
                    Units u = SemanticOps.getUnits((QDataSet)ds);
                    tts[ids] = UnitsUtil.isTimeLocation((Units)u) ? new AsciiTimeTransferType(24, u) : (UnitsUtil.isNominalMeasurement((Units)u) ? new IntegerTransferType() : new DoubleTransferType());
                    switch (ds.rank()) {
                        case 0: {
                            nbytes += tts[ids].sizeBytes();
                            continue block7;
                        }
                        case 1: {
                            nbytes += tts[ids].sizeBytes() * ds.length();
                            continue block7;
                        }
                        default: {
                            throw new IllegalArgumentException("not supported!");
                        }
                    }
                }
                ByteBuffer buf = ByteBuffer.allocate(nbytes);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                for (int ids = 0; ids < dss.size(); ++ids) {
                    QDataSet ds = (QDataSet)dss.get(ids);
                    TransferType tt = tts[ids];
                    if (ds.rank() == 0) {
                        tt.write(ds.value(), buf);
                        continue;
                    }
                    if (ds.rank() == 1) {
                        for (int j = 0; j < ds.length(); ++j) {
                            tt.write(ds.value(j), buf);
                        }
                        continue;
                    }
                    if (ds.rank() <= 1) continue;
                    QDataSet ds1 = ds;
                    QubeDataSetIterator iter = new QubeDataSetIterator(ds1);
                    while (iter.hasNext()) {
                        iter.next();
                        double d = iter.getValue(ds1);
                        tt.write(d, buf);
                    }
                }
                buf.flip();
                assert (channel != null);
                channel.write(buf);
                buf.flip();
                continue;
            }
            DatumFormatter[] dfs = new DatumFormatter[dss.size()];
            for (int ids = 0; ids < dss.size(); ++ids) {
                QDataSet ds = (QDataSet)dss.get(ids);
                Units u = SemanticOps.getUnits((QDataSet)ds);
                dfs[ids] = UnitsUtil.isTimeLocation((Units)u) ? new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS'Z')") : (UnitsUtil.isNominalMeasurement((Units)u) ? DataSetUtil.bestFormatter((QDataSet)ds) : DefaultDatumFormatterFactory.getInstance().defaultFormatter());
            }
            assert (fw != null);
            String delim = "";
            for (int ids = 0; ids < dss.size(); ++ids) {
                QDataSet ds = (QDataSet)dss.get(ids);
                DatumFormatter df = dfs[ids];
                Units u = SemanticOps.getUnits((QDataSet)ds);
                if (ids > 0) {
                    delim = ",";
                }
                boolean uIsOrdinal = UnitsUtil.isOrdinalMeasurement((Units)u);
                fra = (FloatReadAccess)ffds.get(ids);
                if (ds.rank() == 0) {
                    if (ids > 0) {
                        fw.write(delim);
                    }
                    if (fra != null) {
                        fw.write(String.valueOf(fra.fvalue()));
                        continue;
                    }
                    fw.write(df.format(u.createDatum(ds.value()), u));
                    continue;
                }
                if (ds.rank() == 1) {
                    if (fra != null) {
                        for (int j = 0; j < ds.length(); ++j) {
                            if (ids > 0) {
                                fw.write(delim);
                            }
                            fw.write(String.valueOf(fra.fvalue(j)));
                        }
                        continue;
                    }
                    for (int j = 0; j < ds.length(); ++j) {
                        if (ids > 0) {
                            fw.write(delim);
                        }
                        fw.write(df.format(u.createDatum(ds.value(j)), u));
                    }
                    continue;
                }
                if (ds.rank() <= 1) continue;
                QDataSet ds1 = ds;
                QubeDataSetIterator iter = new QubeDataSetIterator(ds1);
                while (iter.hasNext()) {
                    iter.next();
                    double d = iter.getValue(ds1);
                    if (ids > 0) {
                        fw.write(delim);
                    }
                    if (uIsOrdinal) {
                        fw.write("\"");
                        fw.write(df.format(u.createDatum(d), u));
                        fw.write("\"");
                        continue;
                    }
                    fw.write(df.format(u.createDatum(d), u));
                }
            }
            fw.write("\n");
        }
        if (fw != null) {
            fw.close();
        }
        if (channel != null) {
            channel.close();
        }
        return true;
    }
}

