/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.hapi.Connection;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.util.LoggerManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HapiServer {
    protected static final Logger logger = Logger.getLogger("apdss.hapi");
    protected static final Logger loggerUrl = LoggerManager.getLogger((String)"das2.url");
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static Map<String, String> versions = new HashMap<String, String>();
    private static Map<String, Long> versionFresh = new HashMap<String, Long>();

    public static List<String> getKnownServers() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            URL url = new URL("https://raw.githubusercontent.com/hapi-server/servers/master/server_list.txt");
            try {
                String s = HapiServer.readFromURL(url, "");
                String[] ss = s.split("\n");
                result.addAll(Arrays.asList(ss));
            }
            catch (IOException ex) {
                url = new URL("https://raw.githubusercontent.com/hapi-server/servers/master/all.txt");
                String s = HapiServer.readFromURL(url, "");
                String[] ss = s.split("\n");
                result.addAll(Arrays.asList(ss));
            }
            if ("true".equals(System.getProperty("hapiDeveloper", "false"))) {
                result.add("http://tsds.org/get/IMAGE/PT1M/hapi");
                result.add("https://cdaweb.gsfc.nasa.gov/registry/hdp/hapi");
                result.add("http://jfaden.net/HapiServerDemo/hapi");
            }
        }
        catch (IOException ex) {
            Logger.getLogger(HapiServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        result.remove("http://datashop.elasticbeanstalk.com/hapi");
        result.add("http://datashop.elasticbeanstalk.com/hapi");
        ArrayList<String> uniq = new ArrayList<String>();
        for (String s : result) {
            if (uniq.contains(s)) continue;
            uniq.add(s);
        }
        return uniq;
    }

    public static String[] getKnownServersArray() {
        List<String> result = HapiServer.getKnownServers();
        return result.toArray(new String[result.size()]);
    }

    public static String[] listHapiServersArray() {
        List<String> result = HapiServer.listHapiServers();
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listHapiServers() {
        if (EventQueue.isDispatchThread()) {
            logger.warning("HAPI network call on event thread");
        }
        ArrayList<String> d2ss1 = new ArrayList<String>();
        d2ss1.addAll(HapiServer.getKnownServers());
        File home = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
        File book = new File(home, "bookmarks");
        File hist = new File(book, "history.txt");
        long t0 = System.currentTimeMillis();
        logger.log(Level.FINE, "reading recent datasources from {0}", hist.toString());
        if (hist.exists()) {
            BufferedReader r = null;
            try {
                String seek = "hapi:";
                int ttaglen = 25;
                r = new BufferedReader(new FileReader(hist));
                String s = r.readLine();
                LinkedHashSet<String> dss = new LinkedHashSet<String>();
                while (s != null) {
                    if (s.length() > ttaglen + 15 && s.substring(ttaglen + 4, ttaglen + 9).equalsIgnoreCase(seek)) {
                        String key;
                        int i = s.indexOf("?");
                        if (i == -1) {
                            i = s.length();
                        }
                        if (dss.contains(key = s.substring(ttaglen + 4 + seek.length(), i))) {
                            dss.remove(key);
                        }
                        dss.add(key);
                    }
                    s = r.readLine();
                }
                d2ss1.removeAll(dss);
                ArrayList<String> d2ssDiscoveryList = new ArrayList<String>(dss);
                Collections.reverse(d2ssDiscoveryList);
                d2ssDiscoveryList.addAll(d2ss1);
                d2ss1 = d2ssDiscoveryList;
                logger.log(Level.FINE, "read extra hapi servers in {0} millis\n", System.currentTimeMillis() - t0);
            }
            catch (IOException ex) {
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        } else {
            logger.log(Level.FINE, "no history file found: {0}", hist);
        }
        return d2ss1;
    }

    public static List<String> getCatalogIds(URL server) throws IOException, JSONException {
        if (EventQueue.isDispatchThread()) {
            logger.warning("HAPI network call on event thread");
        }
        URL url = HapiServer.createURL(server, "catalog");
        String s = HapiServer.readFromURL(url, "json");
        JSONObject o = new JSONObject(s);
        JSONArray catalog = o.getJSONArray("catalog");
        ArrayList<String> result = new ArrayList<String>(catalog.length());
        for (int i = 0; i < catalog.length(); ++i) {
            result.add(i, catalog.getJSONObject(i).getString("id"));
        }
        return result;
    }

    public static JSONArray getCatalog(URL server) throws IOException, JSONException {
        if (EventQueue.isDispatchThread()) {
            logger.warning("HAPI network call on event thread");
        }
        URL url = HapiServer.createURL(server, "catalog");
        String s = HapiServer.readFromURL(url, "json");
        JSONObject o = new JSONObject(s);
        JSONArray catalog = o.getJSONArray("catalog");
        return catalog;
    }

    public static URL getInfoURL(URL server, String id) {
        URL url = HapiServer.createURL(server, "info", Collections.singletonMap("id", id));
        return url;
    }

    public static String getHapiServerVersion(URL server) throws JSONException, IOException {
        String sserver = server.toString();
        Long fresh = versionFresh.get(sserver);
        if (fresh == null || fresh < System.currentTimeMillis() - 600000L) {
            JSONObject capabilities = HapiServer.getCapabilities(server);
            String version = capabilities.getString("HAPI");
            versions.put(sserver, version);
            versionFresh.put(sserver, System.currentTimeMillis());
            return version;
        }
        return versions.get(sserver);
    }

    public static URL getDataURL(URL server, String id, DatumRange tr, String parameters) {
        String version;
        TimeParser tp = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("id", id);
        try {
            version = HapiServer.getHapiServerVersion(server);
        }
        catch (IOException | JSONException ex) {
            version = "2.0";
        }
        if (version.startsWith("2.") || version.startsWith("1.")) {
            map.put("time.min", tp.format(tr.min()));
            map.put("time.max", tp.format(tr.max()));
        } else {
            map.put("start", tp.format(tr.min()));
            map.put("stop", tp.format(tr.max()));
        }
        if (parameters.length() > 0) {
            map.put("parameters", parameters);
        }
        URL serverUrl = HapiServer.createURL(server, "data", map);
        return serverUrl;
    }

    public static URL createURL(URL server, String append) {
        return HapiServer.createURL(server, append, null);
    }

    public static String urlEncode(String id) {
        Pattern p = Pattern.compile("[a-zA-Z0-9_:\\-\\+,/\\.]+");
        if (p.matcher(id).matches()) {
            return id;
        }
        try {
            return URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static JSONArray getParameters(URL server, String id) throws IOException, JSONException {
        JSONObject o = HapiServer.getInfo(server, id);
        JSONArray catalog = o.getJSONArray("parameters");
        return catalog;
    }

    public static JSONObject getInfo(URL server, String id) throws IOException, JSONException {
        if (EventQueue.isDispatchThread()) {
            logger.warning("HAPI network call on event thread");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        URL url = HapiServer.createURL(server, "info", params);
        logger.log(Level.FINE, "getInfo {0}", url.toString());
        String s = HapiServer.readFromURL(url, "json");
        JSONObject o = new JSONObject(s);
        return o;
    }

    protected static JSONObject getCapabilities(URL server) throws IOException, JSONException {
        if (EventQueue.isDispatchThread()) {
            logger.warning("HAPI network call on event thread");
        }
        URL url = HapiServer.createURL(server, "capabilities");
        String s = HapiServer.readFromURL(url, "json");
        JSONObject o = new JSONObject(s);
        return o;
    }

    protected static boolean useCache() {
        return "true".equals(System.getProperty("hapiServerCache", "false"));
    }

    protected static long cacheAgeLimitMillis() {
        return 3600000L;
    }

    public static String readFromFile(File f) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), UTF8));){
            String line = in.readLine();
            while (line != null) {
                builder.append(line);
                builder.append("\n");
                line = in.readLine();
            }
        }
        if (builder.length() == 0) {
            throw new IOException("file is empty:" + f);
        }
        String result = builder.toString();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFromURL(URL url, String type) throws IOException {
        loggerUrl.log(Level.FINE, "GET {0}", new Object[]{url});
        Connection urlc = Connection.openConnection(url);
        StringBuilder builder = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream(), UTF8));){
            String line = in.readLine();
            while (line != null) {
                builder.append(line);
                builder.append("\n");
                line = in.readLine();
            }
        }
        catch (IOException ex) {
            StringBuilder builder2 = new StringBuilder();
            InputStream err = urlc.getErrorStream();
            if (err == null) {
                throw ex;
            }
            try (BufferedReader in2 = new BufferedReader(new InputStreamReader(err, UTF8));){
                String line = in2.readLine();
                while (line != null) {
                    builder2.append(line);
                    builder2.append("\n");
                    line = in2.readLine();
                }
                String s2 = builder2.toString().trim();
                if (type.equals("json") && s2.length() > 0 && s2.charAt(0) == '{') {
                    logger.warning("incorrect error code returned, content is JSON");
                    String string = s2;
                    return string;
                }
            }
            catch (IOException ex2) {
                logger.log(Level.FINE, ex2.getMessage(), ex2);
            }
            logger.log(Level.FINE, ex.getMessage(), ex);
            throw ex;
        }
        if (builder.length() != 0) return builder.toString();
        throw new IOException("empty response from " + url);
    }

    public static URL createURL(URL server, String append, Map<String, String> singletonMap) {
        StringBuilder s = new StringBuilder(server.toString());
        if (append.startsWith("/")) {
            append = append.substring(1);
        }
        s = s.substring(s.length() - 1).equals("/") ? s.append(append) : s.append("/").append(append);
        if (singletonMap != null && !singletonMap.isEmpty()) {
            boolean firstArg = true;
            for (Map.Entry<String, String> entry : singletonMap.entrySet()) {
                if (entry.getValue() == null) continue;
                if (firstArg) {
                    s.append("?");
                    firstArg = false;
                } else {
                    s.append("&");
                }
                String svalue = entry.getKey().equals("time.min") || entry.getKey().equals("time.max") ? entry.getValue() : HapiServer.urlEncode(entry.getValue());
                s.append(entry.getKey()).append("=").append(svalue);
            }
        }
        try {
            return new URL(s.toString());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static Datum cadenceArrayToDatum(int[] array) {
        double seconds = (double)array[6] / 1.0E9;
        seconds += (double)array[5];
        seconds += (double)(array[4] * 60);
        seconds += (double)(array[3] * 3600);
        seconds += (double)(array[2] * 86400);
        seconds += (double)(array[1] * 86400 * 30);
        return Units.seconds.createDatum(seconds += (double)(array[0] * 86400 * 365));
    }

    public static DatumRange getRange(JSONObject info) {
        try {
            if (info.has("firstDate") && info.has("lastDate")) {
                String firstDate = info.getString("firstDate");
                String lastDate = info.getString("lastDate");
                if (firstDate != null && lastDate != null) {
                    Datum t2;
                    Datum t1 = Units.us2000.parse(firstDate);
                    if (t1.le(t2 = Units.us2000.parse(lastDate))) {
                        return new DatumRange(t1, t2);
                    }
                    logger.warning("firstDate and lastDate are out of order, ignoring.");
                }
            } else if (info.has("startDate")) {
                String startDate = info.getString("startDate");
                String stopDate = info.has("stopDate") ? info.getString("stopDate") : null;
                if (startDate != null) {
                    Datum t2;
                    Datum t1 = Units.us2000.parse(startDate);
                    if (t1.le(t2 = Units.us2000.parse(stopDate))) {
                        return new DatumRange(t1, t2);
                    }
                    logger.warning("firstDate and lastDate are out of order, ignoring.");
                }
            }
        }
        catch (ParseException | JSONException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    public static DatumRange getSampleTimeRange(JSONObject info) throws JSONException {
        DatumRange range = HapiServer.getRange(info);
        if (range == null) {
            logger.warning("server is missing required startDate and stopDate parameters.");
            throw new IllegalArgumentException("here fail");
        }
        DatumRange sampleRange = null;
        if (info.has("sampleStartDate") && info.has("sampleStopDate")) {
            try {
                Datum t1 = Units.us2000.parse(info.getString("sampleStartDate"));
                Datum t2 = Units.us2000.parse(info.getString("sampleStopDate"));
                if (!t1.isFill()) {
                    logger.info("parse error in sampleStartDate");
                    sampleRange = new DatumRange(t1, t2);
                }
            }
            catch (ParseException | JSONException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        if (sampleRange == null) {
            Datum end;
            Datum cadence = Units.seconds.createDatum(60);
            if (info.has("cadence")) {
                try {
                    int[] icadence = DatumRangeUtil.parseISO8601Duration((String)info.getString("cadence"));
                    cadence = HapiServer.cadenceArrayToDatum(icadence);
                }
                catch (ParseException ex) {
                    logger.log(Level.WARNING, "parse error in cadence: {0}", info.getString("cadence"));
                }
            }
            if (cadence.ge(Units.days.createDatum(1))) {
                end = TimeUtil.nextMidnight((Datum)range.max());
                end = end.subtract(10.0, Units.days);
                sampleRange = range.max().subtract(end).ge(Datum.create((int)1, (Units)Units.days)) ? new DatumRange(end, end.add(10.0, Units.days)) : new DatumRange(end.subtract(10.0, Units.days), end);
            } else if (cadence.ge(Units.seconds.createDatum(1))) {
                end = TimeUtil.prevMidnight((Datum)range.max());
                sampleRange = range.max().subtract(end).ge(Datum.create((int)1, (Units)Units.hours)) ? new DatumRange(end, end.add(1.0, Units.days)) : new DatumRange(end.subtract(1.0, Units.days), end);
            } else {
                end = TimeUtil.prev((int)4, (Datum)range.max());
                sampleRange = range.max().subtract(end).ge(Datum.create((int)1, (Units)Units.minutes)) ? new DatumRange(end, end.add(1.0, Units.hours)) : new DatumRange(end.subtract(1.0, Units.hours), end);
            }
            if (!sampleRange.intersects(range)) {
                sampleRange = sampleRange.next();
            }
        }
        return sampleRange;
    }

    public static final URL encodeURL(String s) throws MalformedURLException {
        try {
            return new URL(s);
        }
        catch (MalformedURLException ex) {
            return new URL(URLEncoder.encode(s));
        }
    }

    public static final String decodeURL(URL s) {
        return URLDecoder.decode(s.toString());
    }

    public static final String encodeURLParameters(String s) {
        s = s.replaceAll("\\+", "%2B");
        return s.replaceAll(" ", "+");
    }

    public static final String decodeURLParameters(String s) {
        s = s.replaceAll("\\+", " ");
        return s.replaceAll("%2B", "+");
    }
}

