/*
 * Decompiled with CFR 0.152.
 */
package org.hapiserver;

import java.util.Map;
import org.hapiserver.CSVHapiRecord;
import org.hapiserver.HapiRecord;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CSVHapiRecordConverter {
    Map<Integer, Integer> indexMap;
    JSONObject info;
    JSONArray params;
    int[] sizes;

    public CSVHapiRecordConverter(JSONObject info) throws JSONException {
        this.info = info;
        this.params = info.getJSONArray("parameters");
        this.sizes = new int[this.params.length()];
        for (int i = 0; i < this.params.length(); ++i) {
            JSONObject jo = this.params.getJSONObject(i);
            if (jo.has("size")) {
                JSONArray size = jo.getJSONArray("size");
                this.sizes[i] = size.getInt(0);
                for (int j = 1; j < size.length(); ++j) {
                    int n = i;
                    this.sizes[n] = this.sizes[n] * size.getInt(j);
                }
                continue;
            }
            this.sizes[i] = 1;
        }
    }

    public HapiRecord convert(String record) {
        String[] fields = record.trim().split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -2);
        String[] ff = new String[this.params.length()];
        int i = 0;
        int j = 0;
        while (i < this.params.length()) {
            if (this.sizes[j] == 1) {
                ff[j] = fields[i];
                ++i;
            } else {
                StringBuilder build = new StringBuilder(fields[i]);
                for (int k = 1; k < this.sizes[j]; ++k) {
                    build.append(",").append(fields[i + k]);
                }
                ff[j] = build.toString();
                i += this.sizes[j];
            }
            ++j;
        }
        return new CSVHapiRecord(this.info, ff);
    }
}

